<?php

/***********************************************************
 * @Description: Widget For Display Knowledge Base Categories
 * @Created At: 14-02-2013
 * @Last Edited AT: 07-04-2017
 * @Created By: Mahbub
 ***********************************************************/

function bkb_categories_widget_init()
{

    register_widget('BKB_categories_widget');
}

add_action('widgets_init', 'bkb_categories_widget_init');

class BKB_categories_widget extends WP_Widget
{

    //widget init.
    public function __construct()
    {
        parent::__construct(
            'bkb_categories_widget',
            'BKBM Categories Widget',
            array('description' => esc_attr__('Display Knowledget Base Categories.', 'bwl-kb'))
        );
    }

    //output the widget options in the back-end

    public function form($instance)
    {

        $defaults = array(
            'title' => esc_attr__('Categories', 'bwl-kb'),
            'entries_display' => "",
            'bkb_order_by' =>  'title',
            'bkb_order_type' =>  'asc',
            'sub_cat_mode' =>  'on',
            'show_post_count' =>  'on',
            'show_cat_icon' => 'on'
        );

        $instance = wp_parse_args((array) $instance, $defaults);

?>

<p>
  <label for="<?php echo $this->get_field_id('title') ?>"><?php esc_attr_e('Title', 'bwl-kb'); ?></label>
  <input type="text" id="<?php echo $this->get_field_id('title') ?>" name="<?php echo $this->get_field_name('title') ?>"
    class="widefat" value="<?php echo esc_attr($instance['title']) ?>" />
</p>

<p>
  <label
    for="<?php echo $this->get_field_id('entries_display') ?>"><?php esc_attr_e('Display Limit', 'bwl-kb'); ?></label>
  <input type="text" id="<?php echo $this->get_field_id('entries_display') ?>"
    name="<?php echo $this->get_field_name('entries_display') ?>" class="widefat"
    value="<?php echo esc_attr($instance['entries_display']) ?>" />
  <br /><small><?php esc_attr_e('Set any number. Example: 10 Or Keep it blank if you want to display all categories.', 'bwl-kb'); ?></small>
</p>

<!-- Order Type -->

<p>
  <label for="<?php echo $this->get_field_id('bkb_order_by'); ?>"><?php esc_attr_e('Order By', 'bwl-kb') ?></label>
  <select id="<?php echo $this->get_field_id('bkb_order_by'); ?>"
    name="<?php echo $this->get_field_name('bkb_order_by'); ?>" class="widefat" style="width:100%;">
    <option value="title" <?php if ($instance['bkb_order_by'] == 'title') echo 'selected="selected"'; ?>>
      <?php esc_attr_e('Title', 'bwl-kb'); ?></option>
    <option value="id" <?php if ($instance['bkb_order_by'] == 'id') echo 'selected="selected"'; ?>>
      <?php esc_attr_e('ID', 'bwl-kb'); ?></option>
  </select>
</p>

<!-- Order Type -->

<p>
  <label for="<?php echo $this->get_field_id('bkb_order_type'); ?>"><?php esc_attr_e('Order Type', 'bwl-kb') ?></label>
  <select id="<?php echo $this->get_field_id('bkb_order_type'); ?>"
    name="<?php echo $this->get_field_name('bkb_order_type'); ?>" class="widefat" style="width:100%;">
    <option value="asc" <?php if ($instance['bkb_order_type'] == 'asc') echo 'selected="selected"'; ?>>
      <?php esc_attr_e('Ascending', 'bwl-kb'); ?></option>
    <option value="desc" <?php if ($instance['bkb_order_type'] == 'desc') echo 'selected="selected"'; ?>>
      <?php esc_attr_e('Descending', 'bwl-kb'); ?></option>
  </select>
</p>

<p>
  <input type="checkbox" id="<?php echo $this->get_field_id('sub_cat_mode'); ?>"
    name="<?php echo $this->get_field_name('sub_cat_mode'); ?>"
    <?php checked($instance['sub_cat_mode'], 'on'); ?> />&nbsp;
  <?php esc_attr_e('Enable Sub Category Mode?', 'bwl-kb'); ?>
</p>

<p>
  <input type="checkbox" id="<?php echo $this->get_field_id('show_post_count'); ?>"
    name="<?php echo $this->get_field_name('show_post_count'); ?>"
    <?php checked($instance['show_post_count'], 'on'); ?> />&nbsp; <?php esc_attr_e('Display Post Count?', 'bwl-kb'); ?>
</p>

<p>
  <input type="checkbox" id="<?php echo $this->get_field_id('show_cat_icon'); ?>"
    name="<?php echo $this->get_field_name('show_cat_icon'); ?>"
    <?php checked($instance['show_cat_icon'], 'on'); ?> />&nbsp;
  <?php esc_attr_e('Display Category Icon?', 'bwl-kb'); ?>
</p>

<?php

    }

    //process widget option for saving
    public function update($new_instance, $old_instance)
    {
        $instance = $old_instance;

        // Widget Title
        $instance['title'] =  strip_tags($new_instance['title']);
        $instance['entries_display'] =  wp_kses_post($new_instance['entries_display']);
        $instance['bkb_order_by'] =  $new_instance['bkb_order_by'];
        $instance['bkb_order_type'] =  $new_instance['bkb_order_type'];
        $instance['sub_cat_mode'] =  $new_instance['sub_cat_mode'];
        $instance['show_post_count'] =  $new_instance['show_post_count'];
        $instance['show_cat_icon'] =  $new_instance['show_cat_icon'];

        //The No of post show.
        //        $instance['entries_display'] =  strip_tags($new_instance['entries_display']);

        return $instance;
    }

    //Displays the widgets on the front end.
    public function widget($args, $instance)
    {

        extract($args);

        $title = apply_filters('widget-title', $instance['title']);

        echo $before_widget;

        // Generate Widget Title.

        if ($title) :
            echo $before_title . $title . $after_title;
        endif;

        // Fetch & Manage Data From Database.

        $entries_display = isset($instance['entries_display']) ? $instance['entries_display'] : "";
        $bkb_order_by = isset($instance['bkb_order_by']) ? $instance['bkb_order_by'] : "title";
        $bkb_order_type = isset($instance['bkb_order_type']) ? $instance['bkb_order_type'] : "asc";
        $sub_cat_mode = isset($instance['sub_cat_mode']) ? $instance['sub_cat_mode'] : "";
        $show_post_count = isset($instance['show_post_count']) ? $instance['show_post_count'] : "";
        $show_cat_icon = isset($instance['show_cat_icon']) ?  $instance['show_cat_icon'] : "";


        // Sub category Mode feature has been added in version 1.1.8

        if ($sub_cat_mode == "on") {

            $show_post_count = ($show_post_count == "on") ? 1 : 0;
            $show_cat_icon = ($show_cat_icon == "on") ? 1 : 0;
            echo do_shortcode('[bkb_nested_sub_taxonomy taxonomy="bkb_category" orderby="' . $bkb_order_by . '" order="' . $bkb_order_type . '" show_count="' . $show_post_count . '" show_icon="' . $show_cat_icon . '" number="' . $entries_display . '"/]');


            $args = array(
                'post_type' => BWL_KB_CPT,
                'show_option_none' => esc_attr__('- Select KB Category -', 'bwl-kb'),
                'taxonomy' => BWL_KB_TAX_CAT,
                'option_none_value' => '-1',
                'orderby' => 'title',
                'order' => 'ASC',
                'show_count' => 1,
                'hide_empty' => 0,
                'child_of' => 0,
                'echo' => 0,
                'selected' => 0,
                'hierarchical' => 1,
                'name' => 'cat',
                'class' => 'bkb_widget_cat_dropdown',
                'depth' => 0,
                'tab_index' => 3,
                'hide_if_empty' => true,
                'value_field' => 'term_id'
            );

            echo $after_widget;

            return '';
        }

        // Start Codes For Plain Category Display.

        // Build query arguments.

        $bkb_category_args = array(
            'taxonomy' => BWL_KB_TAX_CAT,
            'hide_empty' => 0,
            'orderby' => $bkb_order_by,
            'order' => $bkb_order_type
        );

        if ($entries_display != "") {

            $bkb_category_args['number'] = $entries_display;
        }

        $bkb_category_args['depth'] = 2;

        // Build Query.

        $bkb_categories = get_categories($bkb_category_args);

        // Rest Query :)

        wp_reset_query();

        // Initialize Strings.

        $bkb_post_count = "";
        $bkb_cat_icon_string = "";
        $bkb_kb_cat_default_icon = "fa fa-file-o"; // default category icon.

    ?>

<ul class="bkb-widget bkb-categories-list">

  <?php

            foreach ($bkb_categories as $category) :

                $category_link = get_term_link($category->slug, BWL_KB_TAX_CAT);

                // If user check the show cat icon box, we will going to display the icon corrosponding that category.

                if ($show_cat_icon == "on") {

                    $bkb_kb_cat_icon = get_tax_meta($category->term_id, "bkb_fa_id", true); // fixed in version 1.1.6

                    if ($bkb_kb_cat_icon == "") {

                        $bkb_kb_cat_icon = $bkb_kb_cat_default_icon;
                    }

                    $bkb_cat_icon_string = '<i class="' . $bkb_kb_cat_icon . '"></i> &nbsp;';
                }


                // If user check the show count, we will going to display the total post counts per category.

                if ($show_post_count == "on") {
                    $bkb_post_count = '&nbsp;(' . $category->count . ')';
                }


            ?>

  <li><a href="<?php echo esc_url($category_link); ?>"
      title="<?php echo $category->name; ?>"><?php echo $bkb_cat_icon_string . $category->name . $bkb_post_count; ?>
    </a></li>

  <?php

            endforeach;

            ?>

</ul> <!-- end .bkb-widget  -->

<?php

        echo $after_widget;
    }
}