<?php

/***********************************************************
 * @Description: Widget For Display Knowledge Base Tags
 * @Created At: 14-02-2013
 * @Last Edited AT: 07-04-2017
 * @Created By: Mahbub
 ***********************************************************/

function bkb_tags_widget_init()
{

    register_widget('BKB_tags_widget');
}

add_action('widgets_init', 'bkb_tags_widget_init');

class BKB_tags_widget extends WP_Widget
{

    //widget init.
    public function __construct()
    {
        parent::__construct(
            'bkb_tags_widget',
            'BKBM Tags Widget',
            array('description' => esc_attr__('Display Knowledget Base Tags.', 'bwl-kb'))
        );
    }

    //output the widget options in the back-end

    public function form($instance)
    {

        $defaults = array(
            'title' => esc_attr__('Tags', 'bwl-kb'),
            'entries_display' => "",
            'bkb_order_by' =>  'title',
            'bkb_order_type' =>  'asc',
            'sub_tag_mode' =>  'on',
            'show_post_count' =>  'on',
            'show_tag_icon' => 'on'
        );

        $instance = wp_parse_args((array) $instance, $defaults);

?>

<!-- Title  -->
<p>
  <label for="<?php echo $this->get_field_id('title') ?>"><?php esc_attr_e('Title', 'bwl-kb'); ?></label>
  <input type="text" id="<?php echo $this->get_field_id('title') ?>" name="<?php echo $this->get_field_name('title') ?>"
    class="widefat" value="<?php echo esc_attr($instance['title']) ?>" />
</p>

<p>
  <label
    for="<?php echo $this->get_field_id('entries_display') ?>"><?php esc_attr_e('Display Limit', 'bwl-kb'); ?></label>
  <input type="text" id="<?php echo $this->get_field_id('entries_display') ?>"
    name="<?php echo $this->get_field_name('entries_display') ?>" class="widefat"
    value="<?php echo esc_attr($instance['entries_display']) ?>" />
  <br /><small><?php esc_attr_e('Set any number. Example: 10 Or Keep it blank if you want to display all Tags.', 'bwl-kb'); ?></small>
</p>

<!-- Order Type -->

<p>
  <label for="<?php echo $this->get_field_id('bkb_order_by'); ?>"><?php esc_attr_e('Order By', 'bwl-kb') ?></label>
  <select id="<?php echo $this->get_field_id('bkb_order_by'); ?>"
    name="<?php echo $this->get_field_name('bkb_order_by'); ?>" class="widefat" style="width:100%;">
    <option value="title" <?php if ($instance['bkb_order_by'] == 'title') echo 'selected="selected"'; ?>>
      <?php esc_attr_e('Title', 'bwl-kb'); ?></option>
    <option value="id" <?php if ($instance['bkb_order_by'] == 'id') echo 'selected="selected"'; ?>>
      <?php esc_attr_e('ID', 'bwl-kb'); ?></option>
  </select>
</p>

<!-- Order Type -->

<p>
  <label for="<?php echo $this->get_field_id('bkb_order_type'); ?>"><?php esc_attr_e('Order Type', 'bwl-kb') ?></label>
  <select id="<?php echo $this->get_field_id('bkb_order_type'); ?>"
    name="<?php echo $this->get_field_name('bkb_order_type'); ?>" class="widefat" style="width:100%;">
    <option value="asc" <?php if ($instance['bkb_order_type'] == 'asc') echo 'selected="selected"'; ?>>
      <?php esc_attr_e('Ascending', 'bwl-kb'); ?></option>
    <option value="desc" <?php if ($instance['bkb_order_type'] == 'desc') echo 'selected="selected"'; ?>>
      <?php esc_attr_e('Descending', 'bwl-kb'); ?></option>
  </select>
</p>

<p>
  <input type="checkbox" id="<?php echo $this->get_field_id('sub_tag_mode'); ?>"
    name="<?php echo $this->get_field_name('sub_tag_mode'); ?>"
    <?php checked($instance['sub_tag_mode'], 'on'); ?> />&nbsp;
  <?php esc_attr_e('Enable Sub Category Mode?', 'bwl-kb'); ?>
</p>

<p>
  <input type="checkbox" id="<?php echo $this->get_field_id('show_post_count'); ?>"
    name="<?php echo $this->get_field_name('show_post_count'); ?>"
    <?php checked($instance['show_post_count'], 'on'); ?> />&nbsp; <?php esc_attr_e('Display Post Count?', 'bwl-kb'); ?>
</p>

<p>
  <input type="checkbox" id="<?php echo $this->get_field_id('show_tag_icon'); ?>"
    name="<?php echo $this->get_field_name('show_tag_icon'); ?>"
    <?php checked($instance['show_tag_icon'], 'on'); ?> />&nbsp; <?php esc_attr_e('Display Tag Icon?', 'bwl-kb'); ?>
</p>

<?php

    }

    //process widget option for saving
    public function update($new_instance, $old_instance)
    {
        $instance = $old_instance;

        // Widget Title
        $instance['title'] =  strip_tags($new_instance['title']);
        $instance['entries_display'] =  wp_kses_post($new_instance['entries_display']);
        $instance['bkb_order_by'] =  $new_instance['bkb_order_by'];
        $instance['bkb_order_type'] =  $new_instance['bkb_order_type'];
        $instance['sub_tag_mode'] =  $new_instance['sub_tag_mode'];
        $instance['show_post_count'] =  $new_instance['show_post_count'];
        $instance['show_tag_icon'] =  $new_instance['show_tag_icon'];

        return $instance;
    }

    //Displays the widgets on the front end.
    public function widget($args, $instance)
    {

        extract($args);

        $title = apply_filters('widget-title', $instance['title']);

        echo $before_widget;

        if ($title) :
            echo $before_title . $title . $after_title;
        endif;

        // Fetch & Manage Data From Database.

        $entries_display = isset($instance['entries_display']) ? $instance['entries_display'] : "";
        $bkb_order_by = isset($instance['bkb_order_by']) ? $instance['bkb_order_by'] : "title";
        $bkb_order_type = isset($instance['bkb_order_type']) ? $instance['bkb_order_type'] : "asc";
        $sub_tag_mode = isset($instance['sub_tag_mode']) ? $instance['sub_tag_mode'] : "";
        $show_post_count = isset($instance['show_post_count']) ? $instance['show_post_count'] : "";
        $show_tag_icon = isset($instance['show_tag_icon']) ?  $instance['show_tag_icon'] : "";
        $show_post_count = $instance['show_post_count'];

        // Sub Tags Mode feature has been added in version 1.1.8

        if ($sub_tag_mode == "on") {

            $show_post_count = ($show_post_count == "on") ? 1 : 0;
            $show_tag_icon = ($show_tag_icon == "on") ? 1 : 0;
            echo do_shortcode('[bkb_nested_sub_taxonomy taxonomy="bkb_tags" orderby="' . $bkb_order_by . '" order="' . $bkb_order_type . '" show_count="' . $show_post_count . '" show_icon="' . $show_tag_icon . '" number="' . $entries_display . '"/]');
            echo $after_widget;
            return '';
        }

        // Build query arguments.

        $bkb_tag_args = array(
            'taxonomy' => BWL_KB_TAX_TAG,
            'hide_empty' => 0,
            'orderby' => $bkb_order_by,
            'order' => $bkb_order_type
        );

        if ($entries_display != "") {

            $bkb_tag_args['number'] = $entries_display;
        }

        $bkb_tag_args['depth'] = 2;

        // Build Query.

        $bkb_tags = get_categories($bkb_tag_args);

        // Rest Query :)

        wp_reset_query();

        // Initialize Strings.

        $bkb_post_count = "";
        $bkb_tag_icon_string = "";
        $bkb_kb_tag_default_icon = "fa fa-file-o"; // default category icon.

    ?>

<ul class="bkb-widget bkb-tags-list">

  <?php

            foreach ($bkb_tags as $tag) :

                $tag_link = get_term_link($tag->slug, BWL_KB_TAX_TAG);

                // If user check the show cat icon box, we will going to display the icon corrosponding that category.

                if ($show_tag_icon == "on") {

                    //                        $bkb_kb_tag_icon = get_tax_meta( $tag->term_taxonomy_id, "bkb_fa_id", true); 
                    $bkb_kb_tag_icon = get_tax_meta($tag->term_id, "bkb_fa_id", true);

                    if ($bkb_kb_tag_icon == "") {

                        $bkb_kb_tag_icon = $bkb_kb_tag_default_icon;
                    }

                    $bkb_tag_icon_string = '<i class="' . $bkb_kb_tag_icon . '"></i> &nbsp;';
                }


                // If user check the show count, we will going to display the total post counts per category.

                if ($show_post_count == "on") {
                    $bkb_post_count = '&nbsp;(' . $tag->count . ')';
                }


            ?>

  <li><a href="<?php echo esc_url($tag_link); ?>"
      title="<?php echo $tag->name; ?>"><?php echo $bkb_tag_icon_string . $tag->name . $bkb_post_count; ?> </a></li>

  <?php

            endforeach;

            ?>

</ul> <!-- end .bkb-widget  -->

<?php

        echo $after_widget;
    }
}