<?php

/***********************************************************
 * @Description: BKB Related Posts Widget
 * @Created At: 25-04-2014
 * @Last Edited AT: 25-04-2014
 * @Created By: Mahbub
 ***********************************************************/

function bkb_toc_widget_init()
{

    register_widget('BKB_Toc_Widget');
}

add_action('widgets_init', 'bkb_toc_widget_init');


class BKB_Toc_Widget extends WP_Widget
{

    public function __construct()
    {

        parent::__construct(
            'bkb_toc_widget_init',
            esc_attr__('BKBM TOC Widget', 'bwl-kb'),
            array(
                'classname'     =>  'BKB_Toc_Widget',
                'description'    =>   esc_attr__('Display TOC in single KB pages widget area', 'bwl-kb')
            )
        );
    }

    public function form($instance)
    {

        $defaults = array(
            'title'                   =>  esc_attr__('Table Of Content', 'bwl-kb')
        );

        $instance = wp_parse_args((array) $instance, $defaults);

        extract($instance);


?>


<p>
  <label for="<?php echo $this->get_field_id('title') ?>"><?php esc_attr_e('Title', 'bwl-kb'); ?></label>
  <input type="text" class="widefat" id="<?php echo $this->get_field_id('title') ?>"
    name="<?php echo $this->get_field_name('title') ?>" value="<?php echo esc_attr($title) ?>" />
</p>

<?php

    }

    public function update($new_instance, $old_instance)
    {

        $instance                                    = $old_instance;

        $instance['title']                           = strip_tags(stripslashes($new_instance['title']));

        return $instance;
    }

    public function widget($args, $instance)
    {

        if (is_singular(BWL_KB_CPT)) {

            extract($args);

            $title  = apply_filters('widget-title', $instance['title']);

            //                $id = get_the_ID();
            //
            //                $bkb_toc_min_tag = 2;
            //                
            //                $content=get_the_content();

            //                $toc = bkb_create_toc($content, $bkb_toc_min_tag);

            //                if( empty( $toc ) ) {
            //                    return '';
            //                }

            echo $before_widget;

            if ($title) :



                echo $before_title . $title . $after_title;

            endif;

            echo $toc = '<div class="bkb-toc-widget"></div>';

            echo $after_widget;

            wp_reset_query();
        }
    }
}