(function($) {

  'use strict';

  $(document).ready(function() {

    'use strict';

    //Reload the menu when the "Cancel" button is clicked
    $(document.body).on('click', '#cancel', function(event) {

      'use strict';

      event.preventDefault();
      window.location.replace(window.dale_admin_url +
          'admin.php?page=dale-events');

    });

    //Handle the options groups ----------------------------------------------------------------------------------------
    removeBorderLastTableTr();

    $(document.body).on('click', '.group-trigger', function() {

      'use strict';

      //open and close the various sections of the tables area
      const target = $(this).attr('data-trigger-target');
      $('.' + target).toggle();

      $(this).find('.expand-icon').toggleClass('arrow-down');

      removeBorderLastTableTr();

    });

    /*
   Remove the bottom border on the last visible tr included in the form
   */
    function removeBorderLastTableTr() {

      'use strict';

      $('table.daext-form-table tr > *').css('border-bottom-width', '1px');
      $('table.daext-form-table tr:visible:last > *').
      css('border-bottom-width', '0');

    }

    //jQuery UI Datepicker ---------------------------------------------------------------------------------------------
    //create array with the available steps of the day
    var allowTimesArray = Array();
    let hour, formatted_hour, formatted_minute;

    for(hour=0;hour<=23;hour++){

      var minute = 0;

      while(minute <= 50){

        if(hour <= 9){
          formatted_hour = "0" + hour;
        }else{
          formatted_hour = hour;
        }

        if(minute <= 9){
          formatted_minute = "0" + minute;
        }else{
          formatted_minute = minute;
        }

        allowTimesArray.push(formatted_hour + ":" + formatted_minute);

        minute = minute + 10;

      }

    }

    /**
     * Initialize the date picker and set the format of the alternative field and the selector of the alternative field.
     *
     * Ref: http://api.jqueryui.com/datepicker/
     */
    let dpBaseConfig = {
      changeMonth: true,
      changeYear: true,
      yearRange: '1900:2100',
      format:'Y-m-d H:i',
      allowTimes:allowTimesArray
    };
    $( "#schema-start-date" ).datetimepicker({
      ...dpBaseConfig,
    });

  });

})(window.jQuery);