/**
 * This script creates the 'liveevents' TinyMCE plugin with the related 'selectlliveevents' TinyMCE button, more information
 * are available in the TinyMCE documentation:
 *
 * - https://www.tinymce.com/docs/
 *
 * The modal window is handled with the windowManager API:
 *
 * - https://www.tinymce.com/docs/api/tinymce/tinymce.windowmanager/
 *
 * To have a general idea on how this script works check out the following resources:
 *
 * - https://www.tinymce.com/docs/advanced/creating-a-plugin/
 * - http://jamesdigioia.com/add-button-pop-wordpresss-tinymce-editor/
 */
(function($) {

  'use strict';

  //Creates the 'liveevents' plugin
  window.tinymce.PluginManager.add('liveevents', function(editor) {

    'use strict';

    //Creates the 'selectliveevents' TinyMCE button and associate the 'openliveevents' command with its click
    editor.addButton('selectliveevents',
        {title: 'Live Events', cmd: 'openliveevents', icon: 'icon dashicons-microphone',});

    //Create the 'openliveevents' command
    editor.addCommand('openliveevents', function() {

      'use strict';

      //Open the modal window
      editor.windowManager.open({

        //Set the various properties of the modal window
        title: 'Live Events',
        width: 300,
        height: 72,
        id: 'dale-liveevents',

        /**
         * Add buttons in the bottom of the modal window. (eg. Add Event, Add Shortcode, Insert, Cancel, etc.)
         *
         * The buttons should be provided as objects of this array, in this case there is only a single object/button.
         */
        buttons: [
          {
            text: 'Add Event',
            id: 'dale-button-add-event',
            class: 'dale-button'
            ,
            onclick: function() {
              var eventId = $('#event-id').val();
              if (eventId === null) {
                eventId = '';
              }

              //Add the shortcode in the post
              editor.execCommand('mceInsertContent', false, '[le id="' + eventId + '"]');

              //Close the modal window
              editor.windowManager.close();
            },
          }],

      });

      //Generates the content of modal window
      appendContent();

    });

  });

  /**
   * Get the modal window content with an AJAX request and append it in the modal window.
   */
  function appendContent() {

    'use strict';

    //Get a reference to the DOM element
    var contentBody = $('#dale-liveevents-body');

    //Prepare the parameters for the AJAX request
    var data = {
      action: 'dale_get_modal_window_content',
      security: window.dale_nonce,
    };

    //Send the AJAX request
    $.post(window.ajaxurl, data, function(responseHtml) {

      //Append the content in the modal window
      $(contentBody).append(responseHtml);

      //Initialize Chosen
      $('#event-id').chosen();

    });

  }

})(window.jQuery);