<?php

/*
 * this class should be used to work with the administrative side of wordpress
 */

class dale_Admin
{

    protected static $instance = null;
    private $shared = null;

    private $screen_id_events = null;
    private $screen_id_timelines = null;
    private $screen_id_timelines_items = null;
    private $screen_id_timelines_icons = null;
    private $screen_id_stats = null;
    private $screen_id_stats_groups = null;
    private $screen_id_stats_items = null;
    private $screen_id_comments = null;
    private $screen_id_comments_items = null;
	private $screen_id_help = null;
    private $screen_id_options = null;

    private function __construct()
    {

        //assign an instance of the plugin info
        $this->shared = dale_Shared::get_instance();

        //Load admin stylesheets and JavaScript
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_styles'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_scripts'));

        //Write in back-end head
        add_action('admin_head', array($this, 'wr_admin_head'));

        //Add the admin menu
        add_action('admin_menu', array($this, 'me_add_admin_menu'));

        //Load the options API registrations and callbacks
        add_action('admin_init', array($this, 'op_register_options'));

        //Create tinymce plugin
        add_action('init', array($this, 'create_tinymce_plugin'));

        //this hook is triggered during the creation of a new blog
        add_action('wpmu_new_blog', array($this, 'new_blog_create_options_and_tables'), 10, 6);

        //this hook is triggered during the deletion of a blog
        add_action('delete_blog', array($this, 'delete_blog_delete_options_and_tables'), 10, 1);

        //This hook is triggered after a user is deleted
	    add_action( 'deleted_user', array($this, 'delete_comment_item_of_user'));

    }

    /*
     * return an instance of this class
     */
    public static function get_instance()
    {

        if (null == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;

    }

    /*
     * write in the admin head
     */
    public function wr_admin_head()
    {

        echo '<script type="text/javascript">';
        echo 'var dale_ajax_url = "' . admin_url('admin-ajax.php') . '";';
        echo 'var dale_nonce = "' . wp_create_nonce("dale") . '";';
        echo 'var dale_admin_url ="' . get_admin_url() . '";';
        echo 'var dale_site_url ="' . get_site_url() . '";';
        echo '</script>';

    }

    public function enqueue_admin_styles()
    {

        $screen = get_current_screen();

        //multiple menus
        if ($screen->id == $this->screen_id_events or
            $screen->id == $this->screen_id_timelines or
            $screen->id == $this->screen_id_timelines_items or
            $screen->id == $this->screen_id_timelines_icons or
            $screen->id == $this->screen_id_stats or
            $screen->id == $this->screen_id_stats_groups or
            $screen->id == $this->screen_id_stats_items or
            $screen->id == $this->screen_id_comments or
            $screen->id == $this->screen_id_comments_items) {
            wp_enqueue_style($this->shared->get('slug') . '-framework-menu',
                $this->shared->get('url') . 'admin/assets/css/framework/menu.css', array(), $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-jquery-ui-tooltip',
                $this->shared->get('url') . 'admin/assets/css/jquery-ui-tooltip.css', array(),
                $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-chosen',
                $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.css', array(),
                $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-chosen-custom',
                $this->shared->get('url') . 'admin/assets/css/chosen-custom.css', array(), $this->shared->get('ver'));
        }

        //menu events
        if ($screen->id == $this->screen_id_events) {

            wp_enqueue_style($this->shared->get('slug') . '-menu-timelines-items',
                $this->shared->get('url') . 'admin/assets/css/menu-events.css', array(), $this->shared->get('ver'));

            //jQuery UI Datepicker
            wp_enqueue_style( $this->shared->get('slug') .'-datetimepicker', $this->shared->get('url') . 'admin/assets/css/jquery.datetimepicker.css', array(), $this->shared->get('ver') );


        }

        //menu timelines
        if ($screen->id == $this->screen_id_timelines) {

            wp_enqueue_style($this->shared->get('slug') . '-menu-timelines',
                $this->shared->get('url') . 'admin/assets/css/menu-timelines.css', array(),
                $this->shared->get('ver'));

            //jQuery UI Datepicker
            wp_enqueue_style( $this->shared->get('slug') .'-datetimepicker', $this->shared->get('url') . 'admin/assets/css/jquery.datetimepicker.css', array(), $this->shared->get('ver') );

        }

        //menu timelines items
        if ($screen->id == $this->screen_id_timelines_items) {
            wp_enqueue_style($this->shared->get('slug') . '-menu-timelines-items',
                $this->shared->get('url') . 'admin/assets/css/menu-timelines-items.css', array(),
                $this->shared->get('ver'));
        }

        //menu timelines icons
        if ($screen->id == $this->screen_id_timelines_icons) {
            wp_enqueue_style($this->shared->get('slug') . '-chosen',
                $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.css', array(),
                $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-chosen-custom',
                $this->shared->get('url') . 'admin/assets/css/chosen-custom.css', array(), $this->shared->get('ver'));
        }

        //menu stats groups
        if ($screen->id == $this->screen_id_stats_groups) {
            wp_enqueue_style($this->shared->get('slug') . '-menu-stats-items',
                $this->shared->get('url') . 'admin/assets/css/menu-stats-groups.css', array(),
                $this->shared->get('ver'));
        }

        //menu stats items
        if ($screen->id == $this->screen_id_stats_items) {
            wp_enqueue_style($this->shared->get('slug') . '-menu-stats-items',
                $this->shared->get('url') . 'admin/assets/css/menu-stats-items.css', array(),
                $this->shared->get('ver'));
        }

        //menu stats items
        if ($screen->id == $this->screen_id_comments_items) {
            wp_enqueue_style($this->shared->get('slug') . '-menu-comments-items',
                $this->shared->get('url') . 'admin/assets/css/menu-comments-items.css', array(),
                $this->shared->get('ver'));
        }

	    //Menu Help
	    if ( $screen->id == $this->screen_id_help ) {

		    wp_enqueue_style( $this->shared->get( 'slug' ) . '-menu-help',
			    $this->shared->get( 'url' ) . 'admin/assets/css/menu-help.css', array(), $this->shared->get( 'ver' ) );

	    }
        
        //menu options
        if ($screen->id == $this->screen_id_options) {
            wp_enqueue_style('wp-color-picker');
            wp_enqueue_style($this->shared->get('slug') . '-framework-options',
                $this->shared->get('url') . 'admin/assets/css/framework/options.css', array(),
                $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-jquery-ui-tooltip',
                $this->shared->get('url') . 'admin/assets/css/jquery-ui-tooltip.css', array(),
                $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-chosen',
                $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.css', array(),
                $this->shared->get('ver'));
            wp_enqueue_style($this->shared->get('slug') . '-chosen-custom',
                $this->shared->get('url') . 'admin/assets/css/chosen-custom.css', array(), $this->shared->get('ver'));
        }

        $args               = array(
            'show_ui' => true
        );
        $post_types_with_ui = get_post_types($args);
        unset($post_types_with_ui['attachment']);

        if (in_array($screen->id,
                $post_types_with_ui) and current_user_can(get_option($this->shared->get('slug') . '_advanced_events_menu_capability'))) {

            /*
             * This enables the use of custom icons from Dashicons without using a .png image.
             *
             * For details: https://www.gavick.com/blog/wordpress-tinymce-custom-buttons#tc-section-4
             */
            wp_enqueue_style($this->shared->get('slug') . '-enable-dashicons-in-tinymce',
                $this->shared->get('url') . 'admin/assets/css/enable-dashicons-in-tinymce.css', array(),
                $this->shared->get('ver'));

            //Load Chosen CSS
            wp_enqueue_style($this->shared->get('slug') . '-chosen',
                $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.css', array(),
                $this->shared->get('ver'));

            //Load the CSS used in the modal window opened when the Live Events button is clicked
            wp_enqueue_style($this->shared->get('slug') . '-tinymce-modal-window',
                $this->shared->get('url') . 'admin/assets/css/tinymce-liveevents.css', array(),
                $this->shared->get('ver'));

        }

    }

    /*
     * enqueue admin-specific javascript
     */
    public function enqueue_admin_scripts()
    {

        $screen = get_current_screen();

        //multiple menus
        if ($screen->id == $this->screen_id_events or
            $screen->id == $this->screen_id_timelines or
            $screen->id == $this->screen_id_timelines_items or
            $screen->id == $this->screen_id_timelines_icons or
            $screen->id == $this->screen_id_stats or
            $screen->id == $this->screen_id_stats_groups or
            $screen->id == $this->screen_id_stats_items or
            $screen->id == $this->screen_id_comments or
            $screen->id == $this->screen_id_comments_items) {

            wp_enqueue_script('jquery-ui-tooltip');
            wp_enqueue_script($this->shared->get('slug') . '-jquery-ui-tooltip-init',
                $this->shared->get('url') . 'admin/assets/js/jquery-ui-tooltip-init.js', array('jquery'),
                $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-chosen-init',
                $this->shared->get('url') . 'admin/assets/js/chosen-init.js', array('jquery'),
                $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-chosen',
                $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.js', array('jquery'),
                $this->shared->get('ver'));

        }

        //menu events
        if ($screen->id == $this->screen_id_events) {

            wp_enqueue_script( $this->shared->get('slug') . '-jquery-datetimepicker', $this->shared->get('url') . 'admin/assets/js/jquery.datetimepicker.js', 'jquery', $this->shared->get('ver') );

            wp_enqueue_script($this->shared->get('slug') . '-menu-events',
                $this->shared->get('url') . 'admin/assets/js/menu-events.js', array('jquery', 'jquery-ui-datepicker'),
                $this->shared->get('ver'));

        }

        //menu timeline sections
        if ($screen->id == $this->screen_id_timelines) {

            wp_enqueue_script( $this->shared->get('slug') . '-jquery-datetimepicker', $this->shared->get('url') . 'admin/assets/js/jquery.datetimepicker.js', 'jquery', $this->shared->get('ver') );

            wp_enqueue_script($this->shared->get('slug') . '-menu-timelines',
                $this->shared->get('url') . 'admin/assets/js/menu-timelines.js', array('jquery', 'jquery-ui-datepicker'), $this->shared->get('ver'));
        }

        //menu timelines items
        if ($screen->id == $this->screen_id_timelines_items) {
            wp_enqueue_media();
            wp_enqueue_script($this->shared->get('slug') . '-media-uploader',
                $this->shared->get('url') . 'admin/assets/js/media-uploader.js', 'jquery', $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-menu-timelines-items',
                $this->shared->get('url') . 'admin/assets/js/menu-timelines-items.js', 'jquery',
                $this->shared->get('ver'));
        }

        //menu timelines icons
        if ($screen->id == $this->screen_id_timelines_icons) {
            wp_enqueue_media();
            wp_enqueue_script($this->shared->get('slug') . '-media-uploader',
                $this->shared->get('url') . 'admin/assets/js/media-uploader.js', 'jquery', $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-chosen-init',
                $this->shared->get('url') . 'admin/assets/js/chosen-init.js', array('jquery'),
                $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-chosen',
                $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.js', array('jquery'),
                $this->shared->get('ver'));

	        wp_enqueue_script($this->shared->get('slug') . '-menu-timeline-icons',
		        $this->shared->get('url') . 'admin/assets/js/menu-timeline-icons.js', 'jquery',
		        $this->shared->get('ver'));

        }

        //menu stat sections
        if ($screen->id == $this->screen_id_stats) {
            wp_enqueue_media();
            wp_enqueue_script($this->shared->get('slug') . '-menu-stats',
                $this->shared->get('url') . 'admin/assets/js/menu-stats.js', 'jquery', $this->shared->get('ver'));
        }

        //menu stats groups
        if ($screen->id == $this->screen_id_stats_groups) {
            wp_enqueue_media();
            wp_enqueue_script($this->shared->get('slug') . '-media-uploader',
                $this->shared->get('url') . 'admin/assets/js/media-uploader.js', 'jquery', $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-menu-stats-groups',
                $this->shared->get('url') . 'admin/assets/js/menu-stats-groups.js', 'jquery',
                $this->shared->get('ver'));
        }

        //menu stats items
        if ($screen->id == $this->screen_id_stats_items) {
            wp_enqueue_media();
            wp_enqueue_script($this->shared->get('slug') . '-media-uploader',
                $this->shared->get('url') . 'admin/assets/js/media-uploader.js', 'jquery', $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-menu-stats-items',
                $this->shared->get('url') . 'admin/assets/js/menu-stats-items.js', 'jquery', $this->shared->get('ver'));
        }

        //menu comment sections
        if ($screen->id == $this->screen_id_comments) {
            wp_enqueue_media();
            wp_enqueue_script($this->shared->get('slug') . '-menu-comments',
                $this->shared->get('url') . 'admin/assets/js/menu-comments.js', 'jquery', $this->shared->get('ver'));
        }

        //menu comment items
        if ($screen->id == $this->screen_id_comments_items) {
            wp_enqueue_media();
            wp_enqueue_script($this->shared->get('slug') . '-menu-comments-items',
                $this->shared->get('url') . 'admin/assets/js/menu-comments-items.js', 'jquery', $this->shared->get('ver'));
        }

        //menu options
        if ($screen->id == $this->screen_id_options) {
            wp_enqueue_script('jquery-ui-tooltip');
            wp_enqueue_script($this->shared->get('slug') . '-jquery-ui-tooltip-init',
                $this->shared->get('url') . 'admin/assets/js/jquery-ui-tooltip-init.js', array('jquery'),
                $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-chosen',
                $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.js', array('jquery'),
                $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-jquery-ui-chosen-init',
                $this->shared->get('url') . 'admin/assets/js/chosen-init.js', array('jquery'),
                $this->shared->get('ver'));
            wp_enqueue_script($this->shared->get('slug') . '-menu-options',
                $this->shared->get('url') . 'admin/assets/js/menu-options.js', array('jquery', 'wp-color-picker'),
                $this->shared->get('ver'));
        }

        //Enqueue scripts in all the post types of the post editor
        $args               = array(
            'show_ui' => true
        );
        $post_types_with_ui = get_post_types($args);
        unset($post_types_with_ui['attachment']);

        if (in_array($screen->id,
                $post_types_with_ui) and current_user_can(get_option($this->shared->get('slug') . '_advanced_events_menu_capability'))) {

            //Load the Chosen JS
            wp_enqueue_script($this->shared->get('slug') . '-chosen',
                $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.js', 'jquery',
                $this->shared->get('ver'));

        }

    }

    /*
     * plugin activation
     */
    public function ac_activate($networkwide)
    {

        /*
         * create options and tables for all the sites in the network
         */
        if (function_exists('is_multisite') and is_multisite()) {

            /*
             * if this is a "Network Activation" create the options and tables
             * for each blog
             */
            if ($networkwide) {

                //get the current blog id
                global $wpdb;
                $current_blog = $wpdb->blogid;

                //create an array with all the blog ids
                $blogids = $wpdb->get_col("SELECT blog_id FROM $wpdb->blogs");

                //iterate through all the blogs
                foreach ($blogids as $blog_id) {

                    //switch to the iterated blog
                    switch_to_blog($blog_id);

                    //create options and tables for the iterated blog
                    $this->ac_initialize_options();
                    $this->ac_create_database_tables();
                    $this->ac_initialize_custom_css();

                }

                //switch to the current blog
                switch_to_blog($current_blog);

            } else {

                /*
                 * if this is not a "Network Activation" create options and
                 * tables only for the current blog
                 */
                $this->ac_initialize_options();
                $this->ac_create_database_tables();
                $this->ac_initialize_custom_css();

            }

        } else {

            /*
             * if this is not a multisite installation create options and
             * tables only for the current blog
             */
            $this->ac_initialize_options();
            $this->ac_create_database_tables();
            $this->ac_initialize_custom_css();

        }

    }

    //create the options and tables for the newly created blog
    public function new_blog_create_options_and_tables($blog_id, $user_id, $domain, $path, $site_id, $meta)
    {

        global $wpdb;

        /*
         * if the plugin is "Network Active" create the options and tables for
         * this new blog
         */
        if (is_plugin_active_for_network('daext-live-events/init.php')) {

            //get the id of the current blog
            $current_blog = $wpdb->blogid;

            //switch to the blog that is being activated
            switch_to_blog($blog_id);

            //create options and database tables for the new blog
            $this->ac_initialize_options();
            $this->ac_create_database_tables();
            $this->ac_initialize_custom_css();

            //switch to the current blog
            switch_to_blog($current_blog);

        }

    }

    //delete options and tables for the deleted blog
    public function delete_blog_delete_options_and_tables($blog_id)
    {

        global $wpdb;

        //get the id of the current blog
        $current_blog = $wpdb->blogid;

        //switch to the blog that is being activated
        switch_to_blog($blog_id);

        //create options and database tables for the new blog
        $this->un_delete_options();
        $this->un_delete_database_tables();

        //switch to the current blog
        switch_to_blog($current_blog);

    }

    /*
     * initialize plugin options
     */
    private function ac_initialize_options()
    {

        //database version -----------------------------------------------------
        add_option($this->shared->get('slug') . "_database_version", "0");

        //General
        add_option($this->shared->get('slug') . "_general_separators_color", "#e0e0e0");
        add_option($this->shared->get('slug') . "_general_section_title_background_color", "#fcfcfc");
        add_option($this->shared->get('slug') . "_general_section_title_border_color", "#e0e0e0");
        add_option($this->shared->get('slug') . "_general_section_title_font_color", "#777777");
        add_option($this->shared->get('slug') . "_general_tab_font_color", "#a8a8a8");
        add_option($this->shared->get('slug') . "_general_active_tab_border_color", "#5488db");
        add_option($this->shared->get('slug') . "_general_active_tab_font_color", "#222222");
        add_option($this->shared->get('slug') . "_general_font_family", "'Open Sans', sans-serif");
        add_option($this->shared->get('slug') . "_general_base_font_size", "13");
        add_option($this->shared->get('slug') . "_general_top_margin", "0");
        add_option($this->shared->get('slug') . "_general_bottom_margin", "21");
        add_option($this->shared->get('slug') . "_general_responsive_breakpoint", "481");

        //Timeline
        add_option($this->shared->get('slug') . "_timeline_item_date_font_color", "#a8a8a8");
        add_option($this->shared->get('slug') . "_timeline_item_title_font_color", "#222222");
        add_option($this->shared->get('slug') . "_timeline_item_description_font_color", "#666666");
        add_option($this->shared->get('slug') . "_timeline_item_date_font_weight", "400");
        add_option($this->shared->get('slug') . "_timeline_item_title_font_weight", "600");
        add_option($this->shared->get('slug') . "_timeline_item_description_font_weight", "400");

        //Comment
        add_option($this->shared->get('slug') . "_comment_textarea_background_color", "#ffffff");
        add_option($this->shared->get('slug') . "_comment_textarea_border_color", "#e0e0e0");
        add_option($this->shared->get('slug') . "_comment_textarea_font_color", "#666666");
        add_option($this->shared->get('slug') . "_comment_heading_font_color", "#a8a8a8");
        add_option($this->shared->get('slug') . "_comment_content_font_color", "#666666");
        add_option($this->shared->get('slug') . "_comment_submit_comment_font_color", "#5488db");
        add_option($this->shared->get('slug') . "_comment_submit_comment_hover_font_color", "#5e97f2");
        add_option($this->shared->get('slug') . "_comment_message_background_color", "#fcfcfc");
        add_option($this->shared->get('slug') . "_comment_message_border_color", "#e0e0e0");
        add_option($this->shared->get('slug') . "_comment_message_font_color", "#777777");
        add_option($this->shared->get('slug') . "_comment_textarea_font_weight", "400");
        add_option($this->shared->get('slug') . "_comment_heading_font_weight", "400");
        add_option($this->shared->get('slug') . "_comment_content_font_weight", "400");
        add_option($this->shared->get('slug') . "_comment_submit_comment_font_weight", "400");
        add_option($this->shared->get('slug') . "_comment_empty_comment_text", "Empty comments are not allowed");
        add_option($this->shared->get('slug') . "_comment_message_under_moderation_text", "Message under moderation");
        add_option($this->shared->get('slug') . "_comment_comment_limit_text", "You have submitted too many comments");
        add_option($this->shared->get('slug') . "_comment_number_of_comments_single_text", "Comment");
        add_option($this->shared->get('slug') . "_comment_number_of_comments_multiple_text", "Comments");
        add_option($this->shared->get('slug') . "_comment_submit_comment_text", "Post Comment");
        add_option($this->shared->get('slug') . "_comment_sign_in_text", "Sign in to Comment");

        //Stat
        add_option($this->shared->get('slug') . "_stat_subject_font_color", "#666666");
        add_option($this->shared->get('slug') . "_stat_value_font_color", "#666666");
        add_option($this->shared->get('slug') . "_stat_subject_visual_font_color", "#fafafa");
        add_option($this->shared->get('slug') . "_stat_value_visual_font_color", "#fafafa");
        add_option($this->shared->get('slug') . "_stat_bar_value_color", "#5488db");
        add_option($this->shared->get('slug') . "_stat_bar_background_color", "#bbbbbb");
        add_option($this->shared->get('slug') . "_stat_subject_font_weight", "400");
        add_option($this->shared->get('slug') . "_stat_value_font_weight", "400");
        add_option($this->shared->get('slug') . "_stat_subject_visual_font_weight", "400");
        add_option($this->shared->get('slug') . "_stat_value_visual_font_weight", "400");

        //Social
        add_option($this->shared->get('slug') . "_social_icons_color", "#666666");
        add_option($this->shared->get('slug') . "_social_icons_hover_color", "#5488db");
        add_option($this->shared->get('slug') . "_social_share_font_color", "#666666");
        add_option($this->shared->get('slug') . "_social_facebook", "1");
        add_option($this->shared->get('slug') . "_social_twitter", "1");
        add_option($this->shared->get('slug') . "_social_google_plus", "1");
        add_option($this->shared->get('slug') . "_social_pinterest", "1");
        add_option($this->shared->get('slug') . "_social_linkedin", "1");
        add_option($this->shared->get('slug') . "_social_tumblr", "1");
        add_option($this->shared->get('slug') . "_social_email", "1");
        add_option($this->shared->get('slug') . "_social_share_font_weight", "400");
        add_option($this->shared->get('slug') . "_social_share_text", "Share");

        //Advanced
        add_option($this->shared->get('slug') . "_advanced_assets_mode", "1");
        add_option($this->shared->get('slug') . "_advanced_sign_in_mode", "1");
        add_option($this->shared->get('slug') . "_advanced_manual_sign_in_url", wp_login_url());
        add_option($this->shared->get('slug') . "_advanced_apply_kses", "0");
        add_option($this->shared->get('slug') . "_advanced_kses_allowed_html_tags", "a[href][title], br, em, strong, p[style], span[style]");
        add_option($this->shared->get('slug') . "_advanced_kses_allowed_protocols",
            "http, https, ftp, mailto, news, irc, gopher, nntp, feed, telnet");
	    add_option($this->shared->get('slug') . "_advanced_html_editor", "0");
        add_option($this->shared->get('slug') . "_advanced_update_time", "10");
        add_option($this->shared->get('slug') . "_advanced_transient_expiration", "10");
        add_option($this->shared->get('slug') . "_advanced_comment_limit", "10");
        add_option($this->shared->get('slug') . "_advanced_google_font_embed",
            "https://fonts.googleapis.com/css?family=Open+Sans:400,600&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese");
        add_option($this->shared->get('slug') . "_advanced_instagram_process_embed", "1");
        add_option($this->shared->get('slug') . "_advanced_clone_timeline_items", "0");
        add_option($this->shared->get('slug') . "_advanced_clone_stat_groups", "0");
        add_option($this->shared->get('slug') . "_advanced_clone_stat_items", "0");
        add_option($this->shared->get('slug') . "_advanced_clone_comment_items", "0");
        add_option($this->shared->get('slug') . "_advanced_events_menu_pagination", "10");
        add_option($this->shared->get('slug') . "_advanced_timeline_sections_menu_pagination", "10");
        add_option($this->shared->get('slug') . "_advanced_timeline_items_menu_pagination", "10");
        add_option($this->shared->get('slug') . "_advanced_timeline_icons_menu_pagination", "10");
        add_option($this->shared->get('slug') . "_advanced_stat_sections_menu_pagination", "10");
        add_option($this->shared->get('slug') . "_advanced_stat_groups_menu_pagination", "10");
        add_option($this->shared->get('slug') . "_advanced_stat_items_menu_pagination", "10");
        add_option($this->shared->get('slug') . "_advanced_comment_sections_menu_pagination", "10");
        add_option($this->shared->get('slug') . "_advanced_comment_items_menu_pagination", "10");
        add_option($this->shared->get('slug') . "_advanced_write_comments_pagination", "10");
        add_option($this->shared->get('slug') . "_advanced_events_menu_capability", "edit_others_posts");
        add_option($this->shared->get('slug') . "_advanced_timeline_sections_menu_capability", "edit_others_posts");
        add_option($this->shared->get('slug') . "_advanced_timeline_items_menu_capability", "edit_others_posts");
        add_option($this->shared->get('slug') . "_advanced_timeline_icons_menu_capability", "edit_others_posts");
        add_option($this->shared->get('slug') . "_advanced_stat_sections_menu_capability", "edit_others_posts");
        add_option($this->shared->get('slug') . "_advanced_stat_groups_menu_capability", "edit_others_posts");
        add_option($this->shared->get('slug') . "_advanced_stat_items_menu_capability", "edit_others_posts");
        add_option($this->shared->get('slug') . "_advanced_comment_sections_menu_capability", "edit_others_posts");
        add_option($this->shared->get('slug') . "_advanced_comment_items_menu_capability", "edit_others_posts");
        add_option($this->shared->get('slug') . "_advanced_write_comments_capability", "read");

    }

    /*
     * create the plugin database tables
     */
    private function ac_create_database_tables()
    {

        global $wpdb;

        //Get the database character collate that will be appended at the end of each query
        $charset_collate = $wpdb->get_charset_collate();

        //check database version and create the database
        if (intval(get_option($this->shared->get('slug') . '_database_version'), 10) < 1) {

            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

            //create *prefix*_dale_event
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_event";
            $sql        = "CREATE TABLE $table_name (
              event_id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
              name VARCHAR(255) DEFAULT '' NOT NULL,
              description VARCHAR(255) DEFAULT '' NOT NULL,
              live TINYINT(1) NOT NULL,
              schema_start_date DATETIME NOT NULL,
              schema_timezone VARCHAR(6) NOT NULL,
              schema_location TEXT NOT NULL
            ) $charset_collate";

            dbDelta($sql);

            //create *prefix*_dale_timeline
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
            $sql        = "CREATE TABLE $table_name (
              timeline_id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
              event_id BIGINT NOT NULL,
              name VARCHAR(255) DEFAULT '' NOT NULL,
              description VARCHAR(255) NOT NULL,
              time_mode TINYINT(1) DEFAULT 0 NOT NULL,
              show_icon TINYINT(1) DEFAULT 0 NOT NULL,
              structured_data TINYINT(1) DEFAULT 0 NOT NULL,
              schema_coverage_start_time DATETIME NOT NULL,
              schema_coverage_end_time DATETIME NOT NULL,
              label VARCHAR(255) DEFAULT 'Live' NOT NULL,
              `index` SMALLINT DEFAULT 0 NOT NULL
            ) $charset_collate";

            dbDelta($sql);

            //create *prefix*_dale_timeline_item
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
            $sql        = "CREATE TABLE $table_name (
              timeline_item_id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
              timeline_id BIGINT NOT NULL,
              title VARCHAR(255) DEFAULT '' NOT NULL,
              extra SMALLINT DEFAULT 0 NOT NULL,
              content text DEFAULT '' NOT NULL,
              html text DEFAULT '' NOT NULL,
              image VARCHAR(2083) DEFAULT '' NOT NULL,
              tweet_id VARCHAR(50) DEFAULT '' NOT NULL,
              date DATETIME NOT NULL,
              date_gmt DATETIME NOT NULL,
              manual_time VARCHAR(255) DEFAULT '' NOT NULL,
              icon BIGINT NOT NULL
            ) $charset_collate";

            dbDelta($sql);

            //create *prefix*_dale_timeline_icon
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline_icon";
            $sql        = "CREATE TABLE $table_name (
              timeline_icon_id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
              name VARCHAR(255) DEFAULT '' NOT NULL,
              description VARCHAR(255) NOT NULL,
              url VARCHAR(2083) DEFAULT '' NOT NULL
            ) $charset_collate";

            dbDelta($sql);

            //create *prefix*_dale_stat
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat";
            $sql        = "CREATE TABLE $table_name (
              stat_id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
              event_id BIGINT NOT NULL,
              name VARCHAR(255) DEFAULT '' NOT NULL,
              description VARCHAR(255) DEFAULT '' NOT NULL,
              label VARCHAR(255) DEFAULT 'Stats' NOT NULL,
              `index` SMALLINT DEFAULT 0 NOT NULL
            ) $charset_collate";

            dbDelta($sql);

            //create *prefix*_dale_stat_group
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
            $sql        = "CREATE TABLE $table_name (
              stat_group_id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
              stat_id BIGINT NOT NULL,
              name VARCHAR(255) DEFAULT '' NOT NULL,
              description VARCHAR(255) DEFAULT '' NOT NULL,
              label VARCHAR(255) DEFAULT 'Group' NOT NULL,
              `index` SMALLINT DEFAULT 0 NOT NULL
            ) $charset_collate";

            dbDelta($sql);

            //create *prefix*_dale_stat_item
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
            $sql        = "CREATE TABLE $table_name (
              stat_item_id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
              stat_group_id BIGINT NOT NULL,
              type SMALLINT DEFAULT 0 NOT NULL,
              subject VARCHAR(23) DEFAULT 'Subject' NOT NULL,
              value_1 INT UNSIGNED DEFAULT 0 NOT NULL,
              reference INT UNSIGNED DEFAULT 100 NOT NULL,
              value_2 INT UNSIGNED DEFAULT 0 NOT NULL,
              percentage TINYINT(1) DEFAULT 0 NOT NULL,
              `index` SMALLINT DEFAULT 0 NOT NULL
            ) $charset_collate";

            dbDelta($sql);

            //create *prefix*_dale_comment
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment";
            $sql        = "CREATE TABLE $table_name (
              comment_id BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,
              event_id BIGINT NOT NULL,
              name VARCHAR(255) DEFAULT '' NOT NULL,
              description VARCHAR(255) DEFAULT '' NOT NULL,
              closed TINYINT(1) DEFAULT 0 NOT NULL,
              avatar TINYINT(1) DEFAULT 0 NOT NULL,
              label VARCHAR(255) DEFAULT 'Comments' NOT NULL,
              `index` SMALLINT DEFAULT 0 NOT NULL
            ) $charset_collate";

            dbDelta($sql);

            //create *prefix*_dale_comment_item
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
            $sql        = "CREATE TABLE $table_name (
              comment_item_id BIGINT AUTO_INCREMENT PRIMARY KEY,
              comment_id BIGINT NOT NULL,
              user_id BIGINT DEFAULT 0 NOT NULL,
              content TEXT DEFAULT '' NOT NULL,
              approved TINYINT(1) DEFAULT 0 NOT NULL,
              date DATETIME NOT NULL,
              date_gmt DATETIME NOT NULL
            ) $charset_collate";

            dbDelta($sql);

            //Update database version
            update_option($this->shared->get('slug') . '_database_version', "1");

        }

    }

    /*
     * initialize the custom-[blog_id].css file
     */
    public function ac_initialize_custom_css(){

        /*
         * Write the custom-[blog_id].css file or die if the file can't be
         * created or modified
         */
        if( $this->write_custom_css() === false ){
            die( 'The ' . esc_attr($this->shared->get('dir')) . 'public/assets/css/custom-' . get_current_blog_id() . '.css file should be writable by the server. Please change its permissions and try again.');
        }

    }

    /*
     * plugin delete
     */
    static public function un_delete()
    {

        /*
         * delete options and tables for all the sites in the network
         */
        if (function_exists('is_multisite') and is_multisite()) {

            //get the current blog id
            global $wpdb;
            $current_blog = $wpdb->blogid;

            //create an array with all the blog ids
            $blogids = $wpdb->get_col("SELECT blog_id FROM $wpdb->blogs");

            //iterate through all the blogs
            foreach ($blogids as $blog_id) {

                //switch to the iterated blog
                switch_to_blog($blog_id);

                //create options and tables for the iterated blog
                dale_Admin::un_delete_options();
                dale_Admin::un_delete_database_tables();

            }

            //switch to the current blog
            switch_to_blog($current_blog);

        } else {

            /*
             * if this is not a multisite installation delete options and
             * tables only for the current blog
             */
            dale_Admin::un_delete_options();
            dale_Admin::un_delete_database_tables();

        }

    }

    /*
     * delete plugin options
     */
    static public function un_delete_options()
    {

        //assign an instance of dale_Shared
        $shared = dale_Shared::get_instance();

        //database version -----------------------------------------------------
        delete_option($shared->get('slug') . "_database_version");

        //General
        delete_option($shared->get('slug') . "_general_separators_color");
        delete_option($shared->get('slug') . "_general_section_title_background_color");
        delete_option($shared->get('slug') . "_general_section_title_border_color");
        delete_option($shared->get('slug') . "_general_section_title_font_color");
        delete_option($shared->get('slug') . "_general_tab_font_color");
        delete_option($shared->get('slug') . "_general_active_tab_border_color");
        delete_option($shared->get('slug') . "_general_active_tab_font_color");
        delete_option($shared->get('slug') . "_general_font_family");
        delete_option($shared->get('slug') . "_general_base_font_size");
        delete_option($shared->get('slug') . "_general_top_margin");
        delete_option($shared->get('slug') . "_general_bottom_margin");
        delete_option($shared->get('slug') . "_general_responsive_breakpoint");

        //Timeline
        delete_option($shared->get('slug') . "_timeline_item_date_font_color");
        delete_option($shared->get('slug') . "_timeline_item_title_font_color");
        delete_option($shared->get('slug') . "_timeline_item_description_font_color");
        delete_option($shared->get('slug') . "_timeline_item_date_font_weight");
        delete_option($shared->get('slug') . "_timeline_item_title_font_weight");
        delete_option($shared->get('slug') . "_timeline_item_description_font_weight");

        //Comment
        delete_option($shared->get('slug') . "_comment_textarea_background_color");
        delete_option($shared->get('slug') . "_comment_textarea_border_color");
        delete_option($shared->get('slug') . "_comment_textarea_font_color");
        delete_option($shared->get('slug') . "_comment_heading_font_color");
        delete_option($shared->get('slug') . "_comment_content_font_color");
        delete_option($shared->get('slug') . "_comment_submit_comment_font_color");
        delete_option($shared->get('slug') . "_comment_submit_comment_hover_font_color");
        delete_option($shared->get('slug') . "_comment_message_background_color");
        delete_option($shared->get('slug') . "_comment_message_border_color");
        delete_option($shared->get('slug') . "_comment_message_font_color");
        delete_option($shared->get('slug') . "_comment_textarea_font_weight");
        delete_option($shared->get('slug') . "_comment_heading_font_weight");
        delete_option($shared->get('slug') . "_comment_content_font_weight");
        delete_option($shared->get('slug') . "_comment_submit_comment_font_weight");
        delete_option($shared->get('slug') . "_comment_empty_comment_text");
        delete_option($shared->get('slug') . "_comment_message_under_moderation_text");
        delete_option($shared->get('slug') . "_comment_comment_limit_text");
        delete_option($shared->get('slug') . "_comment_number_of_comments_single_text");
        delete_option($shared->get('slug') . "_comment_number_of_comments_multiple_text");
        delete_option($shared->get('slug') . "_comment_submit_comment_text");
        delete_option($shared->get('slug') . "_comment_sign_in_text");

        //Stat
        delete_option($shared->get('slug') . "_stat_subject_font_color");
        delete_option($shared->get('slug') . "_stat_value_font_color");
        delete_option($shared->get('slug') . "_stat_subject_visual_font_color");
        delete_option($shared->get('slug') . "_stat_value_visual_font_color");
        delete_option($shared->get('slug') . "_stat_bar_value_color");
        delete_option($shared->get('slug') . "_stat_bar_background_color");
        delete_option($shared->get('slug') . "_stat_subject_font_weight");
        delete_option($shared->get('slug') . "_stat_value_font_weight");
        delete_option($shared->get('slug') . "_stat_subject_visual_font_weight");
        delete_option($shared->get('slug') . "_stat_value_visual_font_weight");

        //Social
        delete_option($shared->get('slug') . "_social_icons_color");
        delete_option($shared->get('slug') . "_social_icons_hover_color");
        delete_option($shared->get('slug') . "_social_share_font_color");
        delete_option($shared->get('slug') . "_social_facebook");
        delete_option($shared->get('slug') . "_social_twitter");
        delete_option($shared->get('slug') . "_social_google_plus");
        delete_option($shared->get('slug') . "_social_pinterest");
        delete_option($shared->get('slug') . "_social_linkedin");
        delete_option($shared->get('slug') . "_social_tumblr");
        delete_option($shared->get('slug') . "_social_email");
        delete_option($shared->get('slug') . "_social_share_font_weight");
        delete_option($shared->get('slug') . "_social_share_text");

        //Advanced
        delete_option($shared->get('slug') . "_advanced_assets_mode");
        delete_option($shared->get('slug') . "_advanced_sign_in_mode");
        delete_option($shared->get('slug') . "_advanced_manual_sign_in_url");
        delete_option($shared->get('slug') . "_advanced_apply_kses");
        delete_option($shared->get('slug') . "_advanced_kses_allowed_html_tags");
        delete_option($shared->get('slug') . "_advanced_kses_allowed_protocols");
        delete_option($shared->get('slug') . "_advanced_html_editor");
        delete_option($shared->get('slug') . "_advanced_update_time");
        delete_option($shared->get('slug') . "_advanced_transient_expiration");
        delete_option($shared->get('slug') . "_advanced_comment_limit");
        delete_option($shared->get('slug') . "_advanced_google_font_embed");
        delete_option($shared->get('slug') . "_advanced_instagram_process_embed");
        delete_option($shared->get('slug') . "_advanced_clone_timeline_items");
        delete_option($shared->get('slug') . "_advanced_clone_stat_groups");
        delete_option($shared->get('slug') . "_advanced_clone_stat_items");
        delete_option($shared->get('slug') . "_advanced_clone_comment_items");
        delete_option($shared->get('slug') . "_advanced_events_menu_pagination");
        delete_option($shared->get('slug') . "_advanced_timeline_sections_menu_pagination");
        delete_option($shared->get('slug') . "_advanced_timeline_items_menu_pagination");
        delete_option($shared->get('slug') . "_advanced_timeline_icons_menu_pagination");
        delete_option($shared->get('slug') . "_advanced_stat_sections_menu_pagination");
        delete_option($shared->get('slug') . "_advanced_stat_groups_menu_pagination");
        delete_option($shared->get('slug') . "_advanced_stat_items_menu_pagination");
        delete_option($shared->get('slug') . "_advanced_comment_sections_menu_pagination");
        delete_option($shared->get('slug') . "_advanced_comment_items_menu_pagination");
        delete_option($shared->get('slug') . "_advanced_write_comments_pagination");
        delete_option($shared->get('slug') . "_advanced_events_menu_capability");
        delete_option($shared->get('slug') . "_advanced_timeline_sections_menu_capability");
        delete_option($shared->get('slug') . "_advanced_timeline_items_menu_capability");
        delete_option($shared->get('slug') . "_advanced_timeline_icons_menu_capability");
        delete_option($shared->get('slug') . "_advanced_stat_sections_menu_capability");
        delete_option($shared->get('slug') . "_advanced_stat_groups_menu_capability");
        delete_option($shared->get('slug') . "_advanced_stat_items_menu_capability");
        delete_option($shared->get('slug') . "_advanced_comment_sections_menu_capability");
        delete_option($shared->get('slug') . "_advanced_comment_items_menu_capability");
        delete_option($shared->get('slug') . "_advanced_write_comments_capability");

    }

    /*
     * delete plugin database tables
     */
    static public function un_delete_database_tables()
    {

        //assign an instance of dale_Shared
        $shared = dale_Shared::get_instance();

        global $wpdb;

        $table_name = $wpdb->prefix . $shared->get('slug') . "_event";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query($sql);

        $table_name = $wpdb->prefix . $shared->get('slug') . "_timeline";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query($sql);

        $table_name = $wpdb->prefix . $shared->get('slug') . "_timeline_item";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query($sql);

        $table_name = $wpdb->prefix . $shared->get('slug') . "_timeline_icon";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query($sql);

        $table_name = $wpdb->prefix . $shared->get('slug') . "_stat";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query($sql);

        $table_name = $wpdb->prefix . $shared->get('slug') . "_stat_group";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query($sql);

        $table_name = $wpdb->prefix . $shared->get('slug') . "_stat_item";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query($sql);

        $table_name = $wpdb->prefix . $shared->get('slug') . "_comment";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query($sql);

        $table_name = $wpdb->prefix . $shared->get('slug') . "_comment_item";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query($sql);

    }

    /*
     * register the admin menu
     */
    public function me_add_admin_menu()
    {

        add_menu_page(
            'LE',
            esc_attr__('Live Events', 'dale'),
            get_option($this->shared->get('slug') . '_advanced_events_menu_capability'),
            $this->shared->get('slug') . '-events',
            array($this, 'me_display_menu_events'),
            'dashicons-microphone'
        );

        $this->screen_id_events = add_submenu_page(
            $this->shared->get('slug') . '-events',
            esc_attr__('LE - Events', 'dale'),
            esc_attr__('Events', 'dale'),
            get_option($this->shared->get('slug') . '_advanced_events_menu_capability'),
            $this->shared->get('slug') . '-events',
            array($this, 'me_display_menu_events')
        );

        $this->screen_id_timelines = add_submenu_page(
            $this->shared->get('slug') . '-events',
            esc_attr__('LE - Timeline Sections', 'dale'),
            esc_attr__('Timeline Sections', 'dale'),
            get_option($this->shared->get('slug') . '_advanced_timeline_sections_menu_capability'),
            $this->shared->get('slug') . '-timeline-sections',
            array($this, 'me_display_menu_timeline_sections')
        );

        $this->screen_id_timelines_items = add_submenu_page(
            $this->shared->get('slug') . '-events',
            esc_attr__('LE - Timeline Items', 'dale'),
            esc_attr__('Timeline Items', 'dale'),
            get_option($this->shared->get('slug') . '_advanced_timeline_items_menu_capability'),
            $this->shared->get('slug') . '-timeline-items',
            array($this, 'me_display_menu_timeline_items')
        );

        $this->screen_id_timelines_icons = add_submenu_page(
            $this->shared->get('slug') . '-events',
            esc_attr__('LE - Timeline Icons', 'dale'),
            esc_attr__('Timeline Icons', 'dale'),
            get_option($this->shared->get('slug') . '_advanced_timeline_icons_menu_capability'),
            $this->shared->get('slug') . '-timeline-icons',
            array($this, 'me_display_menu_timeline_icons')
        );

        $this->screen_id_stats = add_submenu_page(
            $this->shared->get('slug') . '-events',
            esc_attr__('LE - Stat Sections', 'dale'),
            esc_attr__('Stat Sections', 'dale'),
            get_option($this->shared->get('slug') . '_advanced_stat_sections_menu_capability'),
            $this->shared->get('slug') . '-stat-sections',
            array($this, 'me_display_menu_stat_sections')
        );

        $this->screen_id_stats_groups = add_submenu_page(
            $this->shared->get('slug') . '-events',
            esc_attr__('LE - Stat Groups', 'dale'),
            esc_attr__('Stat Groups', 'dale'),
            get_option($this->shared->get('slug') . '_advanced_stat_groups_menu_capability'),
            $this->shared->get('slug') . '-stat-groups',
            array($this, 'me_display_menu_stat_groups')
        );

        $this->screen_id_stats_items = add_submenu_page(
            $this->shared->get('slug') . '-events',
            esc_attr__('LE - Stat Items', 'dale'),
            esc_attr__('Stat Items', 'dale'),
            get_option($this->shared->get('slug') . '_advanced_stat_items_menu_capability'),
            $this->shared->get('slug') . '-stat-items',
            array($this, 'me_display_menu_stat_items')
        );

        $this->screen_id_comments = add_submenu_page(
            $this->shared->get('slug') . '-events',
            esc_attr__('LE - Comment Sections', 'dale'),
            esc_attr__('Comment Sections', 'dale'),
            get_option($this->shared->get('slug') . '_advanced_comment_sections_menu_capability'),
            $this->shared->get('slug') . '-comment-sections',
            array($this, 'me_display_menu_comment_sections')
        );

        $this->screen_id_comments_items = add_submenu_page(
            $this->shared->get('slug') . '-events',
            esc_attr__('LE - Comment Items', 'dale'),
            esc_attr__('Comment Items', 'dale'),
            get_option($this->shared->get('slug') . '_advanced_comment_items_menu_capability'),
            $this->shared->get('slug') . '-comment-items',
            array($this, 'me_display_menu_comment_items')
        );

	    $this->screen_id_help = add_submenu_page(
		    $this->shared->get('slug') . '-events',
		    esc_html__('LE - Help', 'dale'),
		    esc_html__('Help', 'dale'),
		    'manage_options',
		    $this->shared->get('slug') . '-help',
		    array( $this, 'me_display_menu_help')
	    );

        $this->screen_id_options = add_submenu_page(
            $this->shared->get('slug') . '-events',
            esc_attr__('LE - Options', 'dale'),
            esc_attr__('Options', 'dale'),
            'manage_options',
            $this->shared->get('slug') . '-options',
            array($this, 'me_display_menu_options')
        );

    }

    /*
     * includes the events view
     */
    public function me_display_menu_events()
    {
        include_once('view/events.php');
    }

    /*
     * includes the timeline sections
     */
    public function me_display_menu_timeline_sections()
    {
        include_once('view/timeline_sections.php');
    }

    /*
     * includes the timelines items view
     */
    public function me_display_menu_timeline_items()
    {
        include_once('view/timeline_items.php');
    }

    /*
     * includes the timelines icons view
     */
    public function me_display_menu_timeline_icons()
    {
        include_once('view/timeline_icons.php');
    }

    /*
     * includes the stat sections view
     */
    public function me_display_menu_stat_sections()
    {
        include_once('view/stat_sections.php');
    }

    /*
     * includes the stat groups view
     */
    public function me_display_menu_stat_groups()
    {
        include_once('view/stat_groups.php');
    }

    /*
     * includes the stats items items view
     */
    public function me_display_menu_stat_items()
    {
        include_once('view/stat_items.php');
    }

    /*
     * includes the comment sections items view
     */
    public function me_display_menu_comment_sections()
    {
        include_once('view/comment_sections.php');
    }

    /*
     * includes the comment items items view
     */
    public function me_display_menu_comment_items()
    {
        include_once('view/comment_items.php');
    }

	/*
     * includes the help view
     */
	public function me_display_menu_help() {
		include_once( 'view/help.php' );
	}

    /*
     * includes the options view
     */
    public function me_display_menu_options()
    {
        include_once('view/options.php');
    }

    /*
     * register options
     */
    public function op_register_options()
    {

        //General Section ----------------------------------------------------------------------------------------------
        add_settings_section(
            'dale_general_settings_section',
            null,
            null,
            'dale_general_options'
        );

        add_settings_field(
            'general_separators_color',
            esc_attr__('Separators Color', 'dale'),
            array($this, 'general_separators_color_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_separators_color',
            array($this, 'general_separators_color_validation')
        );

        add_settings_field(
            'general_section_title_background_color',
            esc_attr__('Section Title Background Color', 'dale'),
            array($this, 'general_section_title_background_color_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_section_title_background_color',
            array($this, 'general_section_title_background_color_validation')
        );

        add_settings_field(
            'general_section_title_border_color',
            esc_attr__('Section Title Border Color', 'dale'),
            array($this, 'general_section_title_border_color_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_section_title_border_color',
            array($this, 'general_section_title_border_color_validation')
        );

        add_settings_field(
            'general_section_title_font_color',
            esc_attr__('Section Title Font Color', 'dale'),
            array($this, 'general_section_title_font_color_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_section_title_font_color',
            array($this, 'general_section_title_font_color_validation')
        );

        add_settings_field(
            'general_tab_font_color',
            esc_attr__('Tab Font Color', 'dale'),
            array($this, 'general_tab_font_color_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_tab_font_color',
            array($this, 'general_tab_font_color_validation')
        );

        add_settings_field(
            'general_active_tab_border_color',
            esc_attr__('Active Tab Border Color', 'dale'),
            array($this, 'general_active_tab_border_color_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_active_tab_border_color',
            array($this, 'general_active_tab_border_color_validation')
        );

        add_settings_field(
            'general_active_tab_font_color',
            esc_attr__('Active Tab Font Color', 'dale'),
            array($this, 'general_active_tab_font_color_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_active_tab_font_color',
            array($this, 'general_active_tab_font_color_validation')
        );

        add_settings_field(
            'general_font_family',
            esc_attr__('Font Family', 'dale'),
            array($this, 'general_font_family_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_font_family',
            array($this, 'general_font_family_validation')
        );

        add_settings_field(
            'general_base_font_size',
            esc_attr__('Base Font Size', 'dale'),
            array($this, 'general_base_font_size_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_base_font_size',
            array($this, 'general_base_font_size_validation')
        );

        add_settings_field(
            'general_top_margin',
            esc_attr__('Top Margin', 'dale'),
            array($this, 'general_top_margin_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_top_margin',
            array($this, 'general_top_margin_validation')
        );

        add_settings_field(
            'general_bottom_margin',
            esc_attr__('Bottom Margin', 'dale'),
            array($this, 'general_bottom_margin_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_bottom_margin',
            array($this, 'general_bottom_margin_validation')
        );

        add_settings_field(
            'general_responsive_breakpoint',
            esc_attr__('Responsive Breakpoint', 'dale'),
            array($this, 'general_responsive_breakpoint_callback'),
            'dale_general_options',
            'dale_general_settings_section'
        );

        register_setting(
            'dale_general_options',
            'dale_general_responsive_breakpoint',
            array($this, 'general_responsive_breakpoint_validation')
        );

        //Timeline Section ---------------------------------------------------------------------------------------------
        add_settings_section(
            'dale_timeline_settings_section',
            null,
            null,
            'dale_timeline_options'
        );

        add_settings_field(
            'timeline_item_date_font_color',
            esc_attr__('Item Date Font Color', 'dale'),
            array($this, 'timeline_item_date_font_color_callback'),
            'dale_timeline_options',
            'dale_timeline_settings_section'
        );

        register_setting(
            'dale_timeline_options',
            'dale_timeline_item_date_font_color',
            array($this, 'timeline_item_date_font_color_validation')
        );

        add_settings_field(
            'timeline_item_title_font_color',
            esc_attr__('Item Title Font Color', 'dale'),
            array($this, 'timeline_item_title_font_color_callback'),
            'dale_timeline_options',
            'dale_timeline_settings_section'
        );

        register_setting(
            'dale_timeline_options',
            'dale_timeline_item_title_font_color',
            array($this, 'timeline_item_title_font_color_validation')
        );

        add_settings_field(
            'timeline_item_description_font_color',
            esc_attr__('Item Description Font Color', 'dale'),
            array($this, 'timeline_item_description_font_color_callback'),
            'dale_timeline_options',
            'dale_timeline_settings_section'
        );

        register_setting(
            'dale_timeline_options',
            'dale_timeline_item_description_font_color',
            array($this, 'timeline_item_description_font_color_validation')
        );

        add_settings_field(
            'timeline_item_date_font_weight',
            esc_attr__('Item Date Font Weight', 'dale'),
            array($this, 'timeline_item_date_font_weight_callback'),
            'dale_timeline_options',
            'dale_timeline_settings_section'
        );

        register_setting(
            'dale_timeline_options',
            'dale_timeline_item_date_font_weight',
            array($this, 'timeline_item_date_font_weight_validation')
        );

        add_settings_field(
            'timeline_item_title_font_weight',
            esc_attr__('Item Title Font Weight', 'dale'),
            array($this, 'timeline_item_title_font_weight_callback'),
            'dale_timeline_options',
            'dale_timeline_settings_section'
        );

        register_setting(
            'dale_timeline_options',
            'dale_timeline_item_title_font_weight',
            array($this, 'timeline_item_title_font_weight_validation')
        );

        add_settings_field(
            'timeline_item_description_font_weight',
            esc_attr__('Item Description Font Weight', 'dale'),
            array($this, 'timeline_item_description_font_weight_callback'),
            'dale_timeline_options',
            'dale_timeline_settings_section'
        );

        register_setting(
            'dale_timeline_options',
            'dale_timeline_item_description_font_weight',
            array($this, 'timeline_item_description_font_weight_validation')
        );

        //Comment Section ----------------------------------------------------------------------------------------------
        add_settings_section(
            'dale_comment_settings_section',
            null,
            null,
            'dale_comment_options'
        );

        add_settings_field(
            'comment_textarea_background_color',
            esc_attr__('Textarea Background Color', 'dale'),
            array($this, 'comment_textarea_background_color_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_textarea_background_color',
            array($this, 'comment_textarea_background_color_validation')
        );

        add_settings_field(
            'comment_textarea_border_color',
            esc_attr__('Textarea Border Color', 'dale'),
            array($this, 'comment_textarea_border_color_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_textarea_border_color',
            array($this, 'comment_textarea_border_color_validation')
        );

        add_settings_field(
            'comment_textarea_font_color',
            esc_attr__('Textarea Font Color', 'dale'),
            array($this, 'comment_textarea_font_color_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_textarea_font_color',
            array($this, 'comment_textarea_font_color_validation')
        );

        add_settings_field(
            'comment_heading_font_color',
            esc_attr__('Heading Font Color', 'dale'),
            array($this, 'comment_heading_font_color_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_heading_font_color',
            array($this, 'comment_heading_font_color_validation')
        );

        add_settings_field(
            'comment_content_font_color',
            esc_attr__('Content Font Color', 'dale'),
            array($this, 'comment_content_font_color_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_content_font_color',
            array($this, 'comment_content_font_color_validation')
        );

        add_settings_field(
            'comment_submit_comment_font_color',
            esc_attr__('Submit Comment Font Color', 'dale'),
            array($this, 'comment_submit_comment_font_color_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_submit_comment_font_color',
            array($this, 'comment_submit_comment_font_color_validation')
        );

        add_settings_field(
            'comment_submit_comment_hover_font_color',
            esc_attr__('Submit Comment Hover Font Color', 'dale'),
            array($this, 'comment_submit_comment_hover_font_color_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_submit_comment_hover_font_color',
            array($this, 'comment_submit_comment_hover_font_color_validation')
        );

        add_settings_field(
            'comment_message_background_color',
            esc_attr__('Message Background Color', 'dale'),
            array($this, 'comment_message_background_color_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_message_background_color',
            array($this, 'comment_message_background_color_validation')
        );

        add_settings_field(
            'comment_message_border_color',
            esc_attr__('Message Border Color', 'dale'),
            array($this, 'comment_message_border_color_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_message_border_color',
            array($this, 'comment_message_border_color_validation')
        );

        add_settings_field(
            'comment_message_font_color',
            esc_attr__('Message Font Color', 'dale'),
            array($this, 'comment_message_font_color_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_message_font_color',
            array($this, 'comment_message_font_color_validation')
        );

        add_settings_field(
            'comment_textarea_font_weight',
            esc_attr__('Textarea Font Weight', 'dale'),
            array($this, 'comment_textarea_font_weight_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_textarea_font_weight',
            array($this, 'comment_textarea_font_weight_validation')
        );

        add_settings_field(
            'comment_heading_font_weight',
            esc_attr__('Heading Font Weight', 'dale'),
            array($this, 'comment_heading_font_weight_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_heading_font_weight',
            array($this, 'comment_heading_font_weight_validation')
        );

        add_settings_field(
            'comment_content_font_weight',
            esc_attr__('Content Font Weight', 'dale'),
            array($this, 'comment_content_font_weight_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_content_font_weight',
            array($this, 'comment_content_font_weight_validation')
        );

        add_settings_field(
            'comment_submit_comment_font_weight',
            esc_attr__('Submit Comment Font Weight', 'dale'),
            array($this, 'comment_submit_comment_font_weight_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_submit_comment_font_weight',
            array($this, 'comment_submit_comment_font_weight_validation')
        );

        add_settings_field(
            'comment_empty_comment_text',
            esc_attr__('Empty Comment Text', 'dale'),
            array($this, 'comment_empty_comment_text_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_empty_comment_text',
            array($this, 'comment_empty_comment_text_validation')
        );

        add_settings_field(
            'comment_message_under_moderation_text',
            esc_attr__('Message Under Moderation Text', 'dale'),
            array($this, 'comment_message_under_moderation_text_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_message_under_moderation_text',
            array($this, 'comment_message_under_moderation_text_validation')
        );

        add_settings_field(
            'comment_comment_limit_text',
            esc_attr__('Comment Limit Text', 'dale'),
            array($this, 'comment_comment_limit_text_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_comment_limit_text',
            array($this, 'comment_comment_limit_text_validation')
        );

        add_settings_field(
            'comment_number_of_comments_single_text',
            esc_attr__('Number of Comments (Single) Text', 'dale'),
            array($this, 'comment_number_of_comments_single_text_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_number_of_comments_single_text',
            array($this, 'comment_number_of_comments_single_text_validation')
        );

        add_settings_field(
            'comment_number_of_comments_multiple_text',
            esc_attr__('Number of Comments (Multiple) Text', 'dale'),
            array($this, 'comment_number_of_comments_multiple_text_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_number_of_comments_multiple_text',
            array($this, 'comment_number_of_comments_multiple_text_validation')
        );

        add_settings_field(
            'comment_submit_comment_text',
            esc_attr__('Submit Comment Text', 'dale'),
            array($this, 'comment_submit_comment_text_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_submit_comment_text',
            array($this, 'comment_submit_comment_text_validation')
        );

        add_settings_field(
            'comment_sign_in_text',
            esc_attr__('Sign in Text', 'dale'),
            array($this, 'comment_sign_in_text_callback'),
            'dale_comment_options',
            'dale_comment_settings_section'
        );

        register_setting(
            'dale_comment_options',
            'dale_comment_sign_in_text',
            array($this, 'comment_sign_in_text_validation')
        );

        //Stat Section -------------------------------------------------------------------------------------------------
        add_settings_section(
            'dale_stat_settings_section',
            null,
            null,
            'dale_stat_options'
        );

        add_settings_field(
            'stat_subject_font_color',
            esc_attr__('Subject Font Color', 'dale'),
            array($this, 'stat_subject_font_color_callback'),
            'dale_stat_options',
            'dale_stat_settings_section'
        );

        register_setting(
            'dale_stat_options',
            'dale_stat_subject_font_color',
            array($this, 'stat_subject_font_color_validation')
        );

        add_settings_field(
            'stat_value_font_color',
            esc_attr__('Value Font Color', 'dale'),
            array($this, 'stat_value_font_color_callback'),
            'dale_stat_options',
            'dale_stat_settings_section'
        );

        register_setting(
            'dale_stat_options',
            'dale_stat_value_font_color',
            array($this, 'stat_value_font_color_validation')
        );

        add_settings_field(
            'stat_subject_visual_font_color',
            esc_attr__('Subject (Visual) Font Color', 'dale'),
            array($this, 'stat_subject_visual_font_color_callback'),
            'dale_stat_options',
            'dale_stat_settings_section'
        );

        register_setting(
            'dale_stat_options',
            'dale_stat_subject_visual_font_color',
            array($this, 'stat_subject_visual_font_color_validation')
        );

        add_settings_field(
            'stat_value_visual_font_color',
            esc_attr__('Value (Visual) Font Color', 'dale'),
            array($this, 'stat_value_visual_font_color_callback'),
            'dale_stat_options',
            'dale_stat_settings_section'
        );

        register_setting(
            'dale_stat_options',
            'dale_stat_value_visual_font_color',
            array($this, 'stat_value_visual_font_color_validation')
        );

        add_settings_field(
            'stat_bar_value_color',
            esc_attr__('Bar Value Color', 'dale'),
            array($this, 'stat_bar_value_color_callback'),
            'dale_stat_options',
            'dale_stat_settings_section'
        );

        register_setting(
            'dale_stat_options',
            'dale_stat_bar_value_color',
            array($this, 'stat_bar_value_color_validation')
        );

        add_settings_field(
            'stat_bar_background_color',
            esc_attr__('Bar Background Color', 'dale'),
            array($this, 'stat_bar_background_color_callback'),
            'dale_stat_options',
            'dale_stat_settings_section'
        );

        register_setting(
            'dale_stat_options',
            'dale_stat_bar_background_color',
            array($this, 'stat_bar_background_color_validation')
        );

        add_settings_field(
            'stat_subject_font_weight',
            esc_attr__('Subject Font Weight', 'dale'),
            array($this, 'stat_subject_font_weight_callback'),
            'dale_stat_options',
            'dale_stat_settings_section'
        );

        register_setting(
            'dale_stat_options',
            'dale_stat_subject_font_weight',
            array($this, 'stat_subject_font_weight_validation')
        );

        add_settings_field(
            'stat_value_font_weight',
            esc_attr__('Value Font Weight', 'dale'),
            array($this, 'stat_value_font_weight_callback'),
            'dale_stat_options',
            'dale_stat_settings_section'
        );

        register_setting(
            'dale_stat_options',
            'dale_stat_value_font_weight',
            array($this, 'stat_value_font_weight_validation')
        );

        add_settings_field(
            'stat_subject_visual_font_weight',
            esc_attr__('Subject (Visual) Font Weight', 'dale'),
            array($this, 'stat_subject_visual_font_weight_callback'),
            'dale_stat_options',
            'dale_stat_settings_section'
        );

        register_setting(
            'dale_stat_options',
            'dale_stat_subject_visual_font_weight',
            array($this, 'stat_subject_visual_font_weight_validation')
        );

        add_settings_field(
            'stat_value_visual_font_weight',
            esc_attr__('Value (Visual) Font Weight', 'dale'),
            array($this, 'stat_value_visual_font_weight_callback'),
            'dale_stat_options',
            'dale_stat_settings_section'
        );

        register_setting(
            'dale_stat_options',
            'dale_stat_value_visual_font_weight',
            array($this, 'stat_value_visual_font_weight_validation')
        );

        //Stat Section -------------------------------------------------------------------------------------------------
        add_settings_section(
            'dale_social_settings_section',
            null,
            null,
            'dale_social_options'
        );

        add_settings_field(
            'social_icons_color',
            esc_attr__('Icons Color', 'dale'),
            array($this, 'social_icons_color_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_icons_color',
            array($this, 'social_icons_color_validation')
        );

        add_settings_field(
            'social_icons_hover_color',
            esc_attr__('Icons Hover Color', 'dale'),
            array($this, 'social_icons_hover_color_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_icons_hover_color',
            array($this, 'social_icons_hover_color_validation')
        );

        add_settings_field(
            'social_share_font_color',
            esc_attr__('Share Font Color', 'dale'),
            array($this, 'social_share_font_color_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_share_font_color',
            array($this, 'social_share_font_color_validation')
        );

        add_settings_field(
            'social_facebook',
            esc_attr__('Facebook', 'dale'),
            array($this, 'social_facebook_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_facebook',
            array($this, 'social_facebook_validation')
        );

        add_settings_field(
            'social_twitter',
            esc_attr__('Twitter', 'dale'),
            array($this, 'social_twitter_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_twitter',
            array($this, 'social_twitter_validation')
        );

        add_settings_field(
            'social_google_plus',
            esc_attr__('Google Plus', 'dale'),
            array($this, 'social_google_plus_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_google_plus',
            array($this, 'social_google_plus_validation')
        );

        add_settings_field(
            'social_pinterest',
            esc_attr__('Pinterest', 'dale'),
            array($this, 'social_pinterest_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_pinterest',
            array($this, 'social_pinterest_validation')
        );

        add_settings_field(
            'social_linkedin',
            esc_attr__('Linkedin', 'dale'),
            array($this, 'social_linkedin_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_linkedin',
            array($this, 'social_linkedin_validation')
        );

        add_settings_field(
            'social_tumblr',
            esc_attr__('Tumblr', 'dale'),
            array($this, 'social_tumblr_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_tumblr',
            array($this, 'social_tumblr_validation')
        );

        add_settings_field(
            'social_email',
            esc_attr__('Email', 'dale'),
            array($this, 'social_email_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_email',
            array($this, 'social_email_validation')
        );

        add_settings_field(
            'social_facebook',
            esc_attr__('Facebook', 'dale'),
            array($this, 'social_facebook_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_facebook',
            array($this, 'social_facebook_validation')
        );

        add_settings_field(
            'social_share_font_weight',
            esc_attr__('Share Font Weight', 'dale'),
            array($this, 'social_share_font_weight_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_share_font_weight',
            array($this, 'social_share_font_weight_validation')
        );

        add_settings_field(
            'social_share_text',
            esc_attr__('Share Text', 'dale'),
            array($this, 'social_share_text_callback'),
            'dale_social_options',
            'dale_social_settings_section'
        );

        register_setting(
            'dale_social_options',
            'dale_social_share_text',
            array($this, 'social_share_text_validation')
        );

        //Advanced Section -------------------------------------------------------------------------------------------------
        add_settings_section(
            'dale_advanced_settings_section',
            null,
            null,
            'dale_advanced_options'
        );

        add_settings_field(
            'advanced_assets_mode',
            esc_attr__('Assets Mode', 'dale'),
            array($this, 'advanced_assets_mode_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_assets_mode',
            array($this, 'advanced_assets_mode_validation')
        );

        add_settings_field(
            'advanced_sign_in_mode',
            esc_attr__('Sign in Mode', 'dale'),
            array($this, 'advanced_sign_in_mode_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_sign_in_mode',
            array($this, 'advanced_sign_in_mode_validation')
        );

        add_settings_field(
            'advanced_manual_sign_in_url',
            esc_attr__('Sign in URL', 'dale'),
            array($this, 'advanced_manual_sign_in_url_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_manual_sign_in_url',
            array($this, 'advanced_manual_sign_in_url_validation')
        );

        add_settings_field(
            'advanced_apply_kses',
            esc_attr__('Apply kses', 'dale'),
            array($this, 'advanced_apply_kses_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_apply_kses',
            array($this, 'advanced_apply_kses_validation')
        );

        add_settings_field(
            'advanced_kses_allowed_html_tags',
            esc_attr__('kses Allowed HTML Tags', 'dale'),
            array($this, 'advanced_kses_allowed_html_tags_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_kses_allowed_html_tags',
            array($this, 'advanced_kses_allowed_html_tags_validation')
        );

        add_settings_field(
            'advanced_kses_allowed_protocols',
            esc_attr__('kses Allowed Protocols', 'dale'),
            array($this, 'advanced_kses_allowed_protocols_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_kses_allowed_protocols',
            array($this, 'advanced_kses_allowed_protocols_validation')
        );

	    add_settings_field(
		    'advanced_html_editor',
		    esc_attr__('HTML Editor', 'dale'),
		    array($this, 'advanced_html_editor_callback'),
		    'dale_advanced_options',
		    'dale_advanced_settings_section'
	    );

	    register_setting(
		    'dale_advanced_options',
		    'dale_advanced_html_editor',
		    array($this, 'advanced_html_editor_validation')
	    );

        add_settings_field(
            'advanced_update_time',
            esc_attr__('Update Time', 'dale'),
            array($this, 'advanced_update_time_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_update_time',
            array($this, 'advanced_update_time_validation')
        );

        add_settings_field(
            'advanced_transient_expiration',
            esc_attr__('Transient Expiration', 'dale'),
            array($this, 'advanced_transient_expiration_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_transient_expiration',
            array($this, 'advanced_transient_expiration_validation')
        );

        add_settings_field(
            'advanced_comment_limit',
            esc_attr__('Comment Limit', 'dale'),
            array($this, 'advanced_comment_limit_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_comment_limit',
            array($this, 'advanced_comment_limit_validation')
        );

        add_settings_field(
            'advanced_google_font_embed',
            esc_attr__('Google Font Embed', 'dale'),
            array($this, 'advanced_google_font_embed_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_google_font_embed',
            array($this, 'advanced_google_font_embed_validation')
        );

        add_settings_field(
            'advanced_instagram_process_embed',
            esc_attr__('Instagram Process Embed', 'dale'),
            array($this, 'advanced_instagram_process_embed_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_instagram_process_embed',
            array($this, 'advanced_instagram_process_embed_validation')
        );

        add_settings_field(
            'advanced_clone_timeline_items',
            esc_attr__('Clone Timeline Items', 'dale'),
            array($this, 'advanced_clone_timeline_items_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_clone_timeline_items',
            array($this, 'advanced_clone_timeline_items_validation')
        );

        add_settings_field(
            'advanced_clone_stat_groups',
            esc_attr__('Clone Stat Groups', 'dale'),
            array($this, 'advanced_clone_stat_groups_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_clone_stat_groups',
            array($this, 'advanced_clone_stat_groups_validation')
        );

        add_settings_field(
            'advanced_clone_stat_items',
            esc_attr__('Clone Stat Items', 'dale'),
            array($this, 'advanced_clone_stat_items_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_clone_stat_items',
            array($this, 'advanced_clone_stat_items_validation')
        );

        add_settings_field(
            'advanced_clone_comment_items',
            esc_attr__('Clone Comment Items', 'dale'),
            array($this, 'advanced_clone_comment_items_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_clone_comment_items',
            array($this, 'advanced_clone_comment_items_validation')
        );

        add_settings_field(
            'advanced_events_menu_pagination',
            esc_attr__('Events Menu Pagination', 'dale'),
            array($this, 'advanced_events_menu_pagination_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_events_menu_pagination',
            array($this, 'advanced_events_menu_pagination_validation')
        );

        add_settings_field(
            'advanced_timeline_sections_menu_pagination',
            esc_attr__('Timeline Sections Menu Pagination', 'dale'),
            array($this, 'advanced_timeline_sections_menu_pagination_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_timeline_sections_menu_pagination',
            array($this, 'advanced_timeline_sections_menu_pagination_validation')
        );

        add_settings_field(
            'advanced_timeline_items_menu_pagination',
            esc_attr__('Timeline Items Menu Pagination', 'dale'),
            array($this, 'advanced_timeline_items_menu_pagination_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_timeline_items_menu_pagination',
            array($this, 'advanced_timeline_items_menu_pagination_validation')
        );

        add_settings_field(
            'advanced_timeline_icons_menu_pagination',
            esc_attr__('Timeline Icons Menu Pagination', 'dale'),
            array($this, 'advanced_timeline_icons_menu_pagination_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_timeline_icons_menu_pagination',
            array($this, 'advanced_timeline_icons_menu_pagination_validation')
        );

        add_settings_field(
            'advanced_stat_sections_menu_pagination',
            esc_attr__('Stat Sections Menu Pagination', 'dale'),
            array($this, 'advanced_stat_sections_menu_pagination_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_stat_sections_menu_pagination',
            array($this, 'advanced_stat_sections_menu_pagination_validation')
        );

        add_settings_field(
            'advanced_stat_groups_menu_pagination',
            esc_attr__('Stat Groups Menu Pagination', 'dale'),
            array($this, 'advanced_stat_groups_menu_pagination_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_stat_groups_menu_pagination',
            array($this, 'advanced_stat_groups_menu_pagination_validation')
        );

        add_settings_field(
            'advanced_stat_items_menu_pagination',
            esc_attr__('Stat Items Menu Pagination', 'dale'),
            array($this, 'advanced_stat_items_menu_pagination_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_stat_items_menu_pagination',
            array($this, 'advanced_stat_items_menu_pagination_validation')
        );

        add_settings_field(
            'advanced_comment_sections_menu_pagination',
            esc_attr__('Comment Sections Menu Pagination', 'dale'),
            array($this, 'advanced_comment_sections_menu_pagination_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_comment_sections_menu_pagination',
            array($this, 'advanced_comment_sections_menu_pagination_validation')
        );

        add_settings_field(
            'advanced_comment_items_menu_pagination',
            esc_attr__('Comment Items Menu Pagination', 'dale'),
            array($this, 'advanced_comment_items_menu_pagination_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_comment_items_menu_pagination',
            array($this, 'advanced_comment_items_menu_pagination_validation')
        );

        add_settings_field(
            'advanced_events_menu_capability',
            esc_attr__('Events Menu Capability', 'dale'),
            array($this, 'advanced_events_menu_capability_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_events_menu_capability',
            array($this, 'advanced_events_menu_capability_validation')
        );

        add_settings_field(
            'advanced_timeline_sections_menu_capability',
            esc_attr__('Timeline Sections Menu Capability', 'dale'),
            array($this, 'advanced_timeline_sections_menu_capability_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_timeline_sections_menu_capability',
            array($this, 'advanced_timeline_sections_menu_capability_validation')
        );

        add_settings_field(
            'advanced_timeline_icons_menu_capability',
            esc_attr__('Timeline Icons Menu Capability', 'dale'),
            array($this, 'advanced_timeline_icons_menu_capability_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_timeline_icons_menu_capability',
            array($this, 'advanced_timeline_icons_menu_capability_validation')
        );

        add_settings_field(
            'advanced_stat_sections_menu_capability',
            esc_attr__('Stat Sections Menu Capability', 'dale'),
            array($this, 'advanced_stat_sections_menu_capability_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_stat_sections_menu_capability',
            array($this, 'advanced_stat_sections_menu_capability_validation')
        );

        add_settings_field(
            'advanced_stat_groups_menu_capability',
            esc_attr__('Stat Groups Menu Capability', 'dale'),
            array($this, 'advanced_stat_groups_menu_capability_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_stat_groups_menu_capability',
            array($this, 'advanced_stat_groups_menu_capability_validation')
        );

        add_settings_field(
            'advanced_stat_items_menu_capability',
            esc_attr__('Stat Items Menu Capability', 'dale'),
            array($this, 'advanced_stat_items_menu_capability_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_stat_items_menu_capability',
            array($this, 'advanced_stat_items_menu_capability_validation')
        );

        add_settings_field(
            'advanced_comment_sections_menu_capability',
            esc_attr__('Comment Sections Menu Capability', 'dale'),
            array($this, 'advanced_comment_sections_menu_capability_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_comment_sections_menu_capability',
            array($this, 'advanced_comment_sections_menu_capability_validation')
        );

        add_settings_field(
            'advanced_comment_items_menu_capability',
            esc_attr__('Comment Items Menu Capability', 'dale'),
            array($this, 'advanced_comment_items_menu_capability_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_comment_items_menu_capability',
            array($this, 'advanced_comment_items_menu_capability_validation')
        );

        add_settings_field(
            'advanced_write_comments_capability',
            esc_attr__('Write Comments Capability', 'dale'),
            array($this, 'advanced_write_comments_capability_callback'),
            'dale_advanced_options',
            'dale_advanced_settings_section'
        );

        register_setting(
            'dale_advanced_options',
            'dale_advanced_write_comments_capability',
            array($this, 'advanced_write_comments_capability_validation')
        );

    }

    //General Section --------------------------------------------------------------------------------------------------

    public function general_separators_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_general_separators_color" name="' . $this->shared->get('slug') . '_general_separators_color" class="regular-text" value="' . esc_attr(get_option("dale_general_separators_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the color of the separators.",
                'dale') . '"></div>';
        echo $html;

    }

    public function general_separators_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('general_separators_color', 'general_separators_color',
                esc_attr__('Please enter a valid color in the "Separators Color" option.', 'dale'));
            $output = get_option('dale_general_separators_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function general_section_title_background_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_general_section_title_background_color" name="' . $this->shared->get('slug') . '_general_section_title_background_color" class="regular-text" value="' . esc_attr(get_option("dale_general_section_title_background_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the background color of the section title.",
                'dale') . '"></div>';
        echo $html;

    }

    public function general_section_title_background_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('general_section_title_background_color', 'general_section_title_background_color',
                esc_attr__('Please enter a valid color in the "Section Title Background Color" option.', 'dale'));
            $output = get_option('dale_general_section_title_background_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function general_section_title_border_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_general_section_title_border_color" name="' . $this->shared->get('slug') . '_general_section_title_border_color" class="regular-text" value="' . esc_attr(get_option("dale_general_section_title_border_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the border color of the section title.",
                'dale') . '"></div>';
        echo $html;

    }

    public function general_section_title_border_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('general_section_title_border_color', 'general_section_title_border_color',
                esc_attr__('Please enter a valid color in the "Section Title Border Color" option.', 'dale'));
            $output = get_option('dale_general_section_title_border_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function general_section_title_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_general_section_title_font_color" name="' . $this->shared->get('slug') . '_general_section_title_font_color" class="regular-text" value="' . esc_attr(get_option("dale_general_section_title_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the section title.",
                'dale') . '"></div>';
        echo $html;

    }

    public function general_section_title_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('general_section_title_font_color', 'general_section_title_font_color',
                esc_attr__('Please enter a valid color in the "Section Title Font Color" option.', 'dale'));
            $output = get_option('dale_general_section_title_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function general_tab_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_general_tab_font_color" name="' . $this->shared->get('slug') . '_general_tab_font_color" class="regular-text" value="' . esc_attr(get_option("dale_general_tab_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the tabs.",
                'dale') . '"></div>';
        echo $html;

    }

    public function general_tab_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('general_tab_font_color', 'general_tab_font_color',
                esc_attr__('Please enter a valid color in the "Tab Font Color" option.', 'dale'));
            $output = get_option('dale_general_tab_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function general_active_tab_border_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_general_active_tab_border_color" name="' . $this->shared->get('slug') . '_general_active_tab_border_color" class="regular-text" value="' . esc_attr(get_option("dale_general_active_tab_border_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the border color of the active tabs.",
                'dale') . '"></div>';
        echo $html;

    }

    public function general_active_tab_border_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('general_active_tab_border_color', 'general_active_tab_border_color',
                esc_attr__('Please enter a valid value in the "Active Tab Border Color" option.', 'dale'));
            $output = get_option('dale_general_active_tab_border_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function general_active_tab_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_general_active_tab_font_color" name="' . $this->shared->get('slug') . '_general_active_tab_font_color" class="regular-text" value="' . esc_attr(get_option("dale_general_active_tab_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the active tabs.",
                'dale') . '"></div>';
        echo $html;

    }

    public function general_active_tab_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('general_active_tab_font_color', 'general_active_tab_font_color',
                esc_attr__('Please enter a valid value in the "Active Tab Font Color" option.', 'dale'));
            $output = get_option('dale_general_active_tab_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function general_font_family_callback($args)
    {

        $html = '<input autocomplete="off" maxlength="1000" type="text" id="' . $this->shared->get('slug') . '_general_font_family" name="' . $this->shared->get('slug') . '_general_font_family" class="regular-text" value="' . esc_attr(get_option("dale_general_font_family")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font family used for the text displayed in the live event.",
                'dale') . '"></div>';
        echo $html;

    }

    public function general_font_family_validation($input)
    {

        if ( ! preg_match($this->shared->font_family_regex, $input)) {
            add_settings_error('general_font_family', 'general_font_family',
                esc_attr__('Please enter a valid value in the "Font Family" option.', 'dale'));
            $output = get_option('dale_general_font_family');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function general_base_font_size_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_general_base_font_size" name="dale_general_base_font_size" class="regular-text" value="' . esc_attr(get_option("dale_general_base_font_size")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines the size of all the textual and layout elements of the live event.',
                'dale') . '"></div>';

        echo $html;

    }

    public function general_base_font_size_validation($input)
    {

        if (intval($input, 10) < 1 or intval($input, 10) > 100) {
            add_settings_error('dale_general_base_font_size', 'dale_general_base_font_size',
                esc_attr__('Please enter a valid value in the "Base Font Size" option.', 'dale'));
            $output = get_option('dale_general_base_font_size');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function general_top_margin_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_general_top_margin" name="dale_general_top_margin" class="regular-text" value="' . esc_attr(get_option("dale_general_top_margin")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines the top margin of the live event.',
                'dale') . '"></div>';

        echo $html;

    }

    public function general_top_margin_validation($input)
    {

        if (intval($input, 10) < 0 or intval($input, 10) > 1000000) {
            add_settings_error('dale_general_top_margin', 'dale_general_top_margin',
                esc_attr__('Please enter a valid value in the "Top Margin" option.', 'dale'));
            $output = get_option('dale_general_top_margin');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function general_bottom_margin_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_general_bottom_margin" name="dale_general_bottom_margin" class="regular-text" value="' . esc_attr(get_option("dale_general_bottom_margin")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines the bottom margin of the live event',
                'dale') . '"></div>';

        echo $html;

    }

    public function general_bottom_margin_validation($input)
    {

        if (intval($input, 10) < 0 or intval($input, 10) > 1000000) {
            add_settings_error('dale_general_bottom_margin', 'dale_general_bottom_margin',
                esc_attr__('Please enter a valid value in the "Bottom Margin" option.', 'dale'));
            $output = get_option('dale_general_bottom_margin');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function general_responsive_breakpoint_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_general_responsive_breakpoint" name="dale_general_responsive_breakpoint" class="regular-text" value="' . esc_attr(get_option("dale_general_responsive_breakpoint")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('When the browser viewport width goes below this value the mobile version of the live event layout will be used.',
                'dale') . '"></div>';

        echo $html;

    }

    public function general_responsive_breakpoint_validation($input)
    {

        if (intval($input, 10) < 1 or intval($input, 10) > 1000000) {
            add_settings_error('dale_general_responsive_breakpoint', 'dale_general_responsive_breakpoint',
                esc_attr__('Please enter a valid value in the "Responsive Breakpoint" option.', 'dale'));
            $output = get_option('dale_general_responsive_breakpoint');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    //Timeline Section -------------------------------------------------------------------------------------------------
    public function timeline_item_date_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_timeline_item_date_font_color" name="' . $this->shared->get('slug') . '_timeline_item_date_font_color" class="regular-text" value="' . esc_attr(get_option("dale_timeline_item_date_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the item date.",
                'dale') . '"></div>';
        echo $html;

    }

    public function timeline_item_date_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('timeline_item_date_font_color', 'timeline_item_date_font_color',
                esc_attr__('Please enter e valid color in the "Item Date Font Color" option.', 'dale'));
            $output = get_option('dale_timeline_item_date_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function timeline_item_title_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_timeline_item_title_font_color" name="' . $this->shared->get('slug') . '_timeline_item_title_font_color" class="regular-text" value="' . esc_attr(get_option("dale_timeline_item_title_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the item title.",
                'dale') . '"></div>';
        echo $html;

    }

    public function timeline_item_title_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('timeline_item_title_font_color', 'timeline_item_title_font_color',
                esc_attr__('Please enter a valid color in the "Item Title Font Color" option.', 'dale'));
            $output = get_option('dale_timeline_item_title_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function timeline_item_description_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_timeline_item_description_font_color" name="' . $this->shared->get('slug') . '_timeline_item_description_font_color" class="regular-text" value="' . esc_attr(get_option("dale_timeline_item_description_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the item description.",
                'dale') . '"></div>';
        echo $html;

    }

    public function timeline_item_description_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('timeline_item_description_font_color', 'timeline_item_description_font_color',
                esc_attr__('Please enter a valid color in the "Item Description Font Color" option.', 'dale'));
            $output = get_option('dale_timeline_item_description_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function timeline_item_date_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_timeline_item_date_font_weight" name="dale_timeline_item_date_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_timeline_item_date_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the item date.",
                'dale') . '"></div>';
        echo $html;

    }

    public function timeline_item_date_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_timeline_item_date_font_weight', 'dale_timeline_item_date_font_weight',
                esc_attr__('Please enter a valid font weight in the "Item Date Font Weight" option.', 'dale'));
            $output = get_option('dale_timeline_item_date_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function timeline_item_title_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_timeline_item_title_font_weight" name="dale_timeline_item_title_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_timeline_item_title_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the item title.",
                'dale') . '"></div>';
        echo $html;

    }

    public function timeline_item_title_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_timeline_item_title_font_weight', 'dale_timeline_item_title_font_weight',
                esc_attr__('Please enter a valid font weight in the "Item Title Font Weight" option.', 'dale'));
            $output = get_option('dale_timeline_item_title_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function timeline_item_description_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_timeline_item_description_font_weight" name="dale_timeline_item_description_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_timeline_item_description_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the item description.",
                'dale') . '"></div>';
        echo $html;

    }

    public function timeline_item_description_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_timeline_item_description_font_weight',
                'dale_timeline_item_description_font_weight',
                esc_attr__('Please enter a valid font weight in the "Item Description Font Weight" option.', 'dale'));
            $output = get_option('dale_timeline_item_description_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    //Comment Section --------------------------------------------------------------------------------------------------

    public function comment_textarea_background_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_comment_textarea_background_color" name="' . $this->shared->get('slug') . '_comment_textarea_background_color" class="regular-text" value="' . esc_attr(get_option("dale_comment_textarea_background_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the background color of the textarea.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_textarea_background_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('comment_textarea_background_color', 'comment_textarea_background_color',
                esc_attr__('Please enter a valid value in the "Textarea Background Color" option.', 'dale'));
            $output = get_option('dale_comment_textarea_background_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_textarea_border_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_comment_textarea_border_color" name="' . $this->shared->get('slug') . '_comment_textarea_border_color" class="regular-text" value="' . esc_attr(get_option("dale_comment_textarea_border_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the border color of the textarea.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_textarea_border_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('comment_textarea_border_color', 'comment_textarea_border_color',
                esc_attr__('Please enter a valid value in the "Textarea Border Color" option.', 'dale'));
            $output = get_option('dale_comment_textarea_border_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_textarea_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_comment_textarea_font_color" name="' . $this->shared->get('slug') . '_comment_textarea_font_color" class="regular-text" value="' . esc_attr(get_option("dale_comment_textarea_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the textarea.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_textarea_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('comment_textarea_font_color', 'comment_textarea_font_color',
                esc_attr__('Please enter a valid color in the "Textarea Font Color" option.', 'dale'));
            $output = get_option('dale_comment_textarea_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_heading_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_comment_heading_font_color" name="' . $this->shared->get('slug') . '_comment_heading_font_color" class="regular-text" value="' . esc_attr(get_option("dale_comment_heading_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the heading.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_heading_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('comment_heading_font_color', 'comment_heading_font_color',
                esc_attr__('Please enter a valid color in the "Heading Font Color" option.', 'dale'));
            $output = get_option('dale_comment_heading_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_content_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_comment_content_font_color" name="' . $this->shared->get('slug') . '_comment_content_font_color" class="regular-text" value="' . esc_attr(get_option("dale_comment_content_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the content.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_content_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('comment_content_font_color', 'comment_content_font_color',
                esc_attr__('Please enter a valid value in the "Content Font Color" option.', 'dale'));
            $output = get_option('dale_comment_content_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_submit_comment_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_comment_submit_comment_font_color" name="' . $this->shared->get('slug') . '_comment_submit_comment_font_color" class="regular-text" value="' . esc_attr(get_option("dale_comment_submit_comment_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the button used to submit the comments or to sign in.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_submit_comment_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('comment_submit_comment_font_color', 'comment_submit_comment_font_color',
                esc_attr__('Please enter a valid value in the "Submit Comment Font Color" option.', 'dale'));
            $output = get_option('dale_comment_submit_comment_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_submit_comment_hover_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_comment_submit_comment_hover_font_color" name="' . $this->shared->get('slug') . '_comment_submit_comment_hover_font_color" class="regular-text" value="' . esc_attr(get_option("dale_comment_submit_comment_hover_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color in hover state of the button used to submit the comments or to sign in.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_submit_comment_hover_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('comment_submit_comment_hover_font_color', 'comment_submit_comment_hover_font_color',
                esc_attr__('Please enter a valid value in the "Submit Comment Hover Font Color" option.', 'dale'));
            $output = get_option('dale_comment_submit_comment_hover_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_message_background_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_comment_message_background_color" name="' . $this->shared->get('slug') . '_comment_message_background_color" class="regular-text" value="' . esc_attr(get_option("dale_comment_message_background_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the background color of the message.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_message_background_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('comment_message_background_color', 'comment_submit_comment_hover_font_color',
                esc_attr__('Please enter a valid value in the "Message Background Color" option.', 'dale'));
            $output = get_option('dale_comment_message_background_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_message_border_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_comment_message_border_color" name="' . $this->shared->get('slug') . '_comment_message_border_color" class="regular-text" value="' . esc_attr(get_option("dale_comment_message_border_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the border color of the message.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_message_border_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('comment_message_border_color', 'comment_submit_comment_hover_font_color',
                esc_attr__('Please enter a valid value in the "Message Border Color" option.', 'dale'));
            $output = get_option('dale_comment_message_border_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_message_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_comment_message_font_color" name="' . $this->shared->get('slug') . '_comment_message_font_color" class="regular-text" value="' . esc_attr(get_option("dale_comment_message_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the message.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_message_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('comment_message_font_color', 'comment_submit_comment_hover_font_color',
                esc_attr__('Please enter a valid value in the "Message Font Color" option.', 'dale'));
            $output = get_option('dale_comment_message_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_textarea_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_comment_textarea_font_weight" name="dale_comment_textarea_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_comment_textarea_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the textarea.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_textarea_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_comment_textarea_font_weight', 'dale_comment_textarea_font_weight',
                esc_attr__('Please enter a valid value in the "Textarea Font Weight" option.', 'dale'));
            $output = get_option('dale_comment_textarea_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function comment_heading_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_comment_heading_font_weight" name="dale_comment_heading_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_comment_heading_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the heading.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_heading_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_comment_heading_font_weight', 'dale_comment_heading_font_weight',
                esc_attr__('Please enter a valid value in the "Heading Font Weight" option.', 'dale'));
            $output = get_option('dale_comment_heading_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function comment_content_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_comment_content_font_weight" name="dale_comment_content_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_comment_content_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the content.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_content_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_comment_content_font_weight', 'dale_comment_content_font_weight',
                esc_attr__('Please enter a valid value in the "Content Font Weight" option.', 'dale'));
            $output = get_option('dale_comment_content_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function comment_submit_comment_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_comment_submit_comment_font_weight" name="dale_comment_submit_comment_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_comment_submit_comment_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the button used to submit the comments or to sign in.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_submit_comment_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_comment_submit_comment_font_weight', 'dale_comment_submit_comment_font_weight',
                esc_attr__('Please enter a valid value in the "Submit Comment Font Weight" option.', 'dale'));
            $output = get_option('dale_comment_submit_comment_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function comment_empty_comment_text_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_comment_empty_comment_text" name="dale_comment_empty_comment_text" class="regular-text" value="' . esc_attr(get_option("dale_comment_empty_comment_text")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the text displayed to the users when an empty comment is submitted.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_empty_comment_text_validation($input)
    {

        if (strlen(trim($input)) === 0) {
            add_settings_error('dale_comment_empty_comment_text', 'dale_comment_empty_comment_text',
                esc_attr__('Please enter a valid value in the "Empty Comment Text" option.', 'dale'));
            $output = get_option('dale_comment_empty_comment_text');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_message_under_moderation_text_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_comment_message_under_moderation_text" name="dale_comment_message_under_moderation_text" class="regular-text" value="' . esc_attr(get_option("dale_comment_message_under_moderation_text")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the text displayed to the users when a comment is submitted and the moderation is enabled.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_message_under_moderation_text_validation($input)
    {

        if (strlen(trim($input)) === 0) {
            add_settings_error('dale_comment_message_under_moderation_text',
                'dale_comment_message_under_moderation_text',
                esc_attr__('Please enter a valid value in the "Message Under Moderation" text.', 'dale'));
            $output = get_option('dale_comment_message_under_moderation_text');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_comment_limit_text_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_comment_comment_limit_text" name="dale_comment_comment_limit_text" class="regular-text" value="' . esc_attr(get_option("dale_comment_comment_limit_text")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('This message is displayed when the number of comments submitted in 24 hours by a user exceed the value defined in the "Comment Limit" option.',
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_comment_limit_text_validation($input)
    {

        if (strlen(trim($input)) === 0) {
            add_settings_error('dale_comment_comment_limit_text', 'dale_comment_message_under_moderation_text',
                esc_attr__('Please enter a valid value in the "Comment Limit Text" text.', 'dale'));
            $output = get_option('dale_comment_comment_limit_text');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_number_of_comments_single_text_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_comment_number_of_comments_single_text" name="dale_comment_number_of_comments_single_text" class="regular-text" value="' . esc_attr(get_option("dale_comment_number_of_comments_single_text")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the text displayed after the numeric value which indicates the number of comments. (when there is one comment)",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_number_of_comments_single_text_validation($input)
    {

        if (strlen(trim($input)) === 0) {
            add_settings_error('dale_comment_number_of_comments_single_text',
                'dale_comment_number_of_comments_single_text',
                esc_attr__('Please enter a valid value in the "Number of Comments (Single) Text" option.', 'dale'));
            $output = get_option('dale_comment_number_of_comments_single_text');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_number_of_comments_multiple_text_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_comment_number_of_comments_multiple_text" name="dale_comment_number_of_comments_multiple_text" class="regular-text" value="' . esc_attr(get_option("dale_comment_number_of_comments_multiple_text")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the text displayed after the numeric value which indicates the number of comments. (when there is more than one comment)",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_number_of_comments_multiple_text_validation($input)
    {

        if (strlen(trim($input)) === 0) {
            add_settings_error('dale_comment_number_of_comments_multiple_text',
                'dale_comment_number_of_comments_multiple_text',
                esc_attr__('Please enter a valid value in the "Number of Comments (Multiple) Text" option.', 'dale'));
            $output = get_option('dale_comment_number_of_comments_multiple_text');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_submit_comment_text_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_comment_submit_comment_text" name="dale_comment_submit_comment_text" class="regular-text" value="' . esc_attr(get_option("dale_comment_submit_comment_text")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the text of the button used to submit a comment.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_submit_comment_text_validation($input)
    {

        if (strlen(trim($input)) === 0) {
            add_settings_error('dale_comment_submit_comment_text', 'dale_comment_submit_comment_text',
                esc_attr__('Please enter a valid value in the "Submit Comment Text" button.', 'dale'));
            $output = get_option('dale_comment_submit_comment_text');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function comment_sign_in_text_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_comment_sign_in_text" name="dale_comment_sign_in_text" class="regular-text" value="' . esc_attr(get_option("dale_comment_sign_in_text")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the text of the button used to sign in.",
                'dale') . '"></div>';
        echo $html;

    }

    public function comment_sign_in_text_validation($input)
    {

        if (strlen(trim($input)) === 0) {
            add_settings_error('dale_comment_sign_in_text', 'dale_comment_sign_in_text',
                esc_attr__('Please enter a valid value in the "Sign in Text" button.', 'dale'));
            $output = get_option('dale_comment_sign_in_text');
        } else {
            $output = $input;
        }

        return $output;

    }

    //Stat Section -----------------------------------------------------------------------------------------------------

    public function stat_subject_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_stat_subject_font_color" name="' . $this->shared->get('slug') . '_stat_subject_font_color" class="regular-text" value="' . esc_attr(get_option("dale_stat_subject_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the subject.",
                'dale') . '"></div>';
        echo $html;

    }

    public function stat_subject_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('stat_subject_font_color', 'stat_subject_font_color',
                esc_attr__('Please enter a valid value in the "Subject Font Color" option.', 'dale'));
            $output = get_option('dale_stat_subject_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function stat_value_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_stat_value_font_color" name="' . $this->shared->get('slug') . '_stat_value_font_color" class="regular-text" value="' . esc_attr(get_option("dale_stat_value_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the value.",
                'dale') . '"></div>';
        echo $html;

    }

    public function stat_value_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('stat_value_font_color', 'stat_value_font_color',
                esc_attr__('Please enter a valid value in the "Value Font Color" option.', 'dale'));
            $output = get_option('dale_stat_value_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function stat_subject_visual_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_stat_subject_visual_font_color" name="' . $this->shared->get('slug') . '_stat_subject_visual_font_color" class="regular-text" value="' . esc_attr(get_option("dale_stat_subject_visual_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the subject (Visual).",
                'dale') . '"></div>';
        echo $html;

    }

    public function stat_subject_visual_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('stat_subject_visual_font_color', 'stat_subject_visual_font_color',
                esc_attr__('Please enter a valid value in the "Subject (Visual) Font Color" option.', 'dale'));
            $output = get_option('dale_stat_subject_visual_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function stat_value_visual_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_stat_value_visual_font_color" name="' . $this->shared->get('slug') . '_stat_value_visual_font_color" class="regular-text" value="' . esc_attr(get_option("dale_stat_value_visual_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the value (Visual).",
                'dale') . '"></div>';
        echo $html;

    }

    public function stat_value_visual_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('stat_value_visual_font_color', 'stat_value_visual_font_color',
                esc_attr__('Please enter a valid value in the "Value (Visual) Font Color" option.', 'dale'));
            $output = get_option('dale_stat_value_visual_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function stat_bar_value_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_stat_bar_value_color" name="' . $this->shared->get('slug') . '_stat_bar_value_color" class="regular-text" value="' . esc_attr(get_option("dale_stat_bar_value_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the bar value.",
                'dale') . '"></div>';
        echo $html;

    }

    public function stat_bar_value_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('stat_bar_value_color', 'stat_bar_value_color',
                esc_attr__('Please enter a valid value in the "Bar Value Color" option.', 'dale'));
            $output = get_option('dale_stat_bar_value_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function stat_bar_background_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_stat_bar_background_color" name="' . $this->shared->get('slug') . '_stat_bar_background_color" class="regular-text" value="' . esc_attr(get_option("dale_stat_bar_background_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the bar background.",
                'dale') . '"></div>';
        echo $html;

    }

    public function stat_bar_background_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('stat_bar_background_color', 'stat_bar_background_color',
                esc_attr__('Please enter a valid value in the "Bar Background Color" option.', 'dale'));
            $output = get_option('dale_stat_bar_background_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function stat_subject_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_stat_subject_font_weight" name="dale_stat_subject_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_stat_subject_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the subject.",
                'dale') . '"></div>';
        echo $html;

    }

    public function stat_subject_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_stat_subject_font_weight', 'dale_stat_subject_font_weight',
                esc_attr__('Please enter a valid value in the "Subject Font Weight" option.', 'dale'));
            $output = get_option('dale_stat_subject_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function stat_value_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_stat_value_font_weight" name="dale_stat_value_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_stat_value_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the value.",
                'dale') . '"></div>';
        echo $html;

    }

    public function stat_value_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_stat_value_font_weight', 'dale_stat_value_font_weight',
                esc_attr__('Please enter a valid value in the "Value Font Weight" option.', 'dale'));
            $output = get_option('dale_stat_value_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function stat_subject_visual_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_stat_subject_visual_font_weight" name="dale_stat_subject_visual_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_stat_subject_visual_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the subject (Visual).",
                'dale') . '"></div>';
        echo $html;

    }

    public function stat_subject_visual_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_stat_subject_visual_font_weight', 'dale_stat_subject_visual_font_weight',
                esc_attr__('Please enter a valid value in the "Subject (Visual) Font Weight" option.', 'dale'));
            $output = get_option('dale_stat_subject_visual_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }


    public function stat_value_visual_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_stat_value_visual_font_weight" name="dale_stat_value_visual_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_stat_value_visual_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the value (Visual).",
                'dale') . '"></div>';
        echo $html;

    }

    public function stat_value_visual_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_stat_value_visual_font_weight', 'dale_stat_value_visual_font_weight',
                esc_attr__('Please enter a valid value in the "Value (Visual) Font Weight" option.', 'dale'));
            $output = get_option('dale_stat_value_visual_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    //Social Section ---------------------------------------------------------------------------------------------------

    public function social_icons_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_social_icons_color" name="' . $this->shared->get('slug') . '_social_icons_color" class="regular-text" value="' . esc_attr(get_option("dale_social_icons_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the color of the icons.",
                'dale') . '"></div>';
        echo $html;

    }

    public function social_icons_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('social_icons_color', 'social_icons_color',
                esc_attr__('Please enter a valid color in the "Icons Color" option.', 'dale'));
            $output = get_option('dale_social_icons_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function social_icons_hover_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_social_icons_hover_color" name="' . $this->shared->get('slug') . '_social_icons_hover_color" class="regular-text" value="' . esc_attr(get_option("dale_social_icons_hover_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the color of the icons in hover state.",
                'dale') . '"></div>';
        echo $html;

    }

    public function social_icons_hover_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('social_icons_hover_color', 'social_icons_hover_color',
                esc_attr__('Please enter a valid color in the "Icons Hover Color" option.', 'dale'));
            $output = get_option('dale_social_icons_hover_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function social_share_font_color_callback($args)
    {

        $html = '<input class="wp-color-picker" type="text" id="' . $this->shared->get('slug') . '_social_share_font_color" name="' . $this->shared->get('slug') . '_social_share_font_color" class="regular-text" value="' . esc_attr(get_option("dale_social_share_font_color")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font color of the social section.",
                'dale') . '"></div>';
        echo $html;

    }

    public function social_share_font_color_validation($input)
    {

        if ( ! preg_match($this->shared->hex_rgb_regex, $input)) {
            add_settings_error('social_share_font_color', 'social_share_font_color',
                esc_attr__('Please enter a valid color in the "Share Font Color" option.', 'dale'));
            $output = get_option('dale_social_share_font_color');
        } else {
            $output = $input;
        }

        return $output;

    }

    public function social_facebook_callback($args)
    {

        $html = '<select id="dale-social-facebook" name="dale_social_facebook" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_social_facebook")), 0,
                false) . ' value="0">' . esc_attr__('Disabled', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_social_facebook")), 1,
                false) . ' value="1">' . esc_attr__('Enabled', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines if the facebook icon should be displayed.',
                'dale') . '"></div>';

        echo $html;

    }

    public function social_facebook_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function social_twitter_callback($args)
    {

        $html = '<select id="dale-social-twitter" name="dale_social_twitter" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_social_twitter")), 0,
                false) . ' value="0">' . esc_attr__('Disabled', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_social_twitter")), 1,
                false) . ' value="1">' . esc_attr__('Enabled', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines if the Twitter icon should be displayed.',
                'dale') . '"></div>';

        echo $html;

    }

    public function social_twitter_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function social_google_plus_callback($args)
    {

        $html = '<select id="dale-social-google-plus" name="dale_social_google_plus" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_social_google_plus")), 0,
                false) . ' value="0">' . esc_attr__('Disabled', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_social_google_plus")), 1,
                false) . ' value="1">' . esc_attr__('Enabled', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines if the Google Plus icon should be displayed.',
                'dale') . '"></div>';

        echo $html;

    }

    public function social_google_plus_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function social_pinterest_callback($args)
    {

        $html = '<select id="dale-social-pinterest" name="dale_social_pinterest" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_social_pinterest")), 0,
                false) . ' value="0">' . esc_attr__('Disabled', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_social_pinterest")), 1,
                false) . ' value="1">' . esc_attr__('Enabled', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines if the Pinterest icon should be displayed.',
                'dale') . '"></div>';

        echo $html;

    }

    public function social_pinterest_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function social_linkedin_callback($args)
    {

        $html = '<select id="dale-social-linkedin" name="dale_social_linkedin" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_social_linkedin")), 0,
                false) . ' value="0">' . esc_attr__('Disabled', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_social_linkedin")), 1,
                false) . ' value="1">' . esc_attr__('Enabled', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines if the Linkedin icon should be displayed.',
                'dale') . '"></div>';

        echo $html;

    }

    public function social_linkedin_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function social_tumblr_callback($args)
    {

        $html = '<select id="dale-social-tumblr" name="dale_social_tumblr" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_social_tumblr")), 0,
                false) . ' value="0">' . esc_attr__('Disabled', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_social_tumblr")), 1,
                false) . ' value="1">' . esc_attr__('Enabled', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines if the Tumblr icon should be displayed.',
                'dale') . '"></div>';

        echo $html;

    }

    public function social_tumblr_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function social_email_callback($args)
    {

        $html = '<select id="dale-social-email" name="dale_social_email" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_social_email")), 0,
                false) . ' value="0">' . esc_attr__('Disabled', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_social_email")), 1,
                false) . ' value="1">' . esc_attr__('Enabled', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines if the Email icon should be displayed.',
                'dale') . '"></div>';

        echo $html;

    }

    public function social_email_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function social_share_font_weight_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_social_share_font_weight" name="dale_social_share_font_weight" class="regular-text" value="' . esc_attr(get_option("dale_social_share_font_weight")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the font weight of the text displayed in the social section.",
                'dale') . '"></div>';
        echo $html;

    }

    public function social_share_font_weight_validation($input)
    {

        if (intval($input, 10) < 100 or intval($input, 10) > 900) {
            add_settings_error('dale_social_share_font_weight', 'dale_social_share_font_weight',
                esc_attr__('Please enter a valid value in the "Share Font Weight" option.', 'dale'));
            $output = get_option('dale_social_share_font_weight');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function social_share_text_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_social_share_text" name="dale_social_share_text" class="regular-text" value="' . esc_attr(get_option("dale_social_share_text")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the text displayed in the social section.",
                'dale') . '"></div>';
        echo $html;

    }

    public function social_share_text_validation($input)
    {

        if (strlen(trim($input)) === 0) {
            add_settings_error('dale_social_share_text', 'dale_social_share_text',
                esc_attr__('Please enter a valid value in the "Share Text" option.', 'dale'));
            $output = get_option('dale_social_share_text');
        } else {
            $output = $input;
        }

        return $output;

    }

    //Advanced Section -------------------------------------------------------------------------------------------------
    public function advanced_assets_mode_callback($args)
    {

        $html = '<select id="dale-advanced-assets-mode" name="dale_advanced_assets_mode" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_assets_mode")), 0,
                false) . ' value="0">' . esc_attr__('Development', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_assets_mode")), 1,
                false) . ' value="1">' . esc_attr__('Production', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('With "Development" selected the development version of the CSS and JavaScript files used by the plugin will be loaded on the front-end. With "Production" selected the minified version of the CSS and JavaScript file used by the plugin will be loaded on the front-end. ',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_assets_mode_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function advanced_sign_in_mode_callback($args)
    {

        $html = '<select id="dale-advanced-sign-in-mode" name="dale_advanced_sign_in_mode" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_sign_in_mode")), 0,
                false) . ' value="0">' . esc_attr__('Manual', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_sign_in_mode")), 1,
                false) . ' value="1">' . esc_attr__('Automatic', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('With "Automatic" selected the URL that allows the user to log in to the site is automatically generated. With "Manual" selected the URL that allows the user to log in to the site is defined with the "Sign in URL" option.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_sign_in_mode_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function advanced_manual_sign_in_url_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_manual_sign_in_url" name="dale_advanced_manual_sign_in_url" class="regular-text" value="' . esc_attr(get_option("dale_advanced_manual_sign_in_url")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("This option determines the URL that allows the user to log in to the site.",
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_manual_sign_in_url_validation($input)
    {

        if ( ! preg_match($this->shared->url_regex, trim($input))) {
            add_settings_error('dale_advanced_manual_sign_in_url', 'dale_advanced_manual_sign_in_url',
                esc_attr__('Please enter a valid URL in the "Sign in URL" option.', 'dale'));
            $output = get_option('dale_advanced_manual_sign_in_url');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_apply_kses_callback($args)
    {

        $html = '<select id="dale-advanced-sign-in-mode" name="dale_advanced_apply_kses" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_apply_kses")), 0,
                false) . ' value="0">' . esc_attr__('No', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_apply_kses")), 1,
                false) . ' value="1">' . esc_attr__('Yes', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('With kses enabled only the allowed HTML element names, attribute names and attribute values will be displayed in the output of the "HTML" field available in the timeline item.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_apply_kses_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function advanced_kses_allowed_html_tags_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_kses_allowed_html_tags" name="dale_advanced_kses_allowed_html_tags" class="regular-text" value="' . esc_attr(get_option("dale_advanced_kses_allowed_html_tags")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('Enter a list of HTML element names allowed by kses, separated by a comma. You can also set which attributes are allowed for each tag by adding the list of attribute names included in square brackets after the HTML element name, for example you can allow in kses the "a" HTML element with the "href" and "title" attributes by using this string "a[href][title]".',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_kses_allowed_html_tags_validation($input)
    {

        if ( ! preg_match('/^(\s*([A-Za-z0-9\[\]]+\s*,\s*)+[A-Za-z0-9\[\]]+\s*|\s*[A-Za-z0-9\[\]]+\s*)$/',
                $input) and strlen(trim($input)) > 0) {
            add_settings_error('dale_advanced_kses_allowed_html_tags', 'dale_advanced_kses_allowed_html_tags',
                esc_attr__('Please enter a valid URL in the "Sign in URL" option.', 'dale'));
            $output = get_option('dale_advanced_kses_allowed_html_tags');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_kses_allowed_protocols_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_kses_allowed_protocols" name="dale_advanced_kses_allowed_protocols" class="regular-text" value="' . esc_attr(get_option("dale_advanced_kses_allowed_protocols")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('Enter a list of protocols, separated by a comma. This option determines which protocols are allowed by kses inside HTML links.',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_kses_allowed_protocols_validation($input)
    {

        if ( ! preg_match('/^(\s*([A-Za-z]+\s*,\s*)+[A-Za-z]+\s*|\s*[A-Za-z]+\s*)$/',
                $input) and strlen(trim($input)) > 0) {
            add_settings_error('dale_advanced_kses_allowed_protocols', 'dale_advanced_kses_allowed_protocols',
                esc_attr__('Please enter a valid URL in the "Sign in URL" option.', 'dale'));
            $output = get_option('dale_advanced_kses_allowed_protocols');
        } else {
            $output = trim($input);
        }

        return $output;

    }

	public function advanced_html_editor_callback($args)
	{

		$html = '<select id="dale-advanced-sign-in-mode" name="dale_advanced_html_editor" class="daext-display-none">';
		$html .= '<option ' . selected(intval(get_option("dale_advanced_html_editor")), 0,
				false) . ' value="0">' . esc_attr__('No', 'dale') . '</option>';
		$html .= '<option ' . selected(intval(get_option("dale_advanced_html_editor")), 1,
				false) . ' value="1">' . esc_attr__('Yes', 'dale') . '</option>';
		$html .= '</select>';
		$html .= '<div class="help-icon" title="' . esc_attr__('With this option enabled, a TinyMCE editor is applied to the "HTML" field available in the timeline item.',
				'dale') . '"></div>';

		echo $html;

	}

	public function advanced_html_editor_validation($input)
	{

		return intval($input, 10) === 1 ? '1' : '0';

	}

    public function advanced_update_time_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_update_time" name="dale_advanced_update_time" class="regular-text" value="' . esc_attr(get_option("dale_advanced_update_time")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines the time interval (expressed in seconds) between the requests sent to the server to retrieve the data of the live event. Please note that a short time interval generates a high number of HTTP requests and this behavior might not be suitable for a website hosted on a shared server or for a website with high traffic.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_update_time_validation($input)
    {

        if (intval($input, 10) < 1 or intval($input, 10) > 1000000) {
            add_settings_error('dale_advanced_update_time', 'dale_advanced_update_time',
                esc_attr__('Please enter a valid value in the "Update Time" option.', 'dale'));
            $output = get_option('dale_advanced_update_time');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function advanced_transient_expiration_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_transient_expiration" name="dale_advanced_transient_expiration" class="regular-text" value="' . esc_attr(get_option("dale_advanced_transient_expiration")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('Enter the transient expiration in seconds. Set a high value to improve the live event performance and to avoid an excessive load on the web server. Set a low value to have frequent updates of the live event data. Set 0 to not use a transient.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_transient_expiration_validation($input)
    {

        if (intval($input, 10) < 0 or intval($input, 10) > 1000000) {
            add_settings_error('dale_advanced_transient_expiration', 'dale_advanced_transient_expiration',
                esc_attr__('Please enter a valid value in the "Transient Expiration" option.', 'dale'));
            $output = get_option('dale_advanced_transient_expiration');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function advanced_comment_limit_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_comment_limit" name="dale_advanced_comment_limit" class="regular-text" value="' . esc_attr(get_option("dale_advanced_comment_limit")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('This option determines the maximum number of comments that a user will be able to sumbit in 24 hours.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_comment_limit_validation($input)
    {

        if (intval($input, 10) < 0 or intval($input, 10) > 1000000) {
            add_settings_error('dale_advanced_comment_limit', 'dale_advanced_comment_limit',
                esc_attr__('Please enter a valid value in the "Comment Limit" option.', 'dale'));
            $output = get_option('dale_advanced_comment_limit');
        } else {
            $output = $input;
        }

        return intval($output, 10);

    }

    public function advanced_google_font_embed_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_google_font_embed" name="dale_advanced_google_font_embed" class="regular-text" value="' . esc_attr(get_option("dale_advanced_google_font_embed")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__("Load a Google Font in the front-end of your website by entering the Google Font URL in this option.",
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_google_font_embed_validation($input)
    {

        if ( strlen(trim($input)) > 0 and !preg_match($this->shared->url_regex, trim($input))) {
            add_settings_error('dale_advanced_google_font_embed', 'dale_advanced_google_font_embed',
                esc_attr__('Please enter a valid URL in the "Google Font Embed" option.', 'dale'));
            $output = get_option('dale_advanced_google_font_embed');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_instagram_process_embed_callback($args)
    {

        $html = '<select id="dale-advanced-instagram-process-embed" name="dale_advanced_instagram_process_embed" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_instagram_process_embed")), 0,
                false) . ' value="0">' . esc_attr__('No', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_instagram_process_embed")), 1,
                false) . ' value="1">' . esc_attr__('Yes', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines if the instgrm.Embeds.process() function should be called when timeline items are added or modified. Select "Yes" if you are planning to add Instagram posts in a timeline.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_instagram_process_embed_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function advanced_clone_timeline_items_callback($args)
    {

        $html = '<select id="dale-advanced-clone-timeline-items" name="dale_advanced_clone_timeline_items" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_clone_timeline_items")), 0,
                false) . ' value="0">' . esc_attr__('No', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_clone_timeline_items")), 1,
                false) . ' value="1">' . esc_attr__('Yes', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines if a cloned event should include the timeline items of the original event.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_clone_timeline_items_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function advanced_clone_stat_groups_callback($args)
    {

        $html = '<select id="dale-advanced-clone-stat-groups" name="dale_advanced_clone_stat_groups" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_clone_stat_groups")), 0,
                false) . ' value="0">' . esc_attr__('No', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_clone_stat_groups")), 1,
                false) . ' value="1">' . esc_attr__('Yes', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines if a cloned event should include the stat groups of the original event.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_clone_stat_groups_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function advanced_clone_stat_items_callback($args)
    {

        $html = '<select id="dale-advanced-clone-stat-items" name="dale_advanced_clone_stat_items" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_clone_stat_items")), 0,
                false) . ' value="0">' . esc_attr__('No', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_clone_stat_items")), 1,
                false) . ' value="1">' . esc_attr__('Yes', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines if a cloned event should include the stat items of the original event.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_clone_stat_items_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function advanced_clone_comment_items_callback($args)
    {

        $html = '<select id="dale-advanced-clone-comment-items" name="dale_advanced_clone_comment_items" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_clone_comment_items")), 0,
                false) . ' value="0">' . esc_attr__('No', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_clone_comment_items")), 1,
                false) . ' value="1">' . esc_attr__('Yes', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines if a cloned event should include the comment items of the original event.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_clone_comment_items_validation($input)
    {

        return intval($input, 10) === 1 ? '1' : '0';

    }

    public function advanced_events_menu_pagination_callback($args)
    {

        $html = '<select id="dale-advanced-events-menu-pagination" name="dale_advanced_events_menu_pagination" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_events_menu_pagination")), 10,
                false) . ' value="10">' . esc_attr__('10', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_events_menu_pagination")), 20,
                false) . ' value="20">' . esc_attr__('20', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_events_menu_pagination")), 30,
                false) . ' value="30">' . esc_attr__('30', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_events_menu_pagination")), 40,
                false) . ' value="40">' . esc_attr__('40', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_events_menu_pagination")), 50,
                false) . ' value="50">' . esc_attr__('50', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_events_menu_pagination")), 60,
                false) . ' value="60">' . esc_attr__('60', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_events_menu_pagination")), 70,
                false) . ' value="70">' . esc_attr__('70', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_events_menu_pagination")), 80,
                false) . ' value="80">' . esc_attr__('80', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_events_menu_pagination")), 90,
                false) . ' value="90">' . esc_attr__('90', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_events_menu_pagination")), 100,
                false) . ' value="100">' . esc_attr__('100', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines the number of elements per page displayed in the "Events" menu.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_events_menu_pagination_validation($input)
    {

        switch (intval($input, 10)) {
            case 10:
            case 20:
            case 30:
            case 40:
            case 50:
            case 60:
            case 70:
            case 80:
            case 90:
            case 100:
                return $input;
            default:
                return get_option($this->shared->get('slug') . '_advanced_events_menu_pagination');
        }

    }

    public function advanced_timeline_sections_menu_pagination_callback($args)
    {

        $html = '<select id="dale-advanced-timeline-sections-menu-pagination" name="dale_advanced_timeline_sections_menu_pagination" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_sections_menu_pagination")), 10,
                false) . ' value="10">' . esc_attr__('10', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_sections_menu_pagination")), 20,
                false) . ' value="20">' . esc_attr__('20', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_sections_menu_pagination")), 30,
                false) . ' value="30">' . esc_attr__('30', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_sections_menu_pagination")), 40,
                false) . ' value="40">' . esc_attr__('40', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_sections_menu_pagination")), 50,
                false) . ' value="50">' . esc_attr__('50', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_sections_menu_pagination")), 60,
                false) . ' value="60">' . esc_attr__('60', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_sections_menu_pagination")), 70,
                false) . ' value="70">' . esc_attr__('70', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_sections_menu_pagination")), 80,
                false) . ' value="80">' . esc_attr__('80', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_sections_menu_pagination")), 90,
                false) . ' value="90">' . esc_attr__('90', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_sections_menu_pagination")), 100,
                false) . ' value="100">' . esc_attr__('100', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines the number of elements per page displayed in the "Timeline Sections" menu.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_timeline_sections_menu_pagination_validation($input)
    {

        switch (intval($input, 10)) {
            case 10:
            case 20:
            case 30:
            case 40:
            case 50:
            case 60:
            case 70:
            case 80:
            case 90:
            case 100:
                return $input;
            default:
                return get_option($this->shared->get('slug') . '_advanced_timeline_sections_menu_pagination');
        }

    }

    public function advanced_timeline_items_menu_pagination_callback($args)
    {

        $html = '<select id="dale-advanced-timeline-items-menu-pagination" name="dale_advanced_timeline_items_menu_pagination" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_items_menu_pagination")), 10,
                false) . ' value="10">' . esc_attr__('10', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_items_menu_pagination")), 20,
                false) . ' value="20">' . esc_attr__('20', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_items_menu_pagination")), 30,
                false) . ' value="30">' . esc_attr__('30', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_items_menu_pagination")), 40,
                false) . ' value="40">' . esc_attr__('40', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_items_menu_pagination")), 50,
                false) . ' value="50">' . esc_attr__('50', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_items_menu_pagination")), 60,
                false) . ' value="60">' . esc_attr__('60', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_items_menu_pagination")), 70,
                false) . ' value="70">' . esc_attr__('70', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_items_menu_pagination")), 80,
                false) . ' value="80">' . esc_attr__('80', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_items_menu_pagination")), 90,
                false) . ' value="90">' . esc_attr__('90', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_items_menu_pagination")), 100,
                false) . ' value="100">' . esc_attr__('100', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines the number of elements per page displayed in the "Timeline Items" menu.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_timeline_items_menu_pagination_validation($input)
    {

        switch (intval($input, 10)) {
            case 10:
            case 20:
            case 30:
            case 40:
            case 50:
            case 60:
            case 70:
            case 80:
            case 90:
            case 100:
                return $input;
            default:
                return get_option($this->shared->get('slug') . '_advanced_timeline_items_menu_pagination');
        }

    }

    public function advanced_timeline_icons_menu_pagination_callback($args)
    {

        $html = '<select id="dale-advanced-timeline-icons-menu-pagination" name="dale_advanced_timeline_icons_menu_pagination" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_icons_menu_pagination")), 10,
                false) . ' value="10">' . esc_attr__('10', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_icons_menu_pagination")), 20,
                false) . ' value="20">' . esc_attr__('20', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_icons_menu_pagination")), 30,
                false) . ' value="30">' . esc_attr__('30', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_icons_menu_pagination")), 40,
                false) . ' value="40">' . esc_attr__('40', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_icons_menu_pagination")), 50,
                false) . ' value="50">' . esc_attr__('50', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_icons_menu_pagination")), 60,
                false) . ' value="60">' . esc_attr__('60', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_icons_menu_pagination")), 70,
                false) . ' value="70">' . esc_attr__('70', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_icons_menu_pagination")), 80,
                false) . ' value="80">' . esc_attr__('80', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_icons_menu_pagination")), 90,
                false) . ' value="90">' . esc_attr__('90', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_timeline_icons_menu_pagination")), 100,
                false) . ' value="100">' . esc_attr__('100', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines the number of elements per page displayed in the "Timeline Icons" menu.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_timeline_icons_menu_pagination_validation($input)
    {

        switch (intval($input, 10)) {
            case 10:
            case 20:
            case 30:
            case 40:
            case 50:
            case 60:
            case 70:
            case 80:
            case 90:
            case 100:
                return $input;
            default:
                return get_option($this->shared->get('slug') . '_advanced_timeline_icons_menu_pagination');
        }

    }

    public function advanced_stat_sections_menu_pagination_callback($args)
    {

        $html = '<select id="dale-advanced-stat-sections-menu-pagination" name="dale_advanced_stat_sections_menu_pagination" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_sections_menu_pagination")), 10,
                false) . ' value="10">' . esc_attr__('10', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_sections_menu_pagination")), 20,
                false) . ' value="20">' . esc_attr__('20', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_sections_menu_pagination")), 30,
                false) . ' value="30">' . esc_attr__('30', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_sections_menu_pagination")), 40,
                false) . ' value="40">' . esc_attr__('40', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_sections_menu_pagination")), 50,
                false) . ' value="50">' . esc_attr__('50', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_sections_menu_pagination")), 60,
                false) . ' value="60">' . esc_attr__('60', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_sections_menu_pagination")), 70,
                false) . ' value="70">' . esc_attr__('70', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_sections_menu_pagination")), 80,
                false) . ' value="80">' . esc_attr__('80', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_sections_menu_pagination")), 90,
                false) . ' value="90">' . esc_attr__('90', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_sections_menu_pagination")), 100,
                false) . ' value="100">' . esc_attr__('100', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines the number of elements per page displayed in the "Stat Sections" menu.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_stat_sections_menu_pagination_validation($input)
    {

        switch (intval($input, 10)) {
            case 10:
            case 20:
            case 30:
            case 40:
            case 50:
            case 60:
            case 70:
            case 80:
            case 90:
            case 100:
                return $input;
            default:
                return get_option($this->shared->get('slug') . '_advanced_stat_sections_menu_pagination');
        }

    }

    public function advanced_stat_groups_menu_pagination_callback($args)
    {

        $html = '<select id="dale-advanced-stat-groups-menu-pagination" name="dale_advanced_stat_groups_menu_pagination" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_groups_menu_pagination")), 10,
                false) . ' value="10">' . esc_attr__('10', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_groups_menu_pagination")), 20,
                false) . ' value="20">' . esc_attr__('20', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_groups_menu_pagination")), 30,
                false) . ' value="30">' . esc_attr__('30', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_groups_menu_pagination")), 40,
                false) . ' value="40">' . esc_attr__('40', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_groups_menu_pagination")), 50,
                false) . ' value="50">' . esc_attr__('50', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_groups_menu_pagination")), 60,
                false) . ' value="60">' . esc_attr__('60', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_groups_menu_pagination")), 70,
                false) . ' value="70">' . esc_attr__('70', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_groups_menu_pagination")), 80,
                false) . ' value="80">' . esc_attr__('80', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_groups_menu_pagination")), 90,
                false) . ' value="90">' . esc_attr__('90', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_groups_menu_pagination")), 100,
                false) . ' value="100">' . esc_attr__('100', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines the number of elements per page displayed in the "Stat Groups" menu.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_stat_groups_menu_pagination_validation($input)
    {

        switch (intval($input, 10)) {
            case 10:
            case 20:
            case 30:
            case 40:
            case 50:
            case 60:
            case 70:
            case 80:
            case 90:
            case 100:
                return $input;
            default:
                return get_option($this->shared->get('slug') . '_advanced_stat_groups_menu_pagination');
        }

    }

    public function advanced_stat_items_menu_pagination_callback($args)
    {

        $html = '<select id="dale-advanced-stat-items-menu-pagination" name="dale_advanced_stat_items_menu_pagination" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_items_menu_pagination")), 10,
                false) . ' value="10">' . esc_attr__('10', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_items_menu_pagination")), 20,
                false) . ' value="20">' . esc_attr__('20', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_items_menu_pagination")), 30,
                false) . ' value="30">' . esc_attr__('30', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_items_menu_pagination")), 40,
                false) . ' value="40">' . esc_attr__('40', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_items_menu_pagination")), 50,
                false) . ' value="50">' . esc_attr__('50', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_items_menu_pagination")), 60,
                false) . ' value="60">' . esc_attr__('60', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_items_menu_pagination")), 70,
                false) . ' value="70">' . esc_attr__('70', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_items_menu_pagination")), 80,
                false) . ' value="80">' . esc_attr__('80', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_items_menu_pagination")), 90,
                false) . ' value="90">' . esc_attr__('90', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_stat_items_menu_pagination")), 100,
                false) . ' value="100">' . esc_attr__('100', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines the number of elements per page displayed in the "Stat Items" menu.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_stat_items_menu_pagination_validation($input)
    {

        switch (intval($input, 10)) {
            case 10:
            case 20:
            case 30:
            case 40:
            case 50:
            case 60:
            case 70:
            case 80:
            case 90:
            case 100:
                return $input;
            default:
                return get_option($this->shared->get('slug') . '_advanced_stat_items_menu_pagination');
        }

    }

    public function advanced_comment_sections_menu_pagination_callback($args)
    {

        $html = '<select id="dale-advanced-comment-sections-menu-pagination" name="dale_advanced_comment_sections_menu_pagination" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_sections_menu_pagination")), 10,
                false) . ' value="10">' . esc_attr__('10', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_sections_menu_pagination")), 20,
                false) . ' value="20">' . esc_attr__('20', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_sections_menu_pagination")), 30,
                false) . ' value="30">' . esc_attr__('30', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_sections_menu_pagination")), 40,
                false) . ' value="40">' . esc_attr__('40', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_sections_menu_pagination")), 50,
                false) . ' value="50">' . esc_attr__('50', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_sections_menu_pagination")), 60,
                false) . ' value="60">' . esc_attr__('60', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_sections_menu_pagination")), 70,
                false) . ' value="70">' . esc_attr__('70', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_sections_menu_pagination")), 80,
                false) . ' value="80">' . esc_attr__('80', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_sections_menu_pagination")), 90,
                false) . ' value="90">' . esc_attr__('90', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_sections_menu_pagination")), 100,
                false) . ' value="100">' . esc_attr__('100', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines the number of elements per page displayed in the "Comment Sections" menu.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_comment_sections_menu_pagination_validation($input)
    {

        switch (intval($input, 10)) {
            case 10:
            case 20:
            case 30:
            case 40:
            case 50:
            case 60:
            case 70:
            case 80:
            case 90:
            case 100:
                return $input;
            default:
                return get_option($this->shared->get('slug') . '_advanced_comment_sections_menu_pagination');
        }

    }

    public function advanced_comment_items_menu_pagination_callback($args)
    {

        $html = '<select id="dale-advanced-comment-items-menu-pagination" name="dale_advanced_comment_items_menu_pagination" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_items_menu_pagination")), 10,
                false) . ' value="10">' . esc_attr__('10', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_items_menu_pagination")), 20,
                false) . ' value="20">' . esc_attr__('20', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_items_menu_pagination")), 30,
                false) . ' value="30">' . esc_attr__('30', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_items_menu_pagination")), 40,
                false) . ' value="40">' . esc_attr__('40', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_items_menu_pagination")), 50,
                false) . ' value="50">' . esc_attr__('50', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_items_menu_pagination")), 60,
                false) . ' value="60">' . esc_attr__('60', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_items_menu_pagination")), 70,
                false) . ' value="70">' . esc_attr__('70', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_items_menu_pagination")), 80,
                false) . ' value="80">' . esc_attr__('80', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_items_menu_pagination")), 90,
                false) . ' value="90">' . esc_attr__('90', 'dale') . '</option>';
        $html .= '<option ' . selected(intval(get_option("dale_advanced_comment_items_menu_pagination")), 100,
                false) . ' value="100">' . esc_attr__('100', 'dale') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('This options determines the number of elements per page displayed in the "Comment Items" menu.',
                'dale') . '"></div>';

        echo $html;

    }

    public function advanced_comment_items_menu_pagination_validation($input)
    {

        switch (intval($input, 10)) {
            case 10:
            case 20:
            case 30:
            case 40:
            case 50:
            case 60:
            case 70:
            case 80:
            case 90:
            case 100:
                return $input;
            default:
                return get_option($this->shared->get('slug') . '_advanced_comment_items_menu_pagination');
        }

    }

    public function advanced_events_menu_capability_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_events_menu_capability" name="dale_advanced_events_menu_capability" class="regular-text" value="' . esc_attr(get_option("dale_advanced_events_menu_capability")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Events" menu',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_events_menu_capability_validation($input)
    {

        if ( ! preg_match($this->shared->regex_capability, trim($input))) {
            add_settings_error('dale_advanced_events_menu_capability', 'dale_advanced_events_menu_capability',
                esc_attr__('Please enter a valid capability in the "Events Menu Capability" option.', 'dale'));
            $output = get_option('dale_advanced_events_menu_capability');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_timeline_sections_menu_capability_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_timeline_sections_menu_capability" name="dale_advanced_timeline_sections_menu_capability" class="regular-text" value="' . esc_attr(get_option("dale_advanced_timeline_sections_menu_capability")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Timeline Sections" menu.',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_timeline_sections_menu_capability_validation($input)
    {

        if ( ! preg_match($this->shared->regex_capability, trim($input))) {
            add_settings_error('dale_advanced_timeline_sections_menu_capability',
                'dale_advanced_timeline_sections_menu_capability',
                esc_attr__('Please enter a valid capability in the "Timeline Sections Menu Capability" option.',
                    'dale'));
            $output = get_option('dale_advanced_timeline_sections_menu_capability');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_timeline_items_menu_capability_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_timeline_items_menu_capability" name="dale_advanced_timeline_items_menu_capability" class="regular-text" value="' . esc_attr(get_option("dale_advanced_timeline_items_menu_capability")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Timeline Items" menu.',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_timeline_items_menu_capability_validation($input)
    {

        if ( ! preg_match($this->shared->regex_capability, trim($input))) {
            add_settings_error('dale_advanced_timeline_items_menu_capability',
                'dale_advanced_timeline_items_menu_capability',
                esc_attr__('Please enter a valid capability in the "Timeline Items Menu Capability" option.', 'dale'));
            $output = get_option('dale_advanced_timeline_items_menu_capability');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_timeline_icons_menu_capability_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_timeline_icons_menu_capability" name="dale_advanced_timeline_icons_menu_capability" class="regular-text" value="' . esc_attr(get_option("dale_advanced_timeline_icons_menu_capability")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Timeline Icons" menu.',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_timeline_icons_menu_capability_validation($input)
    {

        if ( ! preg_match($this->shared->regex_capability, trim($input))) {
            add_settings_error('dale_advanced_timeline_icons_menu_capability',
                'dale_advanced_timeline_icons_menu_capability',
                esc_attr__('Please enter a valid capability in the "Timeline Icons Menu Capability" option.', 'dale'));
            $output = get_option('dale_advanced_timeline_icons_menu_capability');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_stat_sections_menu_capability_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_stat_sections_menu_capability" name="dale_advanced_stat_sections_menu_capability" class="regular-text" value="' . esc_attr(get_option("dale_advanced_stat_sections_menu_capability")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Stat Sections" menu.',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_stat_sections_menu_capability_validation($input)
    {

        if ( ! preg_match($this->shared->regex_capability, trim($input))) {
            add_settings_error('dale_advanced_stat_sections_menu_capability',
                'dale_advanced_stat_sections_menu_capability',
                esc_attr__('Please enter a valid capability in the "Stat Sections" menu.', 'dale'));
            $output = get_option('dale_advanced_stat_sections_menu_capability');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_stat_groups_menu_capability_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_stat_groups_menu_capability" name="dale_advanced_stat_groups_menu_capability" class="regular-text" value="' . esc_attr(get_option("dale_advanced_stat_groups_menu_capability")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Stat Groups" menu.',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_stat_groups_menu_capability_validation($input)
    {

        if ( ! preg_match($this->shared->regex_capability, trim($input))) {
            add_settings_error('dale_advanced_stat_groups_menu_capability', 'dale_advanced_stat_groups_menu_capability',
                esc_attr__('Please enter a valid capability in the "Stat Groups Menu Capability" option.', 'dale'));
            $output = get_option('dale_advanced_stat_groups_menu_capability');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_stat_items_menu_capability_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_stat_items_menu_capability" name="dale_advanced_stat_items_menu_capability" class="regular-text" value="' . esc_attr(get_option("dale_advanced_stat_items_menu_capability")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Stat Items" menu.',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_stat_items_menu_capability_validation($input)
    {

        if ( ! preg_match($this->shared->regex_capability, trim($input))) {
            add_settings_error('dale_advanced_stat_items_menu_capability', 'dale_advanced_stat_items_menu_capability',
                esc_attr__('Please enter a valid capability in the "Stat Items Menu Capability" option.', 'dale'));
            $output = get_option('dale_advanced_stat_items_menu_capability');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_comment_sections_menu_capability_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_comment_sections_menu_capability" name="dale_advanced_comment_sections_menu_capability" class="regular-text" value="' . esc_attr(get_option("dale_advanced_comment_sections_menu_capability")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Comment Sections" menu.',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_comment_sections_menu_capability_validation($input)
    {

        if ( ! preg_match($this->shared->regex_capability, trim($input))) {
            add_settings_error('dale_advanced_comment_sections_menu_capability',
                'dale_advanced_comment_sections_menu_capability',
                esc_attr__('Please enter a valid capability in the "Comment Sections Menu Capability" option.',
                    'dale'));
            $output = get_option('dale_advanced_comment_sections_menu_capability');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_comment_items_menu_capability_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_comment_items_menu_capability" name="dale_advanced_comment_items_menu_capability" class="regular-text" value="' . esc_attr(get_option("dale_advanced_comment_items_menu_capability")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Comment Items" menu.',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_comment_items_menu_capability_validation($input)
    {

        if ( ! preg_match($this->shared->regex_capability, trim($input))) {
            add_settings_error('dale_advanced_comment_items_menu_capability',
                'dale_advanced_comment_items_menu_capability',
                esc_attr__('Please enter a valid capability in the "Comment Items Menu Capability" option.', 'dale'));
            $output = get_option('dale_advanced_comment_items_menu_capability');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    public function advanced_write_comments_capability_callback($args)
    {

        $html = '<input autocomplete="off" type="text" id="dale_advanced_write_comments_capability" name="dale_advanced_write_comments_capability" class="regular-text" value="' . esc_attr(get_option("dale_advanced_write_comments_capability")) . '" />';
        $html .= '<div class="help-icon" title="' . esc_attr__('The capability required to write comments in the Comment Sections.',
                'dale') . '"></div>';
        echo $html;

    }

    public function advanced_write_comments_capability_validation($input)
    {

        if ( ! preg_match($this->shared->regex_capability, trim($input))) {
            add_settings_error('dale_advanced_write_comments_capability', 'dale_advanced_write_comments_capability',
                esc_attr__('Please enter a valid capability in the "Write Comments Capability" option.', 'dale'));
            $output = get_option('dale_advanced_write_comments_capability');
        } else {
            $output = trim($input);
        }

        return $output;

    }

    /**
     * Add the proper filters used to register the TinyMCE plugin and the TinyMCE button
     */
    function create_tinymce_plugin()
    {

        //The TinyMCE plugin is created only for the users with the Events Menu Capability
        if ( ! current_user_can(get_option($this->shared->get('slug') . '_advanced_events_menu_capability'))) {
            return;
        }

        if (get_user_option('rich_editing') == 'true') {

            //filter used to create the tinymce plugin
            add_filter('mce_external_plugins', array($this, 'add_tinymce_plugin'));

            //filter used to create the tinymce button
            add_filter('mce_buttons', array($this, 'register_tinymce_buttons'));

        }

    }

    //Add the 'liveevents' TinyMCE Plugin
    public function add_tinymce_plugin($plugin_array)
    {

        $plugin_array['liveevents'] = $this->shared->get("url") . 'admin/assets/js/tinymce-liveevents.js';

        return $plugin_array;

    }

    /*
     * Add the "selectliveevents" tinymce button
     *
     * @return array
     */
    public function register_tinymce_buttons($buttons)
    {

        array_push($buttons, "", "selectliveevents");

        return $buttons;

    }

    /*
     * Generate the custom-[blog_id].css file based on the plugin options.
     */
    public function write_custom_css()
    {

        //turn on output buffering
        ob_start();

//generate the CSS
?>/*General Separators Color*/
<?php $general_separators_color = get_option($this->shared->get('slug') . '_general_separators_color'); ?>
#dale-live-event #dale-tabs{border-bottom-color: <?php echo esc_attr($general_separators_color); ?> !important;}
#dale-live-event #dale-social {border-bottom-color: <?php echo esc_attr($general_separators_color); ?> !important;}
#dale-live-event .dale-body-timeline-item{border-bottom-color: <?php echo esc_attr($general_separators_color); ?> !important;}
#dale-live-event .dale-single-comment-container{border-bottom-color: <?php echo esc_attr($general_separators_color); ?> !important;}

/*General Section Title Background Color*/
<?php $general_section_title_background_color = get_option($this->shared->get('slug') . '_general_section_title_background_color'); ?>
#dale-live-event .dale-comment-header{background: <?php echo esc_attr($general_section_title_background_color); ?> !important;}
#dale-live-event .dale-body-stat-group-label{background: <?php echo esc_attr($general_section_title_background_color); ?> !important;}

/*General Section Title Border Color*/
<?php $general_section_title_border_color = get_option($this->shared->get('slug') . '_general_section_title_border_color'); ?>
#dale-live-event .dale-comment-header{border-color: <?php echo esc_attr($general_section_title_border_color); ?> !important;}
#dale-live-event .dale-body-stat-group-label{border-color: <?php echo esc_attr($general_section_title_border_color); ?> !important;}

/*General Section Title Font Color*/
<?php $general_section_title_font_color = get_option($this->shared->get('slug') . '_general_section_title_font_color'); ?>
#dale-live-event .dale-comment-header{color: <?php echo esc_attr($general_section_title_font_color); ?> !important;}
#dale-live-event .dale-body-stat-group-label{color: <?php echo esc_attr($general_section_title_font_color); ?> !important;}

/*General Tab Font Color*/
<?php $general_tab_font_color = get_option($this->shared->get('slug') . '_general_tab_font_color'); ?>
#dale-live-event ul#dale-tabs-ul li, #dale-live-event ul#dale-tabs-ul li span{color: <?php echo esc_attr($general_tab_font_color); ?> !important;}

/*General Active Tab Border Color*/
<?php $general_active_tab_border_color = get_option($this->shared->get('slug') . '_general_active_tab_border_color'); ?>
#dale-live-event ul#dale-tabs-ul li.dale-tabs-highlight{border-color: <?php echo esc_attr($general_active_tab_border_color); ?> !important;}

/*General Active Tab Font Color*/
<?php $general_active_tab_font_color = get_option($this->shared->get('slug') . '_general_active_tab_font_color'); ?>
#dale-live-event ul#dale-tabs-ul li.dale-tabs-highlight, #dale-live-event ul#dale-tabs-ul li.dale-tabs-highlight span{color: <?php echo esc_attr($general_active_tab_font_color); ?> !important;}

/*General Font Family*/
<?php $general_font_family = get_option($this->shared->get('slug') . '_general_font_family'); ?>
#dale-live-event, #dale-live-event *{font-family: <?php echo $general_font_family; ?> !important;}

/*General Base Font Size*/
<?php $general_base_font_size = intval(get_option($this->shared->get('slug') . '_general_base_font_size'),
10); ?>
#dale-live-event, #dale-live-event *{font-size: <?php echo $general_base_font_size; ?>px !important;}
#dale-live-event ul#dale-tabs-ul{font-size: <?php echo $general_base_font_size * (14 / 13); ?>px !important;}
#dale-live-event ul#dale-tabs-ul li > .dale-tabs-li-inner{font-size: <?php echo $general_base_font_size * (14 / 13); ?>px !important;}
#dale-live-event #dale-social{font-size: <?php echo $general_base_font_size * (14 / 13); ?>px !important;}
#dale-live-event #dale-social-label-left{font-size: <?php echo $general_base_font_size * (14 / 13); ?>px !important;}
#dale-live-event .dale-social-label-button > span{font-size: <?php echo $general_base_font_size * (14 / 13); ?>px !important;}
#dale-live-event .dale-body-timeline-date{font-size: <?php echo $general_base_font_size * (11 / 13); ?>px !important;}
#dale-live-event .dale-body-timeline-title{font-size: <?php echo $general_base_font_size; ?>px !important;}
#dale-live-event .dale-body-timeline-content{font-size: <?php echo $general_base_font_size; ?>px !important;}
#dale-live-event .dale-body-timeline-content p{font-size: <?php echo $general_base_font_size; ?>px !important;}
#dale-live-event .dale-new-comment-content{font-size: <?php echo $general_base_font_size; ?>px !important;}
#dale-live-event .dale-comment-header{font-size: <?php echo $general_base_font_size * (11 / 13); ?>px !important;}
#dale-live-event .dale-new-comment-submit{font-size: <?php echo $general_base_font_size * (11 / 13); ?>px !important;}
#dale-live-event .dale-single-comment-user, #dale-live-event .dale-single-comment-date{font-size: <?php echo $general_base_font_size * (11 / 13); ?>px !important;}
#dale-live-event .dale-single-comment-content{font-size: <?php echo $general_base_font_size; ?>px !important;}
#dale-live-event .dale-comment-temporary-message{font-size: <?php echo $general_base_font_size * (11 / 13); ?>px !important;}
#dale-live-event .dale-body-stat-group-label{font-size: <?php echo $general_base_font_size * (11 / 13); ?>px !important;}
#dale-live-event .dale-body-stat-single-data > div{font-size: <?php echo $general_base_font_size; ?>px !important;}
#dale-live-event .dale-body-stat-single-visual .dale-data div{font-size: <?php echo $general_base_font_size; ?>px !important;}
#dale-live-event .dale-body-stat-comparison-data div{font-size: <?php echo $general_base_font_size; ?>px !important;}
#dale-live-event .dale-body-stat-comparison-visual .dale-data div{font-size: <?php echo $general_base_font_size; ?>px !important;}

/*General Top Margin*/
<?php $general_top_margin = intval(get_option($this->shared->get('slug') . '_general_top_margin'), 10); ?>
#dale-live-event{margin-top: <?php echo $general_top_margin; ?>px !important;}

/*General Top Margin*/
<?php $general_bottom_margin = intval(get_option($this->shared->get('slug') . '_general_bottom_margin'), 10); ?>
#dale-live-event{margin-bottom: <?php echo $general_bottom_margin; ?>px !important;}

/*General Responsive Breakpoint*/
<?php $general_responsive_breakpoint = intval(get_option($this->shared->get('slug') . '_general_responsive_breakpoint'),
10); ?>
@media all and (max-width: <?php echo intval($general_responsive_breakpoint, 10); ?>px){
#dale-live-event ul#dale-tabs-ul{
max-height: none !important;
}
#dale-live-event ul#dale-tabs-ul .dale-tabs-li{
width: 100% !important;
margin: 0 auto !important;
padding-bottom: 0 !important;
height: auto !important;
float: left !important;
}
#dale-live-event .dale-tabs-li > .dale-tabs-li-inner{
height: 1.8571428571em !important;
line-height: 1.8571428571em !important;
}
#dale-live-event ul#dale-tabs-ul li.dale-tabs-highlight{
border-bottom-width: 0 !important;
}
#dale-live-event ul#dale-tabs-ul li.dale-tabs-li:not(:last-of-type){
border-bottom: 1px solid <?php echo esc_attr($general_separators_color); ?> !important;
}
#dale-live-event ul#dale-tabs-ul li > .dale-tabs-li-inner{
float: left;
clear: both;
}
#dale-live-event .dale-body-timeline-item-left{display: none !important;}
#dale-live-event .dale-body-timeline-item-right{margin-left: 0 !important;}
#dale-live-event .dale-single-comment-left{display: none !important;}
#dale-live-event .dale-single-comment-right{margin-left: 0 !important;}
.daext-clearfix-responsive:after{
visibility: hidden !important;
display: block !important;
font-size: 0 !important;
content: " " !important;
clear: both !important;
height: 0 !important;
}
.daext-clearfix-responsive{ display: inline-block !important; }
* html .daext-clearfix-responsive{ height: 1% !important; }
.daext-clearfix-responsive{ display: block !important; }
}

/*Timeline Item Date Font Color*/
<?php $timeline_item_date_font_color = get_option($this->shared->get('slug') . '_timeline_item_date_font_color'); ?>
#dale-live-event .dale-body-timeline-date{color: <?php echo esc_attr($timeline_item_date_font_color); ?> !important;}

/*Timeline Item Title Font Color*/
<?php $timeline_item_title_font_color = get_option($this->shared->get('slug') . '_timeline_item_title_font_color'); ?>
#dale-live-event .dale-body-timeline-title{color: <?php echo esc_attr($timeline_item_title_font_color); ?> !important;}

/*Timeline Item Description Font Color*/
<?php $timeline_item_description_font_color = get_option($this->shared->get('slug') . '_timeline_item_description_font_color'); ?>
#dale-live-event .dale-body-timeline-content{color: <?php echo esc_attr($timeline_item_description_font_color); ?> !important;}

/*Timeline Item Date Font Weight*/
<?php $timeline_item_date_font_weight = get_option($this->shared->get('slug') . '_timeline_item_date_font_weight'); ?>
#dale-live-event .dale-body-timeline-date{font-weight: <?php echo intval($timeline_item_date_font_weight,
10); ?> !important;}

/*Timeline Item Title Font Weight*/
<?php $timeline_item_title_font_weight = get_option($this->shared->get('slug') . '_timeline_item_title_font_weight'); ?>
#dale-live-event .dale-body-timeline-title{font-weight: <?php echo intval($timeline_item_title_font_weight,
10); ?> !important;}

/*Timeline Item Description Font Weight*/
<?php $timeline_item_description_font_weight = get_option($this->shared->get('slug') . '_timeline_item_description_font_weight'); ?>
#dale-live-event .dale-body-timeline-content{font-weight: <?php echo intval($timeline_item_description_font_weight,
10); ?> !important;}

/*Comment Textarea Background Color*/
<?php $comment_textarea_background_color = get_option($this->shared->get('slug') . '_comment_textarea_background_color'); ?>
#dale-live-event .dale-new-comment-container, #dale-live-event .dale-new-comment-content{background: <?php echo esc_attr($comment_textarea_background_color); ?> !important;}

/*Comment Textarea Border Color*/
<?php $comment_textarea_border_color = get_option($this->shared->get('slug') . '_comment_textarea_border_color'); ?>
#dale-live-event .dale-new-comment-container{border-color: <?php echo esc_attr($comment_textarea_border_color); ?> !important;}

/*Comment Textarea Font Color*/
<?php $comment_textarea_font_color = get_option($this->shared->get('slug') . '_comment_textarea_font_color'); ?>
#dale-live-event .dale-new-comment-content{color: <?php echo esc_attr($comment_textarea_font_color); ?> !important;}

/*Comment Heading Font Color*/
<?php $comment_heading_font_color = get_option($this->shared->get('slug') . '_comment_heading_font_color'); ?>
#dale-live-event .dale-single-comment-header > div{color: <?php echo esc_attr($comment_heading_font_color); ?> !important;}

/*Comment Content Font Color*/
<?php $comment_content_font_color = get_option($this->shared->get('slug') . '_comment_content_font_color'); ?>
#dale-live-event .dale-single-comment-content{color: <?php echo esc_attr($comment_content_font_color); ?> !important;}

/*Comment Submit Comment Font Color*/
<?php $comment_submit_comment_font_color = get_option($this->shared->get('slug') . '_comment_submit_comment_font_color'); ?>
#dale-live-event .dale-new-comment-submit{color: <?php echo esc_attr($comment_submit_comment_font_color); ?> !important;}

/*Comment Submit Comment Hover Font Color*/
<?php $comment_submit_comment_hover_font_color = get_option($this->shared->get('slug') . '_comment_submit_comment_hover_font_color'); ?>
#dale-live-event .dale-new-comment-submit:hover{color: <?php echo esc_attr($comment_submit_comment_hover_font_color); ?> !important;}

/*Comment Message Background Color*/
<?php $comment_message_background_color = get_option($this->shared->get('slug') . '_comment_message_background_color'); ?>
#dale-live-event .dale-comment-temporary-message{background-color: <?php echo esc_attr($comment_message_background_color); ?> !important;}

/*Comment Message Border Color*/
<?php $comment_message_border_color = get_option($this->shared->get('slug') . '_comment_message_border_color'); ?>
#dale-live-event .dale-comment-temporary-message{border-color: <?php echo esc_attr($comment_message_border_color); ?> !important;}

/*Comment Message Font Color*/
<?php $comment_message_font_color = get_option($this->shared->get('slug') . '_comment_message_font_color'); ?>
#dale-live-event .dale-comment-temporary-message{color: <?php echo esc_attr($comment_message_font_color); ?> !important;}

/*Comment Textarea Font Weight*/
<?php $comment_textarea_font_weight = get_option($this->shared->get('slug') . '_comment_textarea_font_weight'); ?>
#dale-live-event .dale-new-comment-content{font-weight: <?php echo intval($comment_textarea_font_weight,
10); ?> !important;}

/*Comment Heading Font Weight*/
<?php $comment_heading_font_weight = get_option($this->shared->get('slug') . '_comment_heading_font_weight'); ?>
#dale-live-event .dale-single-comment-header > div{font-weight: <?php echo intval($comment_heading_font_weight,
10); ?> !important;}

/*Comment Content Font Weight*/
<?php $comment_content_font_weight = get_option($this->shared->get('slug') . '_comment_content_font_weight'); ?>
#dale-live-event .dale-single-comment-content{font-weight: <?php echo intval($comment_content_font_weight,
10); ?> !important;}

/*Comment Submit Comment Font Weight*/
<?php $comment_submit_comment_font_weight = get_option($this->shared->get('slug') . '_comment_submit_comment_font_weight'); ?>
#dale-live-event .dale-new-comment-submit{font-weight: <?php echo intval($comment_submit_comment_font_weight,
10); ?> !important;}

/*Stat Subject Font Color*/
<?php $stat_subject_font_color = get_option($this->shared->get('slug') . '_stat_subject_font_color'); ?>
#dale-live-event .dale-body-stat-single-data .dale-subject,
#dale-live-event .dale-body-stat-comparison-data .dale-subject{color: <?php echo esc_attr($stat_subject_font_color); ?> !important;}

/*Stat Value Font Color*/
<?php $stat_value_font_color = get_option($this->shared->get('slug') . '_stat_value_font_color'); ?>
#dale-live-event .dale-body-stat-single-data .dale-value-1,
#dale-live-event .dale-body-stat-single-data .dale-reference,
#dale-live-event .dale-body-stat-comparison-data .dale-value-1,
#dale-live-event .dale-body-stat-comparison-data .dale-value-2{color: <?php echo esc_attr($stat_value_font_color); ?> !important;}

/*Stat Subject Visual Font Color*/
<?php $stat_subject_visual_font_color = get_option($this->shared->get('slug') . '_stat_subject_visual_font_color'); ?>
#dale-live-event .dale-body-stat-single-visual .dale-subject,
#dale-live-event .dale-body-stat-comparison-visual .dale-subject{color: <?php echo esc_attr($stat_subject_visual_font_color); ?> !important;}

/*Stat Value Visual Font Color*/
<?php $stat_value_visual_font_color = get_option($this->shared->get('slug') . '_stat_value_visual_font_color'); ?>
#dale-live-event .dale-body-stat-single-visual .dale-value-1,
#dale-live-event .dale-body-stat-single-visual .dale-reference,
#dale-live-event .dale-body-stat-comparison-visual .dale-value-1,
#dale-live-event .dale-body-stat-comparison-visual .dale-value-2{color: <?php echo esc_attr($stat_value_visual_font_color); ?> !important;}

/*Stat Bar Value Color*/
<?php $stat_bar_value_color = get_option($this->shared->get('slug') . '_stat_bar_value_color'); ?>
#dale-live-event .dale-bar{background: <?php echo esc_attr($stat_bar_value_color); ?> !important;}

/*Stat Bar Background Color*/
<?php $stat_bar_background_color = get_option($this->shared->get('slug') . '_stat_bar_background_color'); ?>
#dale-live-event .dale-body-stat-single-visual,
#dale-live-event .dale-body-stat-comparison-visual{background: <?php echo esc_attr($stat_bar_background_color); ?> !important;}

/*Stat Subject Font Weight*/
<?php $stat_subject_font_weight = get_option($this->shared->get('slug') . '_stat_subject_font_weight'); ?>
#dale-live-event .dale-body-stat-single-data .dale-subject,
#dale-live-event .dale-body-stat-comparison-data .dale-subject{font-weight: <?php echo intval($stat_subject_font_weight,
10); ?> !important;}

/*Stat Value Font Weight*/
<?php $stat_value_font_weight = get_option($this->shared->get('slug') . '_stat_value_font_weight'); ?>
#dale-live-event .dale-body-stat-single-data .dale-value-1,
#dale-live-event .dale-body-stat-single-data .dale-reference,
#dale-live-event .dale-body-stat-comparison-data .dale-value-1,
#dale-live-event .dale-body-stat-comparison-data .dale-value-2{font-weight: <?php echo esc_attr($stat_value_font_weight); ?> !important;}

/*Stat Subject Visual Font Weight*/
<?php $stat_subject_visual_font_weight = get_option($this->shared->get('slug') . '_stat_subject_visual_font_weight'); ?>
#dale-live-event .dale-body-stat-single-visual .dale-subject,
#dale-live-event .dale-body-stat-comparison-visual .dale-subject{font-weight: <?php echo esc_attr($stat_subject_visual_font_weight); ?> !important;}

/*Stat Value Visual Font Weight*/
<?php $stat_value_visual_font_weight = get_option($this->shared->get('slug') . '_stat_value_visual_font_weight'); ?>
#dale-live-event .dale-body-stat-single-visual .dale-value-1,
#dale-live-event .dale-body-stat-single-visual .dale-reference,
#dale-live-event .dale-body-stat-comparison-visual .dale-value-1,
#dale-live-event .dale-body-stat-comparison-visual .dale-value-2{font-weight: <?php echo esc_attr($stat_value_visual_font_weight); ?> !important;}

/*Social Icons Color*/
<?php $social_icons_color = get_option($this->shared->get('slug') . '_social_icons_color'); ?>
#dale-live-event .dale-social-label-button > span{color: <?php echo esc_attr($social_icons_color); ?> !important}

/*Social Icons Hover Color*/
<?php $social_icons_hover_color = get_option($this->shared->get('slug') . '_social_icons_hover_color'); ?>
#dale-live-event .dale-social-label-button > span:hover{color: <?php echo esc_attr($social_icons_hover_color); ?> !important}

/*Social Share Font Color*/
<?php $social_share_font_color = get_option($this->shared->get('slug') . '_social_share_font_color'); ?>
#dale-live-event #dale-social-label-left{color: <?php echo esc_attr($social_share_font_color); ?> !important}

/*Social Share Font Weight*/
<?php $social_share_font_weight = get_option($this->shared->get('slug') . '_social_share_font_weight'); ?>
#dale-live-event #dale-social-label-left{font-weight: <?php echo intval($social_share_font_weight,
10); ?> !important}<?php

        $custom_css_string = ob_get_clean();

        return @file_put_contents($this->shared->get('dir') . 'public/assets/css/custom-' . get_current_blog_id() . '.css',
            $custom_css_string, LOCK_EX);

    }

	/**
     * Deletes all the comment_item of the specified user.
     *
	 * @param $user_id
	 */
    public function delete_comment_item_of_user($user_id){

        global $wpdb;
	    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
	    $safe_sql   = $wpdb->prepare("DELETE FROM $table_name WHERE user_id = %d", $user_id);
	    $wpdb->query($safe_sql);

    }

}