<?php

if ( ! current_user_can(get_option($this->shared->get('slug') . '_advanced_events_menu_capability'))) {
    wp_die(esc_attr__('You do not have sufficient permissions to access this page.', 'dale'));
}

?>

<!-- process data -->

<?php

if (isset($_POST['update_id']) or isset($_POST['form_submitted'])) {

    extract($_POST);

    //prepare data -----------------------------------------------------------------------------------------------------
    if (isset($update_id)) {
        $update_id = intval($update_id, 10);
    }
    $name        = trim($name);
    $description = trim($description);
    $live        = intval($live, 10) === 1 ? 1 : 0;
    $schema_start_date        = trim($schema_start_date);
    $schema_timezone        = trim($schema_timezone);
	$schema_location        = trim($schema_location);

	//If the date is invalid set the current date
    if(dateTime::createFromFormat('Y-m-d H:i', $schema_start_date) === false){
        $schema_start_date = current_time('mysql', 1);
    }

    //validation -------------------------------------------------------------------------------------------------------

    $invalid_data_message = '';

    //validation on "event_id"
    if (isset($update_id)) {
        if ( ! $this->shared->event_exists($update_id)) {
            $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__("The event doesn't exist.",
                    'dale') . '</p></div>';
            $invalid_data         = true;
        }
    }

    //validation on "name"
    if (strlen(trim($name)) === 0 or strlen(trim($name)) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Name" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "description"
    if (strlen(trim($description)) === 0 or strlen(trim($description)) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Description" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

}

//update ---------------------------------------------------------------
if (isset($_POST['update_id']) and ! isset($invalid_data)) {

    //update the database
    global $wpdb;
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_event";
    $safe_sql   = $wpdb->prepare("UPDATE $table_name SET 
                name = %s,
                description = %s,
                live = %d,
                schema_start_date = %s,
                schema_timezone = %s,
                schema_location = %s
                WHERE event_id = %d",
        $name,
        $description,
        $live,
        $schema_start_date,
        $schema_timezone,
        $schema_location,
        $update_id);

    $query_result = $wpdb->query($safe_sql);

    if ($query_result !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The event has been successfully updated.',
                'dale') . '</p></div>';
    }

} else {

    //add ------------------------------------------------------------------
    if (isset($_POST['form_submitted']) and ! isset($invalid_data)) {

        //insert into the database
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_event";
        $safe_sql   = $wpdb->prepare("INSERT INTO $table_name SET 
                name = %s,
                description = %s,
                live = %d,
                schema_start_date = %s,
                schema_timezone = %s,
                schema_location = %s",
            $name,
            $description,
            $live,
            $schema_start_date,
            $schema_timezone,
            $schema_location
        );

        $query_result = $wpdb->query($safe_sql);

        if ($query_result !== false) {
            $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The event has been successfully added.',
                    'dale') . '</p></div>';
        }

    }

}

//delete an event
if (isset($_POST['delete_id'])) {

    global $wpdb;
    $delete_id = intval($_POST['delete_id'], 10);

    //Delete the associated timelines ----------------------------------------------------------------------------------

    //Generate an array with the 'timeline_id' of all the timelines associated with this event
    global $wpdb;
    $table_name    = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
    $safe_sql      = $wpdb->prepare("SELECT timeline_id FROM $table_name WHERE event_id = %d", $delete_id);
    $timeline_id_a = $wpdb->get_results($safe_sql, ARRAY_A);

    //Delete all the timeline_items associated with this event
    if (count($timeline_id_a) > 0) {
        foreach ($timeline_id_a as $timeline_id) {
            $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
            $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE timeline_id = %d", $timeline_id);
            $query_result = $wpdb->query($safe_sql);
        }
    }

    //Delete all the timelines associated with this event
    $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
    $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE event_id = %d", $delete_id);
    $query_result = $wpdb->query($safe_sql);

    //Delete the associated stats --------------------------------------------------------------------------------------

    //Generate an array with the 'stat_id' of all the stats associated with this event
    global $wpdb;
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat";
    $safe_sql   = $wpdb->prepare("SELECT stat_id FROM $table_name WHERE event_id = %d", $delete_id);
    $stat_id_a  = $wpdb->get_results($safe_sql, ARRAY_A);

    //Generate an array with the 'stat_group_id' of all the stat_group associated with this stat
    if (count($stat_id_a) > 0) {
        foreach ($stat_id_a as $stat_id) {
            $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
            $safe_sql     = $wpdb->prepare("SELECT stat_group_id FROM $table_name WHERE stat_id = %d", $stat_id);
            $query_result = $wpdb->get_results($safe_sql, ARRAY_A);
            if (count($query_result) > 0) {
                foreach ($query_result as $single_query_result) {
                    $stat_group_id_a[] = $single_query_result['stat_group_id'];
                }
            }
        }
    }

    //Generate an array with the 'stat_item_id' of all the stat_item associated with the stat_group
    if (isset($stat_group_id_a) and count($stat_group_id_a) > 0) {
        foreach ($stat_group_id_a as $stat_group_id) {
            $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
            $safe_sql     = $wpdb->prepare("SELECT stat_item_id FROM $table_name WHERE stat_group_id = %d",
                $stat_group_id);
            $query_result = $wpdb->get_results($safe_sql, ARRAY_A);
            if (count($query_result) > 0) {
                foreach ($query_result as $single_query_result) {
                    $stat_item_id_a[] = $single_query_result['stat_item_id'];
                }

            }
        }
    }

    //Delete all the stat_item associated with this stat
    if (isset($stat_item_id_a) and count($stat_item_id_a) > 0) {
        foreach ($stat_item_id_a as $stat_item_id) {
            $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
            $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE stat_item_id = %d", $stat_item_id);
            $query_result = $wpdb->query($safe_sql);
        }
    }

    //Delete all the stat_group associated with this stat
    if (isset($stat_group_id_a) and count($stat_group_id_a) > 0) {
        foreach ($stat_group_id_a as $stat_group_id) {
            $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
            $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE stat_group_id = %d", $stat_group_id);
            $query_result = $wpdb->query($safe_sql);
        }
    }

    //Delete all the stat associated with this event
    $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_stat";
    $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE event_id = %d", $delete_id);
    $query_result = $wpdb->query($safe_sql);

    //Delete the associated comments -----------------------------------------------------------------------------------

    //Generate an array with the 'comment_id' of all the comments associated with this event
    global $wpdb;
    $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_comment";
    $safe_sql     = $wpdb->prepare("SELECT comment_id FROM $table_name WHERE event_id = %d", $delete_id);
    $comment_id_a = $wpdb->get_results($safe_sql, ARRAY_A);

    //Delete all the comment_item associated with this event
    if (count($comment_id_a) > 0) {
        foreach ($comment_id_a as $comment_id) {
            $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
            $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE comment_id = %d", $comment_id);
            $query_result = $wpdb->query($safe_sql);
        }
    }

    //Delete all the comment associated with this event
    $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_comment";
    $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE event_id = %d", $delete_id);
    $query_result = $wpdb->query($safe_sql);

    //delete this event ------------------------------------------------------------------------------------------------

    $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_event";
    $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE event_id = %d ", $delete_id);
    $query_result = $wpdb->query($safe_sql);

    if ($query_result !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The event has been successfully deleted.',
                'dale') . '</p></div>';
    }

}

//clone the table
if (isset($_POST['clone_id'])) {

    global $wpdb;
    $clone_id = intval($_POST['clone_id'], 10);

    //clone the event
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_event";
    $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE event_id = $clone_id");
    $wpdb->query("UPDATE tmptable_1 SET event_id = NULL");
    $wpdb->query("UPDATE tmptable_1 SET name = CONCAT(name,' - Copy')");
    $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
    $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");
    $last_inserted_event_id = $wpdb->insert_id;

    //clone all timelines associated with the event
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
    $timeline_a = $wpdb->get_results("SELECT timeline_id FROM $table_name WHERE event_id = $clone_id", ARRAY_A);
    foreach ($timeline_a as $key1 => $single_timeline) {

        //clone the timeline -------------------------------------------------------------------------------------------
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
        $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE timeline_id = " . $single_timeline['timeline_id']);
        $wpdb->query("UPDATE tmptable_1 SET event_id = $last_inserted_event_id");
        $wpdb->query("UPDATE tmptable_1 SET timeline_id = NULL");
        $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
        $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");
        $last_inserted_timeline_id = $wpdb->insert_id;

        //clone the timeline items -------------------------------------------------------------------------------------
        if (intval(get_option($this->shared->get('slug') . '_advanced_clone_timeline_items'), 10)) {

            //get the timeline_item_id of all the items of the timeline
            $table_name      = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
            $timeline_item_a = $wpdb->get_results("SELECT timeline_item_id FROM $table_name WHERE timeline_id = " . $single_timeline['timeline_id'],
                ARRAY_A);
            foreach ($timeline_item_a as $key2 => $single_timeline_item) {

                //clone the timeline item
                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
                $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE timeline_item_id = " . $single_timeline_item['timeline_item_id']);
                $wpdb->query("UPDATE tmptable_1 SET timeline_id = $last_inserted_timeline_id");
                $wpdb->query("UPDATE tmptable_1 SET timeline_item_id = NULL");
                $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
                $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");

            }

        }


    }

    //clone all stats associated with the event ------------------------------------------------------------------------
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat";
    $stat_a     = $wpdb->get_results("SELECT stat_id FROM $table_name WHERE event_id = $clone_id", ARRAY_A);
    foreach ($stat_a as $key1 => $single_stat) {

        //clone the stat -----------------------------------------------------------------------------------------------
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat";
        $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE stat_id = " . $single_stat['stat_id']);
        $wpdb->query("UPDATE tmptable_1 SET event_id = $last_inserted_event_id");
        $wpdb->query("UPDATE tmptable_1 SET stat_id = NULL");
        $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
        $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");
        $last_inserted_stat_id = $wpdb->insert_id;

        //clone the stat groups ----------------------------------------------------------------------------------------
        if (intval(get_option($this->shared->get('slug') . '_advanced_clone_stat_groups'), 10)) {

            //get the stat_group_id of all the groups of the stat
            $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
            $stat_group_a = $wpdb->get_results("SELECT stat_group_id FROM $table_name WHERE stat_id = " . $single_stat['stat_id'],
                ARRAY_A);
            foreach ($stat_group_a as $key2 => $single_stat_group) {

                //clone the stat group
                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
                $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE stat_group_id = " . $single_stat_group['stat_group_id']);
                $wpdb->query("UPDATE tmptable_1 SET stat_id = $last_inserted_stat_id");
                $wpdb->query("UPDATE tmptable_1 SET stat_group_id = NULL");
                $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
                $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");
                $last_inserted_stat_group_id = $wpdb->insert_id;

                //Clone the stat items ---------------------------------------------------------------------------------
                if (intval(get_option($this->shared->get('slug') . '_advanced_clone_stat_items'), 10)) {

                    $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
                    $stat_item_a = $wpdb->get_results("SELECT stat_item_id FROM $table_name WHERE stat_group_id = " . $single_stat_group['stat_group_id'],
                        ARRAY_A);
                    foreach ($stat_item_a as $key3 => $single_stat_item) {

                        //clone the stat item
                        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
                        $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE stat_item_id = " . $single_stat_item['stat_item_id']);
                        $wpdb->query("UPDATE tmptable_1 SET stat_group_id = $last_inserted_stat_group_id");
                        $wpdb->query("UPDATE tmptable_1 SET stat_item_id = NULL");
                        $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
                        $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");

                    }

                }

            }

        }

    }

    //clone all comment associated with the event ----------------------------------------------------------------------
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment";
    $comment_a  = $wpdb->get_results("SELECT comment_id FROM $table_name WHERE event_id = $clone_id", ARRAY_A);
    foreach ($comment_a as $key1 => $single_comment) {

        //clone the comment --------------------------------------------------------------------------------------------
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment";
        $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE comment_id = " . $single_comment['comment_id']);
        $wpdb->query("UPDATE tmptable_1 SET event_id = $last_inserted_event_id");
        $wpdb->query("UPDATE tmptable_1 SET comment_id = NULL");
        $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
        $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");
        $last_inserted_comment_id = $wpdb->insert_id;

        //clone the comment items --------------------------------------------------------------------------------------
        if (intval(get_option($this->shared->get('slug') . '_advanced_clone_comment_items'), 10)) {

            //get the comment_item_id of all the items of the comment
            $table_name     = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
            $comment_item_a = $wpdb->get_results("SELECT comment_item_id FROM $table_name WHERE comment_id = " . $single_comment['comment_id'],
                ARRAY_A);
            foreach ($comment_item_a as $key2 => $single_comment_item) {

                //clone the comment item
                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_comment_item";
                $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE comment_item_id = " . $single_comment_item['comment_item_id']);
                $wpdb->query("UPDATE tmptable_1 SET comment_id = $last_inserted_comment_id");
                $wpdb->query("UPDATE tmptable_1 SET comment_item_id = NULL");
                $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
                $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");

            }

        }

    }

    $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The event has been successfully cloned.',
            'dale') . '</p></div>';

}

//get the event data
if (isset($_GET['edit_id'])) {
    $edit_id = intval($_GET['edit_id'], 10);
    global $wpdb;
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_event";
    $safe_sql   = $wpdb->prepare("SELECT * FROM $table_name WHERE event_id = %d ", $edit_id);
    $event_obj  = $wpdb->get_row($safe_sql);
}

?>

<!-- output -->

<div class="wrap">

    <div id="daext-header-wrapper" class="daext-clearfix">

        <h2><?php esc_attr_e('Live Events - Events', 'dale'); ?></h2>

        <!-- Search Form -->

        <form action="admin.php" method="get" id="daext-search-form">

            <input type="hidden" name="page" value="dale-events">

            <p><?php esc_attr_e('Perform your Search', 'dale'); ?></p>

            <?php
            if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {
                $search_string = $_GET['s'];
            } else {
                $search_string = '';
            }
            ?>

            <input type="text" name="s"
                   value="<?php echo esc_attr(stripslashes($search_string)); ?>" autocomplete="off" maxlength="255">
            <input type="submit" value="">

        </form>

    </div>

    <div id="daext-menu-wrapper">

        <?php if (isset($invalid_data_message)) {
            echo $invalid_data_message;
        } ?>
        <?php if (isset($process_data_message)) {
            echo $process_data_message;
        } ?>

        <!-- table -->

        <?php

        //create the query part used to filter the results when a search is performed
        if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {
            $search_string = $_GET['s'];
            global $wpdb;
            $filter = $wpdb->prepare('WHERE (name LIKE %s OR description LIKE %s)', '%' . $search_string . '%',
                '%' . $search_string . '%');
        } else {
            $filter = '';
        }

        //retrieve the total number of events
        global $wpdb;
        $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_event";
        $total_items = $wpdb->get_var("SELECT COUNT(*) FROM $table_name $filter");

        //Initialize the pagination class
        require_once($this->shared->get('dir') . '/admin/inc/class-dale-pagination.php');
        $pag = new dale_pagination();
        $pag->set_total_items($total_items);//Set the total number of items
        $pag->set_record_per_page(intval(get_option($this->shared->get('slug') . '_advanced_events_menu_pagination'))); //Set records per page
        $pag->set_target_page("admin.php?page=" . $this->shared->get('slug') . "-events");//Set target page
        $pag->set_current_page();//set the current page number from $_GET

        ?>

        <!-- Query the database -->
        <?php
        $query_limit = $pag->query_limit();
        $results     = $wpdb->get_results("SELECT * FROM $table_name $filter ORDER BY event_id DESC $query_limit",
            ARRAY_A); ?>

        <?php if (count($results) > 0) : ?>

            <div class="daext-items-container">

                <!-- list of tables -->
                <table class="daext-items">
                    <thead>
                    <tr>
                        <th><?php esc_attr_e('Name', 'dale'); ?></th>
                        <th><?php esc_attr_e('Description', 'dale'); ?></th>
                        <th><?php esc_attr_e('Live', 'dale'); ?></th>
                        <th><?php esc_attr_e('Shortcode', 'dale'); ?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach ($results as $result) : ?>
                        <tr>
                            <td><?php echo esc_attr(stripslashes($result['name'])); ?></td>
                            <td><?php echo esc_attr(stripslashes($result['description'])); ?></td>
                            <td><?php echo intval($result['live'], 10) === 1 ? esc_attr__('Yes',
                                    'dale') : esc_attr('No', 'dale'); ?></td>
                            <td>[le id="<?php echo $result['event_id']; ?>"]</td>
                            <td class="icons-container">
                                <form method="POST"
                                      action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-events">
                                    <input type="hidden" name="clone_id" value="<?php echo $result['event_id']; ?>">
                                    <input class="menu-icon clone" type="submit" value="">
                                </form>
                                <a class="menu-icon edit"
                                   href="admin.php?page=<?php echo $this->shared->get('slug'); ?>-events&edit_id=<?php echo $result['event_id']; ?>"></a>
                                <form method="POST"
                                      action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-events">
                                    <input type="hidden" value="<?php echo $result['event_id']; ?>" name="delete_id">
                                    <input class="menu-icon delete" type="submit" value="">
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

            <!-- Display the pagination -->
            <?php if ($pag->total_items > 0) : ?>
                <div class="daext-tablenav daext-clearfix">
                    <div class="daext-tablenav-pages">
                        <span class="daext-displaying-num"><?php echo $pag->total_items; ?>&nbsp<?php esc_attr_e('items',
                                'dale'); ?></span>
                        <?php $pag->show(); ?>
                    </div>
                </div>
            <?php endif; ?>

        <?php else : ?>

            <?php

            if (strlen(trim($filter)) > 0) {
                echo '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('There are no results that match your filter.',
                        'dale') . '</p></div>';
            }

            ?>

        <?php endif; ?>

        <form method="POST" action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-events" autocomplete="off">

            <input type="hidden" value="1" name="form_submitted">

            <?php if (isset($_GET['edit_id'])) : ?>

            <!-- Edit an Events -->

            <div class="daext-form-container">

                <h3 class="daext-form-title"><?php esc_attr_e('Edit Event',
                        'dale'); ?>&nbsp<?php echo $event_obj->event_id; ?></h3>

                <table class="daext-form daext-form-table">

                    <input type="hidden" name="update_id" value="<?php echo $event_obj->event_id; ?>"/>

                    <!-- Name -->
                    <tr valign="top">
                        <th scope="row"><label for="name"><?php esc_attr_e('Name', 'dale'); ?></label></th>
                        <td>
                            <input value="<?php echo esc_attr(stripslashes($event_obj->name)); ?>" type="text" id="name"
                                   maxlength="255" size="30" name="name"/>
                            <div class="help-icon" title="<?php esc_attr_e('The name of the event.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Description -->
                    <tr valign="top">
                        <th scope="row"><label for="description"><?php esc_attr_e('Description', 'dale'); ?></label>
                        </th>
                        <td>
                            <input value="<?php echo esc_attr(stripslashes($event_obj->description)); ?>" type="text"
                                   id="description" maxlength="255" size="30" name="description"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The description of the event.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Live -->
                    <tr>
                        <th scope="row"><?php esc_attr_e('Live', 'dale'); ?></th>
                        <td>
                            <select id="live" name="live" class="daext-display-none">
                                <option value="0" <?php selected($event_obj->live, 0); ?>><?php esc_attr_e('No',
                                        'dale'); ?></option>
                                <option value="1" <?php selected($event_obj->live, 1); ?>><?php esc_attr_e('Yes',
                                        'dale'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('Select "Yes" to automatically update the data of the event or "No" to create a static event.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Structured Data Options ------------------------------------------------------------ -->
                    <tr class="group-trigger" data-trigger-target="structured-data-options">
                        <th class="group-title"><?php esc_html_e( 'Structured Data', 'dale'); ?></th>
                        <td>
                            <div class="expand-icon"></div>
                        </td>
                    </tr>

                    <!-- Schema Start Date -->
                    <tr class="structured-data-options">
                        <th scope="row"><label for="index"><?php esc_attr_e('Start Date', 'dale'); ?></label></th>
                        <td>
                            <input value="<?php echo esc_attr(date_format(date_create($event_obj->schema_start_date), 'Y-m-d H:i')); ?>" type="text" id="schema-start-date"
                                   maxlength="255" size="30" name="schema_start_date"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The start date and time of the event.',
                                     'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Schema Timezone -->
                    <tr class="structured-data-options">
                        <th scope="row"><label for="index"><?php esc_attr_e('Timezone', 'dale'); ?></label></th>
                        <td>
                            <select id="schema-timezone" name="schema_timezone" class="daext-display-none">
				                <?php

				                $timezone_offsets = $this->shared->generate_timezone_offsets();
				                foreach($timezone_offsets as $timezone_offset){
					                echo '<option value="' . esc_attr($timezone_offset) . '" ' . selected($event_obj->schema_timezone, $timezone_offset, false) . '>' . esc_html('UTC' . $timezone_offset) . '</option>';
				                }

				                ?>

                            </select>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The timezone of the event.',
				                     'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Schema Location -->
                    <tr class="structured-data-options">
                        <th scope="row"><label for="schema-location"><?php esc_attr_e('Location', 'dale'); ?></label></th>
                        <td>
                            <input value="<?php echo esc_attr(stripslashes($event_obj->schema_location)); ?>" type="text" id="schema-location"
                                   maxlength="255" size="30" name="schema_location"/>
                            <div class="help-icon" title="<?php esc_attr_e('The location of the event.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                </table>

                <!-- submit button -->
                <div class="daext-form-action">
                    <input class="button" type="submit" value="<?php esc_attr_e('Update Event', 'dale'); ?>">
                    <input id="cancel" class="button" type="submit"
                           value="<?php esc_attr_e( 'Cancel', 'dale'); ?>">
                </div>

                <?php else : ?>

                <!-- Create New Event -->

                <div class="daext-form-container">

                    <div class="daext-form-title"><?php esc_attr_e('Create New Event', 'dale'); ?></div>

                    <table class="daext-form daext-form-table">

                        <!-- Name -->
                        <tr valign="top">
                            <th scope="row"><label for="name"><?php esc_attr_e('Name', 'dale'); ?></label></th>
                            <td>
                                <input type="text" id="name" maxlength="255" size="30" name="name" placeho/>
                                <div class="help-icon"
                                     title="<?php esc_attr_e('The name of the event.', 'dale'); ?>"></div>
                            </td>
                        </tr>

                        <!-- Description -->
                        <tr valign="top">
                            <th scope="row"><label for="description"><?php esc_attr_e('Description', 'dale'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="description" maxlength="255" size="30" name="description"/>
                                <div class="help-icon"
                                     title="<?php esc_attr_e('The description of the event.', 'dale'); ?>"></div>
                            </td>
                        </tr>

                        <!-- Live -->
                        <tr>
                            <th scope="row"><?php esc_attr_e('Live', 'dale'); ?></th>
                            <td>
                                <select id="live" name="live" class="daext-display-none">
                                    <option value="0"><?php esc_attr_e('No', 'dale'); ?></option>
                                    <option value="1"><?php esc_attr_e('Yes', 'dale'); ?></option>
                                </select>
                                <div class="help-icon"
                                     title='<?php esc_attr_e('Select "Yes" to automatically update the data of the event or "No" to create a static event.',
                                         'dale'); ?>'></div>
                            </td>
                        </tr>

                        <!-- Structured Data Options ------------------------------------------------------------ -->
                        <tr class="group-trigger" data-trigger-target="structured-data-options">
                            <th class="group-title"><?php esc_html_e( 'Structured Data', 'dale'); ?></th>
                            <td>
                                <div class="expand-icon"></div>
                            </td>
                        </tr>

                        <!-- Schema Start Date -->
                        <tr class="structured-data-options">
                            <th scope="row"><label for="index"><?php esc_attr_e('Start Date', 'dale'); ?></label></th>
                            <td>
                                <input type="text" id="schema-start-date" maxlength="255" size="30" name="schema_start_date"/>
                                <div class="help-icon"
                                     title="<?php esc_attr_e('The start date and time of the event.',
                                         'dale'); ?>"></div>
                            </td>
                        </tr>

                        <!-- Schema Timezone -->
                        <tr class="structured-data-options">
                            <th scope="row"><label for="index"><?php esc_attr_e('Timezone', 'dale'); ?></label></th>
                            <td>
                                <select id="schema-timezone" name="schema_timezone" class="daext-display-none">

                                    <?php

                                    $timezone_offsets = $this->shared->generate_timezone_offsets();
                                    foreach($timezone_offsets as $timezone_offset){
	                                    echo '<option value="' . esc_attr($timezone_offset) . '" ' . selected('+00:00', $timezone_offset, false) . '>' . esc_html('UTC' . $timezone_offset) . '</option>';
                                    }

                                    ?>

                                </select>
                                <div class="help-icon"
                                     title="<?php esc_attr_e('The timezone of the event.',
				                         'dale'); ?>"></div>
                            </td>
                        </tr>

                        <!-- Schema Location -->
                        <tr class="structured-data-options">
                            <th scope="row"><label for="schema-location"><?php esc_attr_e('Location', 'dale'); ?></label></th>
                            <td>
                                <input type="text" id="schema-location" maxlength="255" size="30" name="schema_location" />
                                <div class="help-icon"
                                     title="<?php esc_attr_e('The location of the event.', 'dale'); ?>"></div>
                            </td>
                        </tr>

                    </table>

                    <!-- submit button -->
                    <div class="daext-form-action">
                        <input class="button" type="submit" value="<?php esc_attr_e('Add Event', 'dale'); ?>">
                    </div>

                    <?php endif; ?>

                </div>

        </form>

    </div>

</div>