<?php

if ( ! current_user_can(get_option($this->shared->get('slug') . '_advanced_stat_groups_menu_capability'))) {
    wp_die(esc_attr__('You do not have sufficient permissions to access this page.', 'dale'));
}

?>

<!-- process data -->

<?php

if (isset($_POST['update_id']) or isset($_POST['form_submitted'])) {

    extract($_POST);

    $invalid_data_message = '';

    //prepare data -----------------------------------------------------------------------------------------------------
    if (isset($update_id)) {
        $update_id = intval($update_id, 10);
    }
    $stat_id     = intval($stat_id, 10);
    $name        = trim($name);
    $description = trim($description);
    $label       = trim($label);
    $index       = intval($index, 10);

    //validation -------------------------------------------------------------------------------------------------------

    //validation on "stat_group_id"
    if (isset($update_id)) {
        if ( ! $this->shared->stat_group_exists($update_id)) {
            $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__("The stat group doesn't exist.",
                    'dale') . '</p></div>';
            $invalid_data         = true;
        }
    }

    //verify if the event is live
    if ($this->shared->is_event_live($this->shared->get_event_of_stat($stat_id))) {

        if (isset($update_id)) {
            $process_data_message = '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('To update this stat group you have to first set the "Live" option of the associated event to "No".',
                    'dale') . '</p></div>';
        }else{
            $process_data_message = '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('To create this stat group you have to first set the "Live" option of the associated event to "No".',
                    'dale') . '</p></div>';
        }

        $invalid_data         = true;
    }

    //validation on "stat_id"
    if ( ! $this->shared->stat_exists($stat_id)) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__("The stat doesn't exist.",
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "name"
    if (strlen(trim($name)) === 0 or strlen(trim($name)) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Name" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "description"
    if (strlen(trim($description)) === 0 or strlen(trim($description)) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Description" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "label"
    if (strlen(trim($label)) === 0 or strlen(trim($label)) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Label" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "Index"
    if ($index > 1000000) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a number from 0 to 1000000 in the "Index" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

}

//update ---------------------------------------------------------------
if (isset($_POST['update_id']) and ! isset($invalid_data)) {

    //update the database
    global $wpdb;
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
    $safe_sql   = $wpdb->prepare("UPDATE $table_name SET 
                stat_id = %d,
                name = %s,
                description = %s,
                label = %s,
                `index` = %d
                WHERE stat_group_id = %d",
        $stat_id,
        $name,
        $description,
        $label,
        $index,
        $update_id);

    $query_result = $wpdb->query($safe_sql);

    if ($query_result !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The stat group has been successfully updated.',
                'dale') . '</p></div>';
    }

} else {

    //add ------------------------------------------------------------------
    if (isset($_POST['form_submitted']) and ! isset($invalid_data)) {

        //insert into the database
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
        $safe_sql   = $wpdb->prepare("INSERT INTO $table_name SET 
                stat_id = %d,
                name = %s,
                description = %s,
                label = %s,
                `index` = %d",
            $stat_id,
            $name,
            $description,
            $label,
            $index
        );

        $query_result = $wpdb->query($safe_sql);

        if ($query_result !== false) {
            $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The stat group has been successfully added.',
                    'dale') . '</p></div>';
        }

    }

}

//delete a stat group
if (isset($_POST['delete_id'])) {

    global $wpdb;
    $delete_id = intval($_POST['delete_id'], 10);

//prevent deletion if the event associated with the timeline item is live
if ($this->shared->is_event_live($this->shared->get_event_of_stat($this->shared->get_stat_section($delete_id)))){

    $process_data_message = '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('To delete this stat group you have to first set the "Live" option of the associated event to "No".',
            'dale') . '</p></div>';

}else{

    //delete this stat_group
    $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
    $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE stat_group_id = %d ", $delete_id);
    $query_result = $wpdb->query($safe_sql);

    //delete the stat_item associated with this stat_group
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
    $safe_sql   = $wpdb->prepare("DELETE FROM $table_name WHERE stat_group_id = %d ", $delete_id);
    $wpdb->query($safe_sql);

    if ($query_result !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The stat group has been successfully deleted.',
                'dale') . '</p></div>';
    }

}



}

//get the stat group data
if (isset($_GET['edit_id'])) {
    $edit_id = intval($_GET['edit_id'], 10);
    global $wpdb;
    $table_name     = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
    $safe_sql       = $wpdb->prepare("SELECT * FROM $table_name WHERE stat_group_id = %d ", $edit_id);
    $stat_group_obj = $wpdb->get_row($safe_sql);
}

//Get the value of the custom filter
if (isset($_GET['cf']) and $_GET['cf'] != 'all') {
    $stat_id_in_cf = intval($_GET['cf'], 10);
} else {
    $stat_id_in_cf = false;
}

?>

<!-- output -->

<div class="wrap">

    <div id="daext-header-wrapper" class="daext-clearfix">

        <h2><?php esc_attr_e('Live Events - Stat Groups', 'dale'); ?></h2>

        <!-- Search Form -->

        <form action="admin.php" method="get" id="daext-search-form">

            <input type="hidden" name="page" value="dale-stat-groups">

            <p><?php esc_attr_e('Perform your Search', 'dale'); ?></p>

            <?php

            //Search
            if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {
                $search_string = $_GET['s'];
            } else {
                $search_string = '';
            }

            //Custom Filter
            if ($stat_id_in_cf !== false) {
                echo '<input type="hidden" name="cf" value="' . $stat_id_in_cf . '">';
            }

            ?>
            <input type="text" name="s"
                   value="<?php echo esc_attr(stripslashes($search_string)); ?>" autocomplete="off" maxlength="255">
            <input type="submit" value="">

        </form>

        <!-- Filter Form -->

        <form method="GET" action="admin.php" id="daext-filter-form">

            <input type="hidden" name="page" value="<?php echo $this->shared->get('slug'); ?>-stat-groups">

            <p><?php esc_attr_e('Filter by Stat Section', 'dale'); ?></p>

            <select id="cf" name="cf" class="daext-display-none">

                <option value="all" <?php if (isset($_GET['cf'])) {
                    selected($_GET['cf'], 'all');
                } ?>><?php esc_attr_e('All', 'dale'); ?></option>

                <?php

                global $wpdb;
                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat";
                $safe_sql   = "SELECT stat_id, name FROM $table_name ORDER BY stat_id DESC";
                $stats_a    = $wpdb->get_results($safe_sql, ARRAY_A);

                foreach ($stats_a as $key => $stat) {

                    if (isset($_GET['cf'])) {
                        echo '<option value="' . $stat['stat_id'] . '" ' . selected($_GET['cf'], $stat['stat_id'],
                                false) . '>' . esc_attr(stripslashes($stat['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($stat['stat_id'])))) . '</option>';
                    } else {
                        echo '<option value="' . $stat['stat_id'] . '">' . esc_attr(stripslashes($stat['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($stat['stat_id'])))) . '</option>';

                    }

                }

                ?>

            </select>

        </form>

    </div>

    <div id="daext-menu-wrapper">

        <?php if (isset($invalid_data_message)) {
            echo $invalid_data_message;
        } ?>
        <?php if (isset($process_data_message)) {
            echo $process_data_message;
        } ?>

        <!-- table -->

        <?php

        if ($this->shared->get_number_of_stats() > 0){

        //custom filter
        if ($stat_id_in_cf === false) {
            $filter = '';
        } else {
            global $wpdb;
            $filter = $wpdb->prepare("WHERE stat_id = %d", $stat_id_in_cf);
        }

        //create the query part used to filter the results when a search is performed
        if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {

            $search_string = $_GET['s'];
            global $wpdb;

            if (strlen(trim($filter)) > 0) {
                $filter .= $wpdb->prepare(' AND (name LIKE %s OR description LIKE %s)', '%' . $search_string . '%',
                    '%' . $search_string . '%');
            } else {
                $filter = $wpdb->prepare('WHERE (name LIKE %s OR description LIKE %s)', '%' . $search_string . '%',
                    '%' . $search_string . '%');
            }

        }

        //retrieve the total number of stats
        global $wpdb;
        $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
        $total_items = $wpdb->get_var("SELECT COUNT(*) FROM $table_name $filter");

        //Initialize the pagination class
        require_once($this->shared->get('dir') . '/admin/inc/class-dale-pagination.php');
        $pag = new dale_pagination();
        $pag->set_total_items($total_items);//Set the total number of items
        $pag->set_record_per_page(intval(get_option($this->shared->get('slug') . '_advanced_stat_groups_menu_pagination'))); //Set records per page
        $pag->set_target_page("admin.php?page=" . $this->shared->get('slug') . "-stat-groups");//Set target page
        $pag->set_current_page();//set the current page number from $_GET

        ?>

        <!-- Query the database -->
        <?php
        $query_limit = $pag->query_limit();
        $results     = $wpdb->get_results("SELECT * FROM $table_name $filter ORDER BY stat_group_id DESC $query_limit",
            ARRAY_A); ?>

        <?php if (count($results) > 0) : ?>

            <div class="daext-items-container">

                <!-- list of tables -->
                <table class="daext-items">
                    <thead>
                    <tr>
                        <th><?php esc_attr_e('Name', 'dale'); ?></th>
                        <th><?php esc_attr_e('Description', 'dale'); ?></th>
                        <th><?php esc_attr_e('Stat Section', 'dale'); ?></th>
                        <th><?php esc_attr_e('Event', 'dale'); ?></th>
                        <th><?php esc_attr_e('Index', 'dale'); ?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach ($results as $result) : ?>
                        <tr>
                            <td><?php echo esc_attr(stripslashes($result['name'])); ?></td>
                            <td><?php echo esc_attr(stripslashes($result['description'])); ?></td>
                            <td><?php echo esc_attr(stripslashes($this->shared->get_stat_name($result['stat_id']))); ?></td>
                            <td><?php echo esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($result['stat_id'])))); ?></td>
                            <td><?php echo intval($result['index'], 10); ?></td>
                            <td class="icons-container">

                                <?php

                                //Edit -----------------------------------------------------------------------------
                                if ($stat_id_in_cf === false) {
                                    echo '<a class="menu-icon edit" href="admin.php?page=' . $this->shared->get('slug') . '-stat-groups&edit_id=' . $result['stat_group_id'] . '"></a>';
                                } else {
                                    echo '<a class="menu-icon edit" href="admin.php?page=' . $this->shared->get('slug') . '-stat-groups&edit_id=' . $result['stat_group_id'] . '&cf=' . $stat_id_in_cf . '"></a>';
                                }

                                //Delete ---------------------------------------------------------------------------
                                if ($stat_id_in_cf === false) {

                                    ?>
                                    <form method="POST"
                                          action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-stat-groups">
                                        <input type="hidden" value="<?php echo $result['stat_group_id']; ?>"
                                               name="delete_id">
                                        <input class="menu-icon delete" type="submit" value="">
                                    </form>
                                    <?php

                                } else {

                                    ?>
                                    <form method="POST"
                                          action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-stat-groups&cf=<?php echo $stat_id_in_cf; ?>">
                                        <input type="hidden" value="<?php echo $result['stat_group_id']; ?>"
                                               name="delete_id">
                                        <input class="menu-icon delete" type="submit" value="">
                                    </form>
                                    <?php

                                }

                                ?>

                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

            <!-- Display the pagination -->
            <?php if ($pag->total_items > 0) : ?>
                <div class="daext-tablenav daext-clearfix">
                    <div class="daext-tablenav-pages">
                        <span class="daext-displaying-num"><?php echo $pag->total_items; ?>&nbsp<?php esc_attr_e('items',
                                'dale'); ?></span>
                        <?php $pag->show(); ?>
                    </div>
                </div>
            <?php endif; ?>

        <?php else : ?>

            <?php

            if (strlen(trim($filter)) > 0) {
                echo '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('There are no results that match your filter.',
                        'dale') . '</p></div>';
            }

            ?>

        <?php endif; ?>

        <?php

        if ($stat_id_in_cf === false) {
            echo '<form method="POST" action="admin.php?page=' . $this->shared->get('slug') . '-stat-groups" autocomplete="off">';
        } else {
            echo '<form method="POST" action="admin.php?page=' . $this->shared->get('slug') . '-stat-groups&cf=' . $stat_id_in_cf . '" autocomplete="off">';
        }

        ?>

        <input type="hidden" value="1" name="form_submitted">

        <?php if (isset($_GET['edit_id'])) : ?>

        <!-- Edit an Events -->

        <div class="daext-form-container">

            <h3 class="daext-form-title"><?php esc_attr_e('Edit Stat Group',
                    'dale'); ?>&nbsp<?php echo $stat_group_obj->stat_group_id; ?></h3>

            <table class="daext-form">

                <input type="hidden" name="update_id" value="<?php echo $stat_group_obj->stat_group_id; ?>"/>

                <!-- Stat Section -->
                <tr>
                    <th scope="row"><?php esc_attr_e('Stat Section', 'dale'); ?></th>
                    <td>
                        <select id="stat-id" name="stat_id" class="daext-display-none">
                            <?php

                            global $wpdb;
                            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat";
                            $stats_a    = $wpdb->get_results("SELECT * FROM $table_name ORDER BY stat_id DESC",
                                ARRAY_A);

                            foreach ($stats_a as $single_stat) {
                                echo '<option value="' . $single_stat['stat_id'] . '" ' . selected($single_stat['stat_id'],
                                        $stat_group_obj->stat_id,
                                        false) . '>' . esc_attr(stripslashes($single_stat['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($single_stat['stat_id'])))) . '</option>';
                            }

                            ?>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('The stat section that includes this stat group.',
                                 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Name -->
                <tr valign="top">
                    <th scope="row"><label for="name"><?php esc_attr_e('Name', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(stripslashes($stat_group_obj->name)); ?>" type="text"
                               id="name" maxlength="255" size="30" name="name"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The name of the stat group.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Description -->
                <tr valign="top">
                    <th scope="row"><label for="description"><?php esc_attr_e('Description', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(stripslashes($stat_group_obj->description)); ?>" type="text"
                               id="description" maxlength="255" size="30" name="description"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The description of the stat group.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Label -->
                <tr valign="top">
                    <th scope="row"><label for="label"><?php esc_attr_e('Label', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(stripslashes($stat_group_obj->label)); ?>" type="text"
                               id="description" maxlength="255" size="30" name="label"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The text displayed in the title of the stat group.',
                                 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Index -->
                <tr valign="top">
                    <th scope="row"><label for="index"><?php esc_attr_e('Index', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo intval($stat_group_obj->index, 10); ?>" type="text" id="description"
                               maxlength="255" size="30" name="index"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('With this value you can determine the position of this stat group in the stat section.',
                                 'dale'); ?>"></div>
                    </td>
                </tr>

            </table>

            <!-- submit button -->
            <div class="daext-form-action">
                <input class="button" type="submit" value="<?php esc_attr_e('Update Stat Group', 'dale'); ?>">
                <input id="cancel" class="button" type="submit" value="<?php esc_attr_e( 'Cancel', 'dale'); ?>">
            </div>

            <?php else : ?>

            <!-- Create New Event -->

            <div class="daext-form-container">

                <div class="daext-form-title"><?php esc_attr_e('Create New Stat Group', 'dale'); ?></div>

                <table class="daext-form">

                    <!-- Stat Section -->
                    <tr>
                        <th scope="row"><?php esc_attr_e('Stat Section', 'dale'); ?></th>
                        <td>
                            <select id="stat-id" name="stat_id" class="daext-display-none">
                                <?php

                                global $wpdb;
                                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat";
                                $stats_a    = $wpdb->get_results("SELECT * FROM $table_name ORDER BY stat_id DESC",
                                    ARRAY_A);

                                if ($stat_id_in_cf === false) {

                                    foreach ($stats_a as $single_stat) {
                                        echo '<option value="' . $single_stat['stat_id'] . '">' . esc_attr(stripslashes($single_stat['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($single_stat['stat_id'])))) . '</option>';
                                    }

                                } else {

                                    foreach ($stats_a as $single_stat) {
                                        echo '<option value="' . $single_stat['stat_id'] . '" ' . selected($stat_id_in_cf,
                                                $single_stat['stat_id'],
                                                false) . '>' . esc_attr(stripslashes($single_stat['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($single_stat['stat_id'])))) . '</option>';
                                    }

                                }

                                ?>
                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('The stat section that includes this stat group.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Name -->
                    <tr valign="top">
                        <th scope="row"><label for="name"><?php esc_attr_e('Name', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="name" maxlength="255" size="30" name="name"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The name of the stat group.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Description -->
                    <tr valign="top">
                        <th scope="row"><label for="description"><?php esc_attr_e('Description', 'dale'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="description" maxlength="255" size="30" name="description"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The description of the stat group.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Label -->
                    <tr valign="top">
                        <th scope="row"><label for="label"><?php esc_attr_e('Label', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="description" maxlength="255" size="30" name="label"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The text displayed in the title of the stat group.',
                                     'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Index -->
                    <tr valign="top">
                        <th scope="row"><label for="index"><?php esc_attr_e('Index', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="description" maxlength="255" size="30" name="index" value="0"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('With this value you can determine the position of this stat group in the stat section.',
                                     'dale'); ?>"></div>
                        </td>
                    </tr>

                </table>

                <!-- submit button -->
                <div class="daext-form-action">
                    <input class="button" type="submit" value="<?php esc_attr_e('Add Stat Group', 'dale'); ?>">
                </div>

                <?php endif; ?>

            </div>

            </form>

            <?php

            } else {

                echo '<p>' . esc_attr__('Please add at least one stat section with the ',
                        'dale') . '<a href="' . get_admin_url() . 'admin.php?page=dale-stat-sections">' . esc_attr('Stat Sections',
                        'dale') . '</a> ' . esc_attr__('menu', 'dale') . '.</p>';

            }

            ?>

        </div>

    </div>