<?php

if ( ! current_user_can(get_option($this->shared->get('slug') . '_advanced_stat_items_menu_capability'))) {
    wp_die(esc_attr__('You do not have sufficient permissions to access this page.', 'dale'));
}

?>

<!-- process data -->

<?php

if (isset($_POST['update_id']) or isset($_POST['form_submitted'])) {

    extract($_POST);

    $invalid_data_message = '';
    $process_data_message = '';

    //prepare data -----------------------------------------------------------------------------------------------------
    if (isset($update_id)) {
        $update_id = intval($update_id, 10);
    }
    $stat_group_id = intval($stat_group_id, 10);
    $type          = intval($type, 10);
    $subject       = trim($subject);
    $value_1       = trim($value_1);
    $reference     = trim($reference);
    $percentage    = intval($percentage, 10) === 1 ? 1 : 0;
    $value_2       = trim($value_2);
    $index         = intval($index, 10);

    //validation -------------------------------------------------------------------------------------------------------

    //validation on "stat_item_id"
    if (isset($update_id)) {
        if ( ! $this->shared->stat_item_exists($update_id)) {
            $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__("The stat item doesn't exist.",
                    'dale') . '</p></div>';
            $invalid_data         = true;
        }
    }

    //verify if the event is live
    if (!isset($update_id) and $this->shared->is_event_live($this->shared->get_event_of_stat($this->shared->get_stat_section($stat_group_id)))) {

        $process_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('To create this stat item you have to first set the "Live" option of the associated event to "No".',
                'dale') . '</p></div>';
        $invalid_data         = true;

    }

    //In the case of an update if the stat group has been changed do not allow to select a stat group associated with a live event
    if (isset($update_id)) {

        //read stored stat_group
        $stored_stat_group = $this->shared->get_stat_group_from_stat_item($update_id);

        //verify if there is a difference with the new stat group
        if($stored_stat_group !== $stat_group_id){

            //if the new or the old stat group is associated with a live event generate an error
            if($this->shared->is_event_live($this->shared->get_event_of_stat($this->shared->get_stat_section($stat_group_id))) or $this->shared->is_event_live($this->shared->get_event_of_stat($this->shared->get_stat_section($stored_stat_group)))){

                $process_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('To move this stat item in the selected stat group you have to first set the "Live" option of the associated event to "No".',
                        'dale') . '</p></div>';
                $invalid_data         = true;

            }

        }

    }

    //In case of an update do not allow to change the type of the stat item if the stat item belongs to a live event
    if (isset($update_id)) {

        //read the stored type
        $stat_item_obj = $this->shared->get_stat_item_obj($update_id);
        $stored_type = $stat_item_obj->type;

        //Compare the stored type with the submitted type.
        if(intval($stored_type, 10) !== intval($type, 10)){

            //if the stat item is associated with a live event generate an error message
            if($this->shared->is_event_live($this->shared->get_event_of_stat($this->shared->get_stat_section($stat_group_id)))){

                $process_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('To change the type of this stat item you have to first set the "Live" option of the associated event to "No".',
                        'dale') . '</p></div>';
                $invalid_data         = true;

            }

        }

    }

    //In case of an update do not allow to change the index of the stat item if the stat item belongs to a live event
    if (isset($update_id)) {

        //read the stored index
        $stat_item_obj = $this->shared->get_stat_item_obj($update_id);
        $stored_index = $stat_item_obj->index;

        //Compare the stored index with the submitted index.
        if(intval($stored_index, 10) !== intval($index, 10)){

            //if the stat item is associated with a live event generate an error message
            if($this->shared->is_event_live($this->shared->get_event_of_stat($this->shared->get_stat_section($stat_group_id)))){

                $process_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('To change the index of this stat item you have to first set the "Live" option of the associated event to "No".',
                        'dale') . '</p></div>';
                $invalid_data         = true;

            }

        }

    }

    //validation on "stat_group_id"
    if ( ! $this->shared->stat_group_exists($stat_group_id)) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__("The stat group doesn't exist.",
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "subject"
    if (strlen(trim($subject)) === 0 or strlen(trim($subject)) > 23) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Subject" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "value_1"
    if (intval($value_1, 10) < 0 or intval($value_1, 10) > 999999) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Value 1" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "reference"
    if (intval($reference, 10) < 0 or intval($reference, 10) > 999999) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Reference" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "value_2"
    if (intval($value_2, 10) < 0 or intval($value_2, 10) > 999999) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Value 2" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //Single Visual
    if(intval($type, 10) === 1 and intval($value_1, 10) > intval($reference, 10)){
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('With the "Single Visual" type "Value 1" can\'t be higher than "Reference".',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }


}

//update ---------------------------------------------------------------
if (isset($_POST['update_id']) and ! isset($invalid_data)) {

    //update the database
    global $wpdb;
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
    $safe_sql   = $wpdb->prepare("UPDATE $table_name SET 
                stat_group_id = %d,
                type = %d,
                subject = %s,
                value_1 = %d,
                reference = %d,
                value_2 = %d,
                percentage = %d,
                `index` = %d
                WHERE stat_item_id = %d",
        $stat_group_id,
        $type,
        $subject,
        $value_1,
        $reference,
        $value_2,
        $percentage,
        $index,
        $update_id);

    $query_result = $wpdb->query($safe_sql);

    if ($query_result !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The stat item has been successfully updated.',
                'dale') . '</p></div>';
    }

} else {

    //add ------------------------------------------------------------------
    if (isset($_POST['form_submitted']) and ! isset($invalid_data)) {

        //insert into the database
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
        $safe_sql   = $wpdb->prepare("INSERT INTO $table_name SET 
                stat_group_id = %d,
                type = %d,
                subject = %s,
                value_1 = %d,
                reference = %d,
                value_2 = %d,
                percentage = %d,
                `index` = %d",
            $stat_group_id,
            $type,
            $subject,
            $value_1,
            $reference,
            $value_2,
            $percentage,
            $index
        );

        $query_result = $wpdb->query($safe_sql);

        if ($query_result !== false) {
            $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The stat item has been successfully added.',
                    'dale') . '</p></div>';
        }

    }

}

//delete a stat item
if (isset($_POST['delete_id'])) {

    global $wpdb;
    $delete_id = intval($_POST['delete_id'], 10);

    //prevent deletion if the event associated with the timeline item is live
    if ($this->shared->is_event_live($this->shared->get_event_of_stat($this->shared->get_stat_section($this->shared->get_stat_group_from_stat_item($delete_id))))){

        $process_data_message = '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('To delete this stat item you have to first set the "Live" option of the associated event to "No".',
                'dale') . '</p></div>';

    }else{

        //delete this stat item
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
        $safe_sql   = $wpdb->prepare("DELETE FROM $table_name WHERE stat_item_id = %d ", $delete_id);

        $query_result = $wpdb->query($safe_sql);

        if ($query_result !== false) {
            $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The stat item has been successfully deleted.',
                    'dale') . '</p></div>';
        }

    }

}

//get the stat item data
if (isset($_GET['edit_id'])) {
    $edit_id = intval($_GET['edit_id'], 10);
    global $wpdb;
    $table_name    = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
    $safe_sql      = $wpdb->prepare("SELECT * FROM $table_name WHERE stat_item_id = %d ", $edit_id);
    $stat_item_obj = $wpdb->get_row($safe_sql);
}

//Get the value of the custom filter
if (isset($_GET['cf']) and $_GET['cf'] != 'all') {
    $stat_group_id_in_cf = intval($_GET['cf'], 10);
} else {
    $stat_group_id_in_cf = false;
}

?>

<!-- output -->

<div class="wrap">

    <div id="daext-header-wrapper" class="daext-clearfix">

        <h2><?php esc_attr_e('Live Events - Stat Items', 'dale'); ?></h2>

        <!-- Search Form -->

        <form action="admin.php" method="get" id="daext-search-form">

            <input type="hidden" name="page" value="dale-stat-items">

            <p><?php esc_attr_e('Perform your Search', 'dale'); ?></p>

            <?php

            //Search
            if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {
                $search_string = $_GET['s'];
            } else {
                $search_string = '';
            }

            //Custom Filter
            if ($stat_group_id_in_cf !== false) {
                echo '<input type="hidden" name="cf" value="' . $stat_group_id_in_cf . '">';
            }

            ?>

            <input type="text" name="s"
                   value="<?php echo esc_attr(stripslashes($search_string)); ?>" autocomplete="off" maxlength="255">
            <input type="submit" value="">

        </form>

        <!-- Filter Form -->

        <form method="GET" action="admin.php" id="daext-filter-form">

            <input type="hidden" name="page" value="<?php echo $this->shared->get('slug'); ?>-stat-items">

            <p><?php esc_attr_e('Filter by Stat Group', 'dale'); ?></p>

            <select id="cf" name="cf" class="daext-display-none">

                <option value="all" <?php if (isset($_GET['cf'])) {
                    selected($_GET['cf'], 'all');
                } ?>><?php esc_attr_e('All', 'dale'); ?></option>

                <?php

                global $wpdb;
                $table_name    = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
                $safe_sql      = "SELECT stat_group_id, name, stat_id FROM $table_name ORDER BY stat_group_id DESC";
                $stat_groups_a = $wpdb->get_results($safe_sql, ARRAY_A);

                foreach ($stat_groups_a as $key => $stat_group) {

                    if (isset($_GET['cf'])) {
                        echo '<option value="' . $stat_group['stat_group_id'] . '" ' . selected($_GET['cf'],
                                $stat_group['stat_group_id'],
                                false) . '>' . esc_attr(stripslashes($stat_group['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_stat_name($stat_group['stat_id']))) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($stat_group['stat_id'])))) . '</option>';
                    } else {
                        echo '<option value="' . $stat_group['stat_group_id'] . '">' . esc_attr(stripslashes($stat_group['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_stat_name($stat_group['stat_id']))) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($stat_group['stat_id'])))) . '</option>';
                    }

                }

                ?>

            </select>

        </form>

    </div>

    <div id="daext-menu-wrapper">

        <?php if (isset($invalid_data_message)) {
            echo $invalid_data_message;
        } ?>
        <?php if (isset($process_data_message)) {
            echo $process_data_message;
        } ?>

        <!-- table -->

        <?php

        //Prevent the creation of a stat item if there are no stat groups
        if ($this->shared->get_number_of_stats_groups() > 0){

        //custom filter
        if ($stat_group_id_in_cf === false) {
            $filter = '';
        } else {
            global $wpdb;
            $filter = $wpdb->prepare("WHERE stat_group_id = %d", $stat_group_id_in_cf);
        }

        //create the query part used to filter the results when a search is performed
        if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {

            $search_string = $_GET['s'];
            global $wpdb;

            if (strlen(trim($filter)) > 0) {
                $filter .= $wpdb->prepare(' AND (subject LIKE %s)', '%' . $search_string . '%');
            } else {
                $filter = $wpdb->prepare('WHERE (subject LIKE %s)', '%' . $search_string . '%');
            }

        }

        //retrieve the total number of stats
        global $wpdb;
        $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_stat_item";
        $total_items = $wpdb->get_var("SELECT COUNT(*) FROM $table_name $filter");

        //Initialize the pagination class
        require_once($this->shared->get('dir') . '/admin/inc/class-dale-pagination.php');
        $pag = new dale_pagination();
        $pag->set_total_items($total_items);//Set the total number of items
        $pag->set_record_per_page(intval(get_option($this->shared->get('slug') . '_advanced_stat_items_menu_pagination'))); //Set records per page
        $pag->set_target_page("admin.php?page=" . $this->shared->get('slug') . "-stat-items");//Set target page
        $pag->set_current_page();//set the current page number from $_GET

        ?>

        <!-- Query the database -->
        <?php
        $query_limit = $pag->query_limit();
        $results     = $wpdb->get_results("SELECT * FROM $table_name $filter ORDER BY stat_item_id DESC $query_limit",
            ARRAY_A); ?>

        <?php if (count($results) > 0) : ?>

            <div class="daext-items-container">

                <!-- list of tables -->
                <table class="daext-items">
                    <thead>
                    <tr>
                        <th><?php esc_attr_e('Type', 'dale'); ?></th>
                        <th><?php esc_attr_e('Subject', 'dale'); ?></th>
                        <th><?php esc_attr_e('Stat Group', 'dale'); ?></th>
                        <th><?php esc_attr_e('Stat Section', 'dale'); ?></th>
                        <th><?php esc_attr_e('Event', 'dale'); ?></th>
                        <th><?php esc_attr_e('Index', 'dale'); ?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach ($results as $result) : ?>
                        <tr>
                            <td><?php echo $this->shared->display_stat_type(intval($result['type'], 10)); ?></td>
                            <td><?php echo esc_attr(stripslashes($result['subject'])); ?></td>
                            <td><?php echo esc_attr(stripslashes($this->shared->get_stat_group_name($result['stat_group_id']))); ?></td>
                            <?php $stat_group_obj = $this->shared->get_stat_group_obj($result['stat_group_id']); ?>
                            <td><?php echo esc_attr(stripslashes($this->shared->get_stat_name($stat_group_obj->stat_id))); ?></td>
                            <td><?php echo esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($stat_group_obj->stat_id)))); ?></td>
                            <td><?php echo intval($result['index'], 10); ?></td>
                            <td class="icons-container">

                                <?php

                                //Edit -----------------------------------------------------------------------------
                                if ($stat_group_id_in_cf === false) {
                                    echo '<a class="menu-icon edit" href="admin.php?page=' . $this->shared->get('slug') . '-stat-items&edit_id=' . $result['stat_item_id'] . '"></a>';
                                } else {
                                    echo '<a class="menu-icon edit" href="admin.php?page=' . $this->shared->get('slug') . '-stat-items&edit_id=' . $result['stat_item_id'] . '&cf=' . $stat_group_id_in_cf . '"></a>';
                                }

                                //Delete ---------------------------------------------------------------------------
                                if ($stat_group_id_in_cf === false) {

                                    ?>
                                    <form method="POST"
                                          action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-stat-items">
                                        <input type="hidden" value="<?php echo $result['stat_item_id']; ?>"
                                               name="delete_id">
                                        <input class="menu-icon delete" type="submit" value="">
                                    </form>
                                    <?php

                                } else {

                                    ?>
                                    <form method="POST"
                                          action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-stat-items&cf=<?php echo $stat_group_id_in_cf; ?>">
                                        <input type="hidden" value="<?php echo $result['stat_item_id']; ?>"
                                               name="delete_id">
                                        <input class="menu-icon delete" type="submit" value="">
                                    </form>
                                    <?php

                                }

                                ?>

                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

            <!-- Display the pagination -->
            <?php if ($pag->total_items > 0) : ?>
                <div class="daext-tablenav daext-clearfix">
                    <div class="daext-tablenav-pages">
                        <span class="daext-displaying-num"><?php echo $pag->total_items; ?>&nbsp<?php esc_attr_e('items',
                                'dale'); ?></span>
                        <?php $pag->show(); ?>
                    </div>
                </div>
            <?php endif; ?>

        <?php else : ?>

            <?php

            if (strlen(trim($filter)) > 0) {
                echo '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('There are no results that match your filter.',
                        'dale') . '</p></div>';
            }

            ?>

        <?php endif; ?>

        <?php

        if ($stat_group_id_in_cf === false) {
            echo '<form method="POST" action="admin.php?page=' . $this->shared->get('slug') . '-stat-items" autocomplete="off">';
        } else {
            echo '<form method="POST" action="admin.php?page=' . $this->shared->get('slug') . '-stat-items&cf=' . $stat_group_id_in_cf . '" autocomplete="off">';
        }

        ?>

        <input type="hidden" value="1" name="form_submitted">

        <?php if (isset($_GET['edit_id'])) : ?>

        <!-- Edit a Stat Item -->

        <div class="daext-form-container">

            <h3 class="daext-form-title"><?php esc_attr_e('Edit Stat Item',
                    'dale'); ?>&nbsp<?php echo $stat_item_obj->stat_item_id; ?></h3>

            <table class="daext-form">

                <input type="hidden" name="update_id" value="<?php echo $stat_item_obj->stat_item_id; ?>"/>

                <!-- Stat Group -->
                <tr>
                    <th scope="row"><?php esc_attr_e('Stat Group', 'dale'); ?></th>
                    <td>
                        <select id="stat-group-id" name="stat_group_id" class="daext-display-none">
                            <?php

                            global $wpdb;
                            $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
                            $stat_group_a = $wpdb->get_results("SELECT * FROM $table_name ORDER BY stat_group_id DESC",
                                ARRAY_A);

                            foreach ($stat_group_a as $single_stat_group) {
                                echo '<option value="' . $single_stat_group['stat_group_id'] . '" ' . selected($single_stat_group['stat_group_id'],
                                        $stat_item_obj->stat_group_id,
                                        false) . '">' . esc_attr(stripslashes($single_stat_group['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_stat_name($single_stat_group['stat_id']))) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($single_stat_group['stat_id'])))) . '</option>';
                            }

                            ?>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('The stat group that includes this stat item.', 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Type -->
                <tr>
                    <th scope="row"><?php esc_attr_e('Type', 'dale'); ?></th>
                    <td>
                        <select id="type" name="type" class="daext-display-none">
                            <option value="0" <?php selected($stat_item_obj->type,
                                0); ?>><?php esc_attr_e('Single Data', 'dale'); ?></option>
                            <option value="1" <?php selected($stat_item_obj->type,
                                1); ?>><?php esc_attr_e('Single Visual', 'dale'); ?></option>
                            <option value="2" <?php selected($stat_item_obj->type,
                                2); ?>><?php esc_attr_e('Comparison Data', 'dale'); ?></option>
                            <option value="3" <?php selected($stat_item_obj->type,
                                3); ?>><?php esc_attr_e('Comparison Visual', 'dale'); ?></option>
                        </select>
                        <div class="help-icon" title='<?php esc_attr_e('The type of stat item.', 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Subject -->
                <tr id="subject-tr-container" class="daext-display-none">
                    <th scope="row"><label for="subject"><?php esc_attr_e('Subject', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(stripslashes($stat_item_obj->subject)); ?>" type="text"
                               id="subject" maxlength="23" size="30" name="subject"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The subject of the stat item.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Value 1 -->
                <tr id="value-1-tr-container" class="daext-display-none">
                    <th scope="row"><label for="value-1"><?php esc_attr_e('Value 1', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo intval($stat_item_obj->value_1, 10); ?>" type="text"
                               id="value-1" maxlength="6" size="30" name="value_1"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The value 1 of the stat item.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Reference -->
                <tr valign="top" id="reference-tr-container" class="daext-display-none">
                    <th scope="row"><label for="reference"><?php esc_attr_e('Reference', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo intval($stat_item_obj->reference, 10); ?>" type="text"
                               id="reference" maxlength="6" size="30" name="reference"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The reference of the stat item.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Value 2 -->
                <tr id="value-2-tr-container" class="daext-display-none">
                    <th scope="row"><label for="value-1"><?php esc_attr_e('Value 2', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo intval($stat_item_obj->value_2, 10); ?>" type="text"
                               id="value-2" maxlength="6" size="30" name="value_2"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The value 2 of the stat item.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Percentage -->
                <tr id="percentage-tr-container" class="daext-display-none">
                    <th scope="row"><?php esc_attr_e('Percentage', 'dale'); ?></th>
                    <td>
                        <select id="percentage" name="percentage" class="daext-display-none">
                            <option value="0" <?php selected($stat_item_obj->percentage,
                                0); ?>><?php esc_attr_e('Disabled', 'dale'); ?></option>
                            <option value="1" <?php selected($stat_item_obj->percentage,
                                1); ?>><?php esc_attr_e('Enabled', 'dale'); ?></option>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('Whether to display or not the percentage symbol.',
                                 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Index -->
                <tr valign="top">
                    <th scope="row"><label for="index"><?php esc_attr_e('Index', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo intval($stat_item_obj->index, 10); ?>" type="text" id="index"
                               maxlength="255" size="30" name="index"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('With this value you can determine the position of this stat item in the stat group.',
                                 'dale'); ?>"></div>
                    </td>
                </tr>

            </table>

            <!-- submit button -->
            <div class="daext-form-action">
                <input class="button" type="submit" value="<?php esc_attr_e('Update Stat Item', 'dale'); ?>">
                <input id="cancel" class="button" type="submit" value="<?php esc_attr_e( 'Cancel', 'dale'); ?>">
            </div>

            <?php else : ?>

            <!-- Create New Stat Item -->

            <div class="daext-form-container">

                <div class="daext-form-title"><?php esc_attr_e('Create New Stat Item', 'dale'); ?></div>

                <table class="daext-form">

                    <!-- Stat Group -->
                    <tr>
                        <th scope="row"><?php esc_attr_e('Stat Group', 'dale'); ?></th>
                        <td>
                            <select id="stat-group-id" name="stat_group_id" class="daext-display-none">

                                <?php

                                global $wpdb;
                                $table_name    = $wpdb->prefix . $this->shared->get('slug') . "_stat_group";
                                $stat_groups_a = $wpdb->get_results("SELECT * FROM $table_name ORDER BY stat_group_id DESC",
                                    ARRAY_A);

                                if ($stat_group_id_in_cf === false) {

                                    foreach ($stat_groups_a as $single_stat_group) {
                                        echo '<option value="' . $single_stat_group['stat_group_id'] . '">' . esc_attr(stripslashes($single_stat_group['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_stat_name($single_stat_group['stat_id']))) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($single_stat_group['stat_id'])))) . '</option>';
                                    }

                                } else {

                                    foreach ($stat_groups_a as $single_stat_group) {
                                        echo '<option value="' . $single_stat_group['stat_group_id'] . '" ' . selected($stat_group_id_in_cf,
                                                $single_stat_group['stat_group_id'],
                                                false) . '>' . esc_attr(stripslashes($single_stat_group['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_stat_name($single_stat_group['stat_id']))) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_stat($single_stat_group['stat_id'])))) . '</option>';
                                    }

                                }

                                ?>

                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('The stat group that includes this stat item.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Type -->
                    <tr>
                        <th scope="row"><?php esc_attr_e('Type', 'dale'); ?></th>
                        <td>
                            <select id="type" name="type" class="daext-display-none">
                                <option value="0"><?php esc_attr_e('Single Data', 'dale'); ?></option>
                                <option value="1"><?php esc_attr_e('Single Visual', 'dale'); ?></option>
                                <option value="2"><?php esc_attr_e('Comparison Data', 'dale'); ?></option>
                                <option value="3"><?php esc_attr_e('Comparison Visual', 'dale'); ?></option>
                            </select>
                            <div class="help-icon" title='<?php esc_attr_e('The type of stat item.', 'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Subject -->
                    <tr valign="top" id="subject-tr-container" class="daext-display-none">
                        <th scope="row"><label for="name"><?php esc_attr_e('Subject', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="subject" maxlength="23" size="30" name="subject"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The subject of the stat item.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Value 1 -->
                    <tr valign="top" id="value-1-tr-container" class="daext-display-none">
                        <th scope="row"><label for="value-1"><?php esc_attr_e('Value 1', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="value-1" maxlength="6" size="30" name="value_1" value="0"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The value 1 of the stat item.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Reference -->
                    <tr valign="top" id="reference-tr-container" class="daext-display-none">
                        <th scope="row"><label for="reference"><?php esc_attr_e('Reference', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="reference" maxlength="6" size="30" name="reference" value="100"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The reference of the stat item.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Value 2 -->
                    <tr valign="top" id="value-2-tr-container" class="daext-display-none">
                        <th scope="row"><label for="value-1"><?php esc_attr_e('Value 2', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="value-2" maxlength="6" size="30" name="value_2" value="0"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The value 2 of the stat item.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Percentage -->
                    <tr id="percentage-tr-container" class="daext-display-none">
                        <th scope="row"><?php esc_attr_e('Percentage', 'dale'); ?></th>
                        <td>
                            <select id="percentage" name="percentage" class="daext-display-none">
                                <option value="0"><?php esc_attr_e('Disabled', 'dale'); ?></option>
                                <option value="1"><?php esc_attr_e('Enabled', 'dale'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('Whether to display or not the percentage symbol.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Index -->
                    <tr valign="top">
                        <th scope="row"><label for="index"><?php esc_attr_e('Index', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="index" maxlength="255" size="30" name="index" value="0"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('With this value you can determine the position of this stat item in the stat group.',
                                     'dale'); ?>"></div>
                        </td>
                    </tr>

                </table>

                <!-- submit button -->
                <div class="daext-form-action">
                    <input class="button" type="submit" value="<?php esc_attr_e('Add Stat Item', 'dale'); ?>">
                </div>

                <?php endif; ?>

            </div>

            </form>

            <?php

            } else {

                echo '<p>' . esc_attr__('Please add at least one stat group with the ',
                        'dale') . '<a href="' . get_admin_url() . 'admin.php?page=dale-stat-groups">' . esc_attr('Stats Groups',
                        'dale') . '</a> ' . esc_attr__('menu', 'dale') . '.</p>';

            }

            ?>

        </div>

    </div>