<?php

if ( ! current_user_can(get_option($this->shared->get('slug') . '_advanced_timeline_items_menu_capability'))) {
    wp_die(esc_attr__('You do not have sufficient permissions to access this page.', 'dale'));
}

?>

<!-- process data -->

<?php

if (isset($_POST['update_id']) or isset($_POST['form_submitted'])) {

    extract($_POST);

    //prepare data -----------------------------------------------------------------------------------------------------
    if (isset($update_id)) {
        $update_id = intval($update_id, 10);
    }
    $timeline_id = intval($timeline_id, 10);
    $extra       = intval($extra, 10);
    $title       = trim($title);
    $date        = current_time('mysql', 0);
    $date_gmt    = current_time('mysql', 1);
    $manual_time = trim($manual_time);
    $icon        = intval($icon, 10);
    $content     = trim($content);
    $html        = trim($html);
    $image       = trim($image);
    $tweet_id    = $this->shared->find_tweet_id($tweet_id);

    $invalid_data_message = '';

    //validation on "timeline_item_id"
    if (isset($update_id)) {
        if ( ! $this->shared->timeline_item_exists($update_id)) {
            $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__("The timeline item doesn't exist.",
                    'dale') . '</p></div>';
            $invalid_data         = true;
        }
    }

    //validation on "timeline_id"
    if ( ! $this->shared->timeline_exists($timeline_id)) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__("The timeline doesn't exist.",
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "title"
    if (strlen($title) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid title in the "Title" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "manual_time"
    if ( ((intval($this->shared->get_timeline_time_mode($timeline_id), 10) === 1) and strlen(trim($manual_time)) === 0) or
        strlen($manual_time) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Time" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "icon"
    if ( ! $this->shared->timeline_icon_exists($icon)) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__("The timeline icon doesn't exist.",
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "content"
    if (strlen($content) > 65535) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Content" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "image"
    if (strlen($image) > 2083) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Image" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "tweet_id"
    if (intval($extra, 10) === 2 and $tweet_id === false) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid Tweet ID, Tweet URL or Tweet Embed URL.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "html"
    if (strlen($html) > 65535) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "HTML" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

}

//update ---------------------------------------------------------------
if (isset($_POST['update_id']) and ! isset($invalid_data)) {

    //update the database
    global $wpdb;
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
    $safe_sql   = $wpdb->prepare("UPDATE $table_name SET 
                timeline_id = %d,
                title = %s,
                extra = %d,
                content = %s,
                html = %s,
                image = %s,
                tweet_id = %s,
                manual_time = %s,
                icon = %s
                WHERE timeline_item_id = %d",
        $timeline_id,
        $title,
        $extra,
        $content,
        $html,
        $image,
        $tweet_id,
        $manual_time,
        $icon,
        $update_id);

    $query_result = $wpdb->query($safe_sql);

    if ($query_result !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The timeline item has been successfully updated.',
                'dale') . '</p></div>';
    }

} else {

    //add ------------------------------------------------------------------
    if (isset($_POST['form_submitted']) and ! isset($invalid_data)) {

        //insert into the database
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
        $safe_sql   = $wpdb->prepare("INSERT INTO $table_name SET 
                timeline_id = %d,
                title = %s,
                extra = %d,
                content = %s,
                html = %s,
                image = %s,
                tweet_id = %s,
                date = %s,
                date_gmt = %s,
                manual_time = %s,
                icon = %s",
            $timeline_id,
            $title,
            $extra,
            $content,
            $html,
            $image,
            $tweet_id,
            $date,
            $date_gmt,
            $manual_time,
            $icon
        );

        $query_result = $wpdb->query($safe_sql);

        if ($query_result !== false) {
            $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The timeline item has been successfully added.',
                    'dale') . '</p></div>';
        }

    }

}

//delete a timeline item
if (isset($_POST['delete_id'])) {

    global $wpdb;
    $delete_id = intval($_POST['delete_id'], 10);

    //delete this timeline item
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
    $safe_sql   = $wpdb->prepare("DELETE FROM $table_name WHERE timeline_item_id = %d ", $delete_id);

    $query_result = $wpdb->query($safe_sql);

    if ($query_result !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The timeline item has been successfully deleted.',
                'dale') . '</p></div>';
    }

}

//get the event data
if (isset($_GET['edit_id'])) {
    $edit_id = intval($_GET['edit_id'], 10);
    global $wpdb;
    $table_name        = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
    $safe_sql          = $wpdb->prepare("SELECT * FROM $table_name WHERE timeline_item_id = %d ", $edit_id);
    $timeline_item_obj = $wpdb->get_row($safe_sql);
}

//Get the value of the custom filter
if (isset($_GET['cf']) and $_GET['cf'] != 'all') {
    $timeline_id_in_cf = intval($_GET['cf'], 10);
} else {
    $timeline_id_in_cf = false;
}

?>

<!-- output -->

<div class="wrap">

    <div id="daext-header-wrapper" class="daext-clearfix">

        <h2><?php esc_attr_e('Live Events - Timeline Items', 'dale'); ?></h2>

        <!-- Search Form -->

        <form action="admin.php" method="get" id="daext-search-form">

            <input type="hidden" name="page" value="dale-timeline-items">

            <p><?php esc_attr_e('Perform your Search', 'dale'); ?></p>

            <?php

            //Search
            if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {
                $search_string = $_GET['s'];
            } else {
                $search_string = '';
            }

            //Custom Filter
            if ($timeline_id_in_cf !== false) {
                echo '<input type="hidden" name="cf" value="' . $timeline_id_in_cf . '">';
            }

            ?>

            <input type="text" name="s"
                   value="<?php echo esc_attr(stripslashes($search_string)); ?>" autocomplete="off" maxlength="255">
            <input type="submit" value="">

        </form>

        <!-- Filter Form -->

        <form method="GET" action="admin.php" id="daext-filter-form">

            <input type="hidden" name="page" value="<?php echo $this->shared->get('slug'); ?>-timeline-items">

            <p><?php esc_attr_e('Filter by Timeline Section', 'dale'); ?></p>

            <select id="cf" name="cf" class="daext-display-none">

                <option value="all" <?php if (isset($_GET['cf'])) {
                    selected($_GET['cf'], 'all');
                } ?>><?php esc_attr_e('All', 'dale'); ?></option>

                <?php

                global $wpdb;
                $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
                $safe_sql    = "SELECT timeline_id, name FROM $table_name ORDER BY timeline_id DESC";
                $timelines_a = $wpdb->get_results($safe_sql, ARRAY_A);

                foreach ($timelines_a as $key => $timeline) {

                    if (isset($_GET['cf'])) {
                        echo '<option value="' . $timeline['timeline_id'] . '" ' . selected($_GET['cf'],
                                $timeline['timeline_id'],
                                false) . '>' . esc_attr(stripslashes($timeline['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_timeline($timeline['timeline_id'])))) . '</option>';
                    } else {
                        echo '<option value="' . $timeline['timeline_id'] . '">' . esc_attr(stripslashes($timeline['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_timeline($timeline['timeline_id'])))) . '</option>';

                    }

                }

                ?>

            </select>

        </form>

    </div>

    <div id="daext-menu-wrapper">

        <?php if (isset($invalid_data_message)) {
            echo $invalid_data_message;
        } ?>
        <?php if (isset($process_data_message)) {
            echo $process_data_message;
        } ?>

        <!-- table -->

        <?php

        //Prevent the creation of a timeline if there are no timelines
        if ($this->shared->get_number_of_timelines() > 0){

        //custom filter
        if ($timeline_id_in_cf === false) {
            $filter = '';
        } else {
            global $wpdb;
            $filter = $wpdb->prepare("WHERE timeline_id = %d", $timeline_id_in_cf);
        }

        //create the query part used to filter the results when a search is performed
        if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {

            $search_string = $_GET['s'];
            global $wpdb;

            if (strlen(trim($filter)) > 0) {
                $filter .= $wpdb->prepare(' AND (title LIKE %s)', '%' . $search_string . '%');
            } else {
                $filter = $wpdb->prepare('WHERE (title LIKE %s)', '%' . $search_string . '%');
            }

        }

        //retrieve the total number of timelines items
        global $wpdb;
        $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
        $total_items = $wpdb->get_var("SELECT COUNT(*) FROM $table_name $filter");

        //Initialize the pagination class
        require_once($this->shared->get('dir') . '/admin/inc/class-dale-pagination.php');
        $pag = new dale_pagination();
        $pag->set_total_items($total_items);//Set the total number of items
        $pag->set_record_per_page(intval(get_option($this->shared->get('slug') . '_advanced_timeline_items_menu_pagination'))); //Set records per page
        $pag->set_target_page("admin.php?page=" . $this->shared->get('slug') . "-timeline-items");//Set target page
        $pag->set_current_page();//set the current page number from $_GET

        ?>

        <!-- Query the database -->
        <?php
        $query_limit = $pag->query_limit();
        $results     = $wpdb->get_results("SELECT * FROM $table_name $filter ORDER BY timeline_item_id DESC $query_limit",
            ARRAY_A); ?>

        <?php if (count($results) > 0) : ?>

            <div class="daext-items-container">

                <!-- list of tables -->
                <table class="daext-items">
                    <thead>
                    <tr>
                        <th><?php esc_attr_e('Time', 'dale'); ?></th>
                        <th><?php esc_attr_e('Timeline Section', 'dale'); ?></th>
                        <th><?php esc_attr_e('Event', 'dale'); ?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach ($results as $result) : ?>
                        <tr>
                            <td>
                                <?php
                                if ($this->shared->get_timeline_time_mode($result['timeline_id']) == 0) {
                                    echo mysql2date(get_option('date_format') . ' ' . get_option('time_format'),
                                        $result['date']);
                                } else {
                                    echo esc_attr(stripslashes($result['manual_time']));
                                }
                                ?>
                            </td>
                            <td><?php echo esc_attr(stripslashes($this->shared->get_timeline_name($result['timeline_id']))); ?></td>
                            <td><?php echo esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_timeline($result['timeline_id'])))); ?></td>
                            <td class="icons-container">

                                <?php

                                //Edit -----------------------------------------------------------------------------
                                if ($timeline_id_in_cf === false) {
                                    echo '<a class="menu-icon edit" href="admin.php?page=' . $this->shared->get('slug') . '-timeline-items&edit_id=' . $result['timeline_item_id'] . '"></a>';
                                } else {
                                    echo '<a class="menu-icon edit" href="admin.php?page=' . $this->shared->get('slug') . '-timeline-items&edit_id=' . $result['timeline_item_id'] . '&cf=' . $timeline_id_in_cf . '"></a>';
                                }

                                //Delete ---------------------------------------------------------------------------
                                if ($timeline_id_in_cf === false) {

                                    ?>
                                    <form method="POST"
                                          action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-timeline-items">
                                        <input type="hidden" value="<?php echo $result['timeline_item_id']; ?>"
                                               name="delete_id">
                                        <input class="menu-icon delete" type="submit" value="">
                                    </form>
                                    <?php

                                } else {

                                    ?>
                                    <form method="POST"
                                          action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-timeline-items&cf=<?php echo $timeline_id_in_cf; ?>">
                                        <input type="hidden" value="<?php echo $result['timeline_item_id']; ?>"
                                               name="delete_id">
                                        <input class="menu-icon delete" type="submit" value="">
                                    </form>
                                    <?php

                                }

                                ?>

                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

            <!-- Display the pagination -->
            <?php if ($pag->total_items > 0) : ?>
                <div class="daext-tablenav daext-clearfix">
                    <div class="daext-tablenav-pages">
                        <span class="daext-displaying-num"><?php echo $pag->total_items; ?>&nbsp<?php esc_attr_e('items',
                                'dale'); ?></span>
                        <?php $pag->show(); ?>
                    </div>
                </div>
            <?php endif; ?>

        <?php else : ?>

            <?php

            if (strlen(trim($filter)) > 0) {
                echo '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('There are no results that match your filter.',
                        'dale') . '</p></div>';
            }

            ?>

        <?php endif; ?>

        <?php

        if ($timeline_id_in_cf === false) {
            echo '<form method="POST" action="admin.php?page=' . $this->shared->get('slug') . '-timeline-items" autocomplete="off">';
        } else {
            echo '<form method="POST" action="admin.php?page=' . $this->shared->get('slug') . '-timeline-items&cf=' . $timeline_id_in_cf . '" autocomplete="off">';
        }

        ?>

        <input type="hidden" value="1" name="form_submitted">

        <?php

        $wp_editor_args = [
	        'textarea_name' => 'html',
	        'textarea_rows' => 8,
	        'tinymce'       => array(
		        'toolbar1'      => 'bold,italic,underline,separator,alignleft,aligncenter,alignright,separator,link,unlink,undo,redo',
		        'toolbar2'      => false,
		        'toolbar3'      => false,
		        'content_css' => $this->shared->get('url') . 'admin/assets/css/tinymce-editor-style.css'
	        ),
	        'media_buttons'	   => false,
	        'quicktags' => false,
	        'drag_drop_upload' => false,
        ];

        ?>

        <?php if (isset($_GET['edit_id'])) : ?>

        <!-- Edit an Events -->

        <div class="daext-form-container">

            <h3 class="daext-form-title"><?php esc_attr_e('Edit Timeline',
                    'dale'); ?>&nbsp<?php echo $timeline_item_obj->timeline_item_id; ?></h3>

            <table class="daext-form">

                <input type="hidden" name="update_id" value="<?php echo $timeline_item_obj->timeline_item_id; ?>"/>

                <!-- Event -->
                <tr>
                    <th scope="row"><?php esc_attr_e('Timeline Section', 'dale'); ?></th>
                    <td>
                        <select id="timeline-id" name="timeline_id" class="daext-display-none">
                            <?php

                            global $wpdb;
                            $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
                            $timelines_a = $wpdb->get_results("SELECT * FROM $table_name ORDER BY timeline_id DESC",
                                ARRAY_A);

                            foreach ($timelines_a as $single_timeline) {
                                echo '<option value="' . $single_timeline['timeline_id'] . '" ' . selected($single_timeline['timeline_id'],
                                        $timeline_item_obj->timeline_id,
                                        false) . '>' . esc_attr(stripslashes($single_timeline['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_timeline($single_timeline['timeline_id'])))) . '</option>';
                            }

                            ?>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('The timeline section that includes this timeline item.',
                                 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Extra -->
                <tr>
                    <th scope="row"><?php esc_attr_e('Extra', 'dale'); ?></th>
                    <td>
                        <select id="extra" name="extra" class="daext-display-none">
                            <option value="0" <?php selected($timeline_item_obj->extra, 0); ?>><?php esc_attr_e('None',
                                    'dale'); ?></option>
                            <option value="1" <?php selected($timeline_item_obj->extra, 1); ?>><?php esc_attr_e('Image',
                                    'dale'); ?></option>
                            <option value="2" <?php selected($timeline_item_obj->extra, 2); ?>><?php esc_attr_e('Tweet',
                                    'dale'); ?></option>
                            <option value="3" <?php selected($timeline_item_obj->extra, 3); ?>><?php esc_attr_e('HTML',
                                    'dale'); ?></option>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('The additional element associated with this timeline item.',
                                 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Icon -->
                <tr id="show-icon-container">
                    <th scope="row"><?php esc_attr_e('Icon', 'dale'); ?></th>
                    <td>
                        <select id="icon" name="icon" class="daext-display-none">
                            <option value="0" <?php selected(0, $timeline_item_obj->icon,
                                false); ?>><?php esc_attr_e('Empty', 'dale'); ?></option>
                            <?php

                            global $wpdb;
                            $table_name       = $wpdb->prefix . $this->shared->get('slug') . "_timeline_icon";
                            $timeline_icons_a = $wpdb->get_results("SELECT * FROM $table_name ORDER BY timeline_icon_id DESC",
                                ARRAY_A);

                            foreach ($timeline_icons_a as $single_timeline_icon) {
                                echo '<option value="' . $single_timeline_icon['timeline_icon_id'] . '" ' . selected($single_timeline_icon['timeline_icon_id'],
                                        $timeline_item_obj->icon,
                                        false) . '>' . esc_attr(stripslashes($single_timeline_icon['name'])) . '</option>';
                            }

                            ?>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('The icon associated with this timeline item.', 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Manual Time -->
                <tr valign="top" id="manual-time-container">
                    <th scope="row"><label for="manual-time"><?php esc_attr_e('Time', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(stripslashes($timeline_item_obj->manual_time)); ?>"
                               type="text" id="manual-time" maxlength="255" size="30" name="manual_time"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The time associated with this timeline item.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Title -->
                <tr>
                    <th scope="row"><label for="title"><?php esc_attr_e('Title', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(stripslashes($timeline_item_obj->title)); ?>" type="text"
                               id="title" maxlength="255" size="30" name="title"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The title of the timeline item.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Content -->
                <tr id="content-container" valign="top">
                    <th scope="row"><label for="content"><?php esc_attr_e('Content', 'dale'); ?></label></th>
                    <td>
                        <textarea id="content" name="content"
                                  maxlength="65535"><?php echo esc_attr(stripslashes($timeline_item_obj->content)); ?></textarea>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The content of the timeline item.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- HTML -->
                <tr valign="top" id="html-container" class="daext-display-none">
                    <th scope="row"><label for="html"><?php esc_attr_e('HTML', 'dale'); ?></label></th>
                    <td>

	                    <?php

	                    if(intval(get_option($this->shared->get('slug') . "_advanced_html_editor"), 10) === 1){

                            echo '<div id="tinymce-container">';
		                    wp_editor( stripslashes($timeline_item_obj->html), 'html', $wp_editor_args );
                            echo '</div>';

	                    }else{

		                    echo '<textarea id="html" name="html" maxlength="65535"></textarea>';

	                    }

	                    ?>

                        <div class="help-icon"
                             title="<?php esc_attr_e('The HTML of the timeline item.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Image -->
                <tr valign="top" id="image-container" class="daext-display-none">
                    <th scope="row"><label for="image"><?php esc_attr_e('Image', 'dael'); ?></label></th>
                    <td>

                        <div class="image-uploader">
                            <img class="selected-image"
                                 src="<?php echo esc_attr(stripslashes($timeline_item_obj->image)); ?>" <?php echo strlen(trim($timeline_item_obj->image)) == 0 ? 'style="display: none;"' : ''; ?>>
                            <input value="<?php echo esc_attr(stripslashes($timeline_item_obj->image)); ?>"
                                   type="hidden" id="image" name="image" maxlength="2083">
                            <a class="button_add_media"
                               data-set-remove="<?php echo strlen(trim($timeline_item_obj->image)) == 0 ? 'set' : 'remove'; ?>"
                               data-set="<?php esc_attr_e('Set image', 'dale'); ?>"
                               data-remove="<?php esc_attr_e('Remove Image',
                                   'dale'); ?>"><?php echo strlen(trim($timeline_item_obj->image)) == 0 ? esc_attr__('Set image',
                                    'dale') : esc_attr__('Remove image', 'dale'); ?></a>
                            <p class="description"><?php esc_attr_e("Select an image that represents this timeline item.",
                                    "dale"); ?></p>
                        </div>

                    </td>
                </tr>

                <!-- Tweet ID -->
                <tr id="tweet-id-container" class="daext-display-none">
                    <th scope="row"><label for="tweet-id"><?php esc_attr_e('Tweet', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(stripslashes($timeline_item_obj->tweet_id)); ?>" type="text" id="tweet-id" maxlength="65535" size="30" name="tweet_id"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('Enter the Tweet ID, the Tweet URL, or the Tweet Embed Code.', 'dale'); ?>"></div>
                    </td>
                </tr>

            </table>

            <!-- submit button -->
            <div class="daext-form-action">
                <input class="button" type="submit" value="<?php esc_attr_e('Update Timeline Item', 'dale'); ?>">
                <input id="cancel" class="button" type="submit" value="<?php esc_attr_e( 'Cancel', 'dale'); ?>">
            </div>

            <?php else : ?>

            <!-- Create New Timeline Item -->

            <div class="daext-form-container">

                <div class="daext-form-title"><?php esc_attr_e('Create New Timeline Item', 'dale'); ?></div>

                <table class="daext-form">

                    <!-- Event -->
                    <tr>
                        <th scope="row"><?php esc_attr_e('Timeline Section', 'dale'); ?></th>
                        <td>
                            <select id="timeline-id" name="timeline_id" class="daext-display-none">
                                <?php

                                global $wpdb;
                                $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
                                $timelines_a = $wpdb->get_results("SELECT * FROM $table_name ORDER BY timeline_id DESC",
                                    ARRAY_A);

                                if ($timeline_id_in_cf === false) {

                                    foreach ($timelines_a as $single_timeline) {
                                        echo '<option value="' . $single_timeline['timeline_id'] . '">' . esc_attr(stripslashes($single_timeline['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_timeline($single_timeline['timeline_id'])))) . '</option>';
                                    }

                                } else {

                                    foreach ($timelines_a as $single_timeline) {
                                        echo '<option value="' . $single_timeline['timeline_id'] . '" ' . selected($timeline_id_in_cf,
                                                $single_timeline['timeline_id'],
                                                false) . '>' . esc_attr(stripslashes($single_timeline['name'])) . ' - ' . esc_attr(stripslashes($this->shared->get_event_name($this->shared->get_event_of_timeline($single_timeline['timeline_id'])))) . '</option>';
                                    }

                                }

                                ?>
                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('The timeline section that includes this timeline item.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Extra -->
                    <tr>
                        <th scope="row"><?php esc_attr_e('Extra', 'dale'); ?></th>
                        <td>
                            <select id="extra" name="extra" class="daext-display-none">
                                <option value="0"><?php esc_attr_e('None', 'dale'); ?></option>
                                <option value="1"><?php esc_attr_e('Image', 'dale'); ?></option>
                                <option value="2"><?php esc_attr_e('Tweet', 'dale'); ?></option>
                                <option value="3"><?php esc_attr_e('HTML', 'dale'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('The additional element associated with this timeline item.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Icon -->
                    <tr id="show-icon-container">
                        <th scope="row"><?php esc_attr_e('Icon', 'dale'); ?></th>
                        <td>
                            <select id="icon" name="icon" class="daext-display-none">
                                <option value="0"><?php esc_attr_e('Empty', 'dale'); ?></option>
                                <?php

                                global $wpdb;
                                $table_name       = $wpdb->prefix . $this->shared->get('slug') . "_timeline_icon";
                                $timeline_icons_a = $wpdb->get_results("SELECT * FROM $table_name ORDER BY timeline_icon_id DESC",
                                    ARRAY_A);

                                foreach ($timeline_icons_a as $single_timeline_icon) {
                                    echo '<option value="' . $single_timeline_icon['timeline_icon_id'] . '">' . esc_attr(stripslashes($single_timeline_icon['name'])) . '</option>';
                                }

                                ?>
                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('The icon associated with this timeline item.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Manual Time -->
                    <tr valign="top" id="manual-time-container">
                        <th scope="row"><label for="manual-time"><?php esc_attr_e('Time', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="manual-time" maxlength="255" size="30" name="manual_time"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The time associated with this timeline item.',
                                     'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Title -->
                    <tr>
                        <th scope="row"><label for="title"><?php esc_attr_e('Title', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="title" maxlength="255" size="30" name="title"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The title of the timeline item.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Content -->
                    <tr id="content-container" valign="top">
                        <th scope="row"><label for="content"><?php esc_attr_e('Content', 'dale'); ?></label></th>
                        <td>
                            <textarea id="content" name="content" maxlength="65535"></textarea>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The content of the timeline item.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- HTML -->
                    <tr valign="top" id="html-container" class="daext-display-none">
                        <th scope="row"><label for="html"><?php esc_attr_e('HTML', 'dale'); ?></label></th>
                        <td>
	                        <?php

                            if(intval(get_option($this->shared->get('slug') . "_advanced_html_editor"), 10) === 1){

	                            echo '<div id="tinymce-container">';
	                            wp_editor( '', 'html', $wp_editor_args );
	                            echo '</div>';

                            }else{

                                echo '<textarea id="html" name="html" maxlength="65535"></textarea>';

                            }

	                        ?>

                            <div class="help-icon"
                                 title="<?php esc_attr_e('The HTML of the timeline item.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Image -->
                    <tr valign="top" id="image-container" class="daext-display-none">
                        <th scope="row"><label for="image"><?php esc_attr_e('Image', 'dale'); ?></label></th>
                        <td>
                            <div class="image-uploader">
                                <img class="selected-image" src="" style="display: none">
                                <input type="hidden" id="image" maxlength="2083" name="image">
                                <a class="button_add_media" data-set-remove="set"
                                   data-set="<?php esc_attr_e('Set Image', 'dale'); ?>"
                                   data-remove="<?php esc_attr_e('Remove Image',
                                       'dale'); ?>"><?php esc_attr_e('Set image', 'dale'); ?></a>
                                <p class="description"><?php esc_attr_e("Select an image that represents this timeline item.",
                                        "dale"); ?></p>
                            </div>

                        </td>
                    </tr>

                    <!-- Tweet ID -->
                    <tr id="tweet-id-container" class="daext-display-none">
                        <th scope="row"><label for="tweet-id"><?php esc_attr_e('Tweet', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="tweet-id" maxlength="65535" size="30" name="tweet_id"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('Enter the Tweet ID, the Tweet URL, or the Tweet Embed Code.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                </table>

                <!-- submit button -->
                <div class="daext-form-action">
                    <input class="button" type="submit" value="<?php esc_attr_e('Add Timeline Item', 'dale'); ?>">
                </div>

                <?php endif; ?>

            </div>

            </form>

            <?php

            } else {

                echo '<p>' . esc_attr__('Please add at least one timeline section with the ',
                        'dale') . '<a href="' . get_admin_url() . 'admin.php?page=dale-timeline-sections">' . esc_attr('Timeline Sections',
                        'dale') . '</a> ' . esc_attr__('menu', 'dale') . '.</p>';

            }

            ?>

        </div>

    </div>