<?php

if ( ! current_user_can(get_option($this->shared->get('slug') . '_advanced_timeline_sections_menu_capability'))) {
    wp_die(esc_attr__('You do not have sufficient permissions to access this page.', 'dale'));
}

?>

<!-- process data -->

<?php

if (isset($_POST['update_id']) or isset($_POST['form_submitted'])) {

    extract($_POST);

    $invalid_data_message = '';

    //prepare data -----------------------------------------------------------------------------------------------------
    if (isset($update_id)) {
        $update_id = intval($update_id, 10);
    }
    $event_id    = intval($event_id, 10);
    $name        = trim($name);
    $description = trim($description);
    $time_mode   = intval($time_mode, 10) === 1 ? 1 : 0;
    $show_icon   = intval($show_icon, 10) === 1 ? 1 : 0;
    $structured_data   = intval($structured_data, 10) === 1 ? 1 : 0;
    $schema_coverage_start_time   = trim($schema_coverage_start_time);
    $schema_coverage_end_time   = trim($schema_coverage_end_time);
    $label       = trim($label);
    $index       = intval($index, 10);

    //If the date is invalid set the current date
    if(dateTime::createFromFormat('Y-m-d H:i', $schema_coverage_start_time) === false){
        $schema_coverage_start_time = current_time('mysql', 1);
    }

    //If the date is invalid set the current date
    if(dateTime::createFromFormat('Y-m-d H:i', $schema_coverage_end_time) === false){
        $schema_coverage_end_time = current_time('mysql', 1);
    }
    
    //validation -------------------------------------------------------------------------------------------------------

    //validation on "timeline_id"
    if (isset($update_id)) {
        if ( ! $this->shared->timeline_exists($update_id)) {
            $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__("The timeline doesn't exist.",
                    'dale') . '</p></div>';
            $invalid_data         = true;
        }
    }

    //verify if the event already exists
    if ( ! $this->shared->event_exists($event_id)) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__("The event doesn't exist.",
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //verify if the event is live
    if ($this->shared->is_event_live($event_id)) {

        if (isset($update_id)) {
            $process_data_message = '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('To update this timeline section you have to first set the "Live" option of the associated event to "No".',
                    'dale') . '</p></div>';
        }else{
            $process_data_message = '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('To create this timeline section you have to first set the "Live" option of the associated event to "No".',
                    'dale') . '</p></div>';
        }

        $invalid_data         = true;

    }

    //validation on "name"
    if (strlen(trim($name)) === 0 or strlen(trim($name)) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Name" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "description"
    if (strlen(trim($description)) === 0 or strlen(trim($description)) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Description" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "label"
    if (strlen(trim($label)) === 0 or strlen(trim($label)) > 255) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Label" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    if (isset($update_id) and $this->shared->get_number_of_timeline_items($update_id) > 0 and $time_mode !== intval($this->shared->get_timeline_time_mode($update_id), 10)) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('You can\'t change the "Time Mode" of a Timeline Section that includes Timeline Items.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //validation on "Index"
    if ($index > 1000000) {
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a number from 0 to 1000000 in the "Index" field.',
                'dale') . '</p></div>';
        $invalid_data         = true;
    }

    //Structured data can be enabled only when the "Time Mode" is set to "Auto".
    if($structured_data === 1 and $time_mode === 1){

        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_html__('Structured data can be enabled only when the "Time Mode" is set to "Auto".',
                'dale') . '</p></div>';
        $invalid_data         = true;

    }

    /**
     * Prevent the creation of multiple timeline sections with the structured data enabled associated to the same event.
     */
    if($structured_data === 1){

        global $wpdb;
        $table_name    = $wpdb->prefix . $this->shared->get('slug') . "_timeline";

        if (isset($update_id)) {
            $safe_sql      = $wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE event_id = %d AND timeline_id != %d AND structured_data = 1", $event_id, $update_id);
            $total_items = $wpdb->get_var($safe_sql);
        }else{
            $safe_sql      = $wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE event_id = %d AND structured_data = 1", $event_id);
            $total_items = $wpdb->get_var($safe_sql);
        }

        if($total_items > 0){
            $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_html__("Events can have only one timeline section with structured data enabled.",
                    'dale') . '</p></div>';
            $invalid_data         = true;
        }

    }

}

//update ---------------------------------------------------------------
if (isset($_POST['update_id']) and ! isset($invalid_data)) {

    //update the database
    global $wpdb;
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
    $safe_sql   = $wpdb->prepare("UPDATE $table_name SET 
                event_id = %d,
                name = %s,
                description = %s,
                time_mode = %d,
                show_icon = %d,
                structured_data = %d,
                schema_coverage_start_time = %s,
                schema_coverage_end_time = %s,
                label = %s,
                `index` = %d
                WHERE timeline_id = %d",
        $event_id,
        $name,
        $description,
        $time_mode,
        $show_icon,
        $structured_data,
        $schema_coverage_start_time,
        $schema_coverage_end_time,
        $label,
        $index,
        $update_id);

    $query_result = $wpdb->query($safe_sql);

    if ($query_result !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The timeline section has been successfully updated.',
                'dale') . '</p></div>';
    }

} else {

    //add ------------------------------------------------------------------
    if (isset($_POST['form_submitted']) and ! isset($invalid_data)) {

        //insert into the database
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
        $safe_sql   = $wpdb->prepare("INSERT INTO $table_name SET 
                event_id = %d,
                name = %s,
                description = %s,
                time_mode = %d,
                show_icon = %d,
                structured_data = %d,
                schema_coverage_start_time = %s,
                schema_coverage_end_time = %s,
                label = %s,
                `index` = %d",
            $event_id,
            $name,
            $description,
            $time_mode,
            $show_icon,
            $structured_data,
            $schema_coverage_start_time,
            $schema_coverage_end_time,
            $label,
            $index
        );

        $query_result = $wpdb->query($safe_sql);

        if ($query_result !== false) {
            $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The timeline section has been successfully added.',
                    'dale') . '</p></div>';
        }

    }

}

//delete a timeline
if (isset($_POST['delete_id'])) {

    global $wpdb;
    $delete_id = intval($_POST['delete_id'], 10);

    //prevent deletion if the event associated with the timeline item is live
    if ($this->shared->is_event_live($this->shared->get_event_of_timeline($delete_id))){

        $process_data_message = '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('To delete this timeline section you have to first set the "Live" option of the associated event to "No".',
                'dale') . '</p></div>';

    }else{

        //delete this timeline
        $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
        $safe_sql     = $wpdb->prepare("DELETE FROM $table_name WHERE timeline_id = %d ", $delete_id);
        $query_result = $wpdb->query($safe_sql);

        //delete the timeline_item associated with this timeline
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_timeline_item";
        $safe_sql   = $wpdb->prepare("DELETE FROM $table_name WHERE timeline_id = %d ", $delete_id);
        $wpdb->query($safe_sql);

        if ($query_result !== false) {
            $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The timeline section has been successfully deleted.',
                    'dale') . '</p></div>';
        }

    }

}

//get the event data
if (isset($_GET['edit_id'])) {
    $edit_id = intval($_GET['edit_id'], 10);
    global $wpdb;
    $table_name   = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
    $safe_sql     = $wpdb->prepare("SELECT * FROM $table_name WHERE timeline_id = %d ", $edit_id);
    $timeline_obj = $wpdb->get_row($safe_sql);
}

//Get the value of the custom filter
if (isset($_GET['cf']) and $_GET['cf'] != 'all') {
    $event_id_in_cf = intval($_GET['cf'], 10);
} else {
    $event_id_in_cf = false;
}

?>

<!-- output -->

<div class="wrap">

    <div id="daext-header-wrapper" class="daext-clearfix">

        <h2><?php esc_attr_e('Live Events - Timeline Sections', 'dale'); ?></h2>

        <!-- Search Form -->

        <form action="admin.php" method="get" id="daext-search-form">

            <input type="hidden" name="page" value="dale-timeline-sections">

            <p><?php esc_attr_e('Perform your Search', 'dale'); ?></p>

            <?php
            if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {
                $search_string = $_GET['s'];
            } else {
                $search_string = '';
            }

            //Custom Filter
            if ($event_id_in_cf !== false) {
                echo '<input type="hidden" name="cf" value="' . $event_id_in_cf . '">';
            }

            ?>

            <input type="text" name="s" name="s"
                   value="<?php echo esc_attr(stripslashes($search_string)); ?>" autocomplete="off" maxlength="255">
            <input type="submit" value="">

        </form>

        <!-- Filter Form -->

        <form method="GET" action="admin.php" id="daext-filter-form">

            <input type="hidden" name="page" value="<?php echo $this->shared->get('slug'); ?>-timeline-sections">

            <p><?php esc_attr_e('Filter by Event', 'dale'); ?></p>

            <select id="cf" name="cf" class="daext-display-none">

                <option value="all" <?php if (isset($_GET['cf'])) {
                    selected($_GET['cf'], 'all');
                } ?>><?php esc_attr_e('All', 'dale'); ?></option>

                <?php

                global $wpdb;
                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_event";
                $safe_sql   = "SELECT event_id, name FROM $table_name ORDER BY event_id DESC";
                $events_a   = $wpdb->get_results($safe_sql, ARRAY_A);

                foreach ($events_a as $key => $event) {

                    if (isset($_GET['cf'])) {
                        echo '<option value="' . $event['event_id'] . '" ' . selected($_GET['cf'], $event['event_id'],
                                false) . '>' . esc_attr(stripslashes($event['name'])) . '</option>';
                    } else {
                        echo '<option value="' . $event['event_id'] . '">' . esc_attr(stripslashes($event['name'])) . '</option>';

                    }

                }

                ?>

            </select>

        </form>

    </div>

    <div id="daext-menu-wrapper">

        <?php if (isset($invalid_data_message)) {
            echo $invalid_data_message;
        } ?>
        <?php if (isset($process_data_message)) {
            echo $process_data_message;
        } ?>

        <!-- table -->

        <?php

        //Prevent the creation of a timeline if there are no events
        if ($this->shared->get_number_of_events() > 0){

        //custom filter
        if ($event_id_in_cf === false) {
            $filter = '';
        } else {
            global $wpdb;
            $filter = $wpdb->prepare("WHERE event_id = %d", $event_id_in_cf);
        }

        //create the query part used to filter the results when a search is performed
        if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {

            $search_string = $_GET['s'];
            global $wpdb;

            if (strlen(trim($filter)) > 0) {
                $filter .= $wpdb->prepare(' AND (name LIKE %s OR description LIKE %s)', '%' . $search_string . '%',
                    '%' . $search_string . '%');
            } else {
                $filter = $wpdb->prepare('WHERE (name LIKE %s OR description LIKE %s)', '%' . $search_string . '%',
                    '%' . $search_string . '%');
            }

        }

        //retrieve the total number of timelines
        global $wpdb;
        $table_name  = $wpdb->prefix . $this->shared->get('slug') . "_timeline";
        $total_items = $wpdb->get_var("SELECT COUNT(*) FROM $table_name $filter");

        //Initialize the pagination class
        require_once($this->shared->get('dir') . '/admin/inc/class-dale-pagination.php');
        $pag = new dale_pagination();
        $pag->set_total_items($total_items);//Set the total number of items
        $pag->set_record_per_page(intval(get_option($this->shared->get('slug') . '_advanced_timeline_sections_menu_pagination'))); //Set records per page
        $pag->set_target_page("admin.php?page=" . $this->shared->get('slug') . "-timeline-sections");//Set target page
        $pag->set_current_page();//set the current page number from $_GET

        ?>

        <!-- Query the database -->
        <?php
        $query_limit = $pag->query_limit();
        $results     = $wpdb->get_results("SELECT * FROM $table_name $filter ORDER BY timeline_id DESC $query_limit",
            ARRAY_A); ?>

        <?php if (count($results) > 0) : ?>

            <div class="daext-items-container">

                <!-- list of tables -->
                <table class="daext-items">
                    <thead>
                    <tr>
                        <th><?php esc_attr_e('Name', 'dale'); ?></th>
                        <th><?php esc_attr_e('Description', 'dale'); ?></th>
                        <th><?php esc_attr_e('Event', 'dale'); ?></th>
                        <th><?php esc_attr_e('Index', 'dale'); ?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach ($results as $result) : ?>
                        <tr>
                            <td><?php echo esc_attr(stripslashes($result['name'])); ?></td>
                            <td><?php echo esc_attr(stripslashes($result['description'])); ?></td>
                            <td><?php echo esc_attr(stripslashes($this->shared->get_event_name($result['event_id']))); ?></td>
                            <td><?php echo intval($result['index'], 10); ?></td>
                            <td class="icons-container">

                                <?php

                                //Edit -----------------------------------------------------------------------------
                                if ($event_id_in_cf === false) {
                                    echo '<a class="menu-icon edit" href="admin.php?page=' . $this->shared->get('slug') . '-timeline-sections&edit_id=' . $result['timeline_id'] . '"></a>';
                                } else {
                                    echo '<a class="menu-icon edit" href="admin.php?page=' . $this->shared->get('slug') . '-timeline-sections&edit_id=' . $result['timeline_id'] . '&cf=' . $event_id_in_cf . '"></a>';
                                }

                                //Delete ---------------------------------------------------------------------------
                                if ($event_id_in_cf === false) {

                                    ?>
                                    <form method="POST"
                                          action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-timeline-sections">
                                        <input type="hidden" value="<?php echo $result['timeline_id']; ?>"
                                               name="delete_id">
                                        <input class="menu-icon delete" type="submit" value="">
                                    </form>
                                    <?php

                                } else {

                                    ?>
                                    <form method="POST"
                                          action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-timeline-sections&cf=<?php echo $event_id_in_cf; ?>">
                                        <input type="hidden" value="<?php echo $result['timeline_id']; ?>"
                                               name="delete_id">
                                        <input class="menu-icon delete" type="submit" value="">
                                    </form>
                                    <?php

                                }

                                ?>

                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

            <!-- Display the pagination -->
            <?php if ($pag->total_items > 0) : ?>
                <div class="daext-tablenav daext-clearfix">
                    <div class="daext-tablenav-pages">
                        <span class="daext-displaying-num"><?php echo $pag->total_items; ?>&nbsp<?php esc_attr_e('items',
                                'dale'); ?></span>
                        <?php $pag->show(); ?>
                    </div>
                </div>
            <?php endif; ?>

        <?php else : ?>

            <?php

            if (strlen(trim($filter)) > 0) {
                echo '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('There are no results that match your filter.',
                        'dale') . '</p></div>';
            }

            ?>

        <?php endif; ?>

        <?php

        if ($event_id_in_cf === false) {
            echo '<form method="POST" action="admin.php?page=' . $this->shared->get('slug') . '-timeline-sections" autocomplete="off">';
        } else {
            echo '<form method="POST" action="admin.php?page=' . $this->shared->get('slug') . '-timeline-sections&cf=' . $event_id_in_cf . '" autocomplete="off">';
        }

        ?>

        <input type="hidden" value="1" name="form_submitted">

        <?php if (isset($_GET['edit_id'])) : ?>

        <!-- Edit an Events -->

        <div class="daext-form-container">

            <h3 class="daext-form-title"><?php esc_attr_e('Edit Timeline Section',
                    'dale'); ?>&nbsp<?php echo $timeline_obj->timeline_id; ?></h3>

            <table class="daext-form daext-form-table">

                <input type="hidden" name="update_id" value="<?php echo $timeline_obj->timeline_id; ?>"/>

                <!-- Event -->
                <tr>
                    <th scope="row"><?php esc_attr_e('Event', 'dale'); ?></th>
                    <td>
                        <select id="event-id" name="event_id" class="daext-display-none">
                            <?php

                            global $wpdb;
                            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_event";
                            $events_a   = $wpdb->get_results("SELECT * FROM $table_name ORDER BY event_id DESC",
                                ARRAY_A);

                            foreach ($events_a as $single_event) {
                                echo '<option value="' . $single_event['event_id'] . '" ' . selected($single_event['event_id'],
                                        $timeline_obj->event_id,
                                        false) . '>' . esc_attr(stripslashes($single_event['name'])) . '</option>';
                            }

                            ?>
                        </select>
                        <div class="help-icon" title='<?php esc_attr_e('The event that includes this timeline section.',
                            'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Name -->
                <tr valign="top">
                    <th scope="row"><label for="name"><?php esc_attr_e('Name', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(stripslashes($timeline_obj->name)); ?>" type="text" id="name"
                               maxlength="255" size="30" name="name"/>
                        <div class="help-icon" title="<?php esc_attr_e('The name of the event.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Description -->
                <tr valign="top">
                    <th scope="row"><label for="description"><?php esc_attr_e('Description', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(stripslashes($timeline_obj->description)); ?>" type="text"
                               id="description" maxlength="255" size="30" name="description"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The description of the event.', 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Label -->
                <tr valign="top">
                    <th scope="row"><label for="label"><?php esc_attr_e('Label', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(stripslashes($timeline_obj->label)); ?>" type="text"
                               id="description" maxlength="255" size="30" name="label"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The text displayed in the tab of the timeline section.',
                                 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Show Icon -->
                <tr>
                    <th scope="row"><?php esc_attr_e('Show Icon', 'dale'); ?></th>
                    <td>
                        <select id="show-icon" name="show_icon" class="daext-display-none">
                            <option value="0" <?php selected($timeline_obj->show_icon,
                                0); ?>><?php esc_attr_e('Disabled', 'dale'); ?></option>
                            <option value="1" <?php selected($timeline_obj->show_icon,
                                1); ?>><?php esc_attr_e('Enabled', 'dale'); ?></option>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('Select if this timeline section supports the icons associated with the timeline items.',
                                 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Time Mode -->
                <tr>
                    <th scope="row"><?php esc_attr_e('Time Mode', 'dale'); ?></th>
                    <td>
                        <?php if($this->shared->get_number_of_timeline_items($timeline_obj->timeline_id) > 0){echo '<input name="time_mode" type="hidden" value="' . intval($timeline_obj->time_mode, 10) . '">';} ?>
                        <select id="time-mode" name="time_mode" class="daext-display-none">
                            <option value="0" <?php selected($timeline_obj->time_mode, 0); ?>><?php esc_attr_e('Auto',
                                    'dale'); ?></option>
                            <option value="1" <?php selected($timeline_obj->time_mode, 1); ?>><?php esc_attr_e('Manual',
                                    'dale'); ?></option>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('If "Auto" is selected the time associated with the timeline item will be automatically generated. If "Manual" is selected the time associated with the timeline item should be specified with the "Time" field available on the timeline item.',
                                 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Index -->
                <tr valign="top">
                    <th scope="row"><label for="index"><?php esc_attr_e('Index', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo intval($timeline_obj->index, 10); ?>" type="text" id="description"
                               maxlength="255" size="30" name="index"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('With this value you can determine the position of this timeline section in the tabs of the event.',
                                 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Structured Data Options ------------------------------------------------------------------- -->
                <tr class="group-trigger" data-trigger-target="structured-data-options">
                    <th class="group-title"><?php esc_html_e( 'Structured Data', 'dale'); ?></th>
                    <td>
                        <div class="expand-icon"></div>
                    </td>
                </tr>

                <!-- Structured Data -->
                <tr class="structured-data-options">
                    <th scope="row"><?php esc_attr_e('Status', 'dale'); ?></th>
                    <td>
                        <select id="structured-data" name="structured_data" class="daext-display-none">
                            <option value="0" <?php selected($timeline_obj->structured_data,
                                0); ?>><?php esc_attr_e('Disabled', 'dale'); ?></option>
                            <option value="1" <?php selected($timeline_obj->structured_data,
                                1); ?>><?php esc_attr_e('Enabled', 'dale'); ?></option>
                        </select>
                        <div class="help-icon"
                             title='<?php esc_attr_e('Whether to generate or not the structured data associated with the timeline.',
                                 'dale'); ?>'></div>
                    </td>
                </tr>

                <!-- Coverage Start Time -->
                <tr class="structured-data-options">
                    <th scope="row"><label for="index"><?php esc_attr_e('Coverage Start Time', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(date_format(date_create($timeline_obj->schema_coverage_start_time), 'Y-m-d H:i')); ?>" type="text" id="schema-coverage-start-time"
                               maxlength="255" size="30" name="schema_coverage_start_time"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The time when the live blog will begin covering the event.',
                                 'dale'); ?>"></div>
                    </td>
                </tr>

                <!-- Coverage End Time -->
                <tr class="structured-data-options">
                    <th scope="row"><label for="index"><?php esc_attr_e('Coverage End Time', 'dale'); ?></label></th>
                    <td>
                        <input value="<?php echo esc_attr(date_format(date_create($timeline_obj->schema_coverage_end_time), 'Y-m-d H:i')); ?>" type="text" id="schema-coverage-end-time"
                               maxlength="255" size="30" name="schema_coverage_end_time"/>
                        <div class="help-icon"
                             title="<?php esc_attr_e('The time when the live blog will stop covering the event.',
                                 'dale'); ?>"></div>
                    </td>
                </tr>

            </table>

            <!-- submit button -->
            <div class="daext-form-action">
                <input class="button" type="submit" value="<?php esc_attr_e('Update Timeline Section', 'dale'); ?>">
                <input id="cancel" class="button" type="submit" value="<?php esc_attr_e( 'Cancel', 'dale'); ?>">
            </div>

            <?php else : ?>

            <!-- Create New Timeline -->

            <div class="daext-form-container">

                <div class="daext-form-title"><?php esc_attr_e('Create New Timeline Section', 'dale'); ?></div>

                <table class="daext-form daext-form-table">

                    <!-- Event -->
                    <tr>
                        <th scope="row"><?php esc_attr_e('Event', 'dale'); ?></th>
                        <td>
                            <select id="event-id" name="event_id" class="daext-display-none">

                                <?php

                                global $wpdb;
                                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_event";
                                $events_a   = $wpdb->get_results("SELECT * FROM $table_name ORDER BY event_id DESC",
                                    ARRAY_A);

                                if ($event_id_in_cf === false) {

                                    foreach ($events_a as $single_event) {
                                        echo '<option value="' . $single_event['event_id'] . '">' . esc_attr(stripslashes($single_event['name'])) . '</option>';
                                    }

                                } else {

                                    foreach ($events_a as $single_event) {
                                        echo '<option value="' . $single_event['event_id'] . '" ' . selected($event_id_in_cf,
                                                $single_event['event_id'],
                                                false) . '>' . esc_attr(stripslashes($single_event['name'])) . '</option>';
                                    }

                                }

                                ?>

                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('The event that includes this timeline section.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Name -->
                    <tr valign="top">
                        <th scope="row"><label for="name"><?php esc_attr_e('Name', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="name" maxlength="255" size="30" name="name"/>
                            <div class="help-icon" title="<?php esc_attr_e('The name of the event.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Description -->
                    <tr valign="top">
                        <th scope="row"><label for="description"><?php esc_attr_e('Description', 'dale'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="description" maxlength="255" size="30" name="description"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The description of the event.', 'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Label -->
                    <tr valign="top">
                        <th scope="row"><label for="label"><?php esc_attr_e('Label', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="description" maxlength="255" size="30" name="label"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The text displayed in the tab of the timeline section.',
                                     'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Show Icon -->
                    <tr>
                        <th scope="row"><?php esc_attr_e('Show Icon', 'dale'); ?></th>
                        <td>
                            <select id="show-icon" name="show_icon" class="daext-display-none">
                                <option value="0" selected="selected"><?php esc_attr_e('Disabled', 'dale'); ?></option>
                                <option value="1"><?php esc_attr_e('Enabled', 'dale'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('Select if this timeline section supports the icons associated with the timeline items.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Time Mode -->
                    <tr>
                        <th scope="row"><?php esc_attr_e('Time Mode', 'dale'); ?></th>
                        <td>
                            <select id="time-mode" name="time_mode" class="daext-display-none">
                                <option value="0"><?php esc_attr_e('Auto', 'dale'); ?></option>
                                <option value="1"><?php esc_attr_e('Manual', 'dale'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('If "Auto" is selected the time associated with the timeline item will be automatically generated. If "Manual" is selected the time associated with the timeline item should be specified with the "Time" field available on the timeline item.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Index -->
                    <tr valign="top">
                        <th scope="row"><label for="index"><?php esc_attr_e('Index', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="description" maxlength="255" size="30" name="index" value="0"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('With this value you can determine the position of this timeline section in the tabs of the event.',
                                     'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Structured Data Options ------------------------------------------------------------------- -->
                    <tr class="group-trigger" data-trigger-target="structured-data-options">
                        <th class="group-title"><?php esc_html_e( 'Structured Data', 'dale'); ?></th>
                        <td>
                            <div class="expand-icon"></div>
                        </td>
                    </tr>

                    <!-- Structured Data -->
                    <tr class="structured-data-options">
                        <th scope="row"><?php esc_attr_e('Status', 'dale'); ?></th>
                        <td>
                            <select id="structured-data" name="structured_data" class="daext-display-none">
                                <option value="0" selected="selected"><?php esc_attr_e('Disabled', 'dale'); ?></option>
                                <option value="1"><?php esc_attr_e('Enabled', 'dale'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title='<?php esc_attr_e('Whether to generate or not the structured data associated with the timeline.',
                                     'dale'); ?>'></div>
                        </td>
                    </tr>

                    <!-- Coverage Start Time -->
                    <tr class="structured-data-options">
                        <th scope="row"><label for="index"><?php esc_attr_e('Coverage Start Time', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="schema-coverage-start-time" maxlength="255" size="30" name="schema_coverage_start_time"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The time when the live blog will begin covering the event.',
                                     'dale'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Coverage End Time -->
                    <tr class="structured-data-options">
                        <th scope="row"><label for="index"><?php esc_attr_e('Coverage End Time', 'dale'); ?></label></th>
                        <td>
                            <input type="text" id="schema-coverage-end-time" maxlength="255" size="30" name="schema_coverage_end_time"/>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The time when the live blog will stop covering the event.',
                                     'dale'); ?>"></div>
                        </td>
                    </tr>

                </table>

                <!-- submit button -->
                <div class="daext-form-action">
                    <input class="button" type="submit" value="<?php esc_attr_e('Add Timeline Section', 'dale'); ?>">
                </div>

                <?php endif; ?>

            </div>

            </form>

            <?php

            } else {

                echo '<p>' . esc_attr__('Please add at least one event with the ',
                        'dale') . '<a href="' . get_admin_url() . 'admin.php?page=dale-events">' . esc_attr('Events',
                        'dale') . '</a> ' . esc_attr__('menu', 'dale') . '.</p>';

            }

            ?>

        </div>

    </div>