<?php
/*
Plugin Name: Live Events
Description: Generates events updated in real-time.
Version: 1.34
Author: DAEXT
Author URI: https://daext.com
*/

//Prevent direct access to this file
if ( ! defined('WPINC')) {
    die();
}

//Shared across public and admin
require_once(plugin_dir_path(__FILE__) . 'shared/class-dale-shared.php');

require_once(plugin_dir_path(__FILE__) . 'public/class-dale-public.php');
add_action('plugins_loaded', array('dale_Public', 'get_instance'));

//Perform the Gutenberg related activities only if Gutenberg is present
if ( function_exists( 'register_block_type' ) ) {
	require_once( plugin_dir_path( __FILE__ ) . 'blocks/src/init.php' );
}

//Admin
if (is_admin() && ( ! defined('DOING_AJAX') || ! DOING_AJAX)) {

    //Admin
    require_once(plugin_dir_path(__FILE__) . 'admin/class-dale-admin.php');
    add_action('plugins_loaded', array('dale_Admin', 'get_instance'));

    //Activate
    register_activation_hook(__FILE__, array(dale_Admin::get_instance(), 'ac_activate'));

}

//Ajax
if (defined('DOING_AJAX') && DOING_AJAX) {

    //Admin
    require_once(plugin_dir_path(__FILE__) . 'class-dale-ajax.php');
    add_action('plugins_loaded', array('dale_Ajax', 'get_instance'));

}