(function($) {

  'use strict';

  /**
   * Comment Methods
   */
  window.DALE.comment = {

    process: function(tabIndex, commentData) {

      'use strict';

      var commentCollection,
          listOfCommentItemId = [],
          domCommentItemId,
          commentItemToDelete;

      if (window.DALE.states.initialized === false) {

        //add list item to the timeline tabs list
        $('#dale-tabs-ul').
            append('<li class="dale-tabs-li daext-clearfix-responsive" data-element-id="' + tabIndex +
                '"><div class="dale-tabs-li-inner"><span class="icon-comment"></span>' + window.DALE.utility.escapeHtml(commentData.label) +
                '</div></li>');

        //Add all the elements of the comments
        window.DALE.comment.addCommentsToDOM(tabIndex, commentData);

      } else {

        //add new comments
        $.each(commentData.commentItem, function(index, value) {

          window.DALE.comment.addSingleCommentInDom(tabIndex, value, commentData);

        });

        //remove the comments that exists in the DOM but not in the comment data ---------------------------------------

        listOfCommentItemId = [];
        //1 - get all the IDs in the comment item data
        $.each(commentData.commentItem, function(index, value) {
          listOfCommentItemId.push(parseInt(value.commentItemId, 10));
        });

        //2 - verify if all the IDs in the DOM have a match in the commentData
        commentCollection = $('.dale-body-comment[data-element-id="' + tabIndex + '"] .dale-single-comment-container');
        $(commentCollection).each(function() {
          domCommentItemId = parseInt($(this).attr('data-comment-item-id'), 10);
          //delete the comments that don't have a match
          if ($.inArray(domCommentItemId, listOfCommentItemId) === -1) {
            commentItemToDelete = $('.dale-body-comment[data-element-id="' + tabIndex +
                '"] .dale-single-comment-container[data-comment-item-id="' + domCommentItemId + '"]');
            commentItemToDelete.fadeOut(400, function() {
              commentItemToDelete.remove();
            });
          }
        });

      }

    },

    /**
     *
     * Generates the HTML of a comment.
     *
     * @param commentItem Object with the data of the commentItem
     * @param comment Object with the data of the comment
     * @returns {string}
     */
    generateSingleCommentHtml: function(commentItem, comment) {

      'use strict';

      var html = '',
          commentLeft;

      //Generate the avatar HTML
      if (parseInt(comment.avatar, 10) === 1) {
        commentLeft = '<div class="dale-single-comment-left">' + commentItem.avatar + '</div>';
      } else {
        commentLeft = '';
      }

      //Generate the HTML of the single comment
      html += '<div class="dale-single-comment-container" data-comment-item-id="' + commentItem.commentItemId +
          '" data-hash="' + commentItem.hash + '">' +
          commentLeft +
          '<div class="dale-single-comment-right">' +
          '<div class="dale-single-comment-header">' +
          '<div class="dale-single-comment-user">' + window.DALE.utility.escapeHtml(commentItem.displayName) + '</div>' +
          '<div class="dale-single-comment-date">&nbsp- ' + window.DALE.utility.escapeHtml(commentItem.formattedDate) + '</div>' +
          '</div>' +
          '<div class="dale-single-comment-content">' + window.DALE.utility.escapeHtml(commentItem.content) + '</div>' +
          '</div>' +
          '</div>';

      return html;

    },

    /**
     * When the AJAX request used to submit a comment has been completed the comment is added to the DOM in the correct
     * position and the associated event listeners are added.
     *
     * @param response The json string with the data of the commentItem just submitted
     * @param commentId The id of the comment
     * @param commentData The data of the comment
     * @param commentItemId
     * @param tabIndex The id of the comment tab
     */
    handleResponseAfterCommentSubmit: function(response, commentId, commentData, commentItemId, tabIndex) {

      'use strict';

      //Init
      var message;

      //If a message exists remove it
      $('.dale-body-comment[data-element-id="' + tabIndex + '"] .dale-comment-temporary-message').remove();

      if (response == 'Under Moderation') {

        //Add the "Message under moderation" message
        message = $.parseHTML(
            '<div class="dale-comment-temporary-message">' +
            window.DALE.utility.escapeHtml(window.DALE_PHPDATA.commentMessageUnderModerationText) + '</div>');
        $('.dale-body-comment[data-element-id="' + tabIndex + '"] > .dale-new-comment-container').after(message);
        setTimeout(function() {
          $(message).remove();
        }, 4000);

      }else if(response == 'Too many comments'){

        //Add the "You have submitted too many comments" message
        message = $.parseHTML(
            '<div class="dale-comment-temporary-message">' +
            window.DALE.utility.escapeHtml(window.DALE_PHPDATA.commentCommentLimitText) + '</div>');
        $('.dale-body-comment[data-element-id="' + tabIndex + '"] > .dale-new-comment-container').after(message);
        setTimeout(function() {
          $(message).remove();
        }, 4000);

      }

      //clear the textarea
      $('.dale-new-comment-content').val('');

    },

    /**
     * Add the comments to the DOM and all the related event listeners
     *
     * @param commentData The data of the comments
     */
    addCommentsToDOM: function(tabIndex, commentData) {

      'use strict';

      var html = '';
      var numberOfComments;
      var commentString;

      //create comment ------------------------------------------------------------------------------------------------

      //add header
      numberOfComments = window.DALE.comment.getNumberOfComments(commentData.commentItem);
      if (parseInt(numberOfComments, 10) === 1) {
        commentString = window.DALE.utility.escapeHtml(window.DALE_PHPDATA.commentNumberOfCommentsSingleText);
      } else {
        commentString = window.DALE.utility.escapeHtml(window.DALE_PHPDATA.commentNumberOfCommentsMultipleText);
      }
      html += '<div class="dale-comment-header">' + numberOfComments + ' ' + commentString + '</div>';

      //add form to submit a new comment (textarea and button) if the comments are not closed
      if (parseInt(commentData.closed, 10) === 0) {
        html += '<div class="dale-new-comment-container">' +
            '<textarea data-comment-id="' + commentData.commentId + '" class="dale-new-comment-content" maxlength="65535"></textarea>' +
            '<div data-comment-id="' + commentData.commentId + '" class="dale-new-comment-submit" ' +
            'data-user-comment-like="' + +window.DALE.params.userComment + '">';

        if (window.DALE.params.userComment) {
          html += window.DALE.utility.escapeHtml(window.DALE_PHPDATA.commentSubmitCommentText);
        } else {
          html += window.DALE.utility.escapeHtml(window.DALE_PHPDATA.commentSignInText);
        }

        html += '</div>' +
            '</div>';
      }

      //iterate over the first level comments
      var commentItem = commentData.commentItem;
      var firstLevelComments = [];

      if (commentItem !== null) {

        //remove the nested comments
        for (var i = 0; i < commentItem.length; i++) {
          firstLevelComments.push(commentItem[i]);
        }
        firstLevelComments.sort(window.DALE.comment.compare);//sort by commentItemId

        //iterate over the first level comments
        $.each(firstLevelComments, function(index1, value1) {

          html += window.DALE.comment.generateSingleCommentHtml(value1, commentData);

        });

      }

      //add the comment to the body
      html = '<div class="dale-body-comment dale-body-element" data-element-id="' + tabIndex + '">' + html + '</div>';
      $('#dale-body').append(html);

      //bind click event listener on new comment form
      $('.dale-body-comment[data-element-id="' + tabIndex + '"] .dale-new-comment-submit').click(function() {

        //Redirect to the login page if the user is not enabled
        if (parseInt($(this).attr('data-user-comment-like'), 10) === 0) {
          window.location = window.DALE_PHPDATA.advancedSignInUrl;
          return;
        }

        var commentId = parseInt($(this).attr('data-comment-id'), 10);
        var content = $(
            '.dale-new-comment-content[data-comment-id="' + commentId + '"]').
            val();

        if (content.trim().length === 0) {

          //If a message exists remove it
          $('.dale-body-comment[data-element-id="' + tabIndex + '"] .dale-comment-temporary-message').remove();

          //Add the "Empty comments are not allowed" message
          var message = $.parseHTML(
              '<div class="dale-comment-temporary-message">' +
              window.DALE.utility.escapeHtml(window.DALE_PHPDATA.commentEmptyCommentText) + '</div>');
          $('.dale-body-comment[data-element-id="' + tabIndex + '"] > .dale-new-comment-container').after(message);
          setTimeout(function() {
            $(message).remove();
          }, 4000);

          return;

        }

        //prepare ajax request
        var data = {
          'action': 'dale_comment_submit',
          'security': window.DALE_PHPDATA.nonce,
          'comment_id': commentId,
          'comment_item_id': 0,
          'content': content,
        };

        //send ajax request
        $.post(window.DALE_PHPDATA.ajaxUrl, data, function(result) {

          window.DALE.comment.handleResponseAfterCommentSubmit(result, commentId, commentData, 0, tabIndex);

        });

      });

    },

    addSingleCommentInDom: function(tabIndex, commentItemData, commentData) {

      'use strict';

      var commentHtml,
          currentElement,
          nextElement,
          currentCommentItemId,
          nextCommentItemId,
          commentContainer,
          commentItem,
          avatarHtml;

      //if the comment doesn't exists in the DOM add in the correct position
      if ($('.dale-body-comment[data-element-id="' + tabIndex + '"] ' +
              '.dale-single-comment-container[data-comment-item-id="' + commentItemData.commentItemId +
              '"]').length === 0) {

        //add the comment in the correct position ------------------------------------------------------------------

        var collection = $('.dale-body-comment[data-element-id="' + tabIndex + '"] .dale-single-comment-container');
        commentHtml = window.DALE.comment.generateSingleCommentHtml(commentItemData, commentData);

        if (collection.length > 0) {

          //At least one comment is available in the DOM

          //DOM looping
          $(collection).each(function() {

            currentElement = $(this);
            nextElement = $(this).next();

            //previous_commentItemId = $(this).prev().attr('data-comment-item-id');
            currentCommentItemId = parseInt(currentElement.attr('data-comment-item-id'), 10);
            if (nextElement.length > 0) {
              nextCommentItemId = parseInt(nextElement.attr('data-comment-item-id'), 10);
            } else {
              nextCommentItemId = null;
            }

            if (commentItemData.commentItemId > currentCommentItemId) {

              //add it before the current element
              commentHtml = $.parseHTML(commentHtml);
              $(commentHtml).css('display', 'none');
              currentElement.before(commentHtml);
              $(commentHtml).fadeIn('400');
              return false;

            } else if (commentItemData.commentItemId < currentCommentItemId &&
                (commentItemData.commentItemId > nextCommentItemId || nextCommentItemId === null)) {

              //add it after the current element
              commentHtml = $.parseHTML(commentHtml);
              $(commentHtml).css('display', 'none');
              currentElement.after(commentHtml);
              $(commentHtml).fadeIn('400');
              return false;

            }

          });

        } else {

          //No comments are available in the DOM

          //1 - simple add the comments in the DOM in the correct order
          commentHtml = window.DALE.comment.generateSingleCommentHtml(commentItemData, commentData);
          commentContainer = $('.dale-body-comment[data-element-id="' + tabIndex + '"]');
          commentHtml = $.parseHTML(commentHtml);
          $(commentHtml).css('display', 'none');
          commentContainer.append(commentHtml);
          $(commentHtml).fadeIn('400');

        }

      } else {

        //if the comment exists update the comment

        //update existing comments by using the hash to verify if it's modified ----------------------------------

        commentItem = $('.dale-body-comment[data-element-id="' + tabIndex +
            '"] .dale-single-comment-container[data-comment-item-id="' + commentItemData.commentItemId + '"]');

        //1 - find the comment in the DOM with a selector
        if (commentItem.length > 0) {

          //2 - verify if the comment is changed with the hash
          if (commentItem.attr('data-hash') !== commentItemData.hash) {

            //fadeOut
            commentItem.fadeOut(400, function() {

              //update the html of the comment item

              //Generate the avatar HTML
              if (parseInt(commentItemData.avatar.length, 10) > 9) {
                avatarHtml = commentItemData.avatar;
              } else {
                avatarHtml = '';
              }

              $(this).attr('data-hash', commentItemData.hash);
              if (parseInt(commentData.avatar, 10) === 1) {
                $(this).find('.dale-single-comment-left').html(avatarHtml);
              }
              $(this).find('.dale-single-comment-user').html(window.DALE.utility.escapeHtml(commentItemData.displayName));
              $(this).find('.dale-single-comment-date').html('&nbsp- ' + window.DALE.utility.escapeHtml(commentItemData.formattedDate));
              $(this).find('.dale-single-comment-content').html(window.DALE.utility.escapeHtml(commentItemData.content));

              $(this).fadeIn(400);

            });

          }

        }

      }

    },

    /**
     * Returns the number of approved comments.
     *
     * @param commentItem An array with the comments
     * @returns The number of approved comments
     */
    getNumberOfComments: function(commentItem) {

      'use strict';

      var counter = 0;

      $.each(commentItem, function(index, value) {
        if (parseInt(value.approved, 10) === 1) {
          counter = counter + 1;
        }
      });

      return counter;

    },

    /**
     * Function used to define the order of the sort() method.
     *
     * In this case the commentItemId value is used to perform the comparison between the comments.
     *
     * @param a
     * @param b
     * @returns {number}
     */
    compare: function(a, b) {

      'use strict';

      if (a.commentItemId < b.commentItemId)
        return 1;
      if (a.commentItemId > b.commentItemId)
        return -1;
      return 0;

    },

  };

})(window.jQuery);