/**
 * DeBlocker
 * Most effective way to detect ad blockers. Ask the visitors to disable their ad blockers.
 * Exclusively on https://1.envato.market/deblocker
 *
 * @encoding        UTF-8
 * @version         3.3.9
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Nemirovskiy Vitaliy (nemirovskiyvitaliy@gmail.com), Alexander Khmelnitskiy (info@alexander.khmelnitskiy.ua), Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

"use strict";

document.readyState === 'loading' ?
    document.addEventListener( 'DOMContentLoaded', mdpRunThePlugin ) :
    mdpRunThePlugin();

/**
 * Run the plugin.
 */
function mdpRunThePlugin() {

    function makeId(length) {
        let result = '';
        const characters = 'abcdefghijklmnopqrstuvwxyz';
        const charactersLength = characters.length;
        for ( let i = 0; i < length; i++ ) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }
        return result;
    }

    let e = document.createElement( 'div' );
    e.id = window.mdpAdsId[ 0 ] ?? 'mdp-deblocker-ads';
    e.style.display = 'none';
    document.body.appendChild( e );

    function debListener () {
        const isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
        if ( ! isFirefox && this.statusText === 'OK' ) {
            e.remove();
        }
    }

    const request = new XMLHttpRequest();
    request.open( 'GET', 'https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js', true );
    request.addEventListener("load", debListener );
    request.send();

}
