<?php
/**
 * DeBlocker
 * Most effective way to detect ad blockers. Ask the visitors to disable their ad blockers.
 * Exclusively on https://1.envato.market/deblocker
 *
 * @encoding        UTF-8
 * @version         3.3.9
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Nemirovskiy Vitaliy (nemirovskiyvitaliy@gmail.com), Alexander Khmelnitskiy (info@alexander.khmelnitskiy.ua), Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 * @license         Envato License https://1.envato.market/KYbje
 **/

namespace Merkulove\Deblocker;

use Merkulove\Deblocker\Unity\Plugin;
use Merkulove\Deblocker\Unity\Settings;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

final class Bricks {

	public static function get_instance() {
		static $instance = null;
		if ( null === $instance ) {
			$instance = new self();
		}
		return $instance;
	}

	/**
	 * Basic CSS for all styles.
	 * @param $prefix
	 *
	 * @return string
	 */
	public static function basic_css( $prefix ): string {

		$options = Settings::get_instance()->options;

		$align              = $options['align'];
		$cross_delay 	    = $options['cross_delay'] ?? 0;
		$close_color        = $options['close_color'];
		$percent = '%';

		$css = wp_sprintf(
			'
            .%1$s-style-compact .%1$s-blackout,
            .%1$s-style-compact-right-top .%1$s-blackout,
            .%1$s-style-compact-left-top .%1$s-blackout,
            .%1$s-style-compact-right-bottom .%1$s-blackout,
            .%1$s-style-compact-left-bottom .%1$s-blackout,
            .%1$s-style-compact .%1$s-blackout {
                position: fixed;
                z-index: 9997;
                left: 0;
                top: 0;
                width: 100%5$s;
                height: 100%5$s;
                display: none;
            }

            .%1$s-style-compact .%1$s-blackout.active,
            .%1$s-style-compact-right-top .%1$s-blackout.active,
            .%1$s-style-compact-left-top .%1$s-blackout.active,
            .%1$s-style-compact-right-bottom .%1$s-blackout.active,
            .%1$s-style-compact-left-bottom .%1$s-blackout.active,
            .%1$s-style-compact .%1$s-blackout.active {
                display: block;
                -webkit-animation: %1$s-appear;
                animation: %1$s-appear;
                -webkit-animation-duration: .2s;
                animation-duration: .2s;
                -webkit-animation-fill-mode: both;
                animation-fill-mode: both;
            }

            .%1$s-style-compact .%1$s-wrapper,
            .%1$s-style-compact-right-top .%1$s-wrapper,
            .%1$s-style-compact-left-top .%1$s-wrapper,
            .%1$s-style-compact-right-bottom .%1$s-wrapper,
            .%1$s-style-compact-left-bottom .%1$s-wrapper,
            .%1$s-style-compact .%1$s-wrapper {
                display: flex;
                justify-content: center;
                align-items: center;
                position: fixed;
                top: 0;
                left: 0;
                width: 100%5$s;
                height: 100%5$s;
                z-index: 9998;
            }

            .%1$s-style-compact .%1$s-modal,
            .%1$s-style-compact-right-top .%1$s-modal,
            .%1$s-style-compact-left-top .%1$s-modal,
            .%1$s-style-compact-right-bottom .%1$s-modal,
            .%1$s-style-compact-left-bottom .%1$s-modal,
            .%1$s-style-compact .%1$s-modal {
                height: auto;
                width: auto;
                position: relative;
                max-width: 40%5$s;
                padding: 4rem;
                opacity: 0;
                z-index: 9999;
                transition: all 0.5s ease-in-out;
                border-radius: 1rem;
                margin: 1rem;
                text-align: %2$s;
            }

            .%1$s-style-compact .%1$s-modal.active,
            .%1$s-style-compact-right-top .%1$s-modal.active,
            .%1$s-style-compact-left-top .%1$s-modal.active,
            .%1$s-style-compact-right-bottom .%1$s-modal.active,
            .%1$s-style-compact-left-bottom .%1$s-modal.active,
            .%1$s-style-compact .%1$s-modal.active {
                opacity: 1;
                -webkit-animation: %1$s-appear;
                animation: %1$s-appear;
                -webkit-animation-delay: .1s;
                animation-delay: .1s;
                -webkit-animation-duration: .5s;
                animation-duration: .5s;
                -webkit-animation-fill-mode: both;
                animation-fill-mode: both;
            }

            .%1$s-style-compact .%1$s-modal h4,
            .%1$s-style-compact-right-top .%1$s-modal h4,
            .%1$s-style-compact-left-top .%1$s-modal h4,
            .%1$s-style-compact-right-bottom .%1$s-modal h4,
            .%1$s-style-compact-left-bottom .%1$s-modal h4,
            .%1$s-style-compact .%1$s-modal h4 {
                margin: 0 0 1rem 0;
                padding-right: .8rem;
            }

            .%1$s-style-compact .%1$s-modal p,
            .%1$s-style-compact-right-top .%1$s-modal p,
            .%1$s-style-compact-left-top .%1$s-modal p,
            .%1$s-style-compact-right-bottom .%1$s-modal p,
            .%1$s-style-compact-left-bottom .%1$s-modal p,
            .%1$s-style-compact .%1$s-modal p {
                margin: 0;
            }

            @media only screen and (max-width: 1140px) {
                .%1$s-style-compact .%1$s-modal,
                .%1$s-style-compact-right-top .%1$s-modal,
                .%1$s-style-compact-left-top .%1$s-modal,
                .%1$s-style-compact-right-bottom .%1$s-modal,
                .%1$s-style-compact-left-bottom .%1$s-modal,
                .%1$s-style-compact .%1$s-modal {
                    min-width: 60%5$s;
                }
            }

            @media only screen and (max-width: 768px) {
                .%1$s-style-compact .%1$s-modal,
                .%1$s-style-compact-right-top .%1$s-modal,
                .%1$s-style-compact-left-top .%1$s-modal,
                .%1$s-style-compact-right-bottom .%1$s-modal,
                .%1$s-style-compact-left-bottom .%1$s-modal,
                .%1$s-style-compact .%1$s-modal {
                    min-width: 80%5$s;
                }
            }

            @media only screen and (max-width: 420px) {
                .%1$s-style-compact .%1$s-modal,
                .%1$s-style-compact-right-top .%1$s-modal,
                .%1$s-style-compact-left-top .%1$s-modal,
                .%1$s-style-compact-right-bottom .%1$s-modal,
                .%1$s-style-compact-left-bottom .%1$s-modal,
                .%1$s-style-compact .%1$s-modal {
                    min-width: 90%5$s;
                }
            }

            .%1$s-style-compact .%1$s-close,
            .%1$s-style-compact-right-top .%1$s-close,
            .%1$s-style-compact-left-top .%1$s-close,
            .%1$s-style-compact-right-bottom .%1$s-close,
            .%1$s-style-compact-left-bottom .%1$s-close,
            .%1$s-style-compact .%1$s-close {
                position: absolute;
                right: 1rem;
                top: 1rem;
                display: inline-block;
                cursor: pointer;
                opacity: .5;
                width: 32px;
                height: 32px;
                -webkit-animation: %1$s-close-appear;
                animation: %1$s-close-appear;
                -webkit-animation-delay: %4$sms;
                animation-delay: %4$sms;
                -webkit-animation-duration: .4s;
                animation-duration: .4s;
                -webkit-animation-fill-mode: both;
                animation-fill-mode: both;
            }

            .%1$s-style-compact .%1$s-close:hover,
            .%1$s-style-compact-right-top .%1$s-close:hover,
            .%1$s-style-compact-left-top .%1$s-close:hover,
            .%1$s-style-compact-right-bottom .%1$s-close:hover,
            .%1$s-style-compact-left-bottom .%1$s-close:hover,
            .%1$s-style-compact .%1$s-close:hover {
                opacity: 1;
            }

            .%1$s-style-compact .%1$s-close:before,
            .%1$s-style-compact .%1$s-close:after,
            .%1$s-style-compact-right-top .%1$s-close:before,
            .%1$s-style-compact-right-top .%1$s-close:after,
            .%1$s-style-compact-left-top .%1$s-close:before,
            .%1$s-style-compact-left-top .%1$s-close:after,
            .%1$s-style-compact-right-bottom .%1$s-close:before,
            .%1$s-style-compact-right-bottom .%1$s-close:after,
            .%1$s-style-compact-left-bottom .%1$s-close:before,
            .%1$s-style-compact-left-bottom .%1$s-close:after,
            .%1$s-style-compact .%1$s-close:before,
            .%1$s-style-compact .%1$s-close:after {
                position: absolute;
                left: 15px;
                content: " ";
                height: 33px;
                width: 2px;
                background: %3$s;
            }

            .%1$s-style-compact .%1$s-close:before,
            .%1$s-style-compact-right-top .%1$s-close:before,
            .%1$s-style-compact-left-top .%1$s-close:before,
            .%1$s-style-compact-right-bottom .%1$s-close:before,
            .%1$s-style-compact-left-bottom .%1$s-close:before,
            .%1$s-style-compact .%1$s-close:before {
                transform: rotate(45deg);
            }

            .%1$s-style-compact .%1$s-close:after,
            .%1$s-style-compact-right-top .%1$s-close:after,
            .%1$s-style-compact-left-top .%1$s-close:after,
            .%1$s-style-compact-right-bottom .%1$s-close:after,
            .%1$s-style-compact-left-bottom .%1$s-close:after,
            .%1$s-style-compact .%1$s-close:after {
                transform: rotate(-45deg);
            }

            .%1$s-style-compact-right-top .%1$s-wrapper {
                justify-content: flex-end;
                align-items: flex-start;
            }

            .%1$s-style-compact-left-top .%1$s-wrapper {
                justify-content: flex-start;
                align-items: flex-start;
            }

            .%1$s-style-compact-right-bottom .%1$s-wrapper {
                justify-content: flex-end;
                align-items: flex-end;
            }

            .%1$s-style-compact-left-bottom .%1$s-wrapper {
                justify-content: flex-start;
                align-items: flex-end;
            }

            .%1$s-style-full .%1$s-blackout {
                position: fixed;
                z-index: 9998;
                left: 0;
                top: 0;
                width: 100%5$s;
                height: 100%5$s;
                display: none;
            }

            .%1$s-style-full .%1$s-blackout.active {
                display: block;
                -webkit-animation: %1$s-appear;
                animation: %1$s-appear;
                -webkit-animation-delay: .4s;
                animation-delay: .4s;
                -webkit-animation-duration: .4s;
                animation-duration: .4s;
                -webkit-animation-fill-mode: both;
                animation-fill-mode: both;
            }

            .%1$s-style-full .%1$s-modal {
                height: 100%5$s;
                width: 100%5$s;
                max-width: 100%5$s;
                max-height: 100%5$s;
                position: fixed;
                left: 50%5$s;
                top: 50%5$s;
                transform: translate(-50%5$s, -50%5$s);
                padding: 45px;
                opacity: 0;
                z-index: 9999;
                transition: all 0.5s ease-in-out;
                display: flex;
                align-items: center;
                justify-content: center;
                flex-direction: column;
            }

            .%1$s-style-full .%1$s-modal.active {
                opacity: 1;
                -webkit-animation: %1$s-appear;
                animation: %1$s-appear;
                -webkit-animation-duration: .4s;
                animation-duration: .4s;
                -webkit-animation-fill-mode: both;
                animation-fill-mode: both;
            }

            .%1$s-style-full .%1$s-modal h4 {
                margin: 0 0 1rem 0;
            }

            .%1$s-style-full .%1$s-modal p {
                margin: 0;
            }

            .%1$s-style-full .%1$s-close {
                position: absolute;
                right: 10px;
                top: 10px;
                width: 32px;
                height: 32px;
                display: inline-block;
                cursor: pointer;
                opacity: .3;
                -webkit-animation: %1$s-close-appear;
                animation: %1$s-close-appear;
                -webkit-animation-delay: 1s;
                animation-delay: 1s;
                -webkit-animation-duration: .4s;
                animation-duration: .4s;
                -webkit-animation-fill-mode: both;
                animation-fill-mode: both;
            }

            .%1$s-style-full .%1$s-close:hover {
                opacity: 1;
            }

            .%1$s-style-full .%1$s-close:before,
            .%1$s-style-full .%1$s-close:after {
                position: absolute;
                left: 15px;
                content: " ";
                height: 33px;
                width: 2px;
            }

            .%1$s-style-full .%1$s-close:before {
                transform: rotate(45deg);
            }

            .%1$s-style-full .%1$s-close:after {
                transform: rotate(-45deg);
            }
            
            .wp-block-button__link {
			    box-shadow: none;
			    cursor: pointer;
			    display: inline-block;
			    padding: calc(0.667em + 2px) calc(1.333em + 2px);
			    text-align: center;
			    text-decoration: none;
			    word-break: break-word;
			    box-sizing: border-box;
			    margin: 1rem 0 0 0;
		    }

            @-webkit-keyframes %1$s-appear {
                from {
                    opacity: 0;
                }
                to {
                    opacity: 1;
                }
            }

            @keyframes %1$s-appear {
                from {
                    opacity: 0;
                }
                to {
                    opacity: 1;
                }
            }

            @-webkit-keyframes %1$s-close-appear {
                from {
                    opacity: 0;
                    transform: scale(0.2);
                }
                to {
                    opacity: .3;
                    transform: scale(1);
                }
            }

            @keyframes %1$s-close-appear {
                from {
                    opacity: 0;
                    transform: scale(0.2);
                }
                to {
                    opacity: .3;
                    transform: scale(1);
                }
            }

            body.%1$s-blur { 
                -webkit-backface-visibility: none;
            }

            body.%1$s-blur > *:not(#wpadminbar):not(.%1$s-modal):not(.%1$s-wrapper):not(.%1$s-blackout):not(#ez-cookie-dialog-wrapper) {
                -webkit-filter: blur(5px);
                filter: blur(5px);
            }
        ',
			$prefix,
			$align,
			$close_color,
			$cross_delay,
			$percent
		);

		$css .= self::conditional_css( $prefix );

		return $css;

	}

	/**
	 * Conditional CSS
	 *
	 * @param $prefix
	 *
	 * @return string
	 */
	private static function conditional_css( $prefix ): string {

		$options = Settings::get_instance()->options;
		$percent = '%';
		$conditional_css = '';

		if ( isset( $options[ 'button_style' ] ) && $options[ 'button_style' ] === 'on' ) {

			$button_text        = $options[ 'button_text' ] ?? '';
			$button_hover_text  = $options[ 'button_hover_text' ] ?? '';
			$button_bg          = $options[ 'button_bg' ] ?? '';
			$button_hover_bg    = $options[ 'button_hover_bg' ] ?? '';

			$conditional_css .= wp_sprintf(
				'
					.%1$s-close-button {
		                border: unset;
		                color: %2$s !important;
		                background-color: %3$s !important;
		                padding: calc(0.667em + 2px) calc(1.333em + 2px);
		                margin: 1rem 0 0 0;
		                cursor: pointer;
		                box-sizing: border-box;
		                transition: .4s;
		            }
		            .%1$s-close-button:hover,
		            .%1$s-close-button:focus {
		                color: %4$s !important;
		                background-color: %5$s !important;
		                transition: .4s;
		            }
	            ',
				$prefix,
				$button_text,
				$button_bg,
				$button_hover_text,
				$button_hover_bg
			);

		}

		if ( isset( $options[ 'guide' ] ) && $options[ 'guide' ] === 'on' ) {

			$conditional_css .= wp_sprintf(
				'
				.%1$s-guide-triger {
	                font-size: smaller;
	                clear: both;
	                margin-top: 1rem;
	                display: block;
	                text-decoration: underline;
	                text-decoration-style: dotted;
	                cursor: pointer;
	            }
	            .%1$s-guide-triger:hover {
	                text-decoration: underline;
	                text-decoration-style: dotted;
	            }
	            .%1$s-guide ol {
	                text-align: left;
	            }
	            .%1$s-guide > div:before{
	                content: "";
	                background: linear-gradient( to left, rgba(255,255,255,0.01), white);
	                width: 30%2$s;
	                height: 100%2$s;
	                position: absolute;
	                top: 0;
	                left: 0;
	            }
				',
				$prefix,
				$percent
			);

		}

		return $conditional_css;

	}

	/**
	 * Guide JS
	 * @param $prefix
	 * @param $mdpDeblocker
	 *
	 * @return string
	 */
	public static function guide_js( $prefix, $mdpDeblocker ) {

		$options = Settings::get_instance()->options;

		if ( $options[ 'guide' ] !== 'on' ) { return ''; }

		$guide_trigger      = esc_html__( 'How do I disable my ad blocker?', 'deblocker' );
		$guide_trigger_ok   = esc_html__( 'OK. I understand.', 'deblocker' );
		$guide_title        = esc_html__( 'To disable ad blocker on this site:', 'deblocker' );
		$guide_content      = '<div style="position: relative; text-align: right; background: url('. Plugin::get_url() .  'images/browser/browser-top-repeat.jpeg) repeat-x top center"><img src="'. Plugin::get_url() .  'images/browser/browser-top-right.gif"></div>';

		$guide_list         = '<ol><li>';
		$guide_list         .= esc_html__( 'Right click on the ad blocker extension icon at the top right corner of your browser', 'deblocker' );
		$guide_list         .= '</li><li>';
		$guide_list         .= esc_html__( 'From the menu choose', 'deblocker' ) . ' <b>' . esc_html__( '"Disable on this site"', 'deblocker' ) . '</b> ' . esc_html__( 'or', 'deblocker' ) . ' <b>' . esc_html__( '"Pause on this site"', 'deblocker' ) . ' </b>';
		$guide_list         .= '</li><li>';
		$guide_list         .= esc_html__( 'Refresh the page if not automatically refreshed', 'deblocker' ) ;
		$guide_list         .= '</li></ol>';

		// language=JavaScript
		return "

		/**
	    * Render guide UI
		* @param modalWrapper
		* @param modal
		*/
	    function renderGuide( modalWrapper, modal ) {
	        
	        if ( {$mdpDeblocker}.guide !== 'on' ) { return; }
            
            try {
                
				let guideTrigger = document.createElement( 'a' );
		        guideTrigger.classList.add( `{$prefix}-guide-triger` );
		        guideTrigger.innerHTML = `{$guide_trigger}`;
		        guideTrigger.addEventListener( 'click', guideTriggerHadler );
		        modal.appendChild( guideTrigger );
		        
		        let guideModal = document.createElement( 'div' );
		        guideModal.classList.add( `{$prefix}-modal` );
		        guideModal.classList.add( `{$prefix}-modal-guide` );
		        guideModal.style.display = 'none';
		        guideModal.style.backgroundColor = {$mdpDeblocker}.modal_color; // Set Modal Color.
		        
		        let guide = document.createElement( 'div' );
		        guide.classList.add( `{$prefix}-guide` );
		        guide.innerHTML = `<h4>{$guide_title}</h4>`;
		        guide.innerHTML += `{$guide_content}`;
		        guide.innerHTML += `{$guide_list}`;
		        
		        let guideTriggerOk = document.createElement( 'a' );
		        guideTriggerOk.classList.add( `{$prefix}-guide-triger` );
		        guideTriggerOk.innerHTML = `{$guide_trigger_ok}`;
		        guideTriggerOk.addEventListener( 'click', guideTriggerHadler );
		        
		        guideModal.appendChild( guide );
		        guideModal.appendChild( guideTriggerOk );
		        
		        modalWrapper.appendChild(guideModal);
                
			} catch (e) {
                
				console.warn( 'Guide UI cannot be appended' );
                
			}

	    }
	    
	    /**
	    * Guide open/close trigger handler
		* @param e
		*/
	    function guideTriggerHadler( e ) {
	        
	        e.preventDefault();
	        
	        const wrapper = e.target.parentNode.parentNode;
            
            console.log( wrapper );
	        
	        if ( wrapper.querySelector( `.{$prefix}-the-modal` ).classList.contains( 'active' ) ) {
	            wrapper.querySelector( `.{$prefix}-the-modal` ).classList.remove( 'active' );
	            wrapper.querySelector( `.{$prefix}-the-modal` ).style.display = 'none';
	            wrapper.querySelector( `.{$prefix}-modal-guide` ).classList.add( 'active' );
	            wrapper.querySelector( `.{$prefix}-modal-guide` ).style.display = 'block';
	        } else {
	            wrapper.querySelector( `.{$prefix}-the-modal` ).classList.add( 'active' );
	            wrapper.querySelector( `.{$prefix}-the-modal` ).style.display = 'block';
	            wrapper.querySelector( `.{$prefix}-modal-guide` ).classList.remove( 'active' );
	            wrapper.querySelector( `.{$prefix}-modal-guide` ).style.display = 'none';
	        }
	        
	    }
	
		";

	}

	public static function async1() {

		return '
			let callbacked = false;            
            const request = new XMLHttpRequest();  
            request.open( "GET", adsSrc, true );            
            request.onreadystatechange = ( res ) => { 
                
                if ( ! callbacked ) {
                    callback( request.responseURL !== adsSrc, request.readyState );
                    callbacked = true;
                }
                
            };            
            request.send(); 
		';

	}

	public static function async2() {

		$options = Settings::get_instance()->options;
		if ( $options[ 'check_url' ] === '' ) { return ''; }

		return wp_sprintf(
			'
			const request2 = new XMLHttpRequest();
			
			window.mobileCheck = function() {
			  let check = false;
			  (function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4))) check = true;})(navigator.userAgent||navigator.vendor||window.opera);
			  return check;
			};
	            
	        function requestError( e ) {
	        
                if ( window.mobileCheck() ) { return; }
	        
				console.error( "%2$s" );
	            doAction();
	            callbacked = true;
			}
	
	        request2.addEventListener( "error", requestError );
	        request2.addEventListener( "abort", requestError );
			request2.open( "GET", "%1$s", true );
	        request2.send();
			',
			$options[ 'check_url' ],
			esc_html__( 'An error occurred while transferring the file.', 'deblocker' ))
		;

	}

	public static function async3() {

		$options = Settings::get_instance()->options;
		if ( $options[ 'check_url' ] === '' ) { return ''; }

		return wp_sprintf(
			"
			let request3 = new XMLHttpRequest();
            request3.open( 'GET', adsSrc, true );
            request3.onreadystatechange = function() {
            
	            if ( this.readyState === 4 ) {
	            
		            if ( this.responseText.length === 0 || this.responseText.includes( '/*****' ) ) {
		                doAction();
		                callbacked = true;
					}
	            
	            }
            
			};
			
			request3.send();
			",
			$options[ 'check_url' ]
		);

	}

	/**
	 * Modal markup
	 *
	 * @param array $options
	 *
	 * @return string
	 */
	public static function modalMarkup( array $options ): string {

		$prefix = get_option( 'mdp_deblocker_random_folder_fake_prefix', 'mdpDeblocker' );

		/** Prepare content */
		$content = $options['content'] !== strip_tags( $options['content'] ) ?
			wp_kses_post( $options['content'] ): // HTML
			esc_html__( $options['content'], 'deblocker' ); // Plain text

		// X button
		$x_button= wp_sprintf(
			'<span href="#" class="%s-close">&nbsp;</span>',
			esc_attr( $prefix )
		);

		// Close button
		$close_button = wp_sprintf(
			'<button href="#" class="%s-close-button %s">%s</button>',
			esc_attr( $prefix ),
			$options[ 'button_style' ] !== 'on' ? 'wp-block-button__link elementor-button-link' : '',
			esc_html__( $options['button_caption'], 'deblocker' )
		);

		// Guide strings
		$guide_trigger      = esc_html__( 'How do I disable my ad blocker?', 'deblocker' );
		$guide_trigger_ok   = esc_html__( 'OK. I understand.', 'deblocker' );
		$guide_title        = esc_html__( 'To disable ad blocker on this site:', 'deblocker' );
		$guide_content      = '<div style="position: relative; text-align: right; background: url('. Plugin::get_url() .  'images/browser/browser-top-repeat.jpeg) repeat-x top center"><img src="'. Plugin::get_url() .  'images/browser/browser-top-right.gif"></div>';

		$guide_list         = '<ol><li>';
		$guide_list         .= esc_html__( 'Right click on the ad blocker extension icon at the top right corner of your browser', 'deblocker' );
		$guide_list         .= '</li><li>';
		$guide_list         .= esc_html__( 'From the menu choose', 'deblocker' ) . ' <b>' . esc_html__( '"Disable on this site"', 'deblocker' ) . '</b> ' . esc_html__( 'or', 'deblocker' ) . ' <b>' . esc_html__( '"Pause on this site"', 'deblocker' ) . ' </b>';
		$guide_list         .= '</li><li>';
		$guide_list         .= esc_html__( 'Refresh the page if not automatically refreshed', 'deblocker' ) ;
		$guide_list         .= '</li></ol>';

		$guide_trigger = wp_sprintf(
			'<a class="%s-guide-triger" target="_blank">%s</a>',
			esc_attr( $prefix ),
			$guide_trigger
		);

		$guide_modal = wp_sprintf(
			'<div class="%1$s-modal %1$s-modal-guide" style="display: none; background-color: %2$s">
				<div class="%1$s-guide">
					<h4>%3$s</h4>
					%4$s
					%5$s
					<a class="%1$s-guide-triger">
						%6$s
					</a>
				</div>
			</div>',
			esc_attr( $prefix ),
			esc_attr( $options['modal_color'] ),
			$guide_title,
			$guide_content,
			$guide_list,
			$guide_trigger_ok
		);

		// Body markup.
		return wp_sprintf( '
			<div class="%1$s-blackout active" style="background-color: %2$s"></div>
			<div class="%1$s-wrapper">
				<div class="%1$s-modal %1$s-the-modal active" style="background-color: %3$s">
					%4$s
					<h4 style="color: %5$s">%6$s</h4>
					<div class="%1$s-content" style="color: %5$s">
						%7$s
					</div>
					%8$s
					%9$s
				</div>
				%10$s
			</div>
			',
			esc_attr( $prefix ),
			esc_attr( $options[ 'bg_color' ] ),
			esc_attr( $options[ 'modal_color' ] ),
			$options['cross'] === 'on' ? $x_button : '',
			esc_attr( $options['text_color'] ),
			esc_html__( $options['title'], 'deblocker' ),
			$content,
			$options[ 'button' ] === 'on' ? $close_button : '',
			$options[ 'guide' ] === 'on' ? $guide_trigger : '',
			$options[ 'guide' ] === 'on' ? $guide_modal : ''
		);

	}

}
