<?php

/**
 * This file is part of FPDI
 *
 * @package   setasign\Fpdi
 * @copyright Copyright (c) 2023 Setasign GmbH & Co. KG (https://www.setasign.com)
 * @license   http://opensource.org/licenses/mit-license The MIT License
 */
namespace DynamicOOOS\setasign\Fpdi\Math;

/**
 * A simple 2D-Matrix class
 */
class Matrix
{
    /**
     * @var float
     */
    protected $a;
    /**
     * @var float
     */
    protected $b;
    /**
     * @var float
     */
    protected $c;
    /**
     * @var float
     */
    protected $d;
    /**
     * @var float
     */
    protected $e;
    /**
     * @var float
     */
    protected $f;
    /**
     * @param int|float $a
     * @param int|float $b
     * @param int|float $c
     * @param int|float $d
     * @param int|float $e
     * @param int|float $f
     */
    public function __construct($a = 1, $b = 0, $c = 0, $d = 1, $e = 0, $f = 0)
    {
        $this->a = (float) $a;
        $this->b = (float) $b;
        $this->c = (float) $c;
        $this->d = (float) $d;
        $this->e = (float) $e;
        $this->f = (float) $f;
    }
    /**
     * @return float[]
     */
    public function getValues()
    {
        return [$this->a, $this->b, $this->c, $this->d, $this->e, $this->f];
    }
    /**
     * @param Matrix $by
     * @return Matrix
     */
    public function multiply(self $by)
    {
        $a = $this->a * $by->a + $this->b * $by->c;
        $b = $this->a * $by->b + $this->b * $by->d;
        $c = $this->c * $by->a + $this->d * $by->c;
        $d = $this->c * $by->b + $this->d * $by->d;
        $e = $this->e * $by->a + $this->f * $by->c + $by->e;
        $f = $this->e * $by->b + $this->f * $by->d + $by->f;
        return new self($a, $b, $c, $d, $e, $f);
    }
}
