<?php
/**
 * Creates extra api endpoints for the plugin.
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

 /**
  * Overrides permissions of tickets so they are not public
  **/
class FastRESTPurchaseController extends WP_REST_Posts_Controller
{
    /*
    Waiting on this for comments https://core.trac.wordpress.org/ticket/40383#ticket
    */

    /**
     * Checks if a post can be read.
     *
     * Correctly handles posts with the inherit status.
     *
     * @access public
     *
     * @param object $post Post object.
     * @return bool Whether the post can be read.
     */
    public function check_read_permission($post)
    {
        return current_user_can('read_purchase', $post->ID);
    }
}
