<?php
/**
 * Admin only actions
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

 /*
 * plugins_loaded
 */

 /*
 * init
 */

/**
 * Checks if we need to flush permalinks after option page change.
 */
function fast_check_if_we_need_to_flush_permalinks()
{
    if ('true' === get_option('fast-plugin-flush-permalinks')) {
        // Flush permalinks and remove option.
        flush_rewrite_rules();
        delete_option('fast-plugin-flush-permalinks');
    }
}
add_action('init', 'fast_check_if_we_need_to_flush_permalinks');


 /**
  * Checks if updates need to be applied
  */
function fast_check_update()
{
    $plugin_version = get_option('fast_version', '1.15.4');
    if ('1.15.4' !== $plugin_version) {
        // We need to update.
        if (version_compare($plugin_version, '1.2.0', '<')) {
            fast_update_less_than_1_2_0();
        }
        if (version_compare($plugin_version, '1.3.0', '<')) {
            fast_update_less_than_1_3_0();
        }
        if (version_compare($plugin_version, '1.6.3', '<')) {
            fast_update_less_than_1_6_3();
        }
        update_option('fast_version', '1.15.4');
    }
}
add_action('init', 'fast_check_update');

/**
 * Makes sure all tickets use true / false as strings for the agent replied metadaata
 */
function fast_update_less_than_1_2_0()
{
    $all_tickets = get_posts(array(
        'post_type'     => 'fast_ticket',
        'posts_per_page' => -1,
        'post_status' => 'any'
    ));

    foreach ($all_tickets as $ticket) {
        // Update agent_replied post meta.
        $agent_replied = get_post_meta($ticket->ID, '_agent_replied', true);
        $new_agent_replied = '1' === $agent_replied ||  'true' === $agent_replied ? 'true' : 'false';
        update_post_meta($ticket->ID, '_agent_replied', $new_agent_replied);

        // Save all comments to excerpt so search will work.
        $ticket->post_content = fast_create_ticket_content_from_comments($ticket);
        $new_id = wp_update_post($ticket);
        $updated_post = get_post($new_id);
    }
    // Finally recount all taxonomies to include private tickets.
    fast_recalculate_all_taxonomy_counts();
}

/**
 * Moves customer purchases from user meta to cpt & copys site urls
 */
function fast_update_less_than_1_3_0()
{
    // Copy all siteurl params into new extra field.
    $all_tickets = get_posts(array(
        'post_type'      => 'fast_ticket',
        'posts_per_page' => -1,
        'post_status'    => 'any'
    ));

    foreach ($all_tickets as $ticket) {
        $site_url = get_post_meta($ticket->ID, '_site_url', true);
        if (!empty($site_url)) {
            $extra_fields = get_post_meta($ticket->ID, '_extra_fields', true);
            $extra_fields = empty($extra_fields) ? array() : $extra_fields;
            $extra_fields['site-url'] = $site_url;
            update_post_meta($ticket->ID, '_extra_fields', $extra_fields);
        }
    }
}

/**
 * Adds the edit_comment capability to all roles and options.
 */
function fast_update_less_than_1_6_3()
{
    // Add capability to role.
    $cap_to_add = 'edit_comment';
    $roles = apply_filters('fast_filter_ticket_roles', array());
    foreach ($roles as $role_name => $title) {
        $role = get_role($role_name);
        if (null !== $role) {
            $role->add_cap($cap_to_add);
        }
    }
    // Add capability to options.
    $options = array('fast_customer_capabilities', 'fast_agent_capabilities', 'fast_manager_capabilities');
    foreach ($options as $option_name) {
        $caps = fast_get_option($option_name);
        if (!in_array($cap_to_add, $caps)) {
            array_push($caps, $cap_to_add);
            fast_set_option($option_name, $caps);
        }
    }
}

/*
 * after_setup_theme
 */

/**
 * Registers a custom post types.
 */
function fast_add_plugin_options_page()
{
    // Add stack options to appearance menu.
    if (class_exists('FastOptions')) {
        // Create new option set with post type as menu.
        $options = new FastOptions('fast-plugin-option_group', 'fast-plugin-options');
        // Load the stack options and add them to the options page.
        $option_pages = apply_filters('fast_filter_options', array());
        foreach ($option_pages as $options_page) {
            $options->add_menu_page($options_page);
        }
    }
}
add_action('after_setup_theme', 'fast_add_plugin_options_page');

if (!function_exists('fast_setup_metaboxes')) {
    /**
     * Loads and sets up the theme metaboxes.
     *
     * @return void
     **/
    function fast_setup_metaboxes()
    {
        if (class_exists('FastMetaboxes')) {
            $metaboxes = new FastMetaboxes();
            $metabox_options = apply_filters('fast_filter_metabox_options', array());
            foreach ($metabox_options as $metabox) {
                $metaboxes->add_metabox($metabox);
            }
        }
    }
    add_action('after_setup_theme', 'fast_setup_metaboxes');
}

/*
 * init
 */

/**
 * Checks if we are a customer and if so hides all admin pages except the profile page.
 */
function fast_is_customer_allowed()
{
    $current_user = wp_get_current_user();
    if (in_array('fast_customer', (array) $current_user->roles) &&
        !in_array('administrator', (array) $current_user->roles)) {
        add_action('admin_init', 'fast_lock_customer_dashboard_redirect');
        add_action('admin_head', 'fast_lock_customer_hide_side_menus');
        add_action('admin_bar_menu', 'fast_lock_customer_hide_menus', 999);
    }
}
add_action('init', 'fast_is_customer_allowed');

/*
 * admin_init
 */

/**
 * Redirects all admin page requests to the profile page.
 */
function fast_lock_customer_dashboard_redirect()
{
    global $pagenow;

    if (defined('DOING_AJAX') && DOING_AJAX) {
        return;
    }
    
    $allowed_pages = apply_filters('fast_filter_allowed_dashboard_pages', array('profile.php'));
    foreach ($allowed_pages as $page) {
        if ($pagenow === $page) {
            return;
        }
    }

    // Allow the delete me plugin.
    if('options.php' === $pagenow && 'plugin_delete_me_confirmation' === $_GET['page']) {
        return;
    }

    $redirect_page = apply_filters('fast_filter_dashboard_redirect_page', 'profile.php');
    if ($redirect_page != $pagenow) {
        wp_redirect(admin_url($redirect_page));
        exit;
    }
}

if (!function_exists('fast_add_suggested_privacy_content')) {
    /**
     * Adds a suggested privacy policy to the policy postbox
     *
     * @return void
     **/
    function fast_add_suggested_privacy_content()
    {
        if (function_exists('wp_add_privacy_policy_content')) {
            ob_start();
            include FAST_PLUGIN_DIR . 'templates/privacy/policy.php';
            $content = ob_get_contents();
            ob_end_clean();

            wp_add_privacy_policy_content('Fast Plugin', $content);
        }
    }
    add_action('admin_init', 'fast_add_suggested_privacy_content');
}

/*
 * admin_head
 */

/**
 * Removes all admin side menus except profile
 */
function fast_lock_customer_hide_side_menus()
{
    global $menu;

    $menu_ids = array();

    // Gather menu IDs (minus profile.php).
    foreach ($menu as $index => $values) {
        if (isset($values[2])) {
            if ('profile.php' == $values[2]) {
                continue;
            }

            // Remove menu pages.
            remove_menu_page($values[2]);
        }
    }
}

/*
 * admin_bar_menu
 */

/**
 * Removes top admin bar menu items when logged in as customer.
 *
 * @param object $wp_admin_bar Admin bar menu object.
 */
function fast_lock_customer_hide_menus($wp_admin_bar)
{
    $all_toolbar_nodes = $wp_admin_bar->get_nodes();
    $allowed_toolbar_node_ids = apply_filters('fast_filter_customer_allowed_admin_menu_nodes', array());

    foreach ($all_toolbar_nodes as $node) {
        if (!in_array($node->id, $allowed_toolbar_node_ids)) {
            $wp_admin_bar->remove_menu($node->id);
        }
    }
}

/*
 * fast_action_register_options_menu_fast-plugin-general-options
 */

/**
 * Creates the plugin admin menu
 *
 * @param object $menu The menu FastMenuPage object.
 */
function fast_add_plugin_general_options_menu($menu)
{
    $menu->hook = add_menu_page($menu->options['page']['title'], $menu->options['menu']['title'], 'manage_options', $menu->options['slug'], array($menu, 'render_option_page'), 'dashicons-sos');
}
add_action('fast_action_register_options_menu_fast-plugin-general-options', 'fast_add_plugin_general_options_menu', 10, 1);

/*
 * fast_action_register_options_menu_fast-plugin-roles-capabilities
 */

/**
 * Creates the plugin admin menu
 *
 * @param object $menu The menu FastMenuPage object.
 */
function fast_add_plugin_roles_options_menu($menu)
{
    $menu->hook = add_submenu_page('fast-plugin-general-options', $menu->options['page']['title'], $menu->options['menu']['title'], 'manage_options', $menu->options['slug'], array($menu, 'render_option_page'));
}
add_action('fast_action_register_options_menu_fast-plugin-registration-page', 'fast_add_plugin_roles_options_menu', 10, 1);
add_action('fast_action_register_options_menu_fast-plugin-login-page', 'fast_add_plugin_roles_options_menu', 10, 1);
add_action('fast_action_register_options_menu_fast-plugin-new-ticket-page', 'fast_add_plugin_roles_options_menu', 10, 1);
add_action('fast_action_register_options_menu_fast-plugin-roles-capabilities', 'fast_add_plugin_roles_options_menu', 10, 1);
add_action('fast_action_register_options_menu_fast-plugin-email-options', 'fast_add_plugin_roles_options_menu', 10, 1);
add_action('fast_action_register_options_menu_fast-plugin-slack', 'fast_add_plugin_roles_options_menu', 10, 1);
add_action('fast_action_register_options_menu_fast-plugin-envato', 'fast_add_plugin_roles_options_menu', 10, 1);
add_action('fast_action_register_options_menu_fast-plugin-extra-fields', 'fast_add_plugin_roles_options_menu', 10, 1);
add_action('fast_action_register_options_menu_fast-plugin-woocommerce', 'fast_add_plugin_roles_options_menu', 10, 1);
add_action('fast_action_register_options_menu_fast-plugin-email-pipe', 'fast_add_plugin_roles_options_menu', 10, 1);
add_action('fast_action_register_options_menu_fast-plugin-ticket-scheduled-maintenance', 'fast_add_plugin_roles_options_menu', 10, 1);
add_action('fast_action_register_options_menu_fast-plugin-advanced', 'fast_add_plugin_roles_options_menu', 10, 1);

/*
 * fast_action_option_page_saved_fast-plugin-general-options
 */

/**
 * Make sure permalinks work after saving support page option.
 *
 * @param array $data New options data.
 */
function fast_flush_rewrite_rules_after_save_options($data)
{
    update_option('fast-plugin-flush-permalinks', 'true');
}
add_action('fast_action_option_page_saved_fast-plugin-general-options', 'fast_flush_rewrite_rules_after_save_options', 10, 1);
add_action('fast_action_option_page_saved_fast-plugin-registration-page', 'fast_flush_rewrite_rules_after_save_options', 10, 1);

/*
 * fast_action_option_page_saved_fast-plugin-roles-capabilities
 */

/**
 * Make sure roles are saved after saving roles options.
 *
 * @param mixed $data New data being stored.
 */
function fast_recreate_roles_after_save_roles_option_page($data)
{
    $options_defaults = FastOptionsDefaults::instance();
    $options = wp_parse_args($data, $options_defaults->get_defaults('fast-plugin-options'));

    $roles = apply_filters('fast_filter_ticket_roles', array());
    foreach ($roles as $role => $name) {
        $saved_capabilities = $options[$role . '_capabilities'];
        $capabilities = array();
        foreach ($saved_capabilities as $capability) {
            $capabilities[$capability] = true;
        }
        remove_role($role);
        add_role($role, $name, $capabilities);
    }

    // Add all manager capabilities to administrator.
    $administrator = get_role('administrator');
    $manager_caps  = apply_filters('fast_filter_default_fast_manager_capabilities', array());
    foreach ($manager_caps as $cap) {
        $administrator->add_cap($cap);
    }
}
add_action('fast_action_option_page_saved_fast-plugin-roles-capabilities', 'fast_recreate_roles_after_save_roles_option_page', 10, 1);

/*
 * fast_action_option_page_saved_fast-plugin-email-pipe
 */

/**
 * When email piping options page is saved we schedule or unschedule the chron hook.
 *
 * @param mixed $data New data being stored.
 */
function fast_schedule_email_pipe_if_needed($data)
{
    // Get options.
    $options_defaults = FastOptionsDefaults::instance();
    $options = wp_parse_args($data, $options_defaults->get_defaults('fast-plugin-options'));

    // Check if timespan has changed, if so remove old scheduled event.
    // Also remove if we just turned off piping.
    if (fast_get_option('emailp_timespan') !== $options['emailp_timespan'] || 'off' === $options['emailp_enabled']) {
        wp_clear_scheduled_hook('fast_action_email_pipe');
    }

    if ('on' === $options['emailp_enabled']) {
        // Schedule if we need to.
        if (false === wp_next_scheduled('fast_action_email_pipe')) {
            wp_schedule_event(time(), $options['emailp_timespan'], 'fast_action_email_pipe');
        }
    }

    // Check if someone clicked the run now button.
    if (isset($_POST['emailp_run_check'])) {
        // Clear schedule and start an email check now.
        wp_clear_scheduled_hook('fast_action_email_pipe');
        wp_schedule_event(time(), $options['emailp_timespan'], 'fast_action_email_pipe');
    }
}
add_action('fast_action_option_page_saved_fast-plugin-email-pipe', 'fast_schedule_email_pipe_if_needed', 10, 1);

/**
 * When ticket maintenance options page is saved we schedule or unschedule the chron hook.
 *
 * @param mixed $data New data being stored.
 */
function fast_schedule_ticket_maintenance_if_needed($data)
{
     // Get options.
     $options_defaults = FastOptionsDefaults::instance();
     $options = wp_parse_args($data, $options_defaults->get_defaults('fast-plugin-options'));

    // Check if timespan has changed, if so remove old scheduled event.
    if (fast_get_option('ticket_maintenance_timespan') !== $options['ticket_maintenance_timespan'] || 'off' === $options['ticket_maintenance_enabled']) {
        wp_clear_scheduled_hook('fast_action_scheduled_maintenance');
    }

    $selected_schedule = $options['ticket_maintenance_timespan'] . '_days';
    $update_on = strtotime('tomorrow') - (( (int) get_option('gmt_offset')) * 3600);
    if ('on' === $options['ticket_maintenance_enabled']) {
        // Schedule if we need to.
        if (false === wp_next_scheduled('fast_action_scheduled_maintenance')) {
            wp_schedule_event($update_on, 'daily', 'fast_action_scheduled_maintenance');
        }
    }

     // Check if someone clicked the run now button.
    if (isset($_POST['ticket_maintenance_run_check'])) {
        wp_schedule_single_event(time() - 1, 'fast_action_scheduled_maintenance');
        spawn_cron();
    }
}
add_action('fast_action_option_page_saved_fast-plugin-ticket-scheduled-maintenance', 'fast_schedule_ticket_maintenance_if_needed', 10, 1);

/**
 * Make sure permalinks work after saving support page option.
 *
 * @param array $data New options data.
 */
function fast_load_envato_products_from_api($data)
{
    if (isset($_POST['envato_products_load'])) {
        $page_size = 100;
        $first_page_items = fast_generate_envato_get_marketplace_items(fast_get_option('envato_username'), $page_size, 1);

        if (!is_wp_error($first_page_items)) {
            $first_page_items = json_decode(wp_remote_retrieve_body($first_page_items), true);

            if (isset($first_page_items['matches'])) {
                // Save results.
                $products = fast_add_envato_products($first_page_items);

                // If we have more than 100 products make additional calls.
                if ($first_page_items['total_hits'] > $page_size) {
                    $pages_to_fetch = ($first_page_items['total_hits'] / $page_size) + 1;
                    for ($page = 2; $page < $pages_to_fetch; $page++) {
                        $extra_page_items = fast_generate_envato_get_marketplace_items(fast_get_option('envato_username'), $page_size, $page);
                        if (!is_wp_error($extra_page_items)) {
                            $extra_page_items = json_decode(wp_remote_retrieve_body($extra_page_items), true);
                            $products = fast_add_envato_products($extra_page_items, $products);
                        }
                    }
                }
                update_option('fast-pluginenvato_product_list', $products);
            }
        }
    }
}
add_action('fast_action_option_page_saved_fast-plugin-envato', 'fast_load_envato_products_from_api', 10, 1);

/**
 * Make sure permalinks work after saving support page option.
 *
 * @param array $data New options data.
 */
function fast_add_customer_roles_button_check($data)
{
    if (isset($_POST['woocommerce_add_fast_customer_roles'])) {
        fast_add_customer_role_to_existing_users('customer');
    }
}
add_action('fast_action_option_page_saved_fast-plugin-woocommerce', 'fast_add_customer_roles_button_check', 10, 1);

/**
 * Converts users if convert button is clicked.
 *
 * @param array $data New options data.
 */
function fast_advanced_convert_existing_customers($data)
{
    if (isset($_POST['convert_role_clicked'])) {
        fast_add_customer_role_to_existing_users($data['convert_role']);
    }
}
add_action('fast_action_option_page_saved_fast-plugin-advanced', 'fast_advanced_convert_existing_customers', 10, 1);


/**
 * Outputs the extra fields options above the options fields.
 */
function fast_render_custom_fields()
{
    $title = esc_html('Extra Fields', 'fast-plugin');
    // translators: Number of tickets.
    $subtitle = esc_html('You currently have %s extra fields set for your tickets.', 'fast-plugin');
    $extra_fields    = fast_get_extra_fields();
    $support_page_id = fast_get_option('support_page');
    $builder_link    = set_url_scheme(trailingslashit(get_the_permalink($support_page_id)) . 'form-builder');
    include FAST_PLUGIN_DIR . 'templates/options/extra-fields.php';

    $title = esc_html('Secure Fields', 'fast-plugin');
    // translators: Number of tickets.
    $subtitle = esc_html('You currently have %s secure fields set for your tickets.', 'fast-plugin');
    $extra_fields    = fast_get_secure_fields();
    include FAST_PLUGIN_DIR . 'templates/options/extra-fields.php';
}
add_action('fast-plugin-extra-fields-before-option-fields', 'fast_render_custom_fields', 10, 0);

/**
 * Hides create new status form with CSS.
 *
 * @param string $hook Hook for page.
 */
function fast_hide_new_statuses_form($hook)
{
    global $post_type, $taxnow;
    // Load only on status taxonomies page.
    if ('edit-tags.php' === $hook  &&
        null !== $taxnow && 'fast_status' === $taxnow &&
        null !== $post_type && 'fast_ticket' === $post_type) {
        wp_enqueue_style('fast_admin_statuses_css', FAST_PLUGIN_URI . 'assets/css/admin.statuses.css');
    }
}
add_action('admin_enqueue_scripts', 'fast_hide_new_statuses_form', 10, 1);

/**
 * Hides edit slug field & delete button status with CSS.
 *
 * @param string $hook Hook for page.
 */
function fast_hide_edit_status_slug($hook)
{
    global $post_type, $taxnow;
    // Load only on edit status taxonomy page.
    if ('term.php' === $hook  &&
        null !== $taxnow && 'fast_status' === $taxnow &&
        null !== $post_type && 'fast_ticket' === $post_type) {
        wp_enqueue_style('fast_admin_statuses_css', FAST_PLUGIN_URI . 'assets/css/admin.status.css');
    }
}
add_action('admin_enqueue_scripts', 'fast_hide_edit_status_slug', 10, 1);

/**
 * Adds ticket number to admin bar.
 *
 * @param object $admin_bar Admin bar.
 */
function add_toolbar_items($admin_bar)
{
    $user_id = get_current_user_id();
    $is_agent = fast_is_user_agent($user_id);
    $query = array(
        'post_status'    => 'publish,private',
        'meta_key' => '_agent_replied'
    );

    // Create different query if we are agent or not.
    if ($is_agent) {
        $query['tax_query'] = array(
            array(
                'taxonomy' => 'fast_agent',
                'field'    => 'term_id',
                'terms'    => fast_get_user_agent_id($user_id),
            ),
        );
    } else {
        $query['author'] = $user_id;
    }

    // Get the count.
    $count = fast_get_need_reply_count($query, $is_agent);

    // translators: Plural form of tickets.
    $count_text = sprintf(_n('%s Ticket', '%s Tickets', $count, 'fast-plugin'), $count);

    // Add menu to admin bar.
    $admin_bar->add_menu(array(
        'id'    => 'fast-tickets',
        'title' => '<span class="ab-icon"></span>' . $count_text,
        'href'  => fast_get_app_url(),
        'meta'  => array(
            'title' => $count_text,
        ),
    ));
}
add_action('admin_bar_menu', 'add_toolbar_items', 100);

/**
 * Adds one line CSS for tag icon in admin bar.
 */
function fast_add_adminbar_css()
{
    wp_enqueue_style('fast_admin_adminbar_css', FAST_PLUGIN_URI . 'assets/css/admin.adminbar.css');
}
add_action('admin_enqueue_scripts', 'fast_add_adminbar_css', 10, 0);


/**
 * Adds extra filters to the WordPress admin comments page.
 *
 * @param string $screen Screen name.
 */
function fast_add_admin_comment_page_links($screen)
{
    if ($screen->id != 'edit-comments')
        return;

    add_filter('comment_status_links', 'fast_comment_page_links');
}
add_action('current_screen', 'fast_add_admin_comment_page_links', 10, 1);
