<?php
/**
 * Main init file for the plugin.
 *
 * @package Fast_Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

require FAST_PLUGIN_DIR . 'classes/class-ticket-plugin-rest-ticket-controller.php';
require FAST_PLUGIN_DIR . 'classes/class-ticket-plugin-rest-purchase-controller.php';

require FAST_PLUGIN_DIR . 'inc/functions.php';
require FAST_PLUGIN_DIR . 'inc/filters.php';
require FAST_PLUGIN_DIR . 'inc/actions.php';
require FAST_PLUGIN_DIR . 'inc/shortcodes.php';

require FAST_PLUGIN_DIR . 'lib/theme-options/theme-options.php';
require FAST_PLUGIN_DIR . 'lib/theme-stacks/theme-stacks.php';

if (is_admin()) {
    require FAST_PLUGIN_DIR . 'inc/admin/filters.php';
    require FAST_PLUGIN_DIR . 'inc/admin/actions.php';

    // Typography Needed for stacks.
    require FAST_PLUGIN_DIR . 'lib/theme-options/typography/google-fonts.php';
    FastGoogleFonts::instance();
}

// conditionally load the analytics logging code.
if (fast_get_option('analytics_enabled') === 'on') {
    require FAST_PLUGIN_DIR . 'classes/class-analytics.php';
    require FAST_PLUGIN_DIR . 'inc/analytics/functions.php';
    require FAST_PLUGIN_DIR . 'inc/analytics/filters.php';
    require FAST_PLUGIN_DIR . 'inc/analytics/actions.php';
    FastAnalytics::init();
}
