<?php
/**
 * Main init file for the plugin.
 *
 * @package Fast_Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

if (!function_exists('fast_embed_support')) {
    /**
     * Support Embed Shortcode - Loads support page in an iframe
     *
     * @return iframe HTML
     **/
    function fast_embed_support()
    {
        $output = '';
        $support_page_id = fast_get_option('support_page');

        if (!empty($support_page_id)) {
            wp_enqueue_style('fast-style-frontend_shortcodes_css');
            $url = get_permalink($support_page_id);
            $output = '<div class="fast-embed-container"><iframe src="' . esc_url($url) . '"></iframe></div>';
        }
        return $output;
    }
}

add_shortcode('fast_embed', 'fast_embed_support');
