<?php
/**
 * Actions file for WooCommerce
 *
 * @package Fast_Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

 /*
 * init
 */

 /**
  * Adds myaccount link to support tickets if option is on.
  */
function fast_add_support_tickets_to_my_account()
{
    // Only add the support link to myaccounts if option set.
    if ('on' === fast_get_option('woocommerce_support_tickets_link')) {
        add_filter('woocommerce_account_menu_items', 'fast_wc_add_support_link_to_my_account_menu', 10, 1);
        add_filter('woocommerce_get_endpoint_url', 'fast_wc_change_support_ticket_url', 10, 4);
    }

    // Only add get support button if option is set.
    if ('on' === fast_get_option('woocommerce_support_tickets_order_button')) {
        add_filter('woocommerce_my_account_my_orders_actions', 'fast_wc_add_support_link_order_table_actions', 10, 2);
    }
}
add_action('init', 'fast_add_support_tickets_to_my_account');

 /*
 * woocommerce_created_customer
 */

/**
 * Adds a ticket role when a woocommerce customer is created.
 *
 * @param int    $customer_id New Customer id.
 * @param array  $new_customer_data New Customer Data.
 * @param string $password_generated New customer generated password.
 */
function fast_add_customer_role_on_customer_created($customer_id, $new_customer_data, $password_generated)
{
    $user = get_user_by('id', $customer_id);
    $user->add_role('fast_customer');
}
add_action('woocommerce_created_customer', 'fast_add_customer_role_on_customer_created', 10, 3);


/**
 * Sets agent for woocommerce tickets
 *
 * @param WP_Post         $post     Inserted or updated post object.
 * @param WP_REST_Request $request  Request object.
 * @param bool            $creating True when creating a post, false when updating.
 */
function fast_wc_set_agent_for_wc_ticket($post, $request, $creating)
{
    if (true === $creating) {
        $params = $request->get_params();

        // If we have a ticket product or category or wc product set we do nothing.
        if (!isset($params['woocommerce_product_ids'])) {
            return;
        }

        $product_ids = $params['woocommerce_product_ids'];
        $agents = array();

        if (!empty($product_ids)) {
            // Get product agents.
            $agents = fast_get_metabox_value('fast_agents', $product_ids[0]);
            // If product has no agents try the category.
            if (empty($agents)) {
                // Order by id so we check child categories first and work up the heirachy.
                $categories = wp_get_post_terms($product_ids[0], 'product_cat', array(
                    'fields'  => 'ids',
                    'orderby' => 'term_id',
                    'order'   => 'DESC'
                ));

                if (!empty($categories)) {
                    foreach ($categories as $category) {
                        $agents = fast_get_taxonomy_metabox_value('fast_agents', $category);
                        if (!empty($agents)) {
                            break;
                        }
                    }
                }
            }
        }

        // If category is empty just use the default woocommerce agents in the options.
        if (empty($agents)) {
            $agents = fast_get_option('woocommerce_agents');
        }
        // Now assign the agent.
        if (!empty($agents)) {
            $count = get_option('fast_woocommerce_ticket_count', 0);
            $agent_id = $agents[$count % count($agents)];
            wp_set_object_terms($post->ID, intval($agent_id), 'fast_agent', false);
            $count++;
            update_option('fast_woocommerce_ticket_count', $count);
        }
    } // End if().
}
add_action('rest_insert_fast_ticket', 'fast_wc_set_agent_for_wc_ticket', 10, 3);
