<?php
/**
 * Filters file for WooCommerce
 *
 * @package Fast_Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Adds support ticket link to the WooCommerce my account menu.
 *
 * @param array $items Menu items array.
 *
 * @return array Modified menu items array.
 */
function fast_wc_add_support_link_to_my_account_menu($items)
{
    // Remove the logout menu item.
    if (isset($items['customer-logout'])) {
        $logout = $items['customer-logout'];
        unset($items['customer-logout']);
    }
    // Insert your custom endpoint.
    $items['support-tickets'] = esc_html__('Support Tickets', 'fast-plugin');

    // Insert back the logout item.
    if (isset($logout)) {
        $items['customer-logout'] = $logout;
    }
    return $items;
}

/**
 * Changes the Support Ticket menu endpoint url to point to frontend app.
 *
 * @param string $url Url of endpoint.
 * @param string $endpoint Endpoint name.
 * @param string $value Value of endpoint.
 * @param string $permalink Permalink of endpoint.
 *
 * @return string new Url
 */
function fast_wc_change_support_ticket_url($url, $endpoint, $value, $permalink)
{
    if ('support-tickets' === $endpoint) {
        $url = fast_get_app_url();
    }
    return $url;
}

/**
 * Makes users have permission to see their orders
 *
 * @param string $permission Permission type.
 * @param string $context View context.
 * @param int    $object_id Post id.
 * @param string $post_type Post type name.
 *
 * @return string Modified permission.
 */
function set_wc_permissions($permission, $context, $object_id, $post_type)
{
    if ('product' === $post_type) {
        $current_user_roles = fast_get_user_roles();
        if (in_array('fast_customer', $current_user_roles) || in_array('fast_agent', $current_user_roles) || in_array('fast_manager', $current_user_roles)) {
            return true;
        }
    }
    if ('shop_order' === $post_type) {
        if (0 !== $object_id) {
            // Make sure agents and managers can see orders from the api.
            $current_user_roles = fast_get_user_roles();
            if (in_array('fast_agent', $current_user_roles) || in_array('fast_manager', $current_user_roles)) {
                return true;
            }
            $order = wc_get_order($object_id);
            return $order->get_user_id() === get_current_user_id();
        }

        return true;
    }
    return $permission;
}
add_filter('woocommerce_rest_check_permissions', 'set_wc_permissions', 10, 4);

/**
 * Adds button to actions row for each woocommerce order
 *
 * @param array  $actions Actions to add.
 * @param object $order Order object.
 *
 * @return array Modified actions.
 */
function fast_wc_add_support_link_order_table_actions($actions, $order)
{
    $order_status_option = fast_get_option('woocommerce_order_statuses');
    if ('any' === $order_status_option || $order_status_option === $order->get_status()) {
        $actions['get-support'] = array(
            'url' => fast_get_app_url() . 'ticket/new;order_id=' . $order->get_order_number(),
            'name' => esc_html__('Get Support', 'fast-plugin'),
        );
    }
    return $actions;
}
