<?php
/**
 * Handles customise theme options
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Multiple checkbox customize control class.
 *
 * @since  1.0.0
 * @access public
 */
class FastCustomizerControlMultipleCheckbox extends WP_Customize_Control {

    /**
     * The type of customize control being rendered.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $type = 'checkbox-multiple';

    /**
     * Enqueue scripts/styles.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    public function enqueue()
    {
        wp_enqueue_script('oxy-customize-multiple-checkbox', FAST_OPTIONS_URI . 'customizer/controls/multiple-checkbox/multiple-checkbox.js', array('jquery'));
    }

    /**
     * Displays the control content.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    public function render_content()
    {
        if (empty($this->choices)) {
            return;
        }

        include FAST_OPTIONS_DIR . 'customizer/controls/multiple-checkbox/template.php';
    }
}
