<?php
/**
 * Handles customise theme options
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Adds a sliser control to the customizer
 */
class FastCustomizerControlSlider extends WP_Customize_Control {
    /**
     * Loads the slider js
     *
     * @return void
     */
    public function enqueue()
    {
        // Register jquery ui CSS.
        if (function_exists('fast_register_jquery_ui_css')) {
            fast_register_jquery_ui_css();
        }

        // Load option screen CSS and JS.
        wp_enqueue_style('fast-style--jquery-ui-options');
        wp_enqueue_script('fast-script-ui-theme', FAST_OPTIONS_URI . 'customizer/controls/slider/slider.js', array('jquery-ui-slider'));
    }

    /**
     * Echos the slider HTML.
     *
     * @return void
     */
    public function render_content()
    {
        include FAST_OPTIONS_DIR . 'customizer/controls/slider/template.php';
    }
}
