<?php
/**
 * Renders a slider for customiser
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

?>
<label>
    <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
    <?php if (!empty($this->description)) : ?>
        <span class="description customize-control-description"><?php echo esc_html($this->description); ?></span>
    <?php endif; ?>
    <div></div>
    <input type="text" class="slider-option" value="<?php echo esc_attr($this->value()); ?>" min="<?php echo esc_attr($this->choices['min']); ?>" max="<?php echo esc_attr($this->choices['max']); ?>" step="<?php echo esc_attr($this->choices['step']); ?>" <?php $this->link(); ?> />
</label>
