<?php
/**
 * Theme Customizer Class
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Customizer Class
 */
class FastCustomizer {
    /**
     * Stores the singleton instance of the class
     *
     * @var FastCustomizer
     */
    private static $instance;

    /**
     * Stores the option name where customizer values are stored.
     *
     * @var string
     */
    private $option_name;

    /**
     * Array of section options
     *
     * @var array
     */
    private $sections;

    /**
     * Main Customizer construct adds actions
     */

    /**
     * Main Customizer construct adds actions
     *
     * @param string $option_name Stores the option name where customizer values are stored.
     */
    public function __construct($option_name)
    {
        $this->sections = array();
        $this->option_name = $option_name;

        add_action('customize_register', array(&$this, 'customize_register'));
    }

    /**
     * Adds a section to be shown in the customizer
     *
     * @param array $section Section options to add.
     */
    public function add_section($section)
    {
        $this->sections[] = $section;
    }

    /**
     * Handles customize_register action callback
     *
     * @param object $wp_customize WordPress customizer object.
     * @return void
     */
    public function customize_register($wp_customize)
    {
        foreach ($this->sections as $section) {
            $section_options = array(
                'title'       => $section['title'],
                'priority'    => $section['priority']
            );

            if (isset($section['description'])) {
                $section_options['description'] = $section['description'];
            }

            if (isset($section['active_callback'])) {
                $section_options['active_callback'] = $section['active_callback'];
            }

            // Create section.
            $wp_customize->add_section($section['id'], $section_options);

            foreach ($section['fields'] as $index => $field) {
                $option_group_id = $this->option_name . '[' . $field['id'] . ']';
                $transport = isset($field['selector']) && isset($field['callback']) ? 'postMessage' : 'refresh';
                $wp_customize->add_setting($option_group_id, array(
                    'type'              => 'option',
                    'transport'         => $transport,
                    'capability'        => 'edit_theme_options',
                    'default'           => isset($field['default']) ? $field['default'] : '',
                    'sanitize_callback' => isset($field['sanitize_callback']) ? $field['sanitize_callback'] : '',
                ));

                $control_args = array(
                    'label'    => $field['name'],
                    'section'  => $section['id'],
                    'type'     => $field['type'],
                    'settings' => $option_group_id,
                    'priority' => $index,
                );

                if (isset($field['desc'])) {
                    $control_args['description'] = $field['desc'];
                }

                $control_id = $field['id'];
                switch ($field['type']) {
                    case 'select':
                        if (isset($field['filter']) && is_string($field['filter'])) {
                            $field['options'] = apply_filters($field['filter'], array());
                        }
                        if (isset($field['database'])) {
                            $field['options'] = fast_create_database_options($field);
                        }
                        if (isset($field['empty_label']) && is_array($field['options'])) {
                            $control_args['choices'] = array(
                                '' => $field['empty_label']
                            );
                            foreach ($field['options'] as $key => $value) {
                                $control_args['choices'][$key] = $value;
                            }
                        } else {
                            $control_args['choices'] = $field['options'];
                        }
                        $wp_customize->add_control($control_id, $control_args);
                        break;
                    case 'radio':
                        $control_args['choices'] = $field['options'];
                        $wp_customize->add_control($control_id, $control_args);
                        break;

                    case 'upload':
                        unset($control_args['type']);
                        if (isset($field['store']) && 'id' === $field['store']) {
                            $wp_customize->add_control(new WP_Customize_Media_Control($wp_customize, $control_id, $control_args));
                        } else {
                            $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, $control_id, $control_args));
                        }
                        break;

                    case 'slider':
                        require_once FAST_OPTIONS_DIR . 'customizer' . DIRECTORY_SEPARATOR . 'controls' . DIRECTORY_SEPARATOR . 'slider' . DIRECTORY_SEPARATOR . 'customizer-control-slider.php';
                        unset($control_args['type']);
                        $control_args['choices'] = $field['attr'];
                        $wp_customize->add_control(new FastCustomizerControlSlider($wp_customize, $control_id, $control_args));
                        break;

                    case 'multiple-checkbox':
                        require_once FAST_OPTIONS_DIR . 'customizer' . DIRECTORY_SEPARATOR . 'controls' . DIRECTORY_SEPARATOR . 'multiple-checkbox' . DIRECTORY_SEPARATOR . 'customizer-control-multiple-checkbox.php';
                        $control_args['choices'] = $field['options'];
                        $wp_customize->add_control(new FastCustomizerControlMultipleCheckbox($wp_customize, $control_id, $control_args));
                        break;

                    case 'color':
                        unset($control_args['type']);
                        $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, $control_id, $control_args));
                        break;
                    default:
                        // Regular control.
                        $wp_customize->add_control($control_id, $control_args);
                        break;
                } // End switch().

                if (isset($field['selector'])) {
                    $options = array(
                        'selector' => $field['selector']
                    );
                    if (isset($field['callback'])) {
                        $options['render_callback'] = $field['callback'];
                    }
                    $wp_customize->selective_refresh->add_partial(
                        $option_group_id,
                        $options
                    );
                }
            } // End foreach().
        } // End foreach().
    }

    /**
     * Instance accessor. If instance doesn't exist, we'll initialize the class.
     *
     * @return object PagePress
     */
    public static function instance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new FastCustomizer();
        }
        return self::$instance;
    }
}
