<?php
/**
 * Loads all metaboxes into theme
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Loads all metaboxes
 */
class FastMetaboxes {
    /**
     * Stores all the themes metaboxes
     *
     * @var array
     */
    private $theme_metaboxes;

    /**
     * Main constructor initialises actions
     */
    public function __construct()
    {
        $this->theme_metaboxes = array();

        // Create defaults set to store all defaults in.
        $options_defaults = FastOptionsDefaults::instance();
        $options_defaults->create_set('fast-plugin-metabox-options');

        add_action('init', array(&$this, 'setup_theme_metaboxes'));
    }

    /**
     * Adds a metabox
     *
     * @param array $metabox Metabox options array.
     */
    public function add_metabox($metabox)
    {
        $this->theme_metaboxes[] = $metabox;

        $options_defaults = FastOptionsDefaults::instance();
        foreach ($metabox['fields'] as $field) {
            if (isset($field['id']) && isset($field['default'])) {
                $options_defaults->add_default('fast-plugin-metabox-options', $field['id'], $field['default']);
            }
        }
    }

    /**
     * Gets metabox data from filter and creates metaboxes.
     *
     * @return void
     */
    public function setup_theme_metaboxes()
    {
        foreach ($this->theme_metaboxes as $metabox_options) {
            $metabox = isset($metabox_options['pages']) ? new FastMetabox($metabox_options) : new FastTaxonomyMetabox($metabox_options);
        }
    }
}
