<?php
/**
 * Outputs metabox options.
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

?>
<table class="oxy-metabox-table">
    <?php foreach ($metabox_fields as $metabox_field) : ?>
    <tr class="form-table" id="<?php echo esc_attr($metabox_field->option('id')); ?>">
        <th scope="row" valign="top">
            <label for="<?php echo esc_attr($metabox_field->option('name')); ?>"><?php echo esc_html($metabox_field->option('name')); ?></label>
        </th>
        <td>
            <?php $metabox_field->render(); ?>
            <?php if (null !== $metabox_field->option('desc')) : ?>
        </td>
        <td>
            <a class="oxy-tooltip-description oxy-pull-right" title="<?php echo esc_attr($metabox_field->option('desc')); ?>">
                <span class="ui-widget-content">?</span>
            </a>
            <?php endif; ?>
        </td>
    </tr>
    <?php endforeach; ?>

    <?php wp_nonce_field($this->options['id'] . '-metabox', $this->options['id'] . '-theme-metabox-nonce'); ?>
</table>
