<?php
/**
 * Outputs taxonomy metabox options.
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

?>
<?php foreach ($metabox_fields as $metabox_field) : ?>
<div class="form-field" id="<?php echo esc_attr($metabox_field->option('id')); ?>">
    <label for="<?php echo esc_attr($metabox_field->option('name')); ?>"><?php echo esc_html($metabox_field->option('name')); ?></label>
    <?php $metabox_field->render(); ?>
    <?php if (null !== $metabox_field->option('desc')) : ?>
    <p><?php echo esc_html($metabox_field->option('desc')); ?></p>
    <?php endif; ?>
</div>
<?php endforeach; ?>

<?php wp_nonce_field($this->options['id'] . '-metabox', $this->options['id'] . '-theme-metabox-nonce'); ?>
