<?php
/**
 * Color option code
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Creates a color picker option
 */
class FastButton extends FastOption {
    /**
     * Constructor for select option
     *
     * @param array $field Options to create select field.
     * @param mixed $value Value of this option.
     */
    public function __construct($field, $value)
    {
        parent::__construct($field, $value);
    }

    /**
     * Outputs the HTML of the select
     *
     * @return void
     */
    public function render()
    {
        $format = isset($this->field['format']) ? $this->field['format'] : 'rgb';

        $this->set_attribute('name', $this->field['id']);

        include FAST_OPTIONS_DIR . 'options/fields/button/template.php';
    }
}
