jQuery(document).ready(function($) {

    function setInputColor($input, color) {
        if(null !== color) {
            switch($input.attr('data-format')) {
                case 'rgb':
                    $input.attr('value', color.toRgbString());
                    break;

                case 'rgba':
                    // make sure we get an alpha even if its 1
                    var val = color.toRgbString();
                    if(color.getAlpha() === 1) {
                        val = val.replace(')', ', 1)');
                    }
                    $input.attr('value', val);
                    break;

                case 'hex':
                default:
                    $input.attr('value', color.toHexString());
                    break;
            }
        } else {
            $input.attr('value', '');
        }
        $input.trigger('change');
    }

    // set color picker input
    $('.fast-color-option').each(function() {
        var $input = $(this);
        var preferredFormat = $input.attr('data-format') !== undefined ? $input.attr('data-format') : 'hex';
        preferredFormat = preferredFormat === 'rgba' ? 'rgb' : preferredFormat;
        $input.spectrum({
            clickoutFiresChange: true,
            showButtons: false,
            showInput: true,
            showAlpha: $input.attr('data-format') === 'rgba',
            allowEmpty: $input.hasClass('allow-empty'),
            preferredFormat: preferredFormat,
            move: function(color) {
                setInputColor($input, color);
            },
            change: function(color) {
                setInputColor($input, color);
            }
        });
    });
});
