<?php
/**
 * Color option code
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Creates a color picker option
 */
class FastColor extends FastOption {
    /**
     * Constructor for select option
     *
     * @param array $field Options to create select field.
     * @param mixed $value Value of this option.
     */
    public function __construct($field, $value)
    {
        parent::__construct($field, $value);
    }

    /**
     * Outputs the HTML of the select
     *
     * @return void
     */
    public function render()
    {
        $format = isset($this->field['format']) ? $this->field['format'] : 'rgb';

        $this->set_attribute('name', $this->field['id']);
        $this->set_attribute('type', 'text');
        $this->set_attribute('data-format', $format);
        $this->set_attribute('class', 'fast-color-option');
        $this->set_attribute('value', $this->value());

        include FAST_OPTIONS_DIR . 'options/fields/color/template.php';
    }

    /**
     * Enqueues js and css files.
     *
     * @param  string $suffix CSS / JS suffix for filename (.min).
     * @return void
     */
    public function enqueue($suffix)
    {
        wp_enqueue_style('fast-style-spectrum', FAST_OPTIONS_URI . 'assets/css/spectrum' . $suffix . '.css');
        wp_enqueue_script('fast-script-spectrum', FAST_OPTIONS_URI . 'assets/js/spectrum' . $suffix . '.js', array('jquery'));
        wp_enqueue_script('fast-script-color-option', FAST_OPTIONS_URI . 'options/fields/color/color' . $suffix . '.js', array('fast-script-spectrum'));
    }
}
