<?php
/**
 * Editor option code
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Creates an editor option
 */
class FastEditor extends FastOption {
    /**
     * Constructor for select option
     *
     * @param array $field Options to create select field.
     * @param mixed $value Value of this option.
     */
    public function __construct($field, $value)
    {
        parent::__construct($field, $value);
    }

    /**
     * Outputs the HTML of the select
     *
     * @return void
     */
    public function render()
    {
        // Add name to the editor so save works.
        $settings = array(
            'textarea_name' => $this->field['id']
        );

        // Add extra settings if sent form option.
        if (isset($this->field['settings'])) {
            $settings = array_merge($settings, $this->field['settings']);
        }

        wp_editor($this->value(), 'editor-' . $this->field['id'], $settings);
    }
}
