/* global fontOption, googleFonts */

/* eslint-disable max-len */

jQuery(document).ready(function($) {
    $.fn.fontOption = function() {
        return this.each(function() {
            var fonts = [];
            var loading = false;
            var $hiddenInput     = $(this);
            var $familySelect    = $hiddenInput.siblings('.fast-font-option-families');
            var $weightsSelect   = $hiddenInput.siblings('.fast-font-option-weights');
            var $languagesSelect = $hiddenInput.siblings('.fast-font-option-languages');
            var $footer          = $hiddenInput.siblings('.fast-font-option-footer');
            var $updateFonts     = $footer.find('.fast-font-option-update-fonts');

            function prepareFontListData(googleFontsItems) {
                var fonts = $.map(googleFontsItems, function(font, index) {
                    font.id = font.family;
                    font.text = font.family;
                    return font;
                });

                fonts.unshift({
                    id: 'none',
                    variants: [],
                    subsets: [],
                    text: fontOption.translations.empty
                });
                return fonts;
            }

            function updateFamilies(fontItems) {
                fonts = prepareFontListData(fontItems);

                $familySelect.find('option').remove();
                $familySelect.select2({
                    data: fonts
                });

                selectFontFromHiddenValue();
            }


            function loadValue(value) {
                $familySelect.val(value.family).trigger('change');
                if(null !== value.weights) {
                    $weightsSelect.val(value.weights).trigger('change');
                }
                if(null !== value.languages) {
                    $languagesSelect.val(value.languages).trigger('change');
                }
            }

            function updateSelect(values, select, defaultValue) {
                if(undefined !== values) {
                    values = $.map(values, function(value, index) {
                        value.id = index;
                        value.text = value;
                        return value;
                    });
                } else {
                    values = [];
                }
                select.find('option').remove();
                select.select2({
                    data: values
                });

                // Select default value if it is there.
                if(values.indexOf(defaultValue) !== -1) {
                    select.val([defaultValue]).trigger('change');
                }
            }

            function fontSelected() {
                var index = $familySelect.prop('selectedIndex');
                var font = fonts[index];

                if(undefined !== font) {
                    updateSelect(font.variants, $weightsSelect, 'regular');
                    updateSelect(font.subsets, $languagesSelect, 'latin');
                }

                updateHiddenInput();
            }

            function updateHiddenInput() {
                $hiddenInput.val(JSON.stringify({
                    family: $familySelect.val(),
                    weights: $weightsSelect.val(),
                    languages: $languagesSelect.val()
                }));
            }

            function updateClick() {
                $hiddenInput.trigger('google-update-start', []);

                $.post(fontOption.ajaxurl, {
                    action: 'google_fonts_list',
                    nonce: fontOption.updateNonce,
                    dataType: 'json'
                }).done(function(response) {
                    $hiddenInput.trigger('google-update-success', response);
                }).fail(function(jqxhr, textStatus, error) {
                    $hiddenInput.trigger('google-update-error', error);
                });

                return false;
            }

            function toggleLoader() {
                loading = !loading;
                // Disable the selects and button
                $familySelect.prop('disabled', loading);
                $weightsSelect.prop('disabled', loading);
                $languagesSelect.prop('disabled', loading);
                $updateFonts.prop('disabled', loading);
            }

            function createMessage(message, icon, fadeout) {
                // Remove old messages
                $footer.find('.fast-font-option-message').remove();

                $footer.prepend('<span class="fast-font-option-message fast-font-option-message--' + icon + '"><span class="dashicons dashicons-' + icon + '"></span>' + message + '</span>');
                if(fadeout) {
                    window.setTimeout(function() {
                        $footer.find('.fast-font-option-message').fadeOut(300, function() {
                            $(this).remove();
                        });
                    }, 4000);
                }
            }

            function updateSuccess(event, response) {
                if(response.data) {
                    var googleFonts = response.data;

                    updateFamilies(googleFonts.items);
                    toggleLoader();
                    selectFontFromHiddenValue();

                    createMessage(response.message, 'yes', true);
                }
            }

            function updateError(event, error) {
                toggleLoader();
                createMessage(error, 'no', true);
            }

            function selectFontFromHiddenValue() {
                var value = $hiddenInput.val();
                if(value) {
                    loadValue(JSON.parse(value));
                }
            }

            function init() {
                // Watch for update changes
                $('body').bind('google-update-start', toggleLoader);
                $('body').bind('google-update-success', updateSuccess);
                $('body').bind('google-update-error', updateError);

                // Add listeners for change events on selects
                $familySelect.select2().on('change', fontSelected);
                $weightsSelect.select2().on('change', updateHiddenInput);
                $languagesSelect.select2().on('change', updateHiddenInput);

                // Add listener for update fonts click
                $updateFonts.on('click', updateClick);

                // Update families select and show font
                if(undefined !== googleFonts && undefined !== googleFonts.items  && googleFonts.items.length > 0) {
                    updateFamilies(googleFonts.items);
                } else {
                    // We have no fonts yet lets ask the user to get some.
                    createMessage('You have no fonts click there ->', 'warning', false);
                }
            }

            init();
        });
    };

    $('.fast-font-option').fontOption();
});
