<?php
/**
 * Font option code
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Creates a font option
 */
class FastFont extends FastOption {
    /**
     * Constructor for select option
     *
     * @param array $field Options to create select field.
     * @param mixed $value Value of this option.
     */
    public function __construct($field, $value)
    {
        parent::__construct($field, $value);
    }

    /**
     * Outputs the HTML of the select
     *
     * @return void
     */
    public function render()
    {
        $this->set_attribute('name', $this->field['id']);
        $this->set_attribute('type', 'hidden');
        $this->set_attribute('class', 'fast-font-option');
        $this->set_attribute('value', apply_filters('fast_filter_font_option_value', $this->value()));

        include FAST_OPTIONS_DIR . 'options/fields/font/template.php';
    }

    /**
     * Enqueues js and css files.
     *
     * @param  string $suffix CSS / JS suffix for filename (.min).
     * @return void
     */
    public function enqueue($suffix)
    {
        wp_register_script('fast-script-select2', FAST_OPTIONS_URI . 'assets/js/select2' . $suffix . '.js', array('jquery'));
        wp_register_script('fast-script-font-option', FAST_OPTIONS_URI . 'options/fields/font/font' . $suffix . '.js', array('fast-script-select2'));

        $google_fonts_loader = FastGoogleFonts::instance();
        $google_fonts = $google_fonts_loader->get_fonts_from_options();

        wp_localize_script('fast-script-font-option', 'googleFonts', $google_fonts);
        wp_localize_script('fast-script-font-option', 'fontOption', array(
            'translations' => array(
                'empty'    => esc_html__('Load No Font', 'fast-plugin')
            ),
            'ajaxurl'      => admin_url('admin-ajax.php'),
            'updateNonce'  => wp_create_nonce('fast-plugin-add-fontstack')
        ));
        wp_enqueue_script('fast-script-font-option');

        wp_enqueue_style('fast-style-select2', FAST_OPTIONS_URI . 'assets/css/select2' . $suffix . '.css');
        wp_enqueue_style('fast-style-font', FAST_OPTIONS_URI . 'options/fields/font/font' . $suffix . '.css');
    }
}
