<?php
/**
 * Select option code
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Creates a select option
 */
class FastSelect extends FastOption {
    /**
     * Constructor for select option
     *
     * @param array $field Options to create select field.
     * @param mixed $value Value of this option.
     */
    public function __construct($field, $value)
    {
        parent::__construct($field, $value);
    }

    /**
     * Outputs the HTML of the select
     *
     * @return void
     */
    public function render()
    {
        $name = $this->field['id'];
        if (isset($this->attributes['multiple'])) {
            $name .= '[]';
        }
        $this->set_attribute('name', $name);

        if (isset($this->field['filter']) && is_string($this->field['filter'])) {
            $this->field['options'] = apply_filters($this->field['filter'], array());
        }

        if (isset($this->field['database'])) {
            $this->field['options'] = fast_create_database_options($this->field);
        }

        include FAST_OPTIONS_DIR . 'options/fields/select/template.php';
    }

    /**
     * Checks to see if the sent value is the current value
     *
     * @param  string $value Value to check.
     * @return void
     */
    public function selected($value)
    {
        $stored_value = $this->value();

        if (is_array($stored_value)) {
            foreach ($stored_value as $multi_value) {
                if ($multi_value == $value) {
                    echo 'selected="selected"';
                }
            }
        } else if ($stored_value == $value) {
            echo 'selected="selected"';
        }
    }

    /**
     * Enqueues js and css files.
     *
     * @param  string $suffix CSS / JS suffix for filename (.min).
     * @return void
     */
    public function enqueue($suffix)
    {
        if (isset($this->field['select2'])) {
            wp_register_script('fast-script-select2', FAST_OPTIONS_URI . 'assets/js/select2' . $suffix . '.js', array('jquery'));
            wp_enqueue_script('fast-script-select2-option', FAST_OPTIONS_URI . 'options/fields/select/select2' . $suffix . '.js', array('fast-script-select2'));
            wp_register_style('fast-style-select2', FAST_OPTIONS_URI . 'assets/css/select2' . $suffix . '.css');
            wp_enqueue_style('fast-style-select2-option', FAST_OPTIONS_URI . 'options/fields/select/select2' . $suffix . '.css', array('fast-style-select2'));
        }
    }
}
