<?php
/**
 * Outputs a select tag
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

?>
<select <?php $this->esc_attributes(); ?>>
    <?php if (isset($this->field['empty_label'])) : ?>
        <option value=""><?php echo esc_html($this->field['empty_label']); ?></option>
    <?php endif; ?>
    <?php foreach ($this->field['options'] as $value => $name) : ?>
        <?php if (is_array($name)) : ?>
            <optgroup label="<?php echo esc_attr($value); ?>">
                <?php foreach ($name as $optgroup_value => $optgroup_name) : ?>
                    <option <?php $this->selected($optgroup_value); ?>value="<?php echo esc_attr($optgroup_value); ?>"><?php echo esc_html($optgroup_name); ?></option>
                <?php endforeach; ?>
            </optgroup>
        <?php else : ?>
            <option <?php $this->selected($value); ?>value="<?php echo esc_attr($value); ?>"><?php echo esc_html($name); ?></option>
        <?php endif; ?>
    <?php endforeach; ?>
</select>
