<?php
/**
 * Select option code
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Creates a text input option
 */
class FastSlider extends FastOption {
    /**
     * Constructor for select option
     *
     * @param array $field Options to create select field.
     * @param mixed $value Value of this option.
     */
    public function __construct($field, $value)
    {
        parent::__construct($field, $value);

        $this->set_attribute('name', $this->field['id']);
        $this->set_attribute('class', array('fast-slider-option'));
        $this->set_attribute('value', $this->value());
        $this->set_attribute('type', 'text');
        if (isset($this->field['attr']) && is_array($this->field['attr'])) {
            foreach ($this->field['attr'] as $attribute => $value) {
                $this->set_attribute($attribute, $value);
            }
        }
    }

    /**
     * Outputs the HTML of the select
     *
     * @return void
     */
    public function render()
    {
        include FAST_OPTIONS_DIR . 'options/fields/slider/template.php';
    }

    /**
     * Enqueues js and css files.
     *
     * @param  string $suffix CSS / JS suffix for filename (.min).
     * @return void
     */
    public function enqueue($suffix)
    {
        fast_register_jquery_ui_css();
        wp_enqueue_style('fast-style-slider', FAST_OPTIONS_URI . 'options/fields/slider/slider' . $suffix . '.css', array('fast-style--jquery-ui-options'));
        wp_enqueue_script('fast-script-slider', FAST_OPTIONS_URI . 'options/fields/slider/slider' . $suffix . '.js', array('jquery-ui-slider'));
    }
}
