<?php
/**
 * Select option code
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Creates a text input option
 */
class FastTextarea extends FastOption {
    /**
     * Constructor for select option
     *
     * @param array $field Options to create select field.
     * @param mixed $value Value of this option.
     */
    public function __construct($field, $value)
    {
        parent::__construct($field, $value);
    }

    /**
     * Outputs the HTML of the select
     *
     * @return void
     */
    public function render()
    {
        $this->set_attribute('name', $this->field['id']);
        if (isset($this->field['attr']) && is_array($this->field['attr'])) {
            foreach ($this->field['attr'] as $attribute => $value) {
                $this->set_attribute($attribute, $value);
            }
        }
        include FAST_OPTIONS_DIR . 'options/fields/textarea/template.php';
    }
}
