<?php
/**
 * Upload option code
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Creates a text input option
 */
class FastUpload extends FastOption {
    /**
     * Constructor for select option
     *
     * @param array $field Options to create select field.
     * @param mixed $value Value of this option.
     */
    public function __construct($field, $value)
    {
        parent::__construct($field, $value);

        $this->set_attribute('type', 'hidden');
        $this->set_attribute('value', esc_attr($value));
        $this->set_attribute('name', $field['id']);
        $this->set_attribute('data-store', $field['store']);
    }

    /**
     * Outputs the HTML of the select
     *
     * @return void
     */
    public function render()
    {
        $url = '';
        switch ($this->field['store']) {
            case 'id':
                $image = wp_get_attachment_image_src($this->value(), 'full');
                $url = false !== $image ? $image[0] : '';
                break;
            case 'url':
                $url = $this->value();
                break;
        }

        $hide_preview = empty($url) ? 'display:none;' : '';

        include FAST_OPTIONS_DIR . 'options/fields/upload/template.php';
    }

    /**
     * Enqueues js and css files.
     *
     * @param  string $suffix CSS / JS suffix for filename (.min).
     * @return void
     */
    public function enqueue($suffix)
    {
        // Load styles.
        wp_enqueue_style('fast-style-upload', FAST_OPTIONS_URI . 'options/fields/upload/upload' . $suffix . '.css', array('thickbox'));
        // Load scripts.
        wp_enqueue_script('fast-script-upload', FAST_OPTIONS_URI . 'options/fields/upload/upload' . $suffix . '.js');
        wp_enqueue_media();
    }
}
