<?php
/**
 * Stores all the default values used by the theme.
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Singleton storage of all default values used in options by the theme.
 */
class FastOptionsDefaults {
    /**
     * Stores the singleton instance of the class
     *
     * @var FastOptionsDefaults
     */
    private static $instance;

    /**
     * Stores all the default values in id => value array
     *
     * @var array
     */
    private $default_sets;

    /**
     * Creates a new instance of the class
     */
    public function __construct()
    {
        $this->default_sets = array();
    }

    /**
     * Creates a new set to add defaults to
     *
     * @param string $set_name Name to use as a key for the defaults set.
     */
    public function create_set($set_name)
    {
        if (!isset($this->default_sets[$set_name])) {
            $this->default_sets[$set_name] = array();
        }
    }

    /**
     * Adds a default value to be stored
     *
     * @param string $set_name Set to add the value to.
     * @param string $id       Id of the option.
     * @param string $value    Default value of option.
     */
    public function add_default($set_name, $id, $value)
    {
        $this->default_sets[$set_name][$id] = $value;
    }

    /**
     * Gets all the defaults currently registered for this set.
     *
     * @param  string $set_name Name of set that was created using create_set.
     * @return array Array of all default ids and values.
     */
    public function get_defaults($set_name)
    {
        if (isset($this->default_sets[$set_name])) {
            return $this->default_sets[$set_name];
        }
    }

    /**
     * Instance accessor. If instance doesn't exist, we'll initialize the class.
     *
     * @return object FastOptionsDefaults
     */
    public static function instance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new FastOptionsDefaults();
        }
        return self::$instance;
    }
}
