<?php
/**
 * Main theme option builder
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Registers option settings and allows access to create option pages and customizer sections
 */
class FastOptions {
    /**
     * Stores setting option_group
     *
     * @var string
     **/
    public $option_group;

    /**
     * Stores setting option_name
     *
     * @var string
     **/
    public $option_name;

    /**
     * Stores all registered menu pages
     *
     * @var array
     **/
    private $menu_pages;

    /**
     * Creates an option setting
     *
     * @param string $option_group Option group name.
     * @param string $option_name  Option name.
     */
    public function __construct($option_group, $option_name)
    {
        $this->option_group = $option_group;
        $this->option_name = $option_name;
        $this->menu_pages = array();

        // Register settings on admin_init.
        add_action('admin_init', array(&$this, 'admin_init'));
    }

    /**
     * Registers the options array with WordPress
     *
     * @return void
     */
    public function admin_init()
    {
        // Register theme settings.
        register_setting($this->option_group, $this->option_name, array(&$this, 'validate_options'));
    }

    /**
     * Adds a menu page to the side menu
     *
     * @param array $options Sections and Options to add to the option page.
     */
    public function add_menu_page($options)
    {
        $menu_page = new FastMenuPage($options, $this->option_name, $this->option_group);
        $this->menu_pages[] = $menu_page;
    }

    /**
     * Called on option page save, calls menu page with data and returns the updated values.
     *
     * @param  array $customizer_data Data sent by customizer save.
     * @return array Updated data.
     */
    public function validate_options($customizer_data)
    {
        $data = null === $customizer_data ? get_option($this->option_name) : $customizer_data;

        if (isset($_POST['_wpnonce']) && wp_verify_nonce(sanitize_key($_POST['_wpnonce']), $this->option_group . '-options')) {
            foreach ($this->menu_pages as $menu_page) {
                if (isset($_POST['option_page_slug'])) {
                    if ($_POST['option_page_slug'] === $menu_page->options['slug']) {
                        $data = $menu_page->save($data);
                    }
                }
            }
        }
        return $data;
    }
}
