<?php
/**
 * Main bootstrap file for theme options
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

if (function_exists('fast_get_package_directory')) {
    // Load from the theme.
    define('FAST_OPTIONS_DIR', fast_get_package_directory('theme-options'));
    define('FAST_OPTIONS_URI', fast_get_package_uri('theme-options'));
} else {
    // Load from plugin.
    define('FAST_OPTIONS_DIR', FAST_PLUGIN_DIR . 'lib/theme-options/');
    define('FAST_OPTIONS_URI', FAST_PLUGIN_URI . 'lib/theme-options/');
}

// Frontend Modules.
require FAST_OPTIONS_DIR . 'inc/functions.php';
require FAST_OPTIONS_DIR . 'options/inc/options-defaults.php';
require FAST_OPTIONS_DIR . 'customizer/inc/customizer.php';

// Backend Modules.
if (is_admin()) {
    // Options.
    require FAST_OPTIONS_DIR . 'options/inc/option.php';
    require FAST_OPTIONS_DIR . 'options/inc/options.php';
    require FAST_OPTIONS_DIR . 'options/inc/options-page.php';

    // Metaboxes.
    require FAST_OPTIONS_DIR . 'metabox/inc/metabox.php';
    require FAST_OPTIONS_DIR . 'metabox/inc/taxonomy-metabox.php';
    require FAST_OPTIONS_DIR . 'metabox/inc/metaboxes.php';
}
