<?php
/**
 * Extends WordPress widget to work with Oxygenna Options
 *
 * @package Fast Plugin
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Widget class for Oxygenna Widgets
 */
class FastWidget extends WP_Widget {
    /**
     * Stores the widget admin fields options filter name.
     *
     * @var String
     */
    protected $form_options_filter;

    /**
     * Creates a widget.
     *
     * @param string $id_base         Optional Base ID for the widget, lowercase and unique. If left empty, a portion of the widget's class name will be used Has to be unique.
     * @param string $name            Name for the widget displayed on the configuration page.
     * @param array  $widget_options  Optional. Widget options. See wp_register_sidebar_widget() for information on accepted arguments. Default empty array.
     * @param array  $control_options Optional. Widget control options. See wp_register_widget_control() for information on accepted arguments. Default empty array.
     * @param filter $form_options_filter    Optional. Filter used to get the admin options for the widget.
     */
    public function __construct($id_base = false, $name = '', $widget_options = array(), $control_options = array(), $form_options_filter = '')
    {
        parent::__construct($id_base, $name, $widget_options, $control_options);
        $this->form_options_filter = $form_options_filter;
    }

    /**
     * Creates a form of options in the admin panel.
     *
     * @param array $instance Values of the fields.
     * @return void
     */
    public function form($instance)
    {
        $form_options = apply_filters($this->form_options_filter, array());
        foreach ($form_options as $field) {
            $id = $this->get_field_id($field['id']);

            if (isset($instance[$field['id']])) {
                $value = $instance[$field['id']];
            } else {
                $value = isset($field['default']) ? $field['default'] : '';
            }
            $option = fast_create_option($field, $value);
            $option->set_attribute('id', $id);
            $option->set_attribute('name', $this->get_field_name($field['id']));

            echo '<p>';
            echo '<label for="' . esc_attr($id) . '">' . esc_html($field['name']) . '</label>';
            $option->render();
            echo '</p>';
        }
    }
}
