(function($) {
    $(document).ready(function($) {
        function addMessage(type, message, duration) {
            // create message
            var messageHTML = $('<div id="setting-error-settings_updated" class="' + type + ' settings-error below-h2"><p><strong>' + message + '</strong></p></div>');
            messageHTML.hide();
            // add message to the page and fade in
            $('#ajax-errors-here').append(messageHTML);
            messageHTML.fadeIn();

            if(duration !== undefined) {
                setTimeout(function() {
                    messageHTML.fadeOut();
                }, duration);  // will work with every browser
            }
        }

        function success(response) {
            switch(response.status) {
                case 'ok':
                    addMessage('updated' , 'Saved stacks - ' + response.saved.join(', ') , 5000);
                break;
                case 'failed':
                    addMessage('error' , response.message , 10000);
                break;
            }
            // remove the text & spinner next to the select list box
            $('#updateListMessage').remove();
        }

        $('#save-all-stacks').click(function() {
            var $button = $(this);

            // add loading spinner next to the list select
            $button.after('<span id="updateListMessage"><img src="images/wpspin_light.gif" style="vertical-align:middle;padding: 0px 5px;" /><span>Saving...</span></div>');
            // disable the fetch list button
            $button.attr('disabled', true);

            $.ajax({
                type: 'POST',
                url: localData.ajaxurl,
                data: {
                    action: 'save_all_stacks',
                    nonce: localData.installDefaultsNonce,
                },
                success: success,
                complete: function() {
                    $button.attr('disabled', false);
                },
                dataType: 'json'
            });

            return false;
        });
    });
})(jQuery);
