<?php
/**
 * Actions for the stacks
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

/**
 * Adds header css if needed
 *
 * @return void
 */
function fast_enqueue_header_css()
{
    $load_css = fast_get_option('css_save_to', 'fast-plugin_stack_options');
    if ('header' === $load_css) {
        $current_stack_id = apply_filters('fast_filter_current_stack_id', '');
        if (!empty($current_stack_id)) {
            $css = get_post_meta($current_stack_id, '_fast-plugin-skin.min.css', true);
            echo '<style type="text/css" id="stack">' . $css . '</style>';
        }
    }
}
add_action('wp_head', 'fast_enqueue_header_css', 100);
