<?php
/**
 * Outputs a theme option page
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

?>
<div class="wrap">
    <div class="oxy-option-page">
        <header>
            <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        </header>

        <?php settings_errors(); ?>
        <div id="ajax-errors-here"></div>
        <form method="post" action="options.php">
            <?php settings_fields($this->options_page['group']); ?>
            <?php if (isset($_GET['page'])) : ?>
                <?php do_settings_sections(sanitize_key(wp_unslash($_GET['page']))); ?>
            <?php endif; ?>
            <div class="oxy-option-page-footer">
                <?php submit_button(esc_html__('Save Changes', 'fast-plugin'), 'primary', 'save_changes'); ?>
                <?php submit_button(esc_html__('Restore Defaults', 'fast-plugin'), 'secondary', 'reset_options'); ?>
            </div>
            <input type="hidden" name="option_page_slug" value="<?php echo esc_attr($this->options['slug']); ?>"/>
        </form>
    </div>
</div>
