<?php
/**
 * Adds stack status to top of the edit stack page
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

?>
<table>
    <tr class="form-table">
        <th>
            <?php esc_html_e('Upload folder access', 'fast-plugin'); ?>
        </th>
        <td>
            <?php echo esc_html($filesystem_method); ?>
        </td>
    </tr>
    <?php foreach ($css_files as $file) : ?>
    <tr class="form-table">
        <th>
            <?php esc_html_e('File', 'fast-plugin'); ?>
            <?php echo esc_attr(basename($file['path'])); ?>
        </th>
        <td>
            <?php if ($file['exists']) : ?>
                <a href="<?php echo esc_url($file['url']); ?>"><?php echo esc_url($file['url']); ?></a>
            <?php else : ?>
                <?php esc_html_e('Stack CSS File has not been created yet.  Save your stack to create the stack CSS file.', 'fast-plugin'); ?>
            <?php endif; ?>
        </td>
    </tr>
    <?php endforeach; ?>
</table>
