<?php
/**
 * Template for extra fields options page
 *
 * @package Fast Plugin
 *
 * @copyright 2019 Oxygenna.com
 * @license http://themeforest.net/licenses/standard
 * @version 1.15.4
 * @author Oxygenna
 */

?>
<h3><?php echo esc_html($title); ?></h3>
<p><?php printf(esc_html($subtitle), count($extra_fields->fields)); ?></p>
<table class="wp-list-table widefat fixed striped">
    <thead>
        <tr>
            <th><?php esc_html_e('Label', 'fast-plugin'); ?></th>
            <th><?php esc_html_e('Element', 'fast-plugin'); ?></th>
            <th><?php esc_html_e('Id', 'fast-plugin'); ?></th>
            <th><?php esc_html_e('name', 'fast-plugin'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($extra_fields->fields as $field) : ?>
        <tr>
            <td><?php echo esc_html($field->label); ?>
            <td><?php echo esc_html($field->element); ?>
            <td><?php echo esc_html($field->id); ?>
            <td><?php echo esc_html($field->name); ?>
        </tr>
        <?php endforeach; ?>
    </tbody>
    <?php if (empty($extra_fields->fields)) : ?>
        <tbody>
            <tr>
                <td colspan="4" align="center">
                    <?php esc_html_e('You have no fields, click the edit fields button to get started.', 'fast-plugin'); ?>
                </td>
            </tr>
        </tbody>
    <?php endif; ?>
    <tfooter>
        <tr>
            <td colspan="4">
                <a href="<?php echo esc_url($builder_link); ?>" class="button button-secondary">
                    <?php esc_html_e('Edit Fields', 'fast-plugin'); ?>
                </a>
            </td>
        </tr>
    </tfooter>
</table>
