<?php
/**
 * Copyright (c) 2016-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 */
namespace Facebook\InstantArticles\Elements;

/**
 * An AnimatedGIF
 * Also consider to use one of the other media types for an article:
 * <ul>
 *     <li>Audio</li>
*      <li>Image</li>
 *     <li>Video</li>
 *     <li>Slideshow</li>
 *     <li>Map</li>
 * </ul>.
 *
 * Example:
 *  <figure>
 *      <img src="http://mydomain.com/path/to/animated.gif" />
 *      <figcaption>This image is amazing</figcaption>
 *  </figure>
 *
 * @see Audio
 * @see Image
 * @see Video
 * @see Slideshow
 * @see Map
 * @see {link:https://developers.intern.facebook.com/docs/instant-articles/reference/animated-gif}
 */
class AnimatedGIF extends Image
{
}
